/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.goods.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.goods.dto.GoodsCollectDTO;
import com.els.modules.goods.dto.GoodsDTO;
import com.els.modules.goods.entity.GoodsCollect;
import com.els.modules.goods.entity.GoodsItems;
import com.els.modules.goods.service.GoodsCollectService;
import com.els.modules.goods.vo.GoodsVO;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5546\u54c1\u6536\u85cf"})
@RestController
@RequestMapping(value={"/industryinfo/goods"})
public class GoodsCollectController
extends BaseController<GoodsCollect, GoodsCollectService> {
    @Autowired
    private GoodsCollectService goodsCollectService;

    @ApiOperation(value="\u7b5b\u9009\u9879", notes="\u7b5b\u9009\u9879")
    @GetMapping(value={"/options"})
    public Result<?> getOptions(@RequestParam(name="type", required=false, defaultValue="collect") String type, @RequestParam(name="clearCache", required=false, defaultValue="0") String clearCache) {
        return Result.ok(this.goodsCollectService.getOptions(type, clearCache));
    }

    @ApiOperation(value="\u5546\u54c1\u6536\u85cf\u5217\u8868", notes="\u5546\u54c1\u6536\u85cf\u5217\u8868")
    @PostMapping(value={"/collectList"})
    public Result<?> collectListNew(@RequestBody SimplePostRequestParam<GoodsDTO> param) {
        IPage<GoodsVO> pageList = this.goodsCollectService.queryCollectListNew(param);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5546\u54c1\u6536\u85cf\u5217\u8868", notes="\u5546\u54c1\u6536\u85cf\u5217\u8868")
    @PostMapping(value={"/collectListOld"})
    public Result<?> collectList(@RequestBody Map map) {
        IPage<GoodsItems> pageList = this.goodsCollectService.queryCollectList(map);
        return Result.ok(pageList);
    }

    @PostMapping(value={"/collect"})
    @AutoLog(busModule="\u5546\u54c1\u6536\u85cf", value="\u6536\u85cf")
    @ApiOperation(value="\u6536\u85cf", notes="\u6536\u85cf")
    public Result<?> collect(@RequestBody GoodsCollectDTO dto) {
        this.goodsCollectService.collect(dto);
        return Result.ok();
    }
}

