/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.entity.KsTopManResultEntity;
import com.els.modules.industryinfo.exception.TopManException;
import com.els.modules.industryinfo.service.KuaiShouTopManInformationService;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailBaseEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailFansEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailHeadC;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailLiveDataEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailLiveEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailVideoEntity;
import com.els.modules.industryinfo.vo.KsTopManCollectVo;
import com.els.modules.industryinfo.vo.KsTopManDetailVo;
import com.els.modules.industryinfo.vo.KsTopManInformationVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/ks/topMan"})
@Api(tags={"\u5feb\u624b\u8fbe\u4eba\u4fe1\u606f\u5e93"})
public class KuaiShouTopManController {
    @Autowired
    private KuaiShouTopManInformationService topManInformationService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public Result<?> listAll(@RequestBody SimplePostRequestParam<KsTopManInformationVO> topManDto) {
        try {
            IPage<KsTopManResultEntity> pageList = this.topManInformationService.queryTopManList(topManDto);
            return Result.ok(pageList);
        }
        catch (Exception te) {
            te.printStackTrace();
            return Result.error((String)te.getMessage());
        }
    }

    @PostMapping(value={"/collect"})
    @AutoLog(value="\u8fbe\u4eba\u6536\u85cf\u64cd\u4f5c")
    public Result<?> collect(@RequestBody KsTopManCollectVo ksTopManCollectVo) {
        this.topManInformationService.collect(ksTopManCollectVo);
        return Result.ok();
    }

    @PostMapping(value={"/addMark"})
    @AutoLog(value="\u8fbe\u4eba\u6536\u85cf\u64cd\u4f5c")
    public Result<?> addMarkToSpider(@RequestBody KsTopManCollectVo ksTopManCollectVo) {
        this.topManInformationService.addMarkToSpider(ksTopManCollectVo);
        return Result.ok();
    }

    @ApiOperation(value="\u8be6\u60c5\u5934\u90e8", notes="\u8be6\u60c5\u5934\u90e8")
    @PostMapping(value={"/detail/head"})
    public Result<?> getDetailHead(@RequestBody KsTopManDetailVo param) {
        try {
            KsTopManDetailHeadC detailHead = this.topManInformationService.getDetailHead(param);
            return Result.ok((Object)detailHead);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u57fa\u7840\u5206\u6790", notes="\u8be6\u60c5-\u57fa\u7840\u5206\u6790")
    @PostMapping(value={"/detail/body/base"})
    public Result<?> getDetailBodyBase(@RequestBody KsTopManDetailVo param) {
        try {
            KsTopManDetailBaseEntity bodyBase = this.topManInformationService.getDetailBodyBase(param);
            return Result.ok((Object)bodyBase);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u76f4\u64ad\u5206\u6790", notes="\u8be6\u60c5-\u76f4\u64ad\u5206\u6790")
    @PostMapping(value={"/detail/body/live"})
    public Result<?> getDetailBodyLive(@RequestBody KsTopManDetailVo param) {
        try {
            KsTopManDetailLiveEntity bodyLive = this.topManInformationService.getDetailBodyLive(param);
            return Result.ok((Object)bodyLive);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u76f4\u64ad\u5206\u6790-\u672c\u573a\u5e26\u8d27\u6570\u636e", notes="\u8be6\u60c5-\u76f4\u64ad\u5206\u6790-\u672c\u573a\u5e26\u8d27\u6570\u636e")
    @PostMapping(value={"/detail/body/liveData"})
    public Result<?> getDetailBodyLiveData(@RequestBody KsTopManDetailVo param) {
        try {
            KsTopManDetailLiveDataEntity bodyLiveData = this.topManInformationService.getDetailBodyLiveData(param);
            return Result.ok((Object)bodyLiveData);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u89c6\u9891\u5206\u6790", notes="\u8be6\u60c5-\u89c6\u9891\u5206\u6790")
    @PostMapping(value={"/detail/body/video"})
    public Result<?> getDetailBodyVideo(@RequestBody KsTopManDetailVo param) {
        try {
            KsTopManDetailVideoEntity bodyVideo = this.topManInformationService.getDetailBodyVideo(param);
            return Result.ok((Object)bodyVideo);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790", notes="\u8be6\u60c5-\u7c89\u4e1d\u5206\u6790")
    @PostMapping(value={"/detail/body/fans"})
    public Result<?> getDetailBodyFans(@RequestBody KsTopManDetailVo param) {
        try {
            KsTopManDetailFansEntity bodyFans = this.topManInformationService.getDetailBodyFans(param);
            return Result.ok((Object)bodyFans);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }
}

