/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.kafka;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.els.modules.industryinfo.dto.TopmanMsgRqDto;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

@Component
public class KafkaConsumer {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumer.class);
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;

    public void listenTestGroup(ConsumerRecord<String, String> record, Acknowledgment ack) {
        String value = (String)record.value();
        System.out.println(value);
        System.out.println(record);
        log.info("\u3010kakfa\u3011\u6536\u5230\u6d88\u606f\uff1a" + value);
        ack.acknowledge();
    }

    @KafkaListener(topics={"test"})
    public void listenTestMsg(ConsumerRecord<String, String> record, Acknowledgment ack) {
        String value = (String)record.value();
        log.info("\u3010kakfa test\u3011\u6536\u5230\u6d88\u606f\uff1a{}", (Object)value);
        ack.acknowledge();
    }

    @KafkaListener(topics={"douyin_auto_touch_result"})
    public void listenTopMapMsg(ConsumerRecord<String, String> record, Acknowledgment ack) {
        String value = (String)record.value();
        if (StrUtil.isNotBlank((CharSequence)value)) {
            log.info("\u3010douyin_auto_touch_result\u3011received:{}", (Object)value);
            TopmanMsgRqDto msg = (TopmanMsgRqDto)JSON.parseObject((String)value, TopmanMsgRqDto.class);
            this.topManMsgRecordService.handleMsg(msg);
        } else {
            log.info("\u3010douyin_auto_touch_result\u3011received value is blank");
        }
        ack.acknowledge();
    }
}

