/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.industryinfo.dto.TopManMsgTurnRq;
import com.els.modules.industryinfo.entity.TopManMsgRecord;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55"})
@RestController
@RequestMapping(value={"/msg/topManMsgRecord"})
public class TopManMsgRecordController
extends BaseController<TopManMsgRecord, TopManMsgRecordService> {
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list/{platform}/{type}"})
    public Result<?> queryPageList(TopManMsgRecord topManMsgRecord, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req, @PathVariable(value="platform") String platform, @PathVariable(value="type") String type) {
        String topManName = topManMsgRecord.getTopmanName();
        if (StrUtil.isNotBlank((CharSequence)topManName)) {
            topManMsgRecord.setTopmanName(null);
        }
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)topManMsgRecord), (Map)req.getParameterMap());
        queryWrapper.eq((Object)"platform", (Object)platform);
        LoginUser loginUser = SysUtil.getLoginUser();
        queryWrapper.eq((Object)"els_account", (Object)loginUser.getElsAccount());
        if (StrUtil.isNotBlank((CharSequence)topManName)) {
            queryWrapper.like((Object)"topman_name", (Object)topManName);
        }
        if ("2".equals(type)) {
            queryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
        }
        if ("3".equals(type)) {
            queryWrapper.eq((Object)"sub_account", (Object)loginUser.getSubAccount());
            queryWrapper.eq((Object)"is_turn", (Object)"1");
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.topManMsgRecordService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody TopManMsgRecord topManMsgRecord) {
        this.topManMsgRecordService.add(topManMsgRecord);
        return Result.ok((Object)((Object)topManMsgRecord));
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55-\u8f6c\u529e")
    @ApiOperation(value="\u8f6c\u529e", notes="\u8f6c\u529e")
    @PostMapping(value={"/turn"})
    public Result<?> turn(@RequestBody TopManMsgTurnRq rq) {
        this.topManMsgRecordService.turn(rq);
        return Result.ok();
    }

    @PostMapping(value={"/updateAddStatus"})
    public Result<?> updateAddStatus(@RequestBody TopManMsgRecord rq) {
        TopManMsgRecord record = (TopManMsgRecord)((Object)this.topManMsgRecordService.getById((Serializable)((Object)rq.getId())));
        record.setIsAdded("1");
        this.topManMsgRecordService.updateById((Object)record);
        return Result.ok();
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody TopManMsgRecord topManMsgRecord) {
        this.topManMsgRecordService.edit(topManMsgRecord);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.topManMsgRecordService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u8fbe\u4eba\u6d88\u606f\u8bb0\u5f55-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.topManMsgRecordService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        TopManMsgRecord topManMsgRecord = (TopManMsgRecord)((Object)this.topManMsgRecordService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)topManMsgRecord));
    }
}

