/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.industryinfo.entity.McnAttachmentEntity;
import com.els.modules.industryinfo.mapper.McnAttachmentMapper;
import com.els.modules.industryinfo.service.McnAttachmentService;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class McnAttachmentServiceImpl
extends BaseServiceImpl<McnAttachmentMapper, McnAttachmentEntity>
implements McnAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(McnAttachmentServiceImpl.class);
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;

    @Override
    @Async(value="taskExecutor")
    public McnAttachmentEntity upload(JSONObject jsonParam) {
        log.info("\u56fe\u7247\u4e0a\u4f20\u7ebf\u7a0b:", (Object)(Thread.currentThread().getName() + ": " + jsonParam.getString("topmanId")));
        String topmanId = jsonParam.getString("topmanId");
        log.info("\u5934\u50cf\u4e0a\u4f20\u8fbe\u4ebaid:" + topmanId);
        Assert.hasText((String)topmanId, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u8fbe\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a"));
        String platform = jsonParam.getString("platform");
        Assert.hasText((String)platform, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a"));
        byte[] bytes = jsonParam.getBytes("file");
        StorageFileInfo fileInfo = new StorageFileInfo();
        LocalDateTime time = LocalDateTime.now();
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
        String nowday = dtf.format(time);
        String documentName = topmanId + ".jpg";
        documentName = documentName.replaceAll("-", "_");
        String documentType = "";
        String documentLocation = File.separator + "pic" + File.separator + documentName;
        if (documentLocation.contains("\\")) {
            documentLocation = documentLocation.replace("\\", "/");
        }
        String savePath = CharSequenceUtil.emptyToDefault(null, (String)documentLocation);
        savePath = savePath.replaceAll(" ", "_");
        fileInfo.setPath(savePath);
        fileInfo.setFilename(documentName);
        fileInfo.setOriginalFilename(documentName);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
        fileInfo = this.fileStoreSignServiceImpl.storeFile((InputStream)inputStream, fileInfo, (String)null);
        McnAttachmentEntity attachment = new McnAttachmentEntity();
        attachment.setTopmanId(topmanId);
        attachment.setId(topmanId);
        attachment.setPlatform(platform);
        attachment.setFileName(fileInfo.getOriginalFilename());
        attachment.setFileSize(String.valueOf(fileInfo.getSize()));
        attachment.setFilePath(fileInfo.getPath());
        attachment.setTopmanAvatar(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), fileInfo.getSaveType()));
        boolean result = this.saveOrUpdate((Object)attachment);
        log.info(topmanId + ":" + result);
        if (result) {
            log.info("\u4e0a\u4f20\u6210\u529f:" + (Object)((Object)attachment));
            return attachment;
        }
        return null;
    }

    @Override
    public boolean deleteBatch(String ids) {
        List mcnAttachmentEntities;
        List list = this.list();
        List bStationId = list.stream().map(McnAttachmentEntity::getTopmanId).distinct().collect(Collectors.toList());
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(mcnAttachmentEntities = this.listByIds(bStationId)))) {
            for (McnAttachmentEntity purchaseAttachment : mcnAttachmentEntities) {
                filePaths.add(purchaseAttachment.getFilePath());
            }
        }
        boolean b = this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
        this.removeByIds(idList);
        return b;
    }

    @Override
    public boolean delete(String id) {
        ArrayList<String> filePaths = new ArrayList<String>();
        McnAttachmentEntity byId = (McnAttachmentEntity)((Object)this.getById((Serializable)((Object)id)));
        if (byId == null) {
            return false;
        }
        filePaths.add(byId.getFilePath());
        boolean b = this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
        System.out.println("aaaaaaaaaaaaaaaaaaaaaaaaaaaa:" + b);
        this.removeById((Serializable)((Object)id));
        return b;
    }
}

