/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.kafka;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.modules.industryinfo.dto.TopManMsgReplyDto;
import com.els.modules.industryinfo.dto.TopmanMsgRqDto;
import com.els.modules.industryinfo.service.McnAttachmentService;
import com.els.modules.industryinfo.service.TopManMsgRecordService;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

@Component
public class KafkaConsumer {
    private static final Logger log = LoggerFactory.getLogger(KafkaConsumer.class);
    @Autowired
    private TopManMsgRecordService topManMsgRecordService;
    @Autowired
    private McnAttachmentService mcnAttachmentService;

    public void listenTestGroup(ConsumerRecord<String, String> record, Acknowledgment ack) {
        String value = (String)record.value();
        ack.acknowledge();
    }

    @KafkaListener(topics={"douyin_auto_touch_result", "kuaishou_topman_msg_result"})
    public void listenAutoTuchTopMapMsg(ConsumerRecord<String, String> record, Acknowledgment ack) {
        String value = (String)record.value();
        if (StrUtil.isNotBlank((CharSequence)value)) {
            TopmanMsgRqDto msg = (TopmanMsgRqDto)JSON.parseObject((String)value, TopmanMsgRqDto.class);
            this.topManMsgRecordService.handleMsg(msg);
        }
        ack.acknowledge();
    }

    @KafkaListener(topics={"douyin_auto_touch_msg_reply", "kuaishou_auto_touch_msg_reply"})
    public void listenTopMapReply(ConsumerRecord<String, String> record, Acknowledgment ack) {
        String value = (String)record.value();
        if (StrUtil.isNotBlank((CharSequence)value)) {
            TopManMsgReplyDto msg = (TopManMsgReplyDto)JSON.parseObject((String)value, TopManMsgReplyDto.class);
            this.topManMsgRecordService.handleReplyMsg(msg);
        }
        ack.acknowledge();
    }

    public void listenTopMapBstationPic(ConsumerRecord<String, String> record, Acknowledgment ack) {
        log.info("kafka Picture upload consumption");
        String value = (String)record.value();
        if (StrUtil.isNotBlank((CharSequence)value)) {
            JSONObject jsonObject = JSON.parseObject((String)value);
            this.mcnAttachmentService.upload(jsonObject);
        } else {
            log.info("\u3010listenTopMapBstationPic\u3011received value is blank");
        }
        ack.acknowledge();
    }
}

