/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;

public class HttpRequestUtils {
    public static String httpGet(String url, String method, Map<String, Object> param) throws IOException {
        String line;
        String paramJson = JSON.toJSONString(param);
        System.out.println("paramJson=" + paramJson);
        System.out.println("method=" + method);
        URL urlConnect = new URL(url);
        HttpURLConnection conn = (HttpURLConnection)urlConnect.openConnection();
        conn.setDoOutput(true);
        conn.setDoInput(true);
        conn.setUseCaches(false);
        conn.setRequestMethod("GET");
        conn.setRequestProperty("Accept", "*/*");
        conn.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        conn.connect();
        InputStream inputStream = conn.getInputStream();
        StringBuilder result = new StringBuilder();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        while ((line = bufferedReader.readLine()) != null) {
            result.append(line);
        }
        return result.toString();
    }

    public static String httpPost(String url, Map<String, String> map, String encoding) throws Exception {
        if (StringUtils.isEmpty((CharSequence)encoding)) {
            encoding = "UTF-8";
        }
        String body = "";
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost httpPost = new HttpPost(url);
        ArrayList<BasicNameValuePair> nvps = new ArrayList<BasicNameValuePair>();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                nvps.add(new BasicNameValuePair(entry.getKey(), entry.getValue()));
            }
        }
        httpPost.setEntity((HttpEntity)new UrlEncodedFormEntity(nvps, encoding));
        httpPost.setHeader("Content-type", "application/x-www-form-urlencoded");
        CloseableHttpResponse response = client.execute((HttpUriRequest)httpPost);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            body = EntityUtils.toString((HttpEntity)entity, (String)encoding);
        }
        EntityUtils.consume((HttpEntity)entity);
        response.close();
        return body;
    }

    public static JSONObject doPost(String url, String json) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(url);
        JSONObject response = null;
        try {
            StringEntity s = new StringEntity(json, "UTF-8");
            s.setContentEncoding("UTF-8");
            s.setContentType("application/json,text/plain,*/*");
            post.setEntity((HttpEntity)s);
            CloseableHttpResponse res = client.execute((HttpUriRequest)post);
            if (res.getStatusLine().getStatusCode() == 200) {
                HttpEntity entity = res.getEntity();
                String result = EntityUtils.toString((HttpEntity)entity);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                if (jsonObject.getInteger("status") == 500) {
                    return response;
                }
                response = jsonObject.getJSONObject("result");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return response;
    }
}

