/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.annotation.ApiCallCount;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.RequestOptionVO;
import com.els.modules.industryinfo.dto.DouYinTopManCollectDTO;
import com.els.modules.industryinfo.dto.DouYinTopManDetailDTO;
import com.els.modules.industryinfo.entity.TopManGoodsListEntity;
import com.els.modules.industryinfo.entity.TopManParamEntity;
import com.els.modules.industryinfo.entity.TopManResultDetailBody;
import com.els.modules.industryinfo.entity.TopManResultEntity;
import com.els.modules.industryinfo.entity.TopManShopListEntity;
import com.els.modules.industryinfo.enumerate.TopManQueryType;
import com.els.modules.industryinfo.excel.TopManInformationExportServiceImpl;
import com.els.modules.industryinfo.exception.TopManException;
import com.els.modules.industryinfo.service.TopManInformationService;
import com.els.modules.industryinfo.vo.DyTopManAddPopupVO;
import com.els.modules.industryinfo.vo.DyTopManVO;
import com.els.modules.industryinfo.vo.TopManDetailDouYinIdVO;
import com.els.modules.industryinfo.vo.TopManDetailHeadVO;
import com.els.modules.industryinfo.vo.TopManInformationVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/topMan"})
@Api(tags={"\u8fbe\u4eba\u4fe1\u606f\u5e93"})
public class DouYinTopManController
extends BaseController<TopManParamEntity, TopManInformationService> {
    @Autowired
    private TopManInformationService topManInformationService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2\uff08\u5f03\u7528\uff09", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list/{type}"})
    @ApiCallCount(apiCode="industry_top_main_list_data")
    public Result<?> listAll(@RequestBody SimplePostRequestParam<TopManInformationVO> topManDto, @PathVariable(value="type") TopManQueryType topManQueryType) {
        try {
            IPage<? extends TopManResultEntity> pageList = this.topManInformationService.queryTopManList(topManDto, topManQueryType);
            return Result.ok(pageList);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    @ApiCallCount(apiCode="industry_top_main_list_data")
    public Result<?> list(@RequestBody SimplePostRequestParam<RequestOptionVO> topManDto) {
        try {
            IPage<DyTopManVO> pageList = this.topManInformationService.queryTopManListNew(topManDto);
            return Result.ok(pageList);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u7b5b\u9009\u9879", notes="\u7b5b\u9009\u9879")
    @GetMapping(value={"/options"})
    public Result<?> getOptions(@RequestParam(name="type", required=false, defaultValue="0") String type, @RequestParam(name="clearCache", required=false, defaultValue="0") String clearCache) {
        return Result.ok(this.topManInformationService.getOptions(type, clearCache));
    }

    @ApiOperation(value="\u6536\u85cf\u8fbe\u4eba\uff08\u5f03\u7528\uff09", notes="\u6536\u85cf\u8fbe\u4eba")
    @GetMapping(value={"/collect"})
    @AutoLog(value="\u6536\u85cf\u8fbe\u4eba")
    public Result<?> collect(@RequestParam(value="yn") String yn, @RequestParam(value="platform") String platform, @RequestParam(value="topManId") String uid) {
        if (StringUtils.isBlank((CharSequence)yn) || StringUtils.isBlank((CharSequence)platform) || StringUtils.isBlank((CharSequence)platform)) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        ((TopManInformationService)this.service).collect(yn, platform, uid);
        return Result.ok();
    }

    @ApiOperation(value="\u6536\u85cf\u8fbe\u4eba(\u65b0)", notes="\u6536\u85cf\u8fbe\u4eba(\u65b0)")
    @PostMapping(value={"/collectNew"})
    @AutoLog(value="\u6536\u85cf\u8fbe\u4eba(\u65b0)")
    public Result<?> collect(@RequestBody DouYinTopManCollectDTO dto) {
        if (dto.getEntity() == null) {
            return Result.error((String)"\u53c2\u6570\u9519\u8bef");
        }
        ((TopManInformationService)this.service).collectNew(dto);
        return Result.ok();
    }

    @ApiOperation(value="\u6dfb\u52a0\u5165\u5e93\uff08\u5f03\u7528\uff09", notes="\u6dfb\u52a0\u5165\u5e93")
    @GetMapping(value={"/addToDatabase"})
    @AutoLog(value="\u6dfb\u52a0\u4f01\u4e1a\u5e93\u65f6\uff0c\u5148\u628a\u6570\u636e\u5165\u5e93")
    public Result<?> addToDatabase(@RequestParam(value="topManId") String uid) {
        String topManId = ((TopManInformationService)this.service).addToMySql(uid);
        return Result.ok((Object)topManId);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5165\u5e93(\u65b0)", notes="\u6dfb\u52a0\u5165\u5e93(\u65b0)")
    @PostMapping(value={"/addToDatabaseNew"})
    @AutoLog(value="\u6dfb\u52a0\u4f01\u4e1a\u5e93\u65f6\uff0c\u5148\u628a\u6570\u636e\u5165\u5e93(\u65b0)")
    public Result<?> addToDatabaseNew(@RequestBody DouYinTopManCollectDTO dto) {
        String topManId = ((TopManInformationService)this.service).addToMySqlNew(dto);
        return Result.ok((String)topManId);
    }

    @ApiOperation(value="\u6dfb\u52a0\u5f39\u6846\u4fe1\u606f", notes="\u6dfb\u52a0\u5f39\u6846\u4fe1\u606f")
    @PostMapping(value={"/addPopupInfo"})
    public Result<?> addPopupInfo(@RequestBody DouYinTopManDetailDTO dto) {
        DyTopManAddPopupVO vo = ((TopManInformationService)this.service).addPopupInfo(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u5feb\u624b\u8fbe\u4eba\u5217\u8868\u5206\u7c7b\u67e5\u8be2", notes="\u5feb\u624b\u8fbe\u4eba\u5217\u8868\u5206\u7c7b\u67e5\u8be2")
    @GetMapping(value={"/category"})
    public Result<?> getCategoryData(@RequestParam(name="type", required=false, defaultValue="0") String type) {
        return Result.ok(this.topManInformationService.getCategoryData(type));
    }

    @ApiOperation(value="\u5feb\u624b\u8fbe\u4eba\u5217\u8868\u5206\u7c7b\u7f13\u5b58\u6e05\u9664", notes="\u5feb\u624b\u8fbe\u4eba\u5217\u8868\u5206\u7c7b\u7f13\u5b58\u6e05\u9664")
    @GetMapping(value={"/cleanCache"})
    public Result<?> cleanCache() {
        ((TopManInformationService)this.service).cleanCache();
        return Result.ok();
    }

    @ApiOperation(value="\u8fbe\u4eba\u8be6\u60c5-\u5934\u90e8\u6a21\u5757\uff08\u5f03\u7528\uff09", notes="\u8fbe\u4eba\u8be6\u60c5-\u5934\u90e8\u6a21\u5757")
    @GetMapping(value={"/detail/head"})
    @ApiCallCount(apiCode="industry_top_main_detail_data")
    public Result<?> detailHead(@RequestParam(name="topManId") String id, @RequestParam(name="clearCache", required=false, defaultValue="0") String clearCache) {
        TopManDetailHeadVO result = this.topManInformationService.queryDetailHeadBase(id, clearCache);
        return Result.ok((Object)((Object)(result != null ? result : new TopManDetailHeadVO())));
    }

    @ApiOperation(value="\u83b7\u53d6\u6296\u97f3\u53f7", notes="\u83b7\u53d6\u6296\u97f3\u53f7")
    @PostMapping(value={"/getTopmanId"})
    public Result<?> getDouYinId(@RequestBody DouYinTopManDetailDTO dto) {
        TopManDetailDouYinIdVO vo = ((TopManInformationService)this.service).getDouYinId(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8fbe\u4eba\u8be6\u60c5-\u5934\u90e8\u6570\u636e", notes="\u8fbe\u4eba\u8be6\u60c5-\u5934\u90e8\u6570\u636e")
    @PostMapping(value={"/detail/headInfo"})
    @ApiCallCount(apiCode="industry_top_main_detail_data")
    public Result<?> detailHeadInfo(@RequestBody DouYinTopManDetailDTO param) {
        TopManDetailHeadVO result = this.topManInformationService.getTopmanScore(param);
        return Result.ok((Object)((Object)(result != null ? result : new TopManDetailHeadVO())));
    }

    @ApiOperation(value="\u8fbe\u4eba\u8be6\u60c5-\u6838\u5fc3\u6570\u636e", notes="\u8fbe\u4eba\u8be6\u60c5-\u6838\u5fc3\u6570\u636e")
    @PostMapping(value={"/detail/core"})
    @ApiCallCount(apiCode="industry_top_main_detail_data")
    public Result<?> detailHeadCore(@RequestBody DouYinTopManDetailDTO param) {
        TopManDetailHeadVO result = this.topManInformationService.queryDetailHeadCore(param);
        return Result.ok((Object)((Object)(result != null ? result : new TopManDetailHeadVO())));
    }

    @ApiOperation(value="\u8fbe\u4eba\u8be6\u60c5-\u4e3b\u4f53\u6a21\u5757\uff08\u57fa\u7840\u5206\u6790\u3001\u5e26\u8d27\u5206\u6790\uff09", notes="\u8fbe\u4eba\u8be6\u60c5-\u4e3b\u4f53\u6a21\u5757")
    @PostMapping(value={"/detail/body"})
    public Result<?> detailBody(@RequestBody SimplePostRequestParam<DouYinTopManDetailDTO> param) {
        TopManResultDetailBody result = this.topManInformationService.queryDetailBody((DouYinTopManDetailDTO)param.getFilterInfo());
        return Result.ok((Object)((Object)result));
    }

    @ApiOperation(value="\u5e26\u8d27\u5206\u6790-\u5546\u54c1\u5217\u8868", notes="\u5e26\u8d27\u5206\u6790-\u5546\u54c1\u5217\u8868")
    @PostMapping(value={"/detail/listGoods"})
    public Result<?> listGoods(@RequestBody SimplePostRequestParam<DouYinTopManDetailDTO> param) {
        try {
            IPage<TopManGoodsListEntity> pageList = this.topManInformationService.queryGoodsListNew(param);
            return Result.ok(pageList);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @ApiOperation(value="\u5e26\u8d27\u5206\u6790-\u5e97\u94fa\u5217\u8868", notes="\u5e26\u8d27\u5206\u6790-\u5e97\u94fa\u5217\u8868")
    @PostMapping(value={"/detail/listShop"})
    public Result<?> listShop(@RequestBody SimplePostRequestParam<DouYinTopManDetailDTO> param) {
        try {
            IPage<TopManShopListEntity> pageList = this.topManInformationService.queryShopListNew(param);
            return Result.ok(pageList);
        }
        catch (TopManException te) {
            return Result.error((String)te.getMessage());
        }
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, final @RequestParam(value="param") String param) {
        HashMap<String, Object> map = new HashMap<String, Object>(1){
            {
                super(x0);
                this.put("ids", param.split(","));
            }
        };
        return super.exportXls(request, (Map)map, TopManInformationExportServiceImpl.class);
    }
}

