/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.annotation.ApiCallCount;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.util.I18nUtil;
import com.els.common.vo.CountVO;
import com.els.modules.industryinfo.dto.GoodsHeadQueryDTO;
import com.els.modules.industryinfo.dto.StoreHeadQueryDTO;
import com.els.modules.industryinfo.dto.TopmanItemQueryDTO;
import com.els.modules.industryinfo.entity.GoodsHead;
import com.els.modules.industryinfo.entity.StoreHead;
import com.els.modules.industryinfo.entity.TopManInformationHead;
import com.els.modules.industryinfo.excel.StoreHeadExportServiceImpl;
import com.els.modules.industryinfo.query.GoodsHeadQueryParam;
import com.els.modules.industryinfo.query.StoreHeadQueryParam;
import com.els.modules.industryinfo.query.TopmanRecordQueryParam;
import com.els.modules.industryinfo.service.GoodsHeadService;
import com.els.modules.industryinfo.service.StoreHeadService;
import com.els.modules.industryinfo.service.StoreTopmanRecordService;
import com.els.modules.industryinfo.utils.spider.entity.StorePhoneEntity;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.industryinfo.vo.StoreHeadVO;
import com.els.modules.industryinfo.vo.TopmanItemVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/industryinfo/storeHead"})
@Api(tags={"\u5e97\u94fa\u4fe1\u606f\u5934"})
public class StoreHeadController
extends BaseController<StoreHead, StoreHeadService> {
    private static final Logger log = LoggerFactory.getLogger(StoreHeadController.class);
    @Autowired
    private StoreHeadService storeHeadService;
    @Autowired
    private StoreTopmanRecordService storeTopmanRecordService;
    @Autowired
    private GoodsHeadService goodsHeadService;
    @Autowired
    private SpiderApiUtil spiderApiUtil;

    @ApiOperation(value="\u5e97\u94fa\u5217\u8868", notes="\u5e97\u94fa\u5217\u8868")
    @GetMapping(value={"/list"})
    @ApiCallCount(apiCode="industry_shop_list_data")
    public Result<?> queryPageList(StoreHead storeHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, StoreHeadQueryDTO queryDTO, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<StoreHead> queryWrapper = StoreHeadQueryParam.getQueryParam(storeHead, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<StoreHead> pageList = this.storeHeadService.queryPage((Page<StoreHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u6211\u7684\u6536\u85cf\u5217\u8868", notes="\u6211\u7684\u6536\u85cf\u5217\u8868")
    @GetMapping(value={"/favoriteList"})
    public Result<?> queryPageFavoriteList(StoreHead storeHead, StoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<StoreHead> queryWrapper = StoreHeadQueryParam.getQueryParam(storeHead, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<StoreHead> pageList = this.storeHeadService.queryFavoritePage((Page<StoreHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @AutoLog(busModule="\u5e97\u94fa\u4fe1\u606f\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody StoreHeadVO headVO) {
        StoreHead storeHead = new StoreHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)storeHead));
        storeHead.setBusAccount(this.getTenantId());
        this.storeHeadService.saveMain(storeHead, headVO);
        return Result.ok((Object)((Object)storeHead));
    }

    @AutoLog(busModule="\u5e97\u94fa\u4fe1\u606f\u5934", value="\u6536\u85cf")
    @ApiOperation(value="\u6536\u85cf", notes="\u6536\u85cf")
    @GetMapping(value={"/favorite"})
    public Result<?> favorite(@RequestParam(name="id") String id) {
        this.storeHeadService.favorite(id);
        return this.commonSuccessResult(3);
    }

    @AutoLog(busModule="\u5e97\u94fa\u4fe1\u606f\u5934", value="\u53d6\u6d88\u6536\u85cf")
    @ApiOperation(value="\u53d6\u6d88\u6536\u85cf", notes="\u53d6\u6d88\u6536\u85cf")
    @GetMapping(value={"/cancelFavorite"})
    public Result<?> cancelFavorite(@RequestParam(name="id") String id) {
        this.storeHeadService.cancelFavorite(id);
        return this.commonSuccessResult(3);
    }

    @ApiOperation(value="\u5e97\u94fa\u8be6\u60c5", notes="\u5e97\u94fa\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    @ApiCallCount(apiCode="industry_shop_detail_data")
    public Result<?> queryById(@RequestParam(name="id") String id) {
        StoreHeadVO headVO = this.storeHeadService.queryById(id);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/topmanList"})
    public Result<?> topmanList(TopManInformationHead head, TopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Assert.hasText((String)queryDTO.getShopId(), (String)I18nUtil.translate((String)"i18n_alert_empty_notShopId", (String)"\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a"));
        QueryWrapper<TopManInformationHead> queryWrapper = TopmanRecordQueryParam.getQueryParam(head, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage<TopmanItemVO> pageList = this.storeTopmanRecordService.queryTopmanPage((Page<TopManInformationHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf")
    @GetMapping(value={"/contentTypeCounts"})
    public Result<?> contentTypeCounts(TopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.storeTopmanRecordService.contentTypeCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u53e3\u7891\u9875\u7b7e\u6570\u91cf")
    @GetMapping(value={"/goodsWomCounts"})
    public Result<?> goodsWomCounts(TopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.storeTopmanRecordService.goodsWomCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u6790\u5217\u8868", notes="\u5546\u54c1\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/goodsList"})
    public Result<?> queryPageList(GoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Assert.hasText((String)queryDTO.getShopId(), (String)I18nUtil.translate((String)"i18n_alert_empty_notShopId", (String)"\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a"));
        QueryWrapper<GoodsHead> queryWrapper = GoodsHeadQueryParam.getQueryParam(new GoodsHead(), req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        if (StringUtils.isBlank((CharSequence)queryDTO.getTimeSelect())) {
            queryDTO.setTimeSelect("30");
        }
        this.goodsHeadService.categoryConvert(queryDTO);
        IPage<GoodsHead> pageList = this.goodsHeadService.queryPage((Page<GoodsHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf", notes="\u5546\u54c1\u5206\u6790\u5217\u8868-\u5206\u7c7b\u9875\u7b7e\u6570\u91cf")
    @GetMapping(value={"/categoryCounts"})
    public Result<?> contentTypeCounts(GoodsHeadQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.goodsHeadService.categoryCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u5e97\u94fa\u5217\u8868-\u5bfc\u51fa", notes="\u5e97\u94fa\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, StoreHeadExportServiceImpl.class);
    }

    @ApiOperation(value="\u901a\u8fc7\u5e73\u53f0\u548c\u5e97\u94fa\u540d\u79f0\uff08\u7cbe\u51c6\uff09\u67e5\u8be2", notes="\u901a\u8fc7\u5e73\u53f0\u548c\u5e97\u94fa\u540d\u79f0\uff08\u7cbe\u51c6\uff09\u67e5\u8be2")
    @GetMapping(value={"/queryByName"})
    public Result<?> queryByName(@RequestParam(name="platform") String platform, @RequestParam(name="name") String name) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().eq(StoreHead::getPlatform, (Object)platform)).eq(StoreHead::getName, (Object)name);
        List headVO = ((StoreHeadService)this.service).list((Wrapper)queryWrapper);
        headVO.forEach(a -> {
            HashMap<String, Object> paramBean = new HashMap<String, Object>(1){
                {
                    super(arg0);
                    this.put("shop_id", a.getShopId());
                }
            };
            StorePhoneEntity storePhone = this.spiderApiUtil.getForEntity(SpiderMethodType.DOU_YIN_STORE_PHONE, (Map<String, Object>)paramBean, StorePhoneEntity.class);
            String phone = storePhone.getPhone();
            a.setShopPhone(phone != null && phone.length() == 11 ? phone.substring(0, 2) + "********" + phone.substring(10) : null);
        });
        return Result.ok((Object)headVO);
    }
}

