/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.exception.ELSBootException;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryInfo.api.weboption.TopManOptionsEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationAlbumListEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationBasicAnalysisEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationDetailsEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationFanAnalysisEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationLatestTenVideoTrendsEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationLiveAnalysisEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationPromotionAnalysisEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationSpecialListEntity;
import com.els.modules.industryinfo.entity.BStationTopManInformationVideoListEntity;
import com.els.modules.industryinfo.enumerate.BStationOptionsType;
import com.els.modules.industryinfo.enumerate.BStationOptionsTypeGroup;
import com.els.modules.industryinfo.mapper.BStationTopManInformationMapper;
import com.els.modules.industryinfo.mapper.McnAttachmentMapper;
import com.els.modules.industryinfo.service.BStationTopManInformationService;
import com.els.modules.industryinfo.utils.HttpRequestUtils;
import com.els.modules.industryinfo.vo.BStationManInformationVO;
import com.els.modules.industryinfo.vo.BStationRequestParamVO;
import com.els.modules.industryinfo.weboption.OptionFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class BStationTopManInformationServiceImpl
implements BStationTopManInformationService {
    private static final Logger log = LoggerFactory.getLogger(BStationTopManInformationServiceImpl.class);
    @Value(value="${bs.ipAddress}")
    private String ipAddress;
    @Autowired
    BStationTopManInformationMapper baseMapper;
    @Autowired
    McnAttachmentMapper mcnAttachmentMapper;
    @Autowired
    private RedisUtil redisUtil;
    private static final String TALENT_DETAILS = "bstation:talent:details:cache";
    private static final String COLON = ":";
    private static final String BS = "bs";

    @Override
    public List<TopManOptionsEntity> getOptions(String type, String clearCache) {
        OptionFactory.OptionHandler<BStationOptionsTypeGroup, BStationOptionsType> init = OptionFactory.init(BStationOptionsTypeGroup.class, BStationOptionsType.class);
        init.setCollection("tb_huahuo_category");
        switch (type) {
            case "videoTopMan": {
                init.when(BStationOptionsType.commercialOrderType, (doc, param) -> this.transferTopManCommercial(doc, "videoTopMan")).when(BStationOptionsType.talentInfo, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan")).when(BStationOptionsType.fansPortrait, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan")).when(BStationOptionsType.putInfo, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan")).when(BStationOptionsType.otherFilter, (doc, param) -> this.transferFansPortrait(doc, "videoTopMan"));
                break;
            }
            case "liveTopMan": {
                init.when(BStationOptionsType.liveType, (doc, param) -> this.transferLiveTopMan(doc, "liveTopMan")).when(BStationOptionsType.talentInfo, (doc, param) -> this.transferFansPortrait(doc, "liveTopMan")).when(BStationOptionsType.fansPortrait, (doc, param) -> this.transferFansPortrait(doc, "liveTopMan"));
                break;
            }
            case "collectTopMan": {
                init.when(BStationOptionsType.commercialOrderType, (doc, param) -> this.transferTopManCommercial(doc, "collectTopMan")).when(BStationOptionsType.liveType, (doc, param) -> this.transferLiveTopMan(doc, "collectTopMan")).when(BStationOptionsType.talentInfo, (doc, param) -> this.transferFansPortrait(doc, "collectTopMan")).when(BStationOptionsType.putInfo, (doc, param) -> this.transferFansPortrait(doc, "collectTopMan")).when(BStationOptionsType.otherFilter, (doc, param) -> this.transferFansPortrait(doc, "collectTopMan"));
                break;
            }
            default: {
                throw new ELSBootException(I18nUtil.translate((String)"", (String)"\u672a\u627e\u5230\u8be5\u8bf7\u6c42\u7c7b\u578b"));
            }
        }
        return init.getResult(type, "1".equals(clearCache));
    }

    @Override
    public IPage<BStationTopManInformationEntity> queryTopManList(SimplePostRequestParam<BStationManInformationVO> topManDto) throws Exception {
        Page page;
        BStationManInformationVO filterInfo = (BStationManInformationVO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        BStationTopManInformationEntity bStationTopManInformation = new BStationTopManInformationEntity();
        QueryWrapper queryWrapper = new QueryWrapper();
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("list").append(COLON);
        String param = BStationTopManInformationServiceImpl.apiGetList(taskType, topManDto, bStationTopManInformation, (QueryWrapper<BStationTopManInformationEntity>)queryWrapper, redisKey);
        redisKey.append(taskType).append(COLON).append(topManDto.getPageNo()).append(COLON).append(topManDto.getPageSize());
        switch (taskType) {
            case "videoTopMan": {
                page = (Page)this.redisUtil.get(redisKey.toString());
                if (page != null) break;
                page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                String urlVideo = this.ipAddress + "/bilibili/content/cooperation/api/list";
                JSONObject jsonObjectVideo = HttpRequestUtils.doPost(urlVideo, param);
                if (jsonObjectVideo == null || jsonObjectVideo.size() == 0) {
                    return page;
                }
                JSONArray dataVideo = jsonObjectVideo.getJSONArray("data");
                List bStationManInformationVOVideo = dataVideo.toJavaList(BStationTopManInformationEntity.class);
                page.setTotal((long)jsonObjectVideo.getInteger("total_count").intValue());
                this.handleResult(bStationManInformationVOVideo, filterInfo.getPlatformType());
                page.setRecords(bStationManInformationVOVideo);
                if (!CollectionUtils.isNotEmpty((Collection)bStationManInformationVOVideo)) break;
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
                break;
            }
            case "liveTopMan": {
                page = (IPage)this.redisUtil.get(redisKey.toString());
                if (page != null) break;
                page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                String urlLive = this.ipAddress + "/bilibili/live/cooperation/api/telent_live_data/list";
                JSONObject jsonObjectLive = HttpRequestUtils.doPost(urlLive, param);
                if (jsonObjectLive == null || jsonObjectLive.size() == 0) {
                    return page;
                }
                JSONArray dataLive = jsonObjectLive.getJSONArray("data");
                List bStationManInformationVOLive = dataLive.toJavaList(BStationTopManInformationEntity.class);
                page.setTotal((long)jsonObjectLive.getInteger("total_count").intValue());
                this.handleResult(bStationManInformationVOLive, filterInfo.getPlatformType());
                page.setRecords(bStationManInformationVOLive);
                if (!CollectionUtils.isNotEmpty((Collection)bStationManInformationVOLive)) break;
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
                break;
            }
            case "collectTopMan": {
                page = new Page((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
                page = this.baseMapper.selectCollectTopMan((IPage<BStationTopManInformationEntity>)page, (Wrapper<BStationTopManInformationEntity>)queryWrapper, SysUtil.getLoginUser(), bStationTopManInformation);
                break;
            }
            default: {
                throw new ELSBootException("\u8be5\u8bf7\u6c42\u4e0d\u5408\u6cd5");
            }
        }
        return page;
    }

    @Override
    public BStationTopManInformationDetailsEntity bStationTopManDetails(String bStationId, String topmanId) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("list").append(COLON).append(TALENT_DETAILS).append(COLON).append(bStationId);
        System.out.println("vvvvvvvvvvvv:" + redisKey.toString());
        BStationTopManInformationDetailsEntity bStationTopManInformationDetails = (BStationTopManInformationDetailsEntity)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationDetails == null) {
            log.info("\u65e0\u8fbe\u4eba\u5934\u90e8\u8be6\u60c5\u7f13\u5b58\u7684\u65f6\u5019\u8c03\u7528\u8fd9\u91cc\uff01");
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            param.put("mcn_id", topmanId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/video/analysis/details";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new BStationTopManInformationDetailsEntity();
            }
            JSONArray data = jsonObject.getJSONArray("data");
            List topManInfos = data.toJavaList(BStationTopManInformationDetailsEntity.TopManInfo.class);
            List topManVideoData = data.toJavaList(BStationTopManInformationDetailsEntity.TopManVideoData.class);
            List topManLiveData = data.toJavaList(BStationTopManInformationDetailsEntity.TopManLiveData.class);
            List topManCoreData = data.toJavaList(BStationTopManInformationDetailsEntity.TopManCoreData.class);
            bStationTopManInformationDetails = new BStationTopManInformationDetailsEntity();
            bStationTopManInformationDetails.setTopManInfo((BStationTopManInformationDetailsEntity.TopManInfo)topManInfos.get(0));
            bStationTopManInformationDetails.setTopManCoreData((BStationTopManInformationDetailsEntity.TopManCoreData)topManCoreData.get(0));
            bStationTopManInformationDetails.setTopManLiveData((BStationTopManInformationDetailsEntity.TopManLiveData)topManLiveData.get(0));
            bStationTopManInformationDetails.setTopManVideoData((BStationTopManInformationDetailsEntity.TopManVideoData)topManVideoData.get(0));
            List<String> ids = Arrays.asList(((BStationTopManInformationDetailsEntity.TopManInfo)topManInfos.get(0)).getBStationId());
            List<BStationTopManInformationEntity> bStationTopManInformationEntities = this.baseMapper.checkAddedAndCollect(ids, SysUtil.getLoginUser(), "4");
            if (CollectionUtils.isNotEmpty(bStationTopManInformationEntities)) {
                bStationTopManInformationDetails.setIsAdded(bStationTopManInformationEntities.get(0).getIsAdded());
                bStationTopManInformationDetails.setIsCollection(bStationTopManInformationEntities.get(0).getIsCollection());
            }
            System.out.println("aaaaaaaaaaaa=" + redisKey.toString());
            this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationDetails, 9000L);
        }
        return bStationTopManInformationDetails;
    }

    @Override
    public IPage<BStationTopManInformationBasicAnalysisEntity> bStationTopManFanBasicAnalysisList(String bStationId, String fanCode, int pageNO) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("fan").append(COLON).append(bStationId).append(COLON).append(fanCode).append(COLON).append(pageNO);
        IPage page = (IPage)this.redisUtil.get(redisKey.toString());
        if (page == null) {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("upper_mid", bStationId);
            if (StringUtils.isNotEmpty((CharSequence)fanCode)) {
                param.put("fans_range", fanCode);
            }
            param.put("page", pageNO);
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/similar/fan/telent/list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new Page();
            }
            JSONArray dataVideo = jsonObject.getJSONArray("data");
            List bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(BStationTopManInformationBasicAnalysisEntity.class);
            Integer current = jsonObject.getInteger("page");
            Integer total = jsonObject.getInteger("total");
            page = new Page((long)current.intValue(), 9L, (long)total.intValue());
            page.setRecords(bStationTopManInformationBasicAnalysisEntities);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationBasicAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
            }
        }
        return page;
    }

    @Override
    public List<BStationTopManInformationBasicAnalysisEntity.Screen> bStationTopManFanBasicAnalysisCategory() {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("category").append(COLON).append("screen");
        List bStationTopManInformationBasicAnalysisEntities = (List)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationBasicAnalysisEntities == null) {
            HashMap param = new HashMap();
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/similar/fan/telent/category";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new ArrayList<BStationTopManInformationBasicAnalysisEntity.Screen>();
            }
            JSONArray dataVideo = jsonObject.getJSONArray("data");
            bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(BStationTopManInformationBasicAnalysisEntity.Screen.class);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationBasicAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationBasicAnalysisEntities, 9000L);
            }
        }
        return bStationTopManInformationBasicAnalysisEntities;
    }

    @Override
    public List<BStationTopManInformationBasicAnalysisEntity> bStationTopManContentBasicAnalysisList(String bStationId) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("Similarfansoverlap").append(COLON).append(bStationId);
        List bStationTopManInformationBasicAnalysisEntities = (List)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationBasicAnalysisEntities == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/similar/content/telent/list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new ArrayList<BStationTopManInformationBasicAnalysisEntity>();
            }
            JSONArray dataVideo = jsonObject.getJSONArray("data");
            bStationTopManInformationBasicAnalysisEntities = dataVideo.toJavaList(BStationTopManInformationBasicAnalysisEntity.class);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationBasicAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationBasicAnalysisEntities, 9000L);
            }
        }
        return bStationTopManInformationBasicAnalysisEntities;
    }

    @Override
    public BStationTopManInformationFanAnalysisEntity bStationTopManFanAnalysisDetails(String bStationId, String topmanId) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("FanAnalysisEntity").append(COLON).append(bStationId).append(topmanId);
        BStationTopManInformationFanAnalysisEntity bStationTopManInformationFanAnalysis = (BStationTopManInformationFanAnalysisEntity)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationFanAnalysis == null) {
            ArrayList<String> genderMosts = new ArrayList<String>();
            ArrayList<String> regionMosts = new ArrayList<String>();
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            param.put("mcn_id", topmanId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/fan_analysis/details";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new BStationTopManInformationFanAnalysisEntity();
            }
            JSONArray fanIncrementTrends = jsonObject.getJSONArray("fanIncrementTrends");
            List fanIncrements = fanIncrementTrends.toJavaList(BStationTopManInformationFanAnalysisEntity.FanTrend.class);
            JSONArray fanTotalTrends = jsonObject.getJSONArray("fanTotalTrends");
            List fanTotals = fanTotalTrends.toJavaList(BStationTopManInformationFanAnalysisEntity.FanTrend.class);
            JSONArray genderDistributions = jsonObject.getJSONArray("genderDistributions");
            List genders = genderDistributions.toJavaList(BStationTopManInformationFanAnalysisEntity.GenderDistribution.class);
            BStationTopManInformationFanAnalysisEntity.GenderDistribution gendersMax = Collections.max(genders, new Comparator<BStationTopManInformationFanAnalysisEntity.GenderDistribution>(){

                @Override
                public int compare(BStationTopManInformationFanAnalysisEntity.GenderDistribution u1, BStationTopManInformationFanAnalysisEntity.GenderDistribution u2) {
                    int diff = u1.getCount().compareTo(u2.getCount());
                    if (diff > 0) {
                        return 1;
                    }
                    if (diff < 0) {
                        return -1;
                    }
                    return 0;
                }
            });
            genderMosts.add(gendersMax.getGender() + "\u5c45\u591a");
            JSONArray ageDistributions = jsonObject.getJSONArray("ageDistributions");
            List ages = ageDistributions.toJavaList(BStationTopManInformationFanAnalysisEntity.AgeDistribution.class);
            BStationTopManInformationFanAnalysisEntity.AgeDistribution ageMax = Collections.max(ages, new Comparator<BStationTopManInformationFanAnalysisEntity.AgeDistribution>(){

                @Override
                public int compare(BStationTopManInformationFanAnalysisEntity.AgeDistribution u1, BStationTopManInformationFanAnalysisEntity.AgeDistribution u2) {
                    int diff = u1.getCount().compareTo(u2.getCount());
                    if (diff > 0) {
                        return 1;
                    }
                    if (diff < 0) {
                        return -1;
                    }
                    return 0;
                }
            });
            genderMosts.add(ageMax.getAge() + "\u5c45\u591a");
            JSONArray equipmentDistributions = jsonObject.getJSONArray("equipmentDistributions");
            List equipments = equipmentDistributions.toJavaList(BStationTopManInformationFanAnalysisEntity.EquipmentDistribution.class);
            BStationTopManInformationFanAnalysisEntity.EquipmentDistribution equipmentsMax = Collections.max(equipments, new Comparator<BStationTopManInformationFanAnalysisEntity.EquipmentDistribution>(){

                @Override
                public int compare(BStationTopManInformationFanAnalysisEntity.EquipmentDistribution u1, BStationTopManInformationFanAnalysisEntity.EquipmentDistribution u2) {
                    int diff = u1.getCount().compareTo(u2.getCount());
                    if (diff > 0) {
                        return 1;
                    }
                    if (diff < 0) {
                        return -1;
                    }
                    return 0;
                }
            });
            genderMosts.add(equipmentsMax.getMobile() + "\u5c45\u591a");
            JSONArray regionDistributions = jsonObject.getJSONArray("regionDistributions");
            List regions = regionDistributions.toJavaList(BStationTopManInformationFanAnalysisEntity.RegionDistribution.class);
            JSONArray topTenRegionDistributions = jsonObject.getJSONArray("topTenRegionDistributions");
            List topTenRegion = topTenRegionDistributions.toJavaList(BStationTopManInformationFanAnalysisEntity.RegionDistribution.class);
            BStationTopManInformationFanAnalysisEntity.RegionDistribution topTenRegionMax = Collections.max(topTenRegion, new Comparator<BStationTopManInformationFanAnalysisEntity.RegionDistribution>(){

                @Override
                public int compare(BStationTopManInformationFanAnalysisEntity.RegionDistribution u1, BStationTopManInformationFanAnalysisEntity.RegionDistribution u2) {
                    int diff = u1.getCount().compareTo(u2.getCount());
                    if (diff > 0) {
                        return 1;
                    }
                    if (diff < 0) {
                        return -1;
                    }
                    return 0;
                }
            });
            genderMosts.add(topTenRegionMax.getRegion() + "\u5c45\u591a");
            bStationTopManInformationFanAnalysis = new BStationTopManInformationFanAnalysisEntity();
            bStationTopManInformationFanAnalysis.setFanTotalTrends(fanTotals);
            bStationTopManInformationFanAnalysis.setFanIncrementTrends(fanIncrements);
            bStationTopManInformationFanAnalysis.setAgeDistributions(ages);
            bStationTopManInformationFanAnalysis.setEquipmentDistributions(equipments);
            bStationTopManInformationFanAnalysis.setGenderDistributions(genders);
            bStationTopManInformationFanAnalysis.setTopTenRegionDistributions(topTenRegion);
            bStationTopManInformationFanAnalysis.setRegionDistributions(regions);
            bStationTopManInformationFanAnalysis.setGenderMost(genderMosts);
            bStationTopManInformationFanAnalysis.setRegionMost(regionMosts);
            this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationFanAnalysis, 9000L);
        }
        return bStationTopManInformationFanAnalysis;
    }

    @Override
    public List<BStationTopManInformationPromotionAnalysisEntity> bStationTopManPromotionAnalysisDetails(String bStationId, String topmanId) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append("PromotionAnalysisEntity").append(COLON).append(TenantContext.getTenant()).append(COLON).append(bStationId).append(topmanId);
        List bStationTopManInformationPromotionAnalysisEntities = (List)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationPromotionAnalysisEntities == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            param.put("mcn_id", topmanId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/promotion_analysis/details";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new ArrayList<BStationTopManInformationPromotionAnalysisEntity>();
            }
            JSONArray data = jsonObject.getJSONArray("data");
            bStationTopManInformationPromotionAnalysisEntities = data.toJavaList(BStationTopManInformationPromotionAnalysisEntity.class);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationPromotionAnalysisEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationPromotionAnalysisEntities, 9000L);
            }
        }
        return bStationTopManInformationPromotionAnalysisEntities;
    }

    @Override
    public List<BStationTopManInformationLatestTenVideoTrendsEntity> bStationTopManLatestTenVideoTrends(String bStationId, String type) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("TenVideoTrendsEntity").append(COLON).append(bStationId).append(type);
        List latestTenVideoTrendsEntities = (List)this.redisUtil.get(redisKey.toString());
        if (latestTenVideoTrendsEntities == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            param.put("trend_type", type);
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/content/cooperation/api/latest_10_video_trends/details";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new ArrayList<BStationTopManInformationLatestTenVideoTrendsEntity>();
            }
            JSONArray jsonArray = jsonObject.getJSONArray("data");
            latestTenVideoTrendsEntities = jsonArray.toJavaList(BStationTopManInformationLatestTenVideoTrendsEntity.class);
            if (CollectionUtils.isNotEmpty((Collection)latestTenVideoTrendsEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)latestTenVideoTrendsEntities, 9000L);
            }
        }
        return latestTenVideoTrendsEntities;
    }

    @Override
    public BStationTopManInformationLiveAnalysisEntity bStationTopManLiveAnalysis(String bStationId, String topmanId) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("LiveAnalysisEntity").append(COLON).append(bStationId).append(topmanId);
        BStationTopManInformationLiveAnalysisEntity bStationTopManInformationLiveAnalysisEntity = (BStationTopManInformationLiveAnalysisEntity)this.redisUtil.get(redisKey.toString());
        if (bStationTopManInformationLiveAnalysisEntity == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("upper_mid", bStationId);
            param.put("mcn_id", topmanId);
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/live/cooperation/api/telent_live_analysis/details";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new BStationTopManInformationLiveAnalysisEntity();
            }
            bStationTopManInformationLiveAnalysisEntity = (BStationTopManInformationLiveAnalysisEntity)jsonObject.toJavaObject(BStationTopManInformationLiveAnalysisEntity.class);
            this.redisUtil.set(redisKey.toString(), (Object)bStationTopManInformationLiveAnalysisEntity, 9000L);
        }
        return bStationTopManInformationLiveAnalysisEntity;
    }

    @Override
    public BStationTopManInformationVideoListEntity bStationTopManVideoList(String bStationId, String categoryId, String page, String keyword) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("VideoListEntity").append(COLON).append(bStationId).append(categoryId).append(COLON).append(page).append(COLON).append(keyword);
        BStationTopManInformationVideoListEntity videoListEntity = (BStationTopManInformationVideoListEntity)this.redisUtil.get(redisKey.toString());
        if (videoListEntity == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("mid", bStationId);
            param.put("tid", categoryId);
            param.put("pn", page);
            param.put("ps", "30");
            param.put("keyword", keyword);
            param.put("order", "pubdate");
            param.put("jsonp", "jsonp");
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/work/api/work_analysis_video/video_list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new BStationTopManInformationVideoListEntity();
            }
            JSONArray video = jsonObject.getJSONArray("video");
            List videoLists = video.toJavaList(BStationTopManInformationVideoListEntity.VideoList.class);
            JSONArray catgory = jsonObject.getJSONArray("catgory");
            List videoCategories = catgory.toJavaList(BStationTopManInformationVideoListEntity.VideoCategory.class);
            Collections.sort(videoCategories);
            videoListEntity = new BStationTopManInformationVideoListEntity();
            videoListEntity.setVideo(videoLists);
            videoListEntity.setCategory(videoCategories);
            videoListEntity.setCurrent(jsonObject.getInteger("current"));
            videoListEntity.setSize(jsonObject.getInteger("size"));
            videoListEntity.setTotal(jsonObject.getInteger("total"));
            this.redisUtil.set(redisKey.toString(), (Object)videoListEntity, 9000L);
        }
        return videoListEntity;
    }

    @Override
    public IPage<BStationTopManInformationSpecialListEntity> bStationTopManSpecialList(String bStationId, String pageNo) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("SpecialListEntity").append(COLON).append(bStationId).append(pageNo);
        IPage page = (IPage)this.redisUtil.get(redisKey.toString());
        if (page == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("mid", bStationId);
            param.put("pn", pageNo);
            param.put("ps", "12");
            param.put("sort", "publish_time");
            param.put("callback", "__jp3");
            param.put("jsonp", "jsonp");
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/work/api/work_analysis_special/special_list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new Page();
            }
            JSONArray data = jsonObject.getJSONArray("data");
            List bStationTopManInformationSpecialListEntities = data.toJavaList(BStationTopManInformationSpecialListEntity.class);
            page = new Page((long)jsonObject.getInteger("current").intValue(), (long)jsonObject.getInteger("size").intValue(), (long)jsonObject.getInteger("total").intValue());
            page.setRecords(bStationTopManInformationSpecialListEntities);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationSpecialListEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
            }
        }
        return page;
    }

    @Override
    public IPage<BStationTopManInformationAlbumListEntity> bStationTopManAlbumList(String bStationId, String pageNo) {
        StringBuilder redisKey = new StringBuilder(BS).append(COLON).append(TenantContext.getTenant()).append(COLON).append("AlbumListEntity").append(COLON).append(bStationId).append(pageNo);
        IPage page = (IPage)this.redisUtil.get(redisKey.toString());
        if (page == null) {
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("uid", bStationId);
            param.put("page_num", pageNo);
            param.put("page_size", "30");
            param.put("biz", "all");
            param.put("jsonp", "jsonp");
            String string = JSON.toJSONString(param);
            String urlDetails = this.ipAddress + "/bilibili/work/api/work_analysis_album/album_list";
            JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
            if (jsonObject == null || jsonObject.size() == 0) {
                return new Page();
            }
            JSONArray data = jsonObject.getJSONArray("data");
            List bStationTopManInformationAlbumListEntities = data.toJavaList(BStationTopManInformationAlbumListEntity.class);
            page = new Page();
            page.setSize((long)jsonObject.getInteger("size").intValue());
            page.setTotal((long)jsonObject.getInteger("total").intValue());
            page.setRecords(bStationTopManInformationAlbumListEntities);
            if (CollectionUtils.isNotEmpty((Collection)bStationTopManInformationAlbumListEntities)) {
                this.redisUtil.set(redisKey.toString(), (Object)page, 9000L);
            }
        }
        return page;
    }

    @Override
    public void cleanCache(String cacheKey) {
        this.redisUtil.dels(cacheKey);
    }

    public static void sort(SimplePostRequestParam<BStationManInformationVO> topManDto, BStationRequestParamVO.Content ksSpiderApiIndexListVo, QueryWrapper<BStationTopManInformationEntity> queryWrapper) {
        boolean order = false;
        if (StringUtils.isNotEmpty((CharSequence)topManDto.getColumn())) {
            String column = topManDto.getColumn();
            if (StringUtils.isNotEmpty((CharSequence)topManDto.getOrder()) && "asc".equals(topManDto.getOrder())) {
                order = true;
            }
            switch (column) {
                case "fanTotal": {
                    ksSpiderApiIndexListVo.setOrder_by("fans_num");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"fan_total"});
                    break;
                }
                case "avgPlay": {
                    ksSpiderApiIndexListVo.setOrder_by("last5_avg_play");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"avg_play"});
                    break;
                }
                case "interactionRate": {
                    ksSpiderApiIndexListVo.setOrder_by("last5_interaction_rate");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"interaction_rate"});
                    break;
                }
                case "topmanName": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"topman_name"});
                    break;
                }
                case "topmanRegion": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"topman_region"});
                    break;
                }
                case "topmanLevel": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"topman_level"});
                    break;
                }
                case "commercialOrderType": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"commercial_drder_type"});
                    break;
                }
                case "liveLabel": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"livelabel"});
                    break;
                }
                case "liveCategory": {
                    queryWrapper.orderBy(true, order, (Object[])new String[]{"live_category"});
                    break;
                }
                default: {
                    BStationManInformationVO filterInfo = (BStationManInformationVO)topManDto.getFilterInfo();
                    if (!filterInfo.getTaskType().equals("liveTopMan")) break;
                    ksSpiderApiIndexListVo.setOrder_by("fans_num");
                    ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                }
            }
            if (column.equals("customVideoPrice") || column.equals("implantVideoPrice") || column.equals("directDynamicPrice") || column.equals("forwardDynamicPrice")) {
                ksSpiderApiIndexListVo.setOrder_by("price");
                ksSpiderApiIndexListVo.setSort(topManDto.getOrder());
                switch (column) {
                    case "customVideoPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"interaction_rate"});
                        break;
                    }
                    case "implantVideoPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"implant_video_price"});
                        break;
                    }
                    case "directDynamicPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"direct_dynamic_price"});
                        break;
                    }
                    case "forwardDynamicPrice": {
                        queryWrapper.orderBy(true, order, (Object[])new String[]{"forwarddynamic_price"});
                    }
                }
            }
        } else {
            queryWrapper.orderBy(true, order, (Object[])new String[]{"collect_update_time"});
        }
    }

    public static String camelToUnderline(String para) {
        if (para.length() < 3) {
            return para.toLowerCase();
        }
        StringBuilder sb = new StringBuilder(para);
        int temp = 0;
        for (int i = 2; i < para.length(); ++i) {
            if (!Character.isUpperCase(para.charAt(i))) continue;
            sb.insert(i + temp, "_");
            ++temp;
        }
        return sb.toString().toLowerCase();
    }

    private static String apiGetList(String taskType, SimplePostRequestParam<BStationManInformationVO> topManDto, BStationTopManInformationEntity bStationTopManInformation, QueryWrapper<BStationTopManInformationEntity> queryWrapper, StringBuilder cacheKey) throws Exception {
        BStationManInformationVO.ScreenItem screenItem;
        BStationManInformationVO filterInfo = (BStationManInformationVO)topManDto.getFilterInfo();
        BStationRequestParamVO.Content ksSpiderApiIndexListVo = BStationTopManInformationServiceImpl.getRequestContent(taskType, topManDto);
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            ksSpiderApiIndexListVo.setNickname_or_mid(keyWord.trim());
            queryWrapper.lambda().eq(BStationTopManInformationEntity::getTopmanName, (Object)keyWord.trim());
            cacheKey.append(keyWord.trim()).append(";");
        }
        if ((screenItem = filterInfo.getScreenItem()) != null) {
            List<BStationManInformationVO.ScreenItemField> otherFilter;
            List<BStationManInformationVO.ScreenItemField> putInfo;
            List<BStationManInformationVO.ScreenItemField> fansPortrait;
            List<BStationManInformationVO.ScreenItemField> talentInfo;
            List<BStationManInformationVO.ScreenItemField> liveType;
            List<BStationManInformationVO.ScreenItemField> commercialOrderType = screenItem.getCommercialOrderType();
            if (CollectionUtils.isNotEmpty(commercialOrderType)) {
                Map<String, String> queryParam = BStationTopManInformationServiceImpl.getQueryParam(commercialOrderType, cacheKey);
                ksSpiderApiIndexListVo.setCommercial_tag_id(queryParam.get("value"));
                bStationTopManInformation.setCommercialOrderType(queryParam.get("label"));
            }
            if (CollectionUtils.isNotEmpty(liveType = screenItem.getLiveType())) {
                Map<String, String> queryParam = BStationTopManInformationServiceImpl.getQueryParam(liveType, cacheKey);
                ksSpiderApiIndexListVo.setArea_id(queryParam.get("value"));
                bStationTopManInformation.setLiveCategory(queryParam.get("label"));
            }
            if (CollectionUtils.isNotEmpty(talentInfo = screenItem.getTalentInfo())) {
                talentInfo.forEach(a -> {
                    switch (a.getTitle()) {
                        case "\u4eba\u8bbe\u6807\u7b7e": {
                            Map<String, String> telentInfoParam = BStationTopManInformationServiceImpl.getTelentInfoParam(a.getValue(), cacheKey);
                            ksSpiderApiIndexListVo.setCharacter_tag_id(telentInfoParam.get("value"));
                            bStationTopManInformation.setHumanTag(telentInfoParam.get("label"));
                            break;
                        }
                        case "\u76f4\u64ad\u6807\u7b7e": {
                            Map<String, String> liveTag = BStationTopManInformationServiceImpl.getTelentInfoParam(a.getValue(), cacheKey);
                            ksSpiderApiIndexListVo.setLive_parent_tag(liveTag.get("value"));
                            bStationTopManInformation.setLiveLabel(liveTag.get("label"));
                            break;
                        }
                        case "\u65e5\u5e38\u804c\u4e1a": {
                            Map<String, String> occupationTag = BStationTopManInformationServiceImpl.getTelentInfoParam(a.getValue(), cacheKey);
                            ksSpiderApiIndexListVo.setOccupation_tag_id(occupationTag.get("value"));
                            bStationTopManInformation.setDailyOccupation(occupationTag.get("label"));
                            break;
                        }
                        case "\u7c89\u4e1d\u603b\u6570": {
                            BStationTopManInformationServiceImpl.getParam(a.getValue().toString(), a.getTitle(), ksSpiderApiIndexListVo, queryWrapper, cacheKey);
                            break;
                        }
                        case "\u8fbe\u4eba\u6027\u522b": {
                            ksSpiderApiIndexListVo.setGender(a.getValue().toString());
                            queryWrapper.lambda().eq(BStationTopManInformationEntity::getTopmanGender, (Object)a.getValue().toString());
                            cacheKey.append(a.getValue().toString()).append(COLON);
                            break;
                        }
                        case "\u8fbe\u4eba\u5730\u57df": {
                            BStationTopManInformationServiceImpl.getRegion(a.getValue(), ksSpiderApiIndexListVo, bStationTopManInformation, cacheKey);
                            break;
                        }
                        case "\u662f\u5426\u7b7e\u7ea6": {
                            if (!a.getValue().toString().equals("true")) break;
                            ksSpiderApiIndexListVo.setOnly_contract("3");
                            queryWrapper.lambda().eq(BStationTopManInformationEntity::getContract, (Object)"3");
                            cacheKey.append("3").append(COLON);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(fansPortrait = screenItem.getFansPortrait())) {
                fansPortrait.forEach(a -> {
                    switch (a.getTitle()) {
                        case "\u7c89\u4e1d\u6027\u522b": {
                            ksSpiderApiIndexListVo.setFans_gender_tag(a.getValue().toString());
                            cacheKey.append(a.getValue().toString()).append(COLON);
                            break;
                        }
                        case "\u7c89\u4e1d\u5e74\u9f84": {
                            ksSpiderApiIndexListVo.setFans_age_tag(a.getValue().toString());
                            cacheKey.append(a.getValue().toString()).append(COLON);
                            break;
                        }
                        case "\u7c89\u4e1d\u57ce\u5e02\u7ebf": {
                            ksSpiderApiIndexListVo.setFans_region_tag(a.getValue().toString());
                            cacheKey.append(a.getValue().toString()).append(COLON);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(putInfo = screenItem.getPutInfo())) {
                putInfo.forEach(a -> {
                    switch (a.getTitle()) {
                        case "\u5b9a\u5236\u89c6\u9891\u62a5\u4ef7": {
                            BStationTopManInformationServiceImpl.getParam(a.getValue(), a.getTitle(), ksSpiderApiIndexListVo, queryWrapper, cacheKey);
                            break;
                        }
                        case "\u5408\u4f5c\u7c7b\u578b": {
                            ksSpiderApiIndexListVo.setCooperation_types(a.getValue().toString());
                            bStationTopManInformation.setCooperationType(BStationTopManInformationServiceImpl.getCooperationType(a.getValue().toString()));
                            cacheKey.append(a.getValue().toString()).append(COLON);
                            break;
                        }
                        default: {
                            throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                        }
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(otherFilter = screenItem.getOtherFilter())) {
                StringBuilder sb = new StringBuilder();
                block12: for (BStationManInformationVO.ScreenItemField a2 : otherFilter) {
                    switch (a2.getTitle()) {
                        case "\u8fd1\u671f\u5165\u9a7b": {
                            BStationTopManInformationServiceImpl.getRecentlySettled(a2.getValue(), ksSpiderApiIndexListVo, cacheKey);
                            continue block12;
                        }
                        case "\u5408\u4f5c\u4e30\u5bcc": {
                            sb = sb.append("cooperate,coo_frequent,coo_multi_industry").append(",");
                            continue block12;
                        }
                        case "\u7c89\u4e1d\u98d9\u5347": {
                            sb = sb.append("grow").append(",");
                            continue block12;
                        }
                        case "\u591a\u6b21\u70ed\u95e8": {
                            sb = sb.append("hot_frequent").append(",");
                            continue block12;
                        }
                    }
                    throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
                }
                if (StringUtils.isNotBlank((CharSequence)sb.toString())) {
                    sb = sb.delete(sb.length() - 1, sb.length());
                }
                ksSpiderApiIndexListVo.setSpark_tag(sb.toString());
                bStationTopManInformation.setSpark(sb.toString().replaceAll(",", "|"));
                cacheKey.append((CharSequence)sb).append(COLON);
            }
        }
        BStationTopManInformationServiceImpl.sort(topManDto, ksSpiderApiIndexListVo, queryWrapper);
        String json = JSON.toJSONString((Object)ksSpiderApiIndexListVo);
        System.out.println("bbbbbbbbbbbbbbb=" + json);
        return json;
    }

    public static Map<String, String> getQueryParam(List<BStationManInformationVO.ScreenItemField> liveType, StringBuilder cacheKey) {
        StringBuilder sbValue = new StringBuilder();
        StringBuilder sbLabel = new StringBuilder();
        liveType.forEach(a -> {
            Object value = a.getValue();
            String string = JSON.toJSONString((Object)value);
            List maps = JSON.parseArray((String)string, Map.class);
            maps.forEach(b -> {
                sbValue.append(b.get("value")).append(",");
                sbLabel.append(b.get("label")).append("|");
            });
        });
        String strCount = sbValue.delete(sbValue.length() - 1, sbValue.length()).toString();
        String strName = sbLabel.delete(sbLabel.length() - 1, sbLabel.length()).toString();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", strCount);
        param.put("label", strName);
        cacheKey.append(strCount).append(COLON);
        return param;
    }

    public static String getCooperationType(String value) {
        String str = "";
        switch (value) {
            case "1": {
                str = "\u690d\u5165\u89c6\u9891";
                break;
            }
            case "2": {
                str = "\u5b9a\u5236\u89c6\u9891";
                break;
            }
            case "3": {
                str = "\u76f4\u53d1\u52a8\u6001";
                break;
            }
            case "4": {
                str = "\u8f6c\u53d1\u52a8\u6001";
                break;
            }
            default: {
                throw new ELSBootException("\u6ca1\u6709\u627e\u5230\u8be5\u9009\u9879");
            }
        }
        return null;
    }

    public static Map<String, String> getTelentInfoParam(Object value, StringBuilder cacheKey) {
        StringBuilder sbValue = new StringBuilder();
        StringBuilder sbLabel = new StringBuilder();
        String string = JSON.toJSONString((Object)value);
        List maps = JSON.parseArray((String)string, Map.class);
        maps.forEach(b -> {
            sbValue.append(b.get("value")).append(",");
            sbLabel.append(b.get("label")).append("|");
        });
        String strCount = sbValue.delete(sbValue.length() - 1, sbValue.length()).toString();
        String strName = sbLabel.delete(sbLabel.length() - 1, sbLabel.length()).toString();
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("value", strCount);
        param.put("label", strName);
        cacheKey.append(strCount).append(COLON);
        return param;
    }

    public static BStationRequestParamVO.Content getRequestContent(String taskType, SimplePostRequestParam<BStationManInformationVO> topManDto) {
        BStationRequestParamVO.Content ksSpiderApiIndexListVo = new BStationRequestParamVO.Content();
        if (taskType.equals("liveTopMan")) {
            ksSpiderApiIndexListVo.setPage(topManDto.getPageNo());
            ksSpiderApiIndexListVo.setSize(topManDto.getPageSize());
            ksSpiderApiIndexListVo.setSort("desc");
            ksSpiderApiIndexListVo.setOrder_by("fans_num");
            ksSpiderApiIndexListVo.setIs_live("true");
            ksSpiderApiIndexListVo.setLive_parent_tag("");
            ksSpiderApiIndexListVo.setArea_id("");
            ksSpiderApiIndexListVo.setParent_area_id("");
        } else {
            ksSpiderApiIndexListVo.setPage(topManDto.getPageNo());
            ksSpiderApiIndexListVo.setSize(topManDto.getPageSize());
            ksSpiderApiIndexListVo.setSort("");
            ksSpiderApiIndexListVo.setOrder_by("");
            ksSpiderApiIndexListVo.setOnly_potential_upper("0");
            ksSpiderApiIndexListVo.setOccupation_tag_id("");
            ksSpiderApiIndexListVo.setCharacter_tag_id("");
            ksSpiderApiIndexListVo.setMin_task_price("");
            ksSpiderApiIndexListVo.setMax_task_price("");
            ksSpiderApiIndexListVo.setProvider_id("");
            ksSpiderApiIndexListVo.setSpark_tag("");
            ksSpiderApiIndexListVo.setCommercial_tag_id("");
            ksSpiderApiIndexListVo.setUpper_mid("");
            ksSpiderApiIndexListVo.setOnly_contract("0");
            ksSpiderApiIndexListVo.setGoods_permission("0");
            ksSpiderApiIndexListVo.setCooperation_types("");
            ksSpiderApiIndexListVo.setUse_dynamic_score("true");
            ksSpiderApiIndexListVo.setLast_7_days_set_price("0");
            ksSpiderApiIndexListVo.setLast_7_days_set_price("0");
            ksSpiderApiIndexListVo.setLast_14_days_set_price("0");
            ksSpiderApiIndexListVo.setLast_30_days_set_price("0");
            ksSpiderApiIndexListVo.setHas_condition("1");
            if (taskType.equals("collectTopMan")) {
                ksSpiderApiIndexListVo.setArea_id("");
            }
        }
        ksSpiderApiIndexListVo.setFans_region_tag("");
        ksSpiderApiIndexListVo.setFans_age_tag("");
        ksSpiderApiIndexListVo.setFans_gender_tag("");
        ksSpiderApiIndexListVo.setMax_fans_num("");
        ksSpiderApiIndexListVo.setMin_fans_num("");
        ksSpiderApiIndexListVo.setSecond_region_id("");
        ksSpiderApiIndexListVo.setRegion_id("");
        ksSpiderApiIndexListVo.setGender("");
        ksSpiderApiIndexListVo.setNickname_or_mid("");
        return ksSpiderApiIndexListVo;
    }

    public static void getRecentlySettled(Object str, BStationRequestParamVO.Content ksSpiderApiIndexListVo, StringBuilder cacheKey) {
        if (StringUtils.isNotEmpty((CharSequence)str.toString())) {
            switch (str.toString()) {
                case "\u8fd17\u5929\u65b0\u5165\u9a7b": {
                    ksSpiderApiIndexListVo.setLast_7_days_set_price("1");
                    cacheKey.append("7").append(COLON);
                    break;
                }
                case "\u8fd114\u5929\u65b0\u5165\u9a7b": {
                    ksSpiderApiIndexListVo.setLast_14_days_set_price("1");
                    cacheKey.append("14").append(COLON);
                    break;
                }
                case "\u8fd130\u5929\u65b0\u5165\u9a7b": {
                    ksSpiderApiIndexListVo.setLast_30_days_set_price("1");
                    cacheKey.append("30").append(COLON);
                    break;
                }
                default: {
                    new ELSBootException("\u627e\u4e0d\u5230\u6539\u7c7b\u578b\u7b5b\u9009\u6761\u4ef6");
                }
            }
        }
    }

    public static void getRegion(Object str, BStationRequestParamVO.Content ksSpiderApiIndexListVo, BStationTopManInformationEntity bStationTopManInformation, StringBuilder cacheKey) {
        String string = JSON.toJSONString((Object)str);
        List maps = JSON.parseArray((String)string, Map.class);
        ksSpiderApiIndexListVo.setRegion_id(((Map)maps.get(0)).get("value").toString());
        bStationTopManInformation.setTopmanRegion(((Map)maps.get(0)).get("label").toString());
        cacheKey.append(((Map)maps.get(0)).get("value").toString()).append(COLON);
        if (((Map)maps.get(1)).size() > 0) {
            ksSpiderApiIndexListVo.setSecond_region_id(((Map)maps.get(1)).get("value").toString());
            bStationTopManInformation.setTopmanRegion(((Map)maps.get(0)).get("label").toString() + "|" + ((Map)maps.get(1)).get("value").toString());
            cacheKey.append(((Map)maps.get(0)).get("label").toString() + "|" + ((Map)maps.get(1)).get("value").toString()).append(COLON);
        }
    }

    public static void getParam(Object str, String type, BStationRequestParamVO.Content ksSpiderApiIndexListVo, QueryWrapper<BStationTopManInformationEntity> queryWrapper, StringBuilder cacheKey) {
        String[] split;
        String value = str.toString();
        if (type.equals("\u7c89\u4e1d\u603b\u6570")) {
            if (value.startsWith("-")) {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMax_fans_num(split[1]);
                queryWrapper.lambda().lt(BStationTopManInformationEntity::getFanTotal, (Object)split[1]);
                cacheKey.append(split[1]);
            } else if (value.endsWith("-")) {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMin_fans_num(split[0]);
                queryWrapper.lambda().gt(BStationTopManInformationEntity::getFanTotal, (Object)split[0]);
                cacheKey.append(split[0]);
            } else {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMin_fans_num(split[0]);
                ksSpiderApiIndexListVo.setMax_fans_num(split[1]);
                queryWrapper.lambda().between(BStationTopManInformationEntity::getFanTotal, (Object)split[0], (Object)split[1]);
                cacheKey.append(split[0]).append(split[1]);
            }
        }
        if (type.equals("\u5b9a\u5236\u89c6\u9891\u62a5\u4ef7")) {
            if (value.startsWith("-")) {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMax_task_price(split[1]);
                queryWrapper.lambda().lt(BStationTopManInformationEntity::getCustomVideoPrice, (Object)split[1]);
                cacheKey.append(split[1]);
            } else if (value.endsWith("-")) {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMin_task_price(split[0]);
                queryWrapper.lambda().gt(BStationTopManInformationEntity::getCustomVideoPrice, (Object)split[0]);
                cacheKey.append(split[0]);
            } else {
                split = value.split("-");
                ksSpiderApiIndexListVo.setMin_task_price(split[0]);
                ksSpiderApiIndexListVo.setMax_task_price(split[1]);
                queryWrapper.lambda().between(BStationTopManInformationEntity::getCustomVideoPrice, (Object)split[0], (Object)split[1]);
                cacheKey.append(split[0]).append(split[1]);
            }
        }
    }

    private void handleResult(List<BStationTopManInformationEntity> data, String platform) {
        List<String> bStationId = data.stream().map(BStationTopManInformationEntity::getBStationId).distinct().collect(Collectors.toList());
        List<BStationTopManInformationEntity> addedAndCollects = this.baseMapper.checkAddedAndCollect(bStationId, SysUtil.getLoginUser(), platform);
        Map<Object, Object> map = new HashMap();
        if (CollectionUtil.isNotEmpty(addedAndCollects)) {
            map = addedAndCollects.stream().collect(Collectors.toMap(BStationTopManInformationEntity::getBStationId, h -> h, (k1, k2) -> k1));
        }
        ArrayList resultEntityList = new ArrayList(data.size());
        for (BStationTopManInformationEntity topManInfo : data) {
            if (!map.containsKey(topManInfo.getBStationId())) continue;
            BStationTopManInformationEntity info = (BStationTopManInformationEntity)map.get(topManInfo.getBStationId());
            topManInfo.setIsCollection(info.getIsCollection());
            topManInfo.setIsAdded(info.getIsAdded());
        }
    }

    private List<TopManOptionsEntity.Tag> transferTopManCommercial(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"label").toString());
            tag.setValue(h.get((Object)"value").toString());
            tag.setComponentType("RMultipleChoice");
            tag.setChildren(this.getParam((Document)h, type));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getParam(Document document, String type) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"children", Map.class);
        if (children.size() > 0) {
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (children1.size() < 0) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("value").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                System.out.println(children1.getClass().getName());
                tagCopyList.add(tagCopy);
            });
        }
        return tagCopyList;
    }

    private List<TopManOptionsEntity.Tag> transferLiveTopMan(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        return docList.stream().map(h -> {
            TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
            tag.setId(h.get((Object)"id").toString());
            tag.setLabel(h.get((Object)"name").toString());
            tag.setValue(h.get((Object)"id").toString());
            tag.setComponentType("RMultipleChoice");
            tag.setChildren(this.getLiveParam((Document)h));
            return tag;
        }).collect(Collectors.toList());
    }

    private List<Object> getLiveParam(Document document) {
        ArrayList<Object> tagCopyList = new ArrayList<Object>();
        List children = document.getList((Object)"list", Map.class);
        children.forEach(a -> {
            TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
            tagCopy.setId(a.get("id").toString());
            tagCopy.setLabel(a.get("name").toString());
            tagCopy.setValue(a.get("id").toString());
            tagCopyList.add(tagCopy);
        });
        return tagCopyList;
    }

    private List<TopManOptionsEntity.Tag> transferFansPortrait(Document doc, String type) {
        List docList = doc.getList((Object)"directory_json", Document.class);
        List label = docList.stream().map(h -> this.transferSub((Document)h, type, h.get((Object)"label").toString())).collect(Collectors.toList());
        return docList.stream().map(h -> this.transferSub((Document)h, type, h.get((Object)"label").toString())).collect(Collectors.toList());
    }

    private TopManOptionsEntity.TagCopy transferSub(Document doc, String type, String label) {
        TopManOptionsEntity.TagCopy tag = new TopManOptionsEntity.TagCopy();
        tag.setId(doc.get((Object)"id").toString());
        tag.setLabel(doc.getString((Object)"label"));
        tag.setValue(doc.get((Object)"value").toString());
        tag.setLevel(Integer.getInteger("id"));
        if (label.equals("\u4eba\u8bbe\u6807\u7b7e") || label.equals("\u65e5\u5e38\u804c\u4e1a") || label.equals("\u76f4\u64ad\u6807\u7b7e")) {
            tag.setComponentType("RMultipleChoice");
        } else if (label.equals("\u8fbe\u4eba\u6027\u522b") || label.equals("\u7c89\u4e1d\u6027\u522b") || label.equals("\u7c89\u4e1d\u5e74\u9f84") || label.equals("\u5408\u4f5c\u7c7b\u578b") || label.equals("\u8fd1\u671f\u5165\u9a7b") || label.equals("\u7c89\u4e1d\u57ce\u5e02\u7ebf")) {
            tag.setComponentType("RSelect");
        } else if (label.equals("\u662f\u5426\u7b7e\u7ea6") || label.equals("\u5408\u4f5c\u4e30\u5bcc") || label.equals("\u7c89\u4e1d\u98d9\u5347") || label.equals("\u591a\u6b21\u70ed\u95e8") || label.equals("\u5b9d\u85cf\u8fbe\u4eba")) {
            tag.setComponentType("RCheckbox");
        } else if (label.equals("\u7c89\u4e1d\u603b\u6570") || label.equals("\u5b9a\u5236\u89c6\u9891\u62a5\u4ef7") || label.equals("\u690d\u5165\u89c6\u9891\u62a5\u4ef7") || label.equals("\u76f4\u53d1\u89c6\u9891\u62a5\u4ef7") || label.equals("\u8f6c\u53d1\u89c6\u9891\u62a5\u4ef7")) {
            tag.setComponentType("RCustomSelect");
        } else if (label.equals("\u8fbe\u4eba\u5730\u57df")) {
            tag.setComponentType("RCascader");
        }
        if (label.equals("\u4eba\u8bbe\u6807\u7b7e") || label.equals("\u65e5\u5e38\u804c\u4e1a") || label.equals("\u8fbe\u4eba\u5730\u57df")) {
            ArrayList tagCopyList = new ArrayList();
            List children = doc.getList((Object)"children", Map.class);
            children.forEach(a -> {
                TopManOptionsEntity.TagCopy tagCopy = new TopManOptionsEntity.TagCopy();
                tagCopy.setId(a.get("id").toString());
                tagCopy.setLabel(a.get("label").toString());
                tagCopy.setValue(a.get("value").toString());
                List children1 = (List)a.get("children");
                if (children1.size() < 0) {
                    tagCopy.setChildren(null);
                } else {
                    ArrayList sonTagCopyList = new ArrayList();
                    children1.forEach(b -> {
                        TopManOptionsEntity.TagCopy sonTagCopy = new TopManOptionsEntity.TagCopy();
                        sonTagCopy.setId(b.get("id") == null ? null : a.get("id").toString());
                        sonTagCopy.setLabel(b.get("label").toString());
                        sonTagCopy.setValue(b.get("value").toString());
                        sonTagCopy.setChildren(null);
                        sonTagCopyList.add(sonTagCopy);
                    });
                    tagCopy.setChildren(sonTagCopyList);
                }
                tagCopyList.add(tagCopy);
            });
            tag.setChildren(tagCopyList);
        } else {
            tag.setChildren(doc.getList((Object)"children", Object.class));
        }
        if ((type.equals("videoTopMan") || type.equals("collectTopMan")) && label.equals("\u76f4\u64ad\u6807\u7b7e")) {
            return null;
        }
        if (type.equals("liveTopMan") && (label.equals("\u4eba\u8bbe\u6807\u7b7e") || label.equals("\u65e5\u5e38\u804c\u4e1a") || label.equals("\u662f\u5426\u7b7e\u7ea6"))) {
            return null;
        }
        if (type.equals("collectTopMan") && label.equals("\u8fd1\u671f\u5165\u9a7b")) {
            return null;
        }
        if (type.equals("videoTopMan") && (label.equals("\u690d\u5165\u89c6\u9891\u62a5\u4ef7") || label.equals("\u76f4\u53d1\u89c6\u9891\u62a5\u4ef7") || label.equals("\u8f6c\u53d1\u89c6\u9891\u62a5\u4ef7"))) {
            return null;
        }
        return tag;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("uid", "10462362");
        param.put("page_num", "0");
        param.put("page_size", "30");
        param.put("biz", "all");
        param.put("jsonp", "jsonp");
        String string = JSON.toJSONString(param);
        String urlDetails = "http://192.168.20.62:8088/bilibili/work/api/work_analysis_album/album_list";
        JSONObject jsonObject = HttpRequestUtils.doPost(urlDetails, string);
        JSONArray data = jsonObject.getJSONArray("data");
        List bStationTopManInformationAlbumListEntities = data.toJavaList(BStationTopManInformationAlbumListEntity.class);
        System.out.println(bStationTopManInformationAlbumListEntities);
    }
}

