/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.industryinfo.entity.McnAttachmentEntity;
import com.els.modules.industryinfo.mapper.McnAttachmentMapper;
import com.els.modules.industryinfo.service.McnAttachmentService;
import com.els.modules.industryinfo.utils.HttpRequestUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class McnAttachmentServiceImpl
extends BaseServiceImpl<McnAttachmentMapper, McnAttachmentEntity>
implements McnAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(McnAttachmentServiceImpl.class);
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;
    @Autowired
    private RedisUtil redisUtil;
    private static final String COLON = ":";
    @Resource
    private MongoTemplate mongoTemplate;
    private final String TB_DY_LOGIN_USER = "tb_dy_login_user";

    @Override
    public void upload(JSONObject jsonParam) {
        JSONArray upload = jsonParam.getJSONArray("upload");
        List jsonObjects = upload.toJavaList(JSONObject.class);
        log.info("\u4e0a\u4f20\u56fe\u7247list:" + jsonObjects.toString());
        if (CollectionUtils.isNotEmpty((Collection)jsonObjects)) {
            for (JSONObject jsonObject : jsonObjects) {
                this.uploadFile(jsonObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void uploadFile(JSONObject jsonParam) {
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
        criteriaList.add(Criteria.where((String)"status").is((Object)"1"));
        criteriaList.add(Criteria.where((String)"web_server").is((Object)"1"));
        criteriaList.add(Criteria.where((String)"type").is((Object)"B\u7ad9\u82b1\u706b"));
        Query query = new Query((CriteriaDefinition)new Criteria().andOperator(criteriaList.toArray(new Criteria[0])));
        Map cookieMap = (Map)this.mongoTemplate.findOne(query, Map.class, "tb_dy_login_user");
        String topmanId = jsonParam.getString("topmanId");
        Assert.hasText((String)topmanId, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u8fbe\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a"));
        StringBuilder sb = new StringBuilder("bilibili").append(COLON).append("upload").append(COLON).append(topmanId);
        String id = (String)this.redisUtil.get(sb.toString());
        if (id == null) {
            String platform = jsonParam.getString("platform");
            Assert.hasText((String)platform, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a"));
            String url = jsonParam.getString("url");
            Assert.hasText((String)platform, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"url\u4e0d\u80fd\u4e3a\u7a7a"));
            CloseableHttpClient client = null;
            HttpGet request = new HttpGet(url);
            try {
                client = HttpClients.createDefault();
                InputStream inputStream = HttpRequestUtils.httpGetImg(request, client, cookieMap.get("cookies").toString());
                StorageFileInfo fileInfo = new StorageFileInfo();
                LocalDateTime time = LocalDateTime.now();
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
                String nowday = dtf.format(time);
                String documentName = topmanId + ".jpg";
                documentName = documentName.replaceAll("-", "_");
                String documentType = "";
                String documentLocation = File.separator + "pic" + File.separator + documentName;
                if (documentLocation.contains("\\")) {
                    documentLocation = documentLocation.replace("\\", "/");
                }
                String savePath = CharSequenceUtil.emptyToDefault(null, (String)documentLocation);
                savePath = savePath.replaceAll(" ", "_");
                fileInfo.setPath(savePath);
                fileInfo.setFilename(documentName);
                fileInfo.setOriginalFilename(documentName);
                fileInfo = this.fileStoreSignServiceImpl.storeFile(inputStream, fileInfo, (String)null);
                McnAttachmentEntity attachment = new McnAttachmentEntity();
                attachment.setTopmanId(topmanId);
                attachment.setId(topmanId);
                attachment.setPlatform(platform);
                attachment.setFileName(fileInfo.getOriginalFilename());
                attachment.setFileSize(String.valueOf(fileInfo.getSize()));
                attachment.setFilePath(fileInfo.getPath());
                attachment.setTopmanAvatar(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), fileInfo.getSaveType()));
                boolean b = this.saveOrUpdate((Object)attachment);
                log.info("bbbbbbbbbbbbbbbbbbbb", (Object)b);
                if (b) {
                    this.redisUtil.set(sb.toString(), (Object)topmanId, 72000000L);
                    log.info("\u8fbe\u4ebaid:" + topmanId + ":\u4e0a\u4f20\u6210\u529f:" + (Object)((Object)attachment));
                }
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                        request.releaseConnection();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public boolean deleteBatch(String ids) {
        List mcnAttachmentEntities;
        List list = this.list();
        List bStationId = list.stream().map(McnAttachmentEntity::getTopmanId).distinct().collect(Collectors.toList());
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(mcnAttachmentEntities = this.listByIds(bStationId)))) {
            for (McnAttachmentEntity purchaseAttachment : mcnAttachmentEntities) {
                filePaths.add(purchaseAttachment.getFilePath());
            }
        }
        boolean b = this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
        this.removeByIds(idList);
        return b;
    }

    @Override
    public boolean delete(String id) {
        ArrayList<String> filePaths = new ArrayList<String>();
        McnAttachmentEntity byId = (McnAttachmentEntity)((Object)this.getById((Serializable)((Object)id)));
        if (byId == null) {
            return false;
        }
        filePaths.add(byId.getFilePath());
        boolean b = this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
        System.out.println("aaaaaaaaaaaaaaaaaaaaaaaaaaaa:" + b);
        this.removeById((Serializable)((Object)id));
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String url = "http://i2.hdslb.com/bfs/face/224855b46ea187bde4c4a2bbd26ea24b28b8d327.jpg";
        String cookies = "_uuid=3106310F3D-7844-6E106-C564-921CEA73E66945155infoc; B_SESSDATA=cdbd11ed%2C1670122356%2Ce740a%2A99; bili_b_jct=e68da4218264edf4292f50ccc8ef7e06; B_DedeUserID=14209024; B_DedeUserID__ckMd5=d82040a83961a3c9; B_sid=7wv5g0lo; buvid3=D5D08954-17E5-0124-805C-3ED1B7CB658358177infoc; b_nut=1662346358; buvid4=966A082E-A185-C5CE-2B6E-89F5105511D858177-022090510-Eg1Sg8zdHfvo5PT/PtIVIQ%3D%3D; i-wanna-go-back=-1; fingerprint=b72faf44a3e8e30adb63ab7b25cf6dd3; buvid_fp_plain=undefined; CURRENT_FNVAL=16; nostalgia_conf=-1; _pickup=eyJhbGciOiJIUzI1NiJ9.eyJkb21haW5Vc2VyIjoiIiwicGF5bG9hZCI6eyJhY2NvdW50SWQiOjk1NjY3NiwiYWdlbnRJZCI6MCwiZGVwYXJ0bWVudElkIjoxNjksImFnZW50TmFtZSI6bnVsbCwiZGVwYXJ0bWVudFR5cGUiOjR9LCJpc1Zpc2l0b3IiOmZhbHNlLCJtaWQiOjUxMDUwOTQzNSwib3BlcmF0b3JUeXBlIjowLCJiaWQiOjE0MjA5MDI0LCJleHAiOjE2NjMyMDkzMTEsInVzZXJJZCI6OTU2Njc2LCJpYXQiOjE2NjI2MDQ1MTEsInVzZXJuYW1lIjoi5LiW5ZKM5L-h5oGvLeiKseeBq-W5s-WPsCJ9.Qp6w5q73iyQAdqRHiKSfkFUANU8He5Ya9Lj-Ajs4em8; b_ut=5; SESSDATA=c1bd01dc%2C1678160890%2C41157%2A91; bili_jct=4fd96463d5201a4049b3d5f9e5dcf5ff; DedeUserID=1765905967; DedeUserID__ckMd5=54114825545c39c7; sid=fh1t1xad; buvid_fp=c157864006f1877fd1475d29ca438e58; PVID=2; innersign=1; b_lsid=89D69EC8_1831FC294EC";
        CloseableHttpClient client = null;
        HttpGet request = new HttpGet(url);
        try {
            client = HttpClients.createDefault();
            InputStream inputStream = HttpRequestUtils.httpGetImg(request, client, cookies);
            File file = new File("E:\\\u4f01\u4f01\u901a\u5de5\u4f5c\\mcn\u9879\u76ee\u6587\u6863\\aa\\bb.jpg");
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            int len = 0;
            byte[] data = new byte[1024];
            while ((len = inputStream.read(data)) != -1) {
                fileOutputStream.write(data, 0, len);
            }
            fileOutputStream.close();
            inputStream.close();
            System.out.println("ok");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                    request.releaseConnection();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

