/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.industryinfo.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.func.VoidFunc1;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.modules.industryInfo.api.annotation.OrderTagId;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.industryinfo.dto.KsTopManCollectDTO;
import com.els.modules.industryinfo.dto.KsTopManDetailDTO;
import com.els.modules.industryinfo.dto.KsTopManInformationDTO;
import com.els.modules.industryinfo.entity.KsCategoryEntity;
import com.els.modules.industryinfo.entity.KsRegionEntity;
import com.els.modules.industryinfo.entity.KsSpiderTopMan;
import com.els.modules.industryinfo.entity.TopManCollectBean;
import com.els.modules.industryinfo.entity.TopManSpiderMark;
import com.els.modules.industryinfo.enumerate.MarkYn;
import com.els.modules.industryinfo.enumerate.MongoCollectionType;
import com.els.modules.industryinfo.exception.TopManException;
import com.els.modules.industryinfo.mapper.KsTopManInformationMapper;
import com.els.modules.industryinfo.service.KsSpiderTopManService;
import com.els.modules.industryinfo.service.KuaiShouTopManInformationService;
import com.els.modules.industryinfo.service.MongoEntityService;
import com.els.modules.industryinfo.service.MongoHandleService;
import com.els.modules.industryinfo.service.TopManCollectService;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailBaseEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailFansEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailLiveAnalysisEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailLiveDataEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailLiveEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailVideoAnalysisEntity;
import com.els.modules.industryinfo.utils.spider.entity.KsTopManDetailVideoEntity;
import com.els.modules.industryinfo.utils.spider.entity.KuaiShouIndexListPage;
import com.els.modules.industryinfo.utils.spider.entity.KuaiShouTopManInfo;
import com.els.modules.industryinfo.utils.spider.properties.SpiderMethodType;
import com.els.modules.industryinfo.utils.spider.spiderApi.SpiderApiUtil;
import com.els.modules.industryinfo.utils.spider.vo.KsTopManDetailHeadContacrVO;
import com.els.modules.industryinfo.utils.spider.vo.KsTopManDetailHeadVO;
import com.els.modules.industryinfo.vo.KsSpiderApiIndexListVo;
import com.els.modules.industryinfo.vo.KsTopManVO;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KsTopManInformationServiceImpl
implements KuaiShouTopManInformationService {
    private static final Map<String, Integer> orderTag;
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private KsSpiderTopManService ksSpiderTopManService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private TopManCollectService topManCollectService;
    @Autowired
    private KsTopManInformationMapper ksTopManInformationMapper;
    @Resource
    private MongoHandleService mongoHandleService;

    @Override
    public IPage<KsTopManVO> queryTopManList(SimplePostRequestParam<KsTopManInformationDTO> topManDto) throws Exception {
        IPage<KsTopManVO> page = new IPage<KsTopManVO>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        KsTopManInformationDTO filterInfo = (KsTopManInformationDTO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        if ("1".equals(taskType) || "4".equals(taskType)) {
            Map<?, ?> map = this.apiGetList(topManDto);
            SpiderMethodType kuaiShouIndexList = SpiderMethodType.KUAI_SHOU_INDEX_LIST;
            Class<KuaiShouIndexListPage> responseClass = KuaiShouIndexListPage.class;
            KuaiShouIndexListPage data = this.spiderApiUtil.postForEntity(kuaiShouIndexList, map, responseClass);
            page.setTotal(data.getTotal());
            page.setRecords(this.handleResult(data, filterInfo.getPlatformType()));
        } else {
            QueryWrapper<KsSpiderTopMan> queryWrapper = this.getQueryWrapper(topManDto);
            page = this.ksTopManInformationMapper.selectCollectTopMan(page, (Wrapper<KsSpiderTopMan>)queryWrapper, SysUtil.getLoginUser());
        }
        return page;
    }

    @Override
    @Transactional
    public void collect(KsTopManCollectDTO ksTopManCollectDTO) {
        if (MarkYn.check(ksTopManCollectDTO.getCollect())) {
            this.addMarkToSpider(ksTopManCollectDTO);
        }
        this.collectHandle(ksTopManCollectDTO);
    }

    @Override
    public void addMarkToSpider(KsTopManCollectDTO ksTopManCollectDTO) {
        this.addMarkToMongo(ksTopManCollectDTO);
        KsSpiderTopMan spiderMarkEntity = this.getSpiderMarkEntity(ksTopManCollectDTO);
        this.ksSpiderTopManService.saveKsSpiderTopMan(spiderMarkEntity);
    }

    @Override
    public KsTopManDetailHeadVO getDetailHead(KsTopManDetailDTO param) {
        KsTopManDetailHeadVO result = null;
        String redisKey = "KsTopManDetailHead_" + param.getUserId() + "_" + param.getStarId();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(3);
        apiParam.put("starType", "1".equals(param.getLiveStatus()) ? "2" : "1");
        apiParam.put("starId", param.getStarId());
        apiParam.put("userID", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CLJX, apiParam, KsTopManDetailHeadVO.class);
            KsTopManDetailHeadVO.CoreData coreData = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_KFX, apiParam, KsTopManDetailHeadVO.CoreData.class);
            result.setCoreData(coreData);
            this.redisUtil.set(redisKey, (Object)result, 18000L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CLJX, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailHead(param);
                });
            }
        }
        AddedAndCollect addedAndCollect = new AddedAndCollect();
        addedAndCollect.setPlatform(param.getPlatform());
        addedAndCollect.setLoginUser(SysUtil.getLoginUser());
        addedAndCollect.setTopManIds(Collections.singletonList(param.getUserId()));
        List<AddedAndCollect> addedAndCollects = this.ksTopManInformationMapper.checkAddedAndCollect(addedAndCollect);
        if (addedAndCollects != null && addedAndCollects.size() > 0) {
            AddedAndCollect a = addedAndCollects.get(0);
            result.setIsAdded(a.getIsAdded());
            result.setIsCollection(a.getIsCollect());
        }
        return result;
    }

    @Override
    public KsTopManDetailHeadContacrVO getDetailHeadContacr(KsTopManDetailDTO param) {
        KsTopManDetailHeadContacrVO result = null;
        String redisKey = "KsTopManDetailHeadContacr_" + param.getUserId();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailHeadContacrVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("advertiserPhone", "(+86)" + param.getContacrPhone());
        apiParam.put("starId", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CONTACR, apiParam, KsTopManDetailHeadContacrVO.class);
            this.redisUtil.set(redisKey, (Object)result, 18000L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CONTACR, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailHead(param);
                });
            }
        }
        return result;
    }

    @Override
    public KsTopManDetailBaseEntity getDetailBodyBase(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_BASE;
        SpiderMethodType spiderMethodType2 = SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_KFX;
        KsTopManDetailBaseEntity result = null;
        String redisKey = "KsTopManDetailBodyBase_" + param.getUserId();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailBaseEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("userID", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailBaseEntity.class);
            KsTopManDetailHeadVO.CoreData coreData = this.spiderApiUtil.postForEntity(spiderMethodType2, apiParam, KsTopManDetailHeadVO.CoreData.class);
            KsTopManDetailBaseEntity.CommerceRequirement commerceRequirement = result.getCommerceRequirement();
            if (commerceRequirement != null && commerceRequirement.getInviteCommissionRate() != null) {
                commerceRequirement.setInviteCommissionRate(commerceRequirement.getInviteCommissionRate().divide(new BigDecimal(10), 2, RoundingMode.HALF_UP));
            }
            this.getDetailBodyBaseCommerceCapacity(coreData, result);
            this.redisUtil.set(redisKey, (Object)result, 18000L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyBase(param);
            });
        }
        return result;
    }

    private void getDetailBodyBaseCommerceCapacity(KsTopManDetailHeadVO.CoreData coreData, KsTopManDetailBaseEntity result) {
        if (coreData == null) {
            return;
        }
        List<KsTopManDetailHeadVO.HotSaleChannelInfo> hotSaleChannelList = coreData.getHotSaleChannelInfo();
        List<KsTopManDetailHeadVO.HotSaleBrandInfo> hotSaleBrandList = coreData.getHotSaleBrandInfo();
        ArrayList<KsTopManDetailBaseEntity.HotSaleChannelInfo> hotSaleChannelInfos = new ArrayList<KsTopManDetailBaseEntity.HotSaleChannelInfo>(hotSaleChannelList.size());
        ArrayList<KsTopManDetailBaseEntity.HotSaleBrandInfo> hotSaleBrandInfos = new ArrayList<KsTopManDetailBaseEntity.HotSaleBrandInfo>(hotSaleBrandList.size());
        if (CollectionUtil.isNotEmpty(hotSaleChannelList)) {
            hotSaleChannelList.forEach(h -> {
                KsTopManDetailBaseEntity.HotSaleChannelInfo hotSaleChannelInfo = new KsTopManDetailBaseEntity.HotSaleChannelInfo();
                BeanUtils.copyProperties((Object)h, (Object)hotSaleChannelInfo);
                hotSaleChannelInfos.add(hotSaleChannelInfo);
            });
        }
        if (CollectionUtil.isNotEmpty(hotSaleBrandList)) {
            hotSaleBrandList.forEach(h -> {
                KsTopManDetailBaseEntity.HotSaleBrandInfo hotSaleBrandInfo = new KsTopManDetailBaseEntity.HotSaleBrandInfo();
                BeanUtils.copyProperties((Object)h, (Object)hotSaleBrandInfo);
                hotSaleBrandInfos.add(hotSaleBrandInfo);
            });
        }
        KsTopManDetailBaseEntity.CommerceCapacity commerceCapacity = result.getCommerceCapacity();
        commerceCapacity.setHotSaleChannelInfo(hotSaleChannelInfos);
        commerceCapacity.setHotSaleBrandInfo(hotSaleBrandInfos);
    }

    @Override
    public KsTopManDetailLiveEntity getDetailBodyLive(KsTopManDetailDTO param) {
        BigDecimal d100 = new BigDecimal(100);
        HashMap<String, Object> apiParam = new HashMap<String, Object>(8);
        apiParam.put("promoterId", param.getUserId());
        apiParam.put("userID", param.getUserId());
        apiParam.put("channelIdList", param.getChannelIdList() == null ? Collections.EMPTY_LIST : param.getChannelIdList());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        apiParam.put("minPrice", param.getMinPrice() == null ? Integer.valueOf(0) : param.getMinPrice().multiply(d100));
        apiParam.put("maxPrice", param.getMaxPrice() == null ? Integer.valueOf(10000000) : param.getMaxPrice().multiply(d100));
        apiParam.put("orderType", param.getOrderType() == null ? "0" : param.getOrderType());
        apiParam.put("offset", (param.getPage() - 1) * param.getPageSize());
        apiParam.put("limit", param.getPageSize());
        KsTopManDetailLiveEntity result = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_LIST, apiParam, KsTopManDetailLiveEntity.class);
        result.getResultList().forEach(a -> a.setPromoteAvgPrice(a.getPromoteAvgPrice().divide(d100, 0, RoundingMode.HALF_UP)));
        KsTopManDetailLiveEntity tCount = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_SALE_COUNT, apiParam, KsTopManDetailLiveEntity.class);
        result.setPromoteItemCount(tCount.getPromoteItemCount());
        return result;
    }

    @Override
    public KsTopManDetailLiveAnalysisEntity getDetailBodyLiveNew(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_ANALYSIS;
        KsTopManDetailLiveAnalysisEntity result = null;
        String redisKey = "KsTopManDetailBodyLiveAnalysis_" + param.getUserId() + param.getTimeRangeType();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailLiveAnalysisEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("userID", param.getUserId());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailLiveAnalysisEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 18000L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyVideo(param);
            });
        }
        return result;
    }

    @Override
    public KsTopManDetailLiveDataEntity getDetailBodyLiveData(KsTopManDetailDTO param) {
        HashMap<String, Object> apiParam = new HashMap<String, Object>(7);
        apiParam.put("liveStreamId", param.getLiveStreamId());
        apiParam.put("channelIdList", param.getChannelIdList() == null ? Collections.EMPTY_LIST : param.getChannelIdList());
        apiParam.put("brandIdList", param.getBrandIdList() == null ? Collections.EMPTY_LIST : param.getBrandIdList());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        apiParam.put("orderType", param.getOrderType() == null ? "0" : param.getOrderType());
        apiParam.put("offset", (param.getPage() - 1) * param.getPageSize());
        apiParam.put("limit", param.getPageSize());
        return this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_DATA, apiParam, KsTopManDetailLiveDataEntity.class);
    }

    @Override
    public KsTopManDetailVideoEntity getDetailBodyVideo(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO;
        KsTopManDetailVideoEntity result = null;
        String redisKey = "KsTopManDetailBodyVideo_" + param.getStarId();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailVideoEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("starId", param.getStarId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailVideoEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 18000L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyVideo(param);
            });
        }
        return result;
    }

    @Override
    public KsTopManDetailVideoAnalysisEntity getDetailBodyVideoNew(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO_ANALYSIS;
        KsTopManDetailVideoAnalysisEntity result = null;
        String redisKey = "KsTopManDetailBodyVideoAnalysis_" + param.getStarId() + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailVideoAnalysisEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("starId", param.getStarId());
        apiParam.put("starType", param.getStarType());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailVideoAnalysisEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 18000L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyVideo(param);
            });
        }
        return result;
    }

    @Override
    public KsTopManDetailFansEntity getDetailBodyFans(KsTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_FANS;
        KsTopManDetailFansEntity result = null;
        String redisKey = "KsTopManDetailBodyFans_" + param.getStarId();
        if (!"1".equals(param.getClearCache())) {
            result = (KsTopManDetailFansEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(3);
        apiParam.put("starType", "1".equals(param.getLiveStatus()) ? "2" : "1");
        apiParam.put("starId", param.getStarId());
        apiParam.put("userID", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KsTopManDetailFansEntity.class);
            this.formatFansAnalysisData(result);
            KsTopManDetailHeadVO fansDataOther = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CLJX, apiParam, KsTopManDetailHeadVO.class);
            this.fansTrendTranslation(fansDataOther, result);
            this.redisUtil.set(redisKey, (Object)result, 18000L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyFans(param);
            });
        }
        return result;
    }

    private void fansTrendTranslation(KsTopManDetailHeadVO fansDataOther, KsTopManDetailFansEntity result) {
        if (fansDataOther == null) {
            return;
        }
        if (fansDataOther.getFansData() != null) {
            KsTopManDetailHeadVO.FansData fansData = fansDataOther.getFansData();
            result.setFansIncreaseRateIn30(fansData.getFansIncreaseRateIn30());
            result.setFansIncreaseRateIn90(fansData.getFansIncreaseRateIn90());
            result.setFansInterestPercentage(fansData.getFansInterestPercentage());
            result.setCityDetailPercentage(fansData.getCityDetailPercentage());
            result.setStarActiveFansRateDtoList(fansData.getStarActiveFansRateDtoList());
        }
        Map<String, List<KsTopManDetailHeadVO.ViewData>> trendDataMap = fansDataOther.getStarProfileDict().getTrendData();
        Map<String, List<KsTopManDetailHeadVO.ViewData>> trendDiffDataMap = fansDataOther.getStarProfileDict().getTrendDiffData();
        String day = "90";
        if (trendDataMap != null) {
            for (String key : trendDataMap.keySet()) {
                List<KsTopManDetailHeadVO.ViewData> trendDatas;
                if (!day.equals(key) || !CollectionUtil.isNotEmpty(trendDatas = trendDataMap.get(key))) continue;
                ArrayList<KsTopManDetailFansEntity.ViewData> trend = new ArrayList<KsTopManDetailFansEntity.ViewData>(trendDatas.size());
                trendDatas.forEach(h -> {
                    KsTopManDetailFansEntity.ViewData data = new KsTopManDetailFansEntity.ViewData();
                    BeanUtils.copyProperties((Object)h, (Object)data);
                    trend.add(data);
                });
                result.setTrend(trend);
            }
        }
        if (trendDiffDataMap != null) {
            for (String key : trendDiffDataMap.keySet()) {
                List<KsTopManDetailHeadVO.ViewData> trendDiffDatas;
                if (!day.equals(key) || !CollectionUtil.isNotEmpty(trendDiffDatas = trendDiffDataMap.get(key))) continue;
                ArrayList<KsTopManDetailFansEntity.ViewData> trendDiff = new ArrayList<KsTopManDetailFansEntity.ViewData>(trendDiffDatas.size());
                trendDiffDatas.forEach(h -> {
                    KsTopManDetailFansEntity.ViewData data = new KsTopManDetailFansEntity.ViewData();
                    BeanUtils.copyProperties((Object)h, (Object)data);
                    trendDiff.add(data);
                });
                result.setTrendDiff(trendDiff);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void formatFansAnalysisData(KsTopManDetailFansEntity result) {
        if (result == null) {
            return;
        }
        HashMap<String, String> cityLine = new HashMap<String, String>(6);
        cityLine.put("firstline", "\u4e00\u7ebf");
        cityLine.put("newfirstline", "\u65b0\u4e00\u7ebf");
        cityLine.put("secondline", "\u4e8c\u7ebf");
        cityLine.put("thirdline", "\u4e09\u7ebf");
        cityLine.put("fourthline", "\u56db\u7ebf");
        cityLine.put("fifthline", "\u4e94\u7ebf");
        BigDecimal d100 = new BigDecimal(100);
        BigDecimal check = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getCityPercentage()) {
            viewData.setLabel((String)cityLine.get(viewData.getLabel()));
            BigDecimal bigDecimal = viewData.getValue();
            viewData.setValue(bigDecimal.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (check.compareTo(bigDecimal) >= 0) continue;
            check = bigDecimal;
            result.setCityPercentageOptimum(viewData);
        }
        BigDecimal check1 = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getSexPercentage()) {
            BigDecimal bigDecimal = viewData.getValue();
            viewData.setValue(bigDecimal.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (check1.compareTo(bigDecimal) >= 0) continue;
            check1 = bigDecimal;
            result.setSexPercentageOptimum(viewData);
        }
        BigDecimal bigDecimal = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getAgePercentage()) {
            void var6_9;
            BigDecimal bigDecimal2 = viewData.getValue();
            viewData.setValue(bigDecimal2.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (var6_9.compareTo(bigDecimal2) >= 0) continue;
            BigDecimal bigDecimal3 = bigDecimal2;
            result.setAgePercentageOptimum(viewData);
        }
        BigDecimal bigDecimal4 = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getMobileBrandPercentage()) {
            void var7_16;
            BigDecimal bigDecimal5 = viewData.getValue();
            viewData.setValue(bigDecimal5.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (var7_16.compareTo(bigDecimal5) >= 0) continue;
            BigDecimal bigDecimal6 = bigDecimal5;
            result.setMobileBrandPercentageOptimum(viewData);
        }
        BigDecimal bigDecimal7 = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getMobilePricePercentage()) {
            void var8_23;
            BigDecimal value = viewData.getValue();
            viewData.setValue(value.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (var8_23.compareTo(value) >= 0) continue;
            BigDecimal bigDecimal8 = value;
            result.setMobilePricePercentageOptimum(viewData);
        }
        BigDecimal bigDecimal9 = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getAreaTopWithRadio()) {
            void var9_30;
            BigDecimal value = viewData.getValue();
            viewData.setValue(value.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (var9_30.compareTo(value) >= 0) continue;
            BigDecimal bigDecimal10 = value;
            result.setAreaTopWithRadioOptimum(viewData);
        }
        BigDecimal bigDecimal11 = new BigDecimal(0);
        for (KsTopManDetailFansEntity.ViewData viewData : result.getAreaTopWithPermeation()) {
            void var10_37;
            BigDecimal value = viewData.getValue();
            viewData.setValue(value.multiply(d100).setScale(2, RoundingMode.HALF_UP));
            if (var10_37.compareTo(value) >= 0) continue;
            BigDecimal bigDecimal12 = value;
            result.setAreaTopWithPermeationOptimum(viewData);
        }
    }

    private KsSpiderTopMan getSpiderMarkEntity(KsTopManCollectDTO ksTopManCollectDTO) {
        KsTopManVO entity = ksTopManCollectDTO.getEntity();
        KsSpiderTopMan ksSpiderTopMan = new KsSpiderTopMan();
        ksSpiderTopMan.setTopmanId(String.valueOf(entity.getUserId()));
        ksSpiderTopMan.setTopmanName(entity.getName());
        ksSpiderTopMan.setKwaiid(entity.getKwaiId());
        ksSpiderTopMan.setStarId(String.valueOf(entity.getStarId()));
        ksSpiderTopMan.setPlatform(ksTopManCollectDTO.getPlatform());
        ksSpiderTopMan.setTopmanAvatar(entity.getHeadUrl());
        ksSpiderTopMan.setTopmanSource("1");
        ksSpiderTopMan.setLiveStatus(String.valueOf(entity.getLiveStatus()));
        ksSpiderTopMan.setRegion(entity.getRegion());
        ksSpiderTopMan.setProvinceCode(entity.getProvinceCode());
        ksSpiderTopMan.setCityCode(entity.getCityCode());
        ksSpiderTopMan.setContentTypeName(entity.getStarTagStr());
        ksSpiderTopMan.setContentFormName(entity.getMmuStarTagStr());
        ksSpiderTopMan.setIndustryName(entity.getIndustryTagStr());
        if (entity.getStarTagIds() != null && entity.getStarTagIds().length > 0) {
            String starTagIds = Arrays.stream(entity.getStarTagIds()).map(String::valueOf).collect(Collectors.joining(","));
            ksSpiderTopMan.setStarTagIds(starTagIds);
        }
        ksSpiderTopMan.setFansNum(entity.getFansNum());
        ksSpiderTopMan.setFansIncreaseNum(entity.getFansIncreaseNum());
        ksSpiderTopMan.setFansIncreaseRate(entity.getFansIncreaseRate());
        ksSpiderTopMan.setLiveExpectCpm(entity.getLiveExpectCpm());
        ksSpiderTopMan.setLiveExpectViewer(entity.getLiveExpectViewer());
        ksSpiderTopMan.setLiveMaxViewer(entity.getLiveMaxViewer());
        ksSpiderTopMan.setPhotoExpectClick(entity.getPhotoExpectClick());
        ksSpiderTopMan.setPhotoCompletePlayRate(entity.getPhotoCompletePlayRate());
        ksSpiderTopMan.setPhotoExpectCpm(entity.getPhotoExpectCpm());
        ksSpiderTopMan.setPhotoInteractionRate(entity.getPhotoInteractionRate());
        ksSpiderTopMan.setQuoteOfLive(entity.getLiveQuotedPricePerHour());
        ksSpiderTopMan.setQuoteOfVideo(entity.getThreeDaysOrderBid());
        ksSpiderTopMan.setTopmanSex(entity.getGender());
        ksSpiderTopMan.setCreateTime(new Date());
        LoginUser loginUser = SysUtil.getLoginUser();
        ksSpiderTopMan.setCreateBy(loginUser.getElsAccount() + "-" + loginUser.getSubAccount());
        ksSpiderTopMan.setDeleted(0);
        return ksSpiderTopMan;
    }

    private void addMarkToMongo(KsTopManCollectDTO ksTopManCollectDTO) {
        KsTopManVO entity = ksTopManCollectDTO.getEntity();
        String userId = String.valueOf(entity.getUserId());
        MongoCollectionType collectMark = MongoCollectionType.TB_KS_ELS_TOP_MAN;
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("topManId", String.valueOf(userId));
        Map<String, TopManSpiderMark> data = this.mongoHandleService.handleMongo(collectMark, param, TopManSpiderMark.class);
        TopManSpiderMark topManSpiderMark = data.get(userId);
        if (topManSpiderMark == null) {
            topManSpiderMark = new TopManSpiderMark();
            topManSpiderMark.setTopManId(userId);
            topManSpiderMark.setTaskType(ksTopManCollectDTO.getTaskType());
            topManSpiderMark.setCount(1);
            this.mongoTemplate.insert((Object)topManSpiderMark, collectMark.getCollectName());
        } else {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"topManId").is((Object)String.valueOf(userId)));
            Update update = new Update().set("count", (Object)(topManSpiderMark.getCount() + 1));
            this.mongoTemplate.upsert(query, (UpdateDefinition)update, TopManSpiderMark.class, collectMark.getCollectName());
        }
    }

    private void collectHandle(KsTopManCollectDTO ksTopManCollectDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        String collect = ksTopManCollectDTO.getCollect();
        KsTopManVO entity = ksTopManCollectDTO.getEntity();
        if (MarkYn.check(collect)) {
            TopManCollectBean topManCollectBean = new TopManCollectBean();
            topManCollectBean.setTopmanId(String.valueOf(entity.getUserId()));
            topManCollectBean.setPlatform(ksTopManCollectDTO.getPlatform());
            topManCollectBean.setElsAccount(elsAccount);
            topManCollectBean.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectBean);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectBean::getPlatform, (Object)ksTopManCollectDTO.getPlatform());
            queryWrapper.lambda().eq(TopManCollectBean::getTopmanId, (Object)entity.getUserId());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
    }

    private List<KsTopManVO> handleResult(KuaiShouIndexListPage data, String platform) {
        List<KuaiShouTopManInfo> starList = data.getStarList();
        if (starList == null || starList.size() == 0) {
            return new ArrayList<KsTopManVO>(0);
        }
        HashMap<String, KsTopManVO> map = new HashMap<String, KsTopManVO>(starList.size());
        ArrayList<KsTopManVO> resultEntityList = new ArrayList<KsTopManVO>(starList.size());
        for (KuaiShouTopManInfo kuaiShouTopManInfo : starList) {
            KsTopManVO ksTopManVO = new KsTopManVO();
            BeanUtils.copyProperties((Object)kuaiShouTopManInfo, (Object)ksTopManVO);
            KuaiShouTopManInfo.LiveQuotedInfo liveQuotedInfo = kuaiShouTopManInfo.getLiveQuotedInfo();
            ksTopManVO.setLiveQuotedPricePerHour(liveQuotedInfo.getPerHour());
            ksTopManVO.setRegion(this.formatRegion(kuaiShouTopManInfo.getProvinceCode(), kuaiShouTopManInfo.getCityCode()));
            BigDecimal d1000 = new BigDecimal(1000);
            BigDecimal d100 = new BigDecimal(100);
            ksTopManVO.setThreeDaysOrderBid(ksTopManVO.getThreeDaysOrderBid().divide(d1000, 2, RoundingMode.HALF_UP));
            ksTopManVO.setLiveQuotedPricePerHour(ksTopManVO.getLiveQuotedPricePerHour().divide(d1000, 2, RoundingMode.HALF_UP));
            ksTopManVO.setFansIncreaseRate(ksTopManVO.getFansIncreaseRate().multiply(d100));
            ksTopManVO.setPhotoCompletePlayRate(ksTopManVO.getPhotoCompletePlayRate().multiply(d100));
            ksTopManVO.setPhotoInteractionRate(ksTopManVO.getPhotoInteractionRate().multiply(d100));
            resultEntityList.add(ksTopManVO);
            map.put(String.valueOf(ksTopManVO.getUserId()), ksTopManVO);
        }
        AddedAndCollect addedAndCollect = new AddedAndCollect();
        addedAndCollect.setTopManIds(map.keySet());
        addedAndCollect.setPlatform(platform);
        addedAndCollect.setLoginUser(SysUtil.getLoginUser());
        List<AddedAndCollect> addedAndCollects = this.ksTopManInformationMapper.checkAddedAndCollect(addedAndCollect);
        addedAndCollects.forEach(a -> {
            String topManId = a.getTopManId();
            KsTopManVO ksTopManVO = (KsTopManVO)map.get(topManId);
            if (ksTopManVO != null) {
                ksTopManVO.setIsCollection(a.getIsCollect());
                ksTopManVO.setIsAdded(a.getIsAdded());
            }
        });
        return resultEntityList;
    }

    @Override
    public String formatRegion(Integer provinceCode, Integer cityCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("name", "\u8fbe\u4eba\u4fe1\u606f");
        param.put("sec_name", "\u8fbe\u4eba\u5730\u57df");
        Map<String, KsRegionEntity> region = this.cacheMongo(MongoCollectionType.TB_KS_CATEGORY, KsRegionEntity.class, param);
        KsRegionEntity province = region.get(String.valueOf(provinceCode));
        if (province != null) {
            List<KsRegionEntity.KsCityEntity> cityList = province.getCitys();
            String regionString = province.getProvinceName();
            for (KsRegionEntity.KsCityEntity city : cityList) {
                if (!city.getCityCode().equals(String.valueOf(cityCode))) continue;
                regionString = regionString + "-" + city.getCityName();
                break;
            }
            return regionString;
        }
        return null;
    }

    @Override
    public Map<?, ?> apiGetList(SimplePostRequestParam<KsTopManInformationDTO> topManDto) throws Exception {
        String column = topManDto.getColumn();
        String order = topManDto.getOrder();
        KsTopManInformationDTO filterInfo = (KsTopManInformationDTO)topManDto.getFilterInfo();
        Integer orderTabId = orderTag.get(order == null ? "default" : column);
        if (orderTabId == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u8be5\u5b57\u6bb5\u65e0\u6cd5\u6392\u5e8f"));
        }
        KsSpiderApiIndexListVo ksSpiderApiIndexListVo = new KsSpiderApiIndexListVo(topManDto.getPageNo(), topManDto.getPageSize());
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            ksSpiderApiIndexListVo.setUserName(keyWord);
        }
        ksSpiderApiIndexListVo.setStarOrderTag(orderTabId);
        if (!orderTabId.equals(3)) {
            ksSpiderApiIndexListVo.setStarOrderType("desc".equals(order) ? 2 : 1);
        }
        ksSpiderApiIndexListVo.setTaskType(Integer.parseInt(filterInfo.getTaskType()));
        KsTopManInformationDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        if (screenItem != null) {
            List<KsTopManInformationDTO.ScreenItemField> contentType = screenItem.getContentType();
            ksSpiderApiIndexListVo.setContentTagIdList(this.handleTagList(contentType, "\u5185\u5bb9\u5206\u7c7b"));
            List<KsTopManInformationDTO.ScreenItemField> industry = screenItem.getIndustry();
            ksSpiderApiIndexListVo.setIndustryTagIdList(this.handleTagList(industry, "\u6240\u5c5e\u884c\u4e1a"));
            List<KsTopManInformationDTO.ScreenItemField> contentForm = screenItem.getContentForm();
            ksSpiderApiIndexListVo.setContentFormTagId(this.handleStringList(contentForm));
            List<KsTopManInformationDTO.ScreenItemField> starRecommendation = screenItem.getStarRecommendation();
            ksSpiderApiIndexListVo.setStarTagIds(this.handleStringList(starRecommendation));
            List<KsTopManInformationDTO.ScreenItemField> talentInfos = screenItem.getTalentInfo();
            this.initScreenItemField(talentInfos, ksSpiderApiIndexListVo);
            List<KsTopManInformationDTO.ScreenItemField> talentIndex = screenItem.getTalentIndex();
            this.initScreenItemField(talentIndex, ksSpiderApiIndexListVo);
            List<KsTopManInformationDTO.ScreenItemField> fanInfo = screenItem.getFanInfo();
            this.initScreenItemField(fanInfo, ksSpiderApiIndexListVo);
            List<KsTopManInformationDTO.ScreenItemField> contentPerformance = screenItem.getContentPerformance();
            this.initScreenItemField(contentPerformance, ksSpiderApiIndexListVo);
        }
        String json = JSON.toJSONString((Object)ksSpiderApiIndexListVo);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    @Override
    public KsTopManVO getByUserId(String userId) {
        HashMap map = Maps.newHashMap();
        map.put("userName", userId);
        map.put("pageSize", 1);
        map.put("currentPage", 1);
        map.put("starOrderTag", 3);
        map.put("taskType", 1);
        KuaiShouIndexListPage data = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_INDEX_LIST, map, KuaiShouIndexListPage.class);
        KuaiShouTopManInfo info = data.getStarList().get(0);
        KsTopManVO ksTopManVO = new KsTopManVO();
        BeanUtil.copyProperties((Object)info, (Object)ksTopManVO, (String[])new String[0]);
        ksTopManVO.setRegion(this.formatRegion(ksTopManVO.getProvinceCode(), ksTopManVO.getCityCode()));
        return ksTopManVO;
    }

    private <T extends MongoEntityService> Map<String, T> cacheMongo(MongoCollectionType collectionType, Class<T> beanClass, Map<String, String> param) {
        if (beanClass == null || collectionType.getRedisKeyPre() == null) {
            return null;
        }
        StringBuilder redisKey = new StringBuilder(collectionType.getRedisKeyPre());
        for (String value : param.values()) {
            redisKey.append("_").append(value);
        }
        Map<String, T> result = (Map<String, T>)this.redisUtil.get(redisKey.toString());
        if (result == null) {
            result = this.mongoHandleService.handleMongo(collectionType, param, beanClass);
            this.redisUtil.set(redisKey.toString(), result, (long)collectionType.getCacheTime().intValue());
        }
        return result;
    }

    private List<KsSpiderApiIndexListVo.Tag> handleTagList(List<KsTopManInformationDTO.ScreenItemField> screenItemFields, String name) {
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return null;
        }
        return screenItemFields.stream().filter(a -> a.getStarTagId() != null).map(a -> {
            KsCategoryEntity suCategory;
            KsSpiderApiIndexListVo.Tag tag = new KsSpiderApiIndexListVo.Tag();
            tag.setId(a.getStarTagId());
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("name", name);
            Map<String, KsCategoryEntity> category = this.cacheMongo(MongoCollectionType.TB_KS_CATEGORY, KsCategoryEntity.class, param);
            if (category != null && (suCategory = category.get(a.getStarTagId())) != null) {
                tag.setSubIds(suCategory.getSubTagsString());
            }
            return tag;
        }).collect(Collectors.toList());
    }

    private List<String> handleStringList(List<KsTopManInformationDTO.ScreenItemField> screenItemFields) {
        if (screenItemFields != null && screenItemFields.size() > 0) {
            return screenItemFields.stream().map(KsTopManInformationDTO.ScreenItemField::getStarTagId).collect(Collectors.toList());
        }
        return null;
    }

    private void initScreenItemField(List<KsTopManInformationDTO.ScreenItemField> screenItemFields, KsSpiderApiIndexListVo ksSpiderApiIndexListVo) throws Exception {
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return;
        }
        block46: for (KsTopManInformationDTO.ScreenItemField screenItemField : screenItemFields) {
            String value = screenItemField.getValue();
            switch (screenItemField.getTitle()) {
                case "\u7c89\u4e1d\u6570\u91cf": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansMaxNum));
                    continue block46;
                }
                case "\u8fbe\u4eba\u62a5\u4ef7": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setStarMinPrice), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setStarMaxPrice));
                    continue block46;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    ksSpiderApiIndexListVo.setGender(value);
                    continue block46;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)value, String.class);
                    ksSpiderApiIndexListVo.setProvinceCode(Integer.parseInt((String)strings.get(0)));
                    ksSpiderApiIndexListVo.setCityCode(Integer.parseInt((String)strings.get(1)));
                    continue block46;
                }
                case "\u7efc\u5408\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setStarIndex));
                    continue block46;
                }
                case "\u6da8\u7c89\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setAddFansIndex));
                    continue block46;
                }
                case "\u521b\u4f5c\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setCreateIndex));
                    continue block46;
                }
                case "\u6027\u4ef7\u6bd4": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setPerformancePriceIndex));
                    continue block46;
                }
                case "\u5546\u4e1a\u6d3b\u8dc3\u5ea6": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setBizActIndex));
                    continue block46;
                }
                case "\u5408\u4f5c\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setCoopIndex));
                    continue block46;
                }
                case "\u7c89\u4e1d\u5e74\u9f84": {
                    this.handleRatioList(value, (VoidFunc1<List<KsSpiderApiIndexListVo.Ratio>>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansAgeList));
                    continue block46;
                }
                case "\u7c89\u4e1d\u6027\u522b": {
                    this.handleRatio(value, (VoidFunc1<KsSpiderApiIndexListVo.Ratio>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansGender));
                    continue block46;
                }
                case "\u7c89\u4e1d\u57ce\u5e02\u7ebf": {
                    this.handleRatioList(value, (VoidFunc1<List<KsSpiderApiIndexListVo.Ratio>>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansCityList));
                    continue block46;
                }
                case "\u7c89\u4e1d\u8bbe\u5907": {
                    this.handleRatio(value, (VoidFunc1<KsSpiderApiIndexListVo.Ratio>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setFansMobile));
                    continue block46;
                }
                case "\u9884\u8ba1CPM": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setExpectCpmMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setExpectCpmMaxNum));
                    continue block46;
                }
                case "CPE": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setExpectedCpe));
                    continue block46;
                }
                case "\u9884\u671f\u64ad\u653e\u91cf": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setPhotoExpectPlayMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setPhotoExpectPlayMaxNum));
                    continue block46;
                }
                case "\u9884\u4f30\u5728\u7ebf\u4eba\u6570": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setLiveAvgPeopleMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setLiveAvgPeopleMaxNum));
                    continue block46;
                }
                case "\u6700\u9ad8\u5728\u7ebf\u4eba\u6570": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setLiveMaxViewerMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setLiveMaxViewerMaxNum));
                    continue block46;
                }
                case "\u4e92\u52a8\u7387": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setPhotoInteractionRate));
                    continue block46;
                }
                case "\u5b8c\u64ad\u7387": {
                    this.handleScope(value, (VoidFunc1<KsSpiderApiIndexListVo.Scope>)((VoidFunc1 & Serializable)ksSpiderApiIndexListVo::setPhotoCompletePlayRate));
                    continue block46;
                }
            }
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
        }
    }

    private void handleMinMax(String value, VoidFunc1<BigDecimal> minField, VoidFunc1<BigDecimal> maxField) throws Exception {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                String max;
                String min = split[0];
                if (min != null && !"".equals(min)) {
                    minField.call((Object)new BigDecimal(split[0]));
                }
                if ((max = split[1]) == null || "".equals(max)) break;
                maxField.call((Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    maxField.call((Object)new BigDecimal(split[0]));
                    break;
                }
                minField.call((Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new TopManException.TransferParamException.ParamFormatError(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
        }
    }

    private void handleScope(String value, VoidFunc1<KsSpiderApiIndexListVo.Scope> field) throws Exception {
        KsSpiderApiIndexListVo.Scope scope = new KsSpiderApiIndexListVo.Scope();
        this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)scope::setMin), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)scope::setMax));
        field.call((Object)scope);
    }

    private void handleRatio(String value, VoidFunc1<KsSpiderApiIndexListVo.Ratio> field) throws Exception {
        if (value == null || "".equals(value)) {
            return;
        }
        field.call((Object)new KsSpiderApiIndexListVo.Ratio(value));
    }

    private void handleRatioList(String value, VoidFunc1<List<KsSpiderApiIndexListVo.Ratio>> field) throws Exception {
        if (value == null || "".equals(value)) {
            return;
        }
        field.call(Collections.singletonList(new KsSpiderApiIndexListVo.Ratio(value)));
    }

    private QueryWrapper<KsSpiderTopMan> getQueryWrapper(SimplePostRequestParam<KsTopManInformationDTO> topManDto) {
        String[] columns;
        String column;
        KsTopManInformationDTO filterInfo = (KsTopManInformationDTO)topManDto.getFilterInfo();
        QueryWrapper query = new QueryWrapper();
        KsTopManInformationDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        this.handleInTitle(screenItem.getContentType(), (QueryWrapper<KsSpiderTopMan>)query, KsSpiderTopMan::getContentTypeName);
        this.handleInTitle(screenItem.getIndustry(), (QueryWrapper<KsSpiderTopMan>)query, KsSpiderTopMan::getIndustryName);
        this.handleInTitle(screenItem.getContentForm(), (QueryWrapper<KsSpiderTopMan>)query, KsSpiderTopMan::getContentFormName);
        List<KsTopManInformationDTO.ScreenItemField> starRecommendation = screenItem.getStarRecommendation();
        if (starRecommendation != null && starRecommendation.size() > 0) {
            query.and(wrapper -> {
                for (KsTopManInformationDTO.ScreenItemField screenItemField : starRecommendation) {
                    ((LambdaQueryWrapper)wrapper.lambda().like(KsSpiderTopMan::getStarTagIds, (Object)screenItemField)).or();
                }
            });
        }
        List<KsTopManInformationDTO.ScreenItemField> talentInfos = screenItem.getTalentInfo();
        block10: for (int i = 0; talentInfos != null && i < talentInfos.size(); ++i) {
            KsTopManInformationDTO.ScreenItemField screenItemField = talentInfos.get(i);
            String value = screenItemField.getValue();
            switch (screenItemField.getTitle()) {
                case "\u7c89\u4e1d\u6570\u91cf": {
                    this.handleMinMax(value, (QueryWrapper<KsSpiderTopMan>)query, KsSpiderTopMan::getFansNum);
                    continue block10;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    this.handleMinMax(value, (QueryWrapper<KsSpiderTopMan>)query, KsSpiderTopMan::getTopmanSex);
                    continue block10;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)value, String.class);
                    ((LambdaQueryWrapper)query.lambda().eq(KsSpiderTopMan::getProvinceCode, (Object)Integer.parseInt((String)strings.get(0)))).eq(KsSpiderTopMan::getCityCode, (Object)Integer.parseInt((String)strings.get(1)));
                    continue block10;
                }
                default: {
                    throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
                }
            }
        }
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(KsSpiderTopMan::getTopmanName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(KsSpiderTopMan::getTopmanId, (Object)keyWord);
                });
            });
        }
        if ((column = topManDto.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)new KsTopManVO());
        }
        return query;
    }

    private void handleInTitle(List<KsTopManInformationDTO.ScreenItemField> list, QueryWrapper<KsSpiderTopMan> query, SFunction<KsSpiderTopMan, ?> field) {
        if (list == null || list.size() == 0) {
            return;
        }
        List collect = list.stream().map(KsTopManInformationDTO.ScreenItemField::getTitle).collect(Collectors.toList());
        query.lambda().in(field, collect);
    }

    private void handleMinMax(String value, QueryWrapper<KsSpiderTopMan> query, SFunction<KsSpiderTopMan, ?> field) {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.lambda().between(field, (Object)new BigDecimal(split[0]), (Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.lambda().le(field, (Object)new BigDecimal(split[0]));
                    break;
                }
                query.lambda().ge(field, (Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new TopManException.TransferParamException.ParamFormatError(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
        }
    }

    static {
        Field[] declaredFields;
        orderTag = new HashMap<String, Integer>(10);
        orderTag.put("default", 3);
        orderTag.put(null, 3);
        Class<KsTopManVO> ksTopManResultEntityClass = KsTopManVO.class;
        for (Field declaredField : declaredFields = ksTopManResultEntityClass.getDeclaredFields()) {
            OrderTagId annotation = declaredField.getAnnotation(OrderTagId.class);
            if (annotation == null) continue;
            orderTag.put(declaredField.getName(), annotation.value());
        }
    }

    public static class AddedAndCollect {
        private LoginUser loginUser;
        private String platform;
        private Collection<String> topManIds;
        private String topManId;
        private String isAdded;
        private String isCollect;

        public LoginUser getLoginUser() {
            return this.loginUser;
        }

        public String getPlatform() {
            return this.platform;
        }

        public Collection<String> getTopManIds() {
            return this.topManIds;
        }

        public String getTopManId() {
            return this.topManId;
        }

        public String getIsAdded() {
            return this.isAdded;
        }

        public String getIsCollect() {
            return this.isCollect;
        }

        public void setLoginUser(LoginUser loginUser) {
            this.loginUser = loginUser;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setTopManIds(Collection<String> topManIds) {
            this.topManIds = topManIds;
        }

        public void setTopManId(String topManId) {
            this.topManId = topManId;
        }

        public void setIsAdded(String isAdded) {
            this.isAdded = isAdded;
        }

        public void setIsCollect(String isCollect) {
            this.isCollect = isCollect;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddedAndCollect)) {
                return false;
            }
            AddedAndCollect other = (AddedAndCollect)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LoginUser this$loginUser = this.getLoginUser();
            LoginUser other$loginUser = other.getLoginUser();
            if (this$loginUser == null ? other$loginUser != null : !this$loginUser.equals(other$loginUser)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            Collection<String> this$topManIds = this.getTopManIds();
            Collection<String> other$topManIds = other.getTopManIds();
            if (this$topManIds == null ? other$topManIds != null : !((Object)this$topManIds).equals(other$topManIds)) {
                return false;
            }
            String this$topManId = this.getTopManId();
            String other$topManId = other.getTopManId();
            if (this$topManId == null ? other$topManId != null : !this$topManId.equals(other$topManId)) {
                return false;
            }
            String this$isAdded = this.getIsAdded();
            String other$isAdded = other.getIsAdded();
            if (this$isAdded == null ? other$isAdded != null : !this$isAdded.equals(other$isAdded)) {
                return false;
            }
            String this$isCollect = this.getIsCollect();
            String other$isCollect = other.getIsCollect();
            return !(this$isCollect == null ? other$isCollect != null : !this$isCollect.equals(other$isCollect));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AddedAndCollect;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LoginUser $loginUser = this.getLoginUser();
            result = result * 59 + ($loginUser == null ? 43 : $loginUser.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            Collection<String> $topManIds = this.getTopManIds();
            result = result * 59 + ($topManIds == null ? 43 : ((Object)$topManIds).hashCode());
            String $topManId = this.getTopManId();
            result = result * 59 + ($topManId == null ? 43 : $topManId.hashCode());
            String $isAdded = this.getIsAdded();
            result = result * 59 + ($isAdded == null ? 43 : $isAdded.hashCode());
            String $isCollect = this.getIsCollect();
            result = result * 59 + ($isCollect == null ? 43 : $isCollect.hashCode());
            return result;
        }

        public String toString() {
            return "KsTopManInformationServiceImpl.AddedAndCollect(loginUser=" + this.getLoginUser() + ", platform=" + this.getPlatform() + ", topManIds=" + this.getTopManIds() + ", topManId=" + this.getTopManId() + ", isAdded=" + this.getIsAdded() + ", isCollect=" + this.getIsCollect() + ")";
        }
    }
}

