/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.store.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.els.common.annotation.ApiCallCount;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.modules.common.spider.vo.ShopDetailVO;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.store.dto.ShopCollectDTO;
import com.els.modules.store.dto.ShopDTO;
import com.els.modules.store.dto.ShopDetailDTO;
import com.els.modules.store.entity.Shop;
import com.els.modules.store.service.ShopService;
import com.els.modules.store.vo.ShopVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5c0f\u5e97\u4fe1\u606f"})
@RestController
@RequestMapping(value={"/industryinfo/shop"})
public class ShopController
extends BaseController<Shop, ShopService> {
    @Autowired
    private ShopService shopService;

    @ApiOperation(value="\u7b5b\u9009\u9879", notes="\u7b5b\u9009\u9879")
    @GetMapping(value={"/options"})
    public Result<?> getOptions(@RequestParam(name="type", required=false, defaultValue="0") String type, @RequestParam(name="clearCache", required=false, defaultValue="0") String clearCache) {
        return Result.ok(this.shopService.getOptions(type, clearCache));
    }

    @ApiOperation(value="\u5c0f\u5e97\u5217\u8868", notes="\u5c0f\u5e97\u5217\u8868")
    @PostMapping(value={"/list"})
    @ApiCallCount(apiCode="industry_shop_list_data")
    public Result<?> listAll(@RequestBody SimplePostRequestParam<ShopDTO> param) {
        IPage<ShopVO> pageList = this.shopService.queryPageList(param);
        return Result.ok(pageList);
    }

    @PostMapping(value={"/collect"})
    @AutoLog(busModule="\u5c0f\u5e97\u4fe1\u606f", value="\u6536\u85cf")
    @ApiOperation(value="\u6536\u85cf", notes="\u6536\u85cf")
    public Result<?> collect(@RequestBody ShopCollectDTO dto) {
        this.shopService.collect(dto);
        return Result.ok();
    }

    @ApiOperation(value="\u5c0f\u5e97\u8be6\u60c5-\u5934\u90e8\u4fe1\u606f", notes="\u5c0f\u5e97\u8be6\u60c5-\u5934\u90e8\u4fe1\u606f")
    @PostMapping(value={"/detail/head"})
    @ApiCallCount(apiCode="industry_shop_detail_data")
    public Result<?> detailHead(@RequestBody ShopDetailDTO dto) {
        ShopDetailVO vo = this.shopService.queryDetailHead(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790-\u7b5b\u9009\u7c7b\u76ee", notes="\u8fbe\u4eba\u5206\u6790-\u7b5b\u9009\u7c7b\u76ee")
    @PostMapping(value={"/detail/topManCategory"})
    public Result<?> detailTopManCategory(@RequestBody ShopDetailDTO dto) {
        ShopDetailVO vo = this.shopService.queryDetailTopManCategory(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790-\u8fbe\u4eba\u5217\u8868", notes="\u8fbe\u4eba\u5206\u6790-\u8fbe\u4eba\u5217\u8868")
    @PostMapping(value={"/detail/topManList"})
    public Result<?> detailTopManList(@RequestBody ShopDetailDTO dto) {
        ShopDetailVO vo = this.shopService.queryDetailTopManList(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u6790-\u7b5b\u9009\u7c7b\u76ee", notes="\u5546\u54c1\u5206\u6790-\u7b5b\u9009\u7c7b\u76ee")
    @PostMapping(value={"/detail/goodsCategory"})
    public Result<?> detailGoodsCategory(@RequestBody ShopDetailDTO dto) {
        ShopDetailVO vo = this.shopService.queryDetailGoodsCategory(dto);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u5546\u54c1\u5206\u6790-\u5546\u54c1\u5217\u8868", notes="\u5546\u54c1\u5206\u6790-\u5546\u54c1\u5217\u8868")
    @PostMapping(value={"/detail/goodsList"})
    public Result<?> detailGoodsList(@RequestBody ShopDetailDTO dto) {
        ShopDetailVO vo = this.shopService.queryDetailGoodsList(dto);
        return Result.ok((Object)vo);
    }

    @GetMapping(value={"/add/category"})
    public Result<?> addCategory() {
        this.shopService.addCategory();
        return Result.ok();
    }

    @GetMapping(value={"/test"})
    public Result<?> test() {
        return Result.ok();
    }
}

