/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.els.common.aspect.annotation.SrmTransaction;
import com.els.common.constant.CommonConstant;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.common.utils.SmsBean;
import com.els.modules.common.utils.SmsResult;
import com.els.modules.common.utils.SmsUtil;
import com.els.modules.touch.entity.SmsTemplate;
import com.els.modules.touch.entity.TopManMsgConfig;
import com.els.modules.touch.entity.TopManMsgConfigItem;
import com.els.modules.touch.entity.TopManMsgTask;
import com.els.modules.touch.enumerate.MsgTouchTypeEnum;
import com.els.modules.touch.enumerate.MsgTypeEnum;
import com.els.modules.touch.mapper.TopManMsgConfigMapper;
import com.els.modules.touch.service.SmsTemplateService;
import com.els.modules.touch.service.TopManMsgConfigItemService;
import com.els.modules.touch.service.TopManMsgConfigService;
import com.els.modules.touch.service.TopManMsgTaskService;
import com.els.modules.touch.vo.MsgTemplateVO;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.compress.utils.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class TopManMsgConfigServiceImpl
extends BaseServiceImpl<TopManMsgConfigMapper, TopManMsgConfig>
implements TopManMsgConfigService {
    @Lazy
    @Autowired
    private TopManMsgTaskService topManMsgTaskService;
    @Autowired
    private TopManMsgConfigItemService itemService;
    @Autowired
    @Lazy
    private SmsTemplateService smsTemplateService;

    @Override
    public void add(TopManMsgConfig topManMsgConfig) {
        topManMsgConfig.setId(null);
        topManMsgConfig.setDeleted(CommonConstant.STATUS_NO);
        ((TopManMsgConfigMapper)this.baseMapper).insert((Object)topManMsgConfig);
    }

    @Override
    public void edit(TopManMsgConfig topManMsgConfig) {
        int count = ((TopManMsgConfigMapper)this.baseMapper).updateById((Object)topManMsgConfig);
        Assert.isTrue((count != 0 ? 1 : 0) != 0, (String)I18nUtil.translate((String)"i18n_alert_APWFIKXWVVVXVSDJHrW_2fe92d52", (String)"\u5f53\u524d\u6570\u636e\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u540e\u63d0\u4ea4\u66f4\u6539\uff01"));
    }

    @Override
    public void delete(String id) {
        ((TopManMsgConfigMapper)this.baseMapper).deleteById((Serializable)((Object)id));
    }

    @Override
    public void deleteBatch(List<String> idList) {
        ((TopManMsgConfigMapper)this.baseMapper).deleteBatchIds(idList);
    }

    @Override
    public List<TopManMsgConfig> listBySubAccount(String elsAccount, String subAccount, String platform, String touchType) {
        return this.list((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StrUtil.isNotBlank((CharSequence)subAccount), TopManMsgConfig::getSubAccount, (Object)subAccount)).eq(BaseEntity::getElsAccount, (Object)elsAccount)).eq(TopManMsgConfig::getPlatform, (Object)platform)).eq(TopManMsgConfig::getTouchType, (Object)touchType)).orderByAsc(TopManMsgConfig::getSortNum));
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveConfigs(List<TopManMsgConfig> configs, String platform, String touchType) {
        ArrayList add = Lists.newArrayList();
        ArrayList edit = Lists.newArrayList();
        String tenant = TenantContext.getTenant();
        LoginUser loginUser = SysUtil.getLoginUser();
        HashSet newIds = Sets.newHashSet();
        configs.forEach(row -> {
            if (StrUtil.isBlank((CharSequence)row.getId()) || row.getId().indexOf("row") == 0) {
                row.setDeleted(CommonConstant.STATUS_NO);
                row.setSubAccount(loginUser.getSubAccount());
                row.setEmployeeName(loginUser.getRealname());
                row.setDeptNo(loginUser.getOrgCode());
                row.setPlatform(platform);
                row.setId(null);
                row.setTouchType(touchType);
                add.add(row);
            } else {
                newIds.add(row.getId());
                row.setTouchType(touchType);
                row.setDeleted(CommonConstant.STATUS_NO);
                edit.add(row);
            }
        });
        this.remove((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(TopManMsgConfig::getSubAccount, (Object)loginUser.getSubAccount())).eq(BaseEntity::getElsAccount, (Object)tenant)).eq(TopManMsgConfig::getPlatform, (Object)platform)).eq(TopManMsgConfig::getTouchType, (Object)touchType)).notIn(CollUtil.isNotEmpty((Collection)newIds), BaseEntity::getId, (Collection)newIds));
        if (CollUtil.isNotEmpty((Collection)add)) {
            this.saveBatch(add);
        }
        if (CollUtil.isNotEmpty((Collection)edit)) {
            this.updateBatchById(edit);
        }
    }

    private String format(Map<String, Object> params, String var) {
        var = var.replaceAll("\\$\\{", "#{[");
        var = var.replaceAll("}", "]}");
        SpelExpressionParser parser = new SpelExpressionParser();
        TemplateParserContext parserContext = new TemplateParserContext();
        String content = (String)parser.parseExpression(var, (ParserContext)parserContext).getValue(params, String.class);
        return content;
    }

    @Override
    @SrmTransaction(rollbackFor={Exception.class})
    public void saveTemplate(List<MsgTemplateVO> rq, String platform) {
        String elsAccouont = TenantContext.getTenant();
        LoginUser loginUser = SysUtil.getLoginUser();
        rq.forEach(vo -> {
            ConcurrentMap m = Maps.newConcurrentMap();
            SmsTemplate config = (SmsTemplate)((Object)((Object)this.smsTemplateService.getById((Serializable)((Object)vo.getTemplateId()))));
            for (TopManMsgConfigItem item : vo.getItems()) {
                Assert.isTrue((boolean)StrUtil.isNotBlank((CharSequence)item.getText()), (String)(item.getFieldName() + "\u4e0d\u80fd\u4e3a\u7a7a"));
                m.put(item.getField(), item.getText());
            }
            if (StrUtil.isNotBlank((CharSequence)vo.getId())) {
                vo.setElsAccount(elsAccouont);
                vo.setSubAccount(loginUser.getSubAccount());
                vo.setMsgContent(this.format(m, config.getSmsTemplate()));
                vo.setMsgType(MsgTypeEnum.SMS.getCode());
                vo.setPlatform(platform);
                vo.setTouchType(MsgTouchTypeEnum.SMS.getCode());
                this.updateById(vo);
                this.itemService.remove((Wrapper)Wrappers.lambdaQuery().eq(TopManMsgConfigItem::getHeadId, (Object)vo.getId()));
            } else {
                vo.setElsAccount(elsAccouont);
                vo.setSubAccount(loginUser.getSubAccount());
                vo.setMsgContent(this.format(m, config.getSmsTemplate()));
                vo.setPlatform(platform);
                vo.setTouchType(MsgTouchTypeEnum.SMS.getCode());
                vo.setMsgType(MsgTypeEnum.SMS.getCode());
                this.save(vo);
            }
            List<TopManMsgConfigItem> configs = vo.getItems();
            int i = 0;
            for (TopManMsgConfigItem x : configs) {
                x.setId(null);
                x.setHeadId(vo.getId());
                x.setElsAccount(elsAccouont);
                x.setSort(i++);
            }
            this.itemService.saveBatch(configs);
        });
        LoginUser user = SysUtil.getLoginUser();
        TopManMsgTask task = (TopManMsgTask)((Object)this.topManMsgTaskService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)user.getElsAccount())).eq(TopManMsgTask::getSubAccount, (Object)user.getSubAccount())).eq(TopManMsgTask::getTouchType, (Object)MsgTouchTypeEnum.SMS.getCode())).eq(TopManMsgTask::getPlatform, (Object)platform)));
        if (ObjectUtil.isEmpty((Object)((Object)task))) {
            task = new TopManMsgTask();
            task.setElsAccount(user.getElsAccount());
            task.setSubAccount(user.getSubAccount());
            task.setPlatform(platform);
            task.setTouchType(MsgTouchTypeEnum.SMS.getCode());
            this.topManMsgTaskService.save((Object)task);
        }
    }

    @Override
    public void smsTest(MsgTemplateVO rq) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getTestId()), (String)"\u8bf7\u9009\u62e9\u6a21\u677f");
        TopManMsgConfig config = (TopManMsgConfig)((Object)this.getById((Serializable)((Object)rq.getTestId())));
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)config)), (String)"\u8bf7\u5148\u4fdd\u5b58\u914d\u7f6e");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getPhone()), (String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u624b\u673a\u53f7\u7801");
        SmsBean smsBean = new SmsBean();
        smsBean.setExtcode("385485");
        smsBean.setUserName("110426");
        smsBean.setPassword("ZupkpyNnDaz2");
        smsBean.setUrl("http://47.107.255.220:8001/sms/api/sendMessageOne.do");
        smsBean.setMobile(rq.getPhone());
        smsBean.setContent(config.getMsgContent());
        SmsResult result = SmsUtil.sendRenRenZhong(smsBean);
        if (ObjectUtil.isNotEmpty((Object)result) && ObjectUtil.isNotEmpty((Object)result.getData().get(0)) && ObjectUtil.isNotEmpty((Object)result.getData().get(0).getCode())) {
            LoginUser user = SysUtil.getLoginUser();
            TopManMsgTask task = (TopManMsgTask)((Object)this.topManMsgTaskService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BaseEntity::getElsAccount, (Object)user.getElsAccount())).eq(TopManMsgTask::getSubAccount, (Object)user.getSubAccount())).eq(TopManMsgTask::getTouchType, (Object)MsgTouchTypeEnum.SMS.getCode())).eq(TopManMsgTask::getPlatform, (Object)config.getPlatform())));
            Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)((Object)task)), (String)"\u8bf7\u5148\u4fdd\u5b58\u914d\u7f6e");
            task.setTest(Boolean.TRUE);
            this.topManMsgTaskService.updateById((Object)task);
        } else {
            String msg = ObjectUtil.isNotEmpty((Object)result) && ObjectUtil.isEmpty((Object)result.getData().get(0)) && ObjectUtil.isNotEmpty((Object)result.getData().get(0).getMessage()) ? result.getData().get(0).getMessage() : "\u53d1\u9001\u5931\u8d25";
            Assert.isTrue((boolean)false, (String)msg);
        }
    }
}

