/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.func.VoidFunc1;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.els.common.exception.ELSBootException;
import com.els.common.system.base.entity.BaseEntity;
import com.els.common.system.query.QueryGenerator;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.common.spider.entity.KuaiShouIndexListPage;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailBaseEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailFansEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailGoodsEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailGoodsItemEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailGoodsStoreEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailHeadPowerEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailLiveAnalysisEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailLiveDataEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailLiveEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailVideoAnalysisEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailVideoEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailVideoInfoEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManDetailVideoListEntity;
import com.els.modules.common.spider.entity.KuaiShouTopManInfo;
import com.els.modules.common.spider.properties.SpiderMethodType;
import com.els.modules.common.spider.spiderApi.SpiderApiUtil;
import com.els.modules.common.spider.vo.KuaiShouTopManDetailHeadContacrVO;
import com.els.modules.common.spider.vo.KuaiShouTopManDetailHeadVO;
import com.els.modules.industryInfo.api.annotation.OrderTagId;
import com.els.modules.industryInfo.api.dto.SimplePostRequestParam;
import com.els.modules.topman.dto.KuaiShouTopManCollectDTO;
import com.els.modules.topman.dto.KuaiShouTopManDTO;
import com.els.modules.topman.dto.KuaiShouTopManDetailDTO;
import com.els.modules.topman.entity.KuaiShouCategoryEntity;
import com.els.modules.topman.entity.KuaiShouRegionEntity;
import com.els.modules.topman.entity.KuaiShouTopManEntity;
import com.els.modules.topman.entity.TopManCollectEntity;
import com.els.modules.topman.entity.TopManSpiderMark;
import com.els.modules.topman.enumerate.MarkYn;
import com.els.modules.topman.enumerate.MongoCollectionType;
import com.els.modules.topman.enumerate.TopManCategoryEnum;
import com.els.modules.topman.exception.TopManException;
import com.els.modules.topman.mapper.KuaiShouTopManInformationMapper;
import com.els.modules.topman.service.KuaiShouSpiderTopManService;
import com.els.modules.topman.service.KuaiShouTopManService;
import com.els.modules.topman.service.MongoEntityService;
import com.els.modules.topman.service.MongoHandleService;
import com.els.modules.topman.service.TopManCollectService;
import com.els.modules.topman.vo.KuaiShouSpiderApiIndexListVO;
import com.els.modules.topman.vo.KuaiShouTopManCategory;
import com.els.modules.topman.vo.KuaiShouTopManVO;
import com.google.common.collect.Maps;
import com.mongodb.client.MongoCursor;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.data.mongodb.core.query.UpdateDefinition;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KuaiShouTopManServiceImpl
implements KuaiShouTopManService {
    private static final Logger log;
    private static final Map<String, Integer> orderTag;
    private static final String CATALOGUE = "talent:category:cache";
    private static final String COLON = ":";
    private final BigDecimal d1000 = new BigDecimal(1000);
    private final BigDecimal d100 = new BigDecimal(100);
    @Autowired
    private SpiderApiUtil spiderApiUtil;
    @Autowired
    private KuaiShouSpiderTopManService kuaiShouSpiderTopManService;
    @Autowired
    private RedisUtil redisUtil;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private TopManCollectService topManCollectService;
    @Autowired
    private KuaiShouTopManInformationMapper kuaiShouTopManInformationMapper;
    @Resource
    private MongoHandleService mongoHandleService;

    @Override
    public List<KuaiShouTopManCategory> getCategoryData(String type) {
        StringBuilder redisKey;
        List<KuaiShouTopManCategory> stringListMap;
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        if ((stringListMap = (List<KuaiShouTopManCategory>)this.redisUtil.get((redisKey = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append(type).append(COLON).append(language)).toString())) != null) {
            return stringListMap;
        }
        log.info("getCategoryData:\u8d70\u4e86\u65e0\u7f13\u5b58");
        LinkedHashMap<String, KuaiShouTopManCategory> resultData = new LinkedHashMap<String, KuaiShouTopManCategory>();
        Document document = new Document();
        String kuaishouCategory = "tb_kuaishou_category";
        MongoCursor attractCursor = this.mongoTemplate.getCollection(kuaishouCategory).find((Bson)document).noCursorTimeout(true).cursor();
        Document attract = null;
        boolean isTalentCategory = false;
        KuaiShouTopManCategory talentInfoCategory = new KuaiShouTopManCategory();
        ArrayList<KuaiShouTopManCategory.ContentCategory> talentList = new ArrayList<KuaiShouTopManCategory.ContentCategory>();
        boolean isFanCategory = false;
        KuaiShouTopManCategory fanInfoCategory = new KuaiShouTopManCategory();
        ArrayList<KuaiShouTopManCategory.ContentCategory> fanList = new ArrayList<KuaiShouTopManCategory.ContentCategory>();
        boolean isContentCategory = false;
        KuaiShouTopManCategory contentPerformanceCategory = new KuaiShouTopManCategory();
        ArrayList<KuaiShouTopManCategory.ContentCategory> contentList = new ArrayList<KuaiShouTopManCategory.ContentCategory>();
        boolean isGoodsPerformance = false;
        KuaiShouTopManCategory goodsPerformanceCategory = new KuaiShouTopManCategory();
        ArrayList<KuaiShouTopManCategory.ContentCategory> goodsList = new ArrayList<KuaiShouTopManCategory.ContentCategory>();
        while (attractCursor.hasNext()) {
            try {
                List directoryJson;
                List directoryJson2;
                ArrayList<KuaiShouTopManCategory.SubTags> commonList;
                KuaiShouTopManCategory.ContentCategory topManInfo;
                attract = (Document)attractCursor.next();
                String name = attract.getString((Object)"name");
                String secName = attract.getString((Object)"sec_name");
                String str = attract.toJson();
                Map t = (Map)JSONObject.parseObject((String)str, Map.class);
                KuaiShouTopManCategory kuaiShouTopManCategory = new KuaiShouTopManCategory();
                if (TopManCategoryEnum.CONTENT_CATEGORY.getDesc().equals(name)) {
                    this.getContentData(t, resultData, "contentType", kuaiShouTopManCategory, 1);
                }
                if (TopManCategoryEnum.INDUSTRY.getDesc().equals(name)) {
                    this.getContentData(t, resultData, "Industry", kuaiShouTopManCategory, 2);
                }
                if (TopManCategoryEnum.CONTENT_FORM.getDesc().equals(name)) {
                    this.getContentData(t, resultData, "contentForm", kuaiShouTopManCategory, 3);
                }
                if (TopManCategoryEnum.RECOMMEND.getDesc().equals(name)) {
                    kuaiShouTopManCategory.setFieldName("starRecommendation");
                    kuaiShouTopManCategory.setTitle(name);
                    kuaiShouTopManCategory.setSort(4);
                    ArrayList<KuaiShouTopManCategory.ContentCategory> categoryList = new ArrayList<KuaiShouTopManCategory.ContentCategory>();
                    List directoryJson3 = (List)t.get("directory_json");
                    directoryJson3.forEach(a -> {
                        if (this.checkoutStarRecommendation(a.get("tagName").toString(), type)) {
                            KuaiShouTopManCategory.ContentCategory contentCategory = new KuaiShouTopManCategory.ContentCategory();
                            contentCategory.setStarTagId(String.valueOf(a.get("tagId")));
                            contentCategory.setStarTagName(String.valueOf(a.get("tagName")));
                            contentCategory.setComponent("RCheckbox");
                            categoryList.add(contentCategory);
                        }
                    });
                    kuaiShouTopManCategory.setChildren(categoryList);
                    resultData.put("starRecommendation", kuaiShouTopManCategory);
                }
                if (TopManCategoryEnum.CONTENT_PERFORMANCE.getDesc().equals(name)) {
                    topManInfo = new KuaiShouTopManCategory.ContentCategory();
                    topManInfo.setComponent("RCustomSelect");
                    topManInfo.setStarTagId(attract.getString((Object)"_id"));
                    topManInfo.setStarTagName(attract.getString((Object)"sec_name"));
                    if (TopManCategoryEnum.ESTIMATED_CPM.getDesc().equals(secName) || TopManCategoryEnum.EXPECTED_PLAYBACK_VOLUME.getDesc().equals(secName) || TopManCategoryEnum.NUMBER_OF_PEOPLE.getDesc().equals(secName) || TopManCategoryEnum.ESTIMATED_ONLINE_POPULATION.getDesc().equals(secName)) {
                        commonList = new ArrayList<KuaiShouTopManCategory.SubTags>();
                        directoryJson2 = JSON.parseArray((String)t.get("directory_json").toString(), KuaiShouTopManCategory.Fans.class);
                        this.getParamData(commonList, directoryJson2, "", "");
                        topManInfo.setSubTags(commonList);
                    } else {
                        ArrayList<KuaiShouTopManCategory.SubTags> subTagsList = new ArrayList<KuaiShouTopManCategory.SubTags>();
                        directoryJson2 = JSON.parseArray((String)t.get("directory_json").toString(), KuaiShouTopManCategory.Fans.class);
                        directoryJson2.forEach(a -> {
                            KuaiShouTopManCategory.SubTags subTags = new KuaiShouTopManCategory.SubTags();
                            if (TopManCategoryEnum.CPE.getDesc().equals(secName)) {
                                subTags.setStarTagName(a.getMax().stripTrailingZeros().toPlainString() + "\u4ee5\u4e0b");
                                subTags.setStarTagValue(a.getMax());
                            } else {
                                subTags.setStarTagName(a.getMin().multiply(this.d100).stripTrailingZeros().toPlainString() + "%\u4ee5\u4e0a");
                                subTags.setStarTagValue(a.getMin());
                            }
                            subTagsList.add(subTags);
                        });
                        topManInfo.setSubTags(subTagsList);
                    }
                    this.contentPerformanceGroup(contentList, topManInfo, type);
                    if (!isContentCategory) {
                        contentPerformanceCategory.setFieldName("contentPerformance");
                        contentPerformanceCategory.setTitle(name);
                        contentPerformanceCategory.setSort(8);
                        isContentCategory = true;
                    }
                }
                if (TopManCategoryEnum.TANLENT_INDEX.getDesc().equals(secName)) {
                    kuaiShouTopManCategory.setFieldName("talentIndex");
                    kuaiShouTopManCategory.setTitle(TopManCategoryEnum.TANLENT_INDEX.getDesc());
                    kuaiShouTopManCategory.setSort(6);
                    topManInfo = new KuaiShouTopManCategory.ContentCategory();
                    topManInfo.setStarTagId(attract.getString((Object)"_id"));
                    ArrayList<KuaiShouTopManCategory.ContentCategory> categoryList = new ArrayList<KuaiShouTopManCategory.ContentCategory>();
                    ArrayList<KuaiShouTopManCategory.SubTags> subTagsList = new ArrayList<KuaiShouTopManCategory.SubTags>();
                    directoryJson = JSON.parseArray((String)t.get("directory_json").toString(), KuaiShouTopManCategory.Fans.class);
                    directoryJson.stream().sorted((a, b) -> this.getDefault(a.getMin()).compareTo(this.getDefault(b.getMin()))).forEach(a -> {
                        KuaiShouTopManCategory.SubTags subTags = new KuaiShouTopManCategory.SubTags();
                        subTags.setStarTagName(a.getMin().stripTrailingZeros().toPlainString() + "\u4ee5\u4e0a");
                        subTags.setStarTagValue(a.getMin());
                        subTagsList.add(subTags);
                    });
                    topManInfo.setComponent("RCustomSelect");
                    topManInfo.setStarTagName(TopManCategoryEnum.COMPOSTIE_INDEX.getDesc());
                    topManInfo.setSubTags(subTagsList);
                    categoryList.add(topManInfo);
                    KuaiShouTopManCategory.ContentCategory powderTopManInfo = new KuaiShouTopManCategory.ContentCategory();
                    BeanUtils.copyProperties((Object)topManInfo, (Object)powderTopManInfo);
                    powderTopManInfo.setStarTagName(TopManCategoryEnum.FLOUR_INDEX.getDesc());
                    categoryList.add(powderTopManInfo);
                    KuaiShouTopManCategory.ContentCategory creationTopManInfo = new KuaiShouTopManCategory.ContentCategory();
                    BeanUtils.copyProperties((Object)topManInfo, (Object)creationTopManInfo);
                    creationTopManInfo.setStarTagName(TopManCategoryEnum.CREATION_INDEX.getDesc());
                    categoryList.add(creationTopManInfo);
                    KuaiShouTopManCategory.ContentCategory costTopManInfo = new KuaiShouTopManCategory.ContentCategory();
                    BeanUtils.copyProperties((Object)topManInfo, (Object)costTopManInfo);
                    costTopManInfo.setStarTagName(TopManCategoryEnum.COST_PERFORMANCE.getDesc());
                    categoryList.add(costTopManInfo);
                    KuaiShouTopManCategory.ContentCategory activityManInfo = new KuaiShouTopManCategory.ContentCategory();
                    BeanUtils.copyProperties((Object)topManInfo, (Object)activityManInfo);
                    activityManInfo.setStarTagName(TopManCategoryEnum.BUSINESS_ACTIVITY.getDesc());
                    categoryList.add(activityManInfo);
                    KuaiShouTopManCategory.ContentCategory cooperationManInfo = new KuaiShouTopManCategory.ContentCategory();
                    BeanUtils.copyProperties((Object)topManInfo, (Object)cooperationManInfo);
                    cooperationManInfo.setStarTagName(TopManCategoryEnum.COOPERATION_INDEX.getDesc());
                    categoryList.add(cooperationManInfo);
                    kuaiShouTopManCategory.setChildren(categoryList);
                    resultData.put("talentIndex", kuaiShouTopManCategory);
                }
                if (TopManCategoryEnum.TALENT_INFORMATION.getDesc().equals(name)) {
                    if ("0".equals(type) || "2".equals(type) || "3".equals(type)) {
                        if (!TopManCategoryEnum.TANLENT_INDEX.getDesc().equals(secName) && !TopManCategoryEnum.TALENT_QUOTATION.getDesc().equals(secName)) {
                            this.talentInfoTranslation(attract, name, secName, t, talentList, talentInfoCategory, isTalentCategory);
                        }
                    } else if (!TopManCategoryEnum.TANLENT_INDEX.getDesc().equals(secName)) {
                        this.talentInfoTranslation(attract, name, secName, t, talentList, talentInfoCategory, isTalentCategory);
                    }
                }
                if (TopManCategoryEnum.FAN_PORTRAIT.getDesc().equals(name)) {
                    ArrayList<KuaiShouTopManCategory.SubTags> commonList2;
                    topManInfo = new KuaiShouTopManCategory.ContentCategory();
                    topManInfo.setStarTagId(attract.getString((Object)"_id"));
                    String value = attract.getString((Object)"sec_name").equals(TopManCategoryEnum.FAN_REGION.getDesc()) ? "\u7c89\u4e1d\u57ce\u5e02\u7ebf" : attract.getString((Object)"sec_name");
                    topManInfo.setStarTagName(value);
                    if (TopManCategoryEnum.FAN_REGION.getDesc().equals(secName) || TopManCategoryEnum.FAN_DEVICE.getDesc().equals(secName)) {
                        directoryJson2 = JSON.parseArray((String)t.get("directory_json").toString(), KuaiShouTopManCategory.Sex.class);
                        commonList2 = new ArrayList<KuaiShouTopManCategory.SubTags>(directoryJson2.size());
                        directoryJson2.forEach(a -> {
                            KuaiShouTopManCategory.SubTags subTags = new KuaiShouTopManCategory.SubTags();
                            subTags.setStarTagName(a.getLabel() + "\u5c45\u591a");
                            subTags.setStarTagValue(a.getValue());
                            commonList2.add(subTags);
                        });
                        topManInfo.setComponent("RSelect");
                        topManInfo.setSubTags(commonList2);
                    }
                    if (TopManCategoryEnum.FAN_GENDER.getDesc().equals(secName)) {
                        directoryJson2 = JSON.parseArray((String)t.get("directory_json").toString(), KuaiShouTopManCategory.Sex.class);
                        commonList2 = new ArrayList(directoryJson2.size());
                        directoryJson2.forEach(a -> {
                            KuaiShouTopManCategory.SubTags subTags = new KuaiShouTopManCategory.SubTags();
                            subTags.setStarTagName(a.getLabel() + "\u5c45\u591a");
                            subTags.setStarTagValue(a.getValue());
                            commonList2.add(subTags);
                        });
                        topManInfo.setComponent("RSelect");
                        topManInfo.setSubTags(commonList2);
                    }
                    if (TopManCategoryEnum.FAN_AGE.getDesc().equals(secName)) {
                        ArrayList<KuaiShouTopManCategory.SubTags> commonList3 = new ArrayList<KuaiShouTopManCategory.SubTags>();
                        directoryJson = JSON.parseArray((String)t.get("directory_json").toString(), KuaiShouTopManCategory.Fans.class);
                        this.getParamData(commonList3, directoryJson, "\u5c81", secName);
                        topManInfo.setComponent("RSelect");
                        topManInfo.setSubTags(commonList3);
                    }
                    fanList.add(topManInfo);
                    if (!isFanCategory) {
                        fanInfoCategory.setFieldName("fanInfo");
                        fanInfoCategory.setTitle("\u7c89\u4e1d\u4fe1\u606f");
                        fanInfoCategory.setSort(5);
                        isFanCategory = true;
                    }
                }
                if (!TopManCategoryEnum.GOODS_PERFORMANCE.getDesc().equals(name)) continue;
                topManInfo = new KuaiShouTopManCategory.ContentCategory();
                topManInfo.setComponent("RCustomSelect");
                topManInfo.setStarTagId(attract.getString((Object)"_id"));
                topManInfo.setStarTagName(attract.getString((Object)"sec_name"));
                if (!TopManCategoryEnum.VIDEO_CVR.getDesc().equals(secName)) {
                    commonList = new ArrayList();
                    directoryJson2 = JSON.parseArray((String)t.get("directory_json").toString(), KuaiShouTopManCategory.Fans.class);
                    this.getParamData(commonList, directoryJson2, "", "");
                    topManInfo.setSubTags(commonList);
                } else {
                    commonList = new ArrayList();
                    directoryJson2 = JSON.parseArray((String)t.get("directory_json").toString(), KuaiShouTopManCategory.Fans.class);
                    this.getParamData(commonList, directoryJson2, "%", TopManCategoryEnum.PENCENT.getDesc());
                    topManInfo.setSubTags(commonList);
                }
                goodsList.add(topManInfo);
                if (isGoodsPerformance) continue;
                goodsPerformanceCategory.setFieldName("goodsPerformance");
                goodsPerformanceCategory.setTitle("\u5e26\u8d27\u6548\u679c");
                goodsPerformanceCategory.setSort(9);
                isGoodsPerformance = true;
            }
            catch (Exception e) {
                log.error("attractCursor error", (Throwable)e);
                if (attract == null) continue;
                log.error("error is Data" + attract.toJson());
            }
        }
        contentPerformanceCategory.setChildren(contentList);
        resultData.put("contentPerformance", contentPerformanceCategory);
        talentInfoCategory.setChildren(talentList);
        resultData.put("talentInfo", talentInfoCategory);
        fanInfoCategory.setChildren(fanList);
        resultData.put("fanInfo", fanInfoCategory);
        goodsPerformanceCategory.setChildren(goodsList);
        resultData.put("goodsPerformance", goodsPerformanceCategory);
        stringListMap = this.groupMap(type, resultData);
        if (!stringListMap.isEmpty()) {
            this.redisUtil.set(redisKey.toString(), stringListMap, 14400L);
        }
        return stringListMap;
    }

    private void talentInfoTranslation(Document attract, String name, String secName, Map<?, ?> t, List<KuaiShouTopManCategory.ContentCategory> talentList, KuaiShouTopManCategory talentInfoCategory, boolean isTalentCategory) {
        ArrayList<KuaiShouTopManCategory.SubTags> commonList;
        List directoryJson;
        KuaiShouTopManCategory.ContentCategory topManInfo = new KuaiShouTopManCategory.ContentCategory();
        topManInfo.setStarTagId(attract.getString((Object)"_id"));
        topManInfo.setStarTagName(attract.getString((Object)"sec_name"));
        topManInfo.setComponent("RCascader");
        if (TopManCategoryEnum.TALENT_REGION.getDesc().equals(secName)) {
            ArrayList<KuaiShouTopManCategory.SubTags> categoryList = new ArrayList<KuaiShouTopManCategory.SubTags>();
            directoryJson = (List)t.get("directory_json");
            for (Map param : directoryJson) {
                KuaiShouTopManCategory.SubTags subTags = new KuaiShouTopManCategory.SubTags();
                subTags.setStarTagId(String.valueOf(param.get("provinceCode")));
                subTags.setStarTagName((String)param.get("provinceName"));
                subTags.setStarTagValue((String)param.get("provinceName"));
                List citys = (List)param.get("citys");
                ArrayList<KuaiShouTopManCategory.SubTags> subTagsList = new ArrayList<KuaiShouTopManCategory.SubTags>();
                for (Map citysMap : citys) {
                    KuaiShouTopManCategory.SubTags subTagsCitys = new KuaiShouTopManCategory.SubTags();
                    subTagsCitys.setStarTagId(String.valueOf(citysMap.get("cityCode")));
                    subTagsCitys.setStarTagName((String)citysMap.get("cityName"));
                    subTagsCitys.setStarTagValue((String)citysMap.get("cityName"));
                    subTagsList.add(subTagsCitys);
                }
                subTags.setSubTags(subTagsList);
                categoryList.add(subTags);
            }
            topManInfo.setSubTags(categoryList);
        }
        if (TopManCategoryEnum.TALENT_QUOTATION.getDesc().equals(secName) || TopManCategoryEnum.NUMBER_OF_FANS.getDesc().equals(secName)) {
            commonList = new ArrayList<KuaiShouTopManCategory.SubTags>();
            directoryJson = JSON.parseArray((String)t.get("directory_json").toString(), KuaiShouTopManCategory.Fans.class);
            this.getParamData(commonList, directoryJson, "", secName);
            topManInfo.setComponent("RCustomSelect");
            topManInfo.setSubTags(commonList);
        }
        if (TopManCategoryEnum.GENDER_OF_TALENT.getDesc().equals(secName)) {
            commonList = new ArrayList();
            directoryJson = JSON.parseArray((String)t.get("directory_json").toString(), KuaiShouTopManCategory.Sex.class);
            directoryJson.forEach(a -> {
                KuaiShouTopManCategory.SubTags subTags = new KuaiShouTopManCategory.SubTags();
                subTags.setStarTagName(a.getLabel());
                subTags.setStarTagValue(a.getValue().replace("\u6027", ""));
                commonList.add(subTags);
            });
            topManInfo.setComponent("RSelect");
            topManInfo.setSubTags(commonList);
        }
        talentList.add(topManInfo);
        if (!isTalentCategory) {
            talentInfoCategory.setFieldName("talentInfo");
            talentInfoCategory.setTitle(name);
            talentInfoCategory.setSort(5);
            isTalentCategory = true;
        }
    }

    private void contentPerformanceGroup(List<KuaiShouTopManCategory.ContentCategory> contentList, KuaiShouTopManCategory.ContentCategory topManInfo, String type) {
        if (("1".equals(type) || "2".equals(type)) && (TopManCategoryEnum.ESTIMATED_CPM.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.CPE.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.EXPECTED_PLAYBACK_VOLUME.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.INTERACTION_RATE.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.COMPLETION_RATE.getDesc().equals(topManInfo.getStarTagName()))) {
            contentList.add(topManInfo);
        }
        if ("4".equals(type) && (TopManCategoryEnum.ESTIMATED_CPM.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.NUMBER_OF_PEOPLE.getDesc().equals(topManInfo.getStarTagName()) || TopManCategoryEnum.ESTIMATED_ONLINE_POPULATION.getDesc().equals(topManInfo.getStarTagName()))) {
            contentList.add(topManInfo);
        }
    }

    private boolean checkoutStarRecommendation(String str, String type) {
        boolean isFalse = true;
        if (StringUtils.isBlank((CharSequence)str)) {
            return isFalse;
        }
        if ("4".equals(type) || "1".equals(type)) {
            if ("\u652f\u6301\u5bf9\u516c".equals(str) || "\u6709\u5546\u5355\u7ecf\u9a8c".equals(str) || "\u5386\u53f2\u5408\u4f5c\u8fc7".equals(str) || "\u4f18\u9009\u8fbe\u4eba".equals(str)) {
                isFalse = false;
                return isFalse;
            }
        } else if ("\u8fd130\u65e5\u7c89\u4e1d\u6570\u4e0a\u5347".equals(str) || "\u652f\u6301\u5bf9\u516c".equals(str) || "\u6709\u5546\u5355\u7ecf\u9a8c".equals(str) || "\u5386\u53f2\u5408\u4f5c\u8fc7".equals(str) || "\u4f18\u9009\u8fbe\u4eba".equals(str)) {
            isFalse = false;
            return isFalse;
        }
        return isFalse;
    }

    private List<KuaiShouTopManCategory> groupMap(String type, Map<String, KuaiShouTopManCategory> resultData) {
        LinkedList<KuaiShouTopManCategory> linkedHashData = new LinkedList<KuaiShouTopManCategory>();
        if (resultData != null && resultData.size() > 0) {
            linkedHashData.add(resultData.get("contentType"));
            linkedHashData.add(resultData.get("Industry"));
            switch (type) {
                case "1": {
                    linkedHashData.add(resultData.get("contentForm"));
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("talentIndex"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    linkedHashData.add(resultData.get("contentPerformance"));
                    linkedHashData.add(resultData.get("goodsPerformance"));
                    break;
                }
                case "2": {
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    break;
                }
                case "3": {
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    break;
                }
                case "4": {
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("talentIndex"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    linkedHashData.add(resultData.get("contentPerformance"));
                    break;
                }
                case "0": {
                    linkedHashData.add(resultData.get("starRecommendation"));
                    linkedHashData.add(resultData.get("talentInfo"));
                    linkedHashData.add(resultData.get("fanInfo"));
                    break;
                }
                default: {
                    throw new ELSBootException("type\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                }
            }
        }
        return linkedHashData;
    }

    private void getContentData(Map t, Map<String, KuaiShouTopManCategory> resultData, String type, KuaiShouTopManCategory kuaiShouTopManCategory, int sort) {
        kuaiShouTopManCategory.setTitle(String.valueOf(t.get("name")));
        kuaiShouTopManCategory.setSort(sort);
        kuaiShouTopManCategory.setFieldName(type);
        LinkedList<KuaiShouTopManCategory.ContentCategory> categoryList = new LinkedList<KuaiShouTopManCategory.ContentCategory>();
        List map = (List)t.get("directory_json");
        if (map != null && map.size() > 0) {
            for (Map param : map) {
                KuaiShouTopManCategory.ContentCategory aa = new KuaiShouTopManCategory.ContentCategory();
                aa.setStarTagName((String)param.get("starTagName"));
                aa.setStarTagId((String)param.get("starTagId"));
                aa.setComponent("RButton");
                categoryList.add(aa);
            }
            kuaiShouTopManCategory.setChildren(categoryList);
            resultData.put(type, kuaiShouTopManCategory);
        }
    }

    private void getParamData(List<KuaiShouTopManCategory.SubTags> commonList, List<KuaiShouTopManCategory.Fans> map, String postStr, String type) {
        map.stream().sorted((a, b) -> this.getDefault(a.getMin()).compareTo(this.getDefault(b.getMin()))).forEach(a -> {
            String min;
            KuaiShouTopManCategory.SubTags common = new KuaiShouTopManCategory.SubTags();
            if (a.getMax() == null) {
                min = KuaiShouTopManServiceImpl.getTenThousandOfNumber(type.equals(TopManCategoryEnum.TALENT_QUOTATION.getDesc()) ? a.getMin().divide(this.d1000, 0, 4) : a.getMin());
                if (TopManCategoryEnum.FAN_AGE.getDesc().equals(type)) {
                    common.setStarTagName(min + postStr + "\u4ee5\u4e0a\u5c45\u591a");
                } else if (TopManCategoryEnum.PENCENT.getDesc().equals(type)) {
                    common.setStarTagName(this.getHundredOfNumber(min) + postStr + "\u4ee5\u4e0a");
                } else {
                    common.setStarTagName(min + postStr + "\u4ee5\u4e0a");
                }
                common.setStarTagValue(a.getMin().setScale(3, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString() + "-");
            }
            if (a.getMin() == null) {
                String max = KuaiShouTopManServiceImpl.getTenThousandOfNumber(type.equals(TopManCategoryEnum.TALENT_QUOTATION.getDesc()) ? a.getMax().divide(this.d1000, 0, 4) : a.getMax());
                if (TopManCategoryEnum.FAN_AGE.getDesc().equals(type)) {
                    common.setStarTagName(max + postStr + "\u4ee5\u4e0b\u5c45\u591a");
                } else if (TopManCategoryEnum.PENCENT.getDesc().equals(type)) {
                    common.setStarTagName(this.getHundredOfNumber(max) + postStr + "\u4ee5\u4e0b");
                } else {
                    common.setStarTagName(max + postStr + "\u4ee5\u4e0b");
                }
                common.setStarTagValue("-" + a.getMax().setScale(3, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
            }
            if (a.getMin() != null && a.getMax() != null) {
                min = KuaiShouTopManServiceImpl.getTenThousandOfNumber(type.equals(TopManCategoryEnum.TALENT_QUOTATION.getDesc()) ? a.getMin().divide(this.d1000, 0, 4) : a.getMin());
                String max = KuaiShouTopManServiceImpl.getTenThousandOfNumber(type.equals(TopManCategoryEnum.TALENT_QUOTATION.getDesc()) ? a.getMax().divide(this.d1000, 0, 4) : a.getMax());
                if (TopManCategoryEnum.FAN_AGE.getDesc().equals(type)) {
                    common.setStarTagName(min + postStr + "-" + max + postStr + "\u5c45\u591a");
                } else if (TopManCategoryEnum.PENCENT.getDesc().equals(type)) {
                    common.setStarTagName(this.getHundredOfNumber(min) + postStr + "-" + this.getHundredOfNumber(max) + postStr);
                } else {
                    common.setStarTagName(min + postStr + "-" + max + postStr);
                }
                common.setStarTagValue(a.getMin().setScale(3, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString() + "-" + a.getMax().setScale(3, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString());
            }
            commonList.add(common);
        });
    }

    private BigDecimal getDefault(BigDecimal bigDecimal) {
        BigDecimal defaultNum = BigDecimal.ZERO;
        return bigDecimal == null ? defaultNum : bigDecimal;
    }

    private String getHundredOfNumber(String str) {
        return new BigDecimal(str).multiply(this.d100).stripTrailingZeros().toPlainString();
    }

    private static String getTenThousandOfNumber(BigDecimal num) {
        BigDecimal d10000 = new BigDecimal(10000);
        if (num.compareTo(d10000) < 0) {
            return num.setScale(3, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
        }
        String numStr = num.divide(d10000, 2, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
        return numStr + "w";
    }

    @Override
    public void cleanCache() {
        String language = I18nUtil.getCurrentLanguage();
        if (StrUtil.isBlank((CharSequence)language)) {
            language = "zh";
        }
        StringBuilder redisKeyVideo = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("1").append(COLON).append(language);
        StringBuilder redisKeyAll = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("2").append(COLON).append(language);
        StringBuilder redisKeyMy = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("3").append(COLON).append(language);
        StringBuilder redisKeyLive = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("4").append(COLON).append(language);
        StringBuilder redisKeyCollect = new StringBuilder(CATALOGUE).append(TenantContext.getTenant()).append(COLON).append("0").append(COLON).append(language);
        String[] arr = new String[]{redisKeyVideo.toString(), redisKeyAll.toString(), redisKeyMy.toString(), redisKeyLive.toString(), redisKeyCollect.toString()};
        this.redisUtil.del(arr);
    }

    @Override
    public IPage<KuaiShouTopManVO> queryTopManList(SimplePostRequestParam<KuaiShouTopManDTO> topManDto) throws Exception {
        IPage<KuaiShouTopManVO> page = new IPage<KuaiShouTopManVO>((long)topManDto.getPageNo().intValue(), (long)topManDto.getPageSize().intValue());
        KuaiShouTopManDTO filterInfo = (KuaiShouTopManDTO)topManDto.getFilterInfo();
        String taskType = filterInfo.getTaskType();
        if ("1".equals(taskType) || "4".equals(taskType)) {
            Map<?, ?> map = this.apiGetList(topManDto);
            SpiderMethodType kuaiShouIndexList = SpiderMethodType.KUAI_SHOU_INDEX_LIST;
            Class<KuaiShouIndexListPage> responseClass = KuaiShouIndexListPage.class;
            KuaiShouIndexListPage data = this.spiderApiUtil.postForEntity(kuaiShouIndexList, map, responseClass);
            page.setTotal(data.getTotal());
            page.setRecords(this.handleResult(data, filterInfo.getPlatformType(), taskType));
        } else {
            QueryWrapper<KuaiShouTopManEntity> queryWrapper = this.getQueryWrapper(topManDto);
            page = this.kuaiShouTopManInformationMapper.selectCollectTopMan(page, (Wrapper<KuaiShouTopManEntity>)queryWrapper, SysUtil.getLoginUser());
        }
        return page;
    }

    private List<KuaiShouTopManVO> handleResult(KuaiShouIndexListPage data, String platform, String taskType) {
        List<KuaiShouTopManInfo> starList = data.getStarList();
        if (starList == null || starList.size() == 0) {
            return new ArrayList<KuaiShouTopManVO>(0);
        }
        HashMap<String, KuaiShouTopManVO> map = new HashMap<String, KuaiShouTopManVO>(starList.size());
        ArrayList<KuaiShouTopManVO> resultEntityList = new ArrayList<KuaiShouTopManVO>(starList.size());
        for (KuaiShouTopManInfo kuaiShouTopManInfo : starList) {
            KuaiShouTopManVO kuaiShouTopManVO = new KuaiShouTopManVO();
            BeanUtils.copyProperties((Object)kuaiShouTopManInfo, (Object)kuaiShouTopManVO);
            kuaiShouTopManVO.setStarType(taskType);
            KuaiShouTopManInfo.LiveQuotedInfo liveQuotedInfo = kuaiShouTopManInfo.getLiveQuotedInfo();
            kuaiShouTopManVO.setLiveQuotedPricePerHour(liveQuotedInfo.getPerHour());
            String region = this.formatRegion(kuaiShouTopManInfo.getProvinceCode(), kuaiShouTopManInfo.getCityCode());
            kuaiShouTopManVO.setRegion(region);
            kuaiShouTopManVO.setThreeDaysOrderBid(kuaiShouTopManVO.getThreeDaysOrderBid().divide(this.d1000, 2, RoundingMode.HALF_UP));
            kuaiShouTopManVO.setLiveQuotedPricePerHour(kuaiShouTopManVO.getLiveQuotedPricePerHour().divide(this.d1000, 2, RoundingMode.HALF_UP));
            kuaiShouTopManVO.setFansIncreaseRate(kuaiShouTopManVO.getFansIncreaseRate().multiply(this.d100));
            kuaiShouTopManVO.setPhotoCompletePlayRate(kuaiShouTopManVO.getPhotoCompletePlayRate().multiply(this.d100));
            kuaiShouTopManVO.setPhotoInteractionRate(kuaiShouTopManVO.getPhotoInteractionRate().multiply(this.d100));
            resultEntityList.add(kuaiShouTopManVO);
            map.put(String.valueOf(kuaiShouTopManVO.getUserId()), kuaiShouTopManVO);
        }
        AddedAndCollect addedAndCollect = new AddedAndCollect();
        addedAndCollect.setTopManIds(map.keySet());
        addedAndCollect.setPlatform(platform);
        addedAndCollect.setLoginUser(SysUtil.getLoginUser());
        List<AddedAndCollect> addedAndCollects = this.kuaiShouTopManInformationMapper.checkAddedAndCollect(addedAndCollect);
        addedAndCollects.forEach(a -> {
            String topManId = a.getTopManId();
            KuaiShouTopManVO kuaiShouTopManVO = (KuaiShouTopManVO)map.get(topManId);
            if (kuaiShouTopManVO != null) {
                kuaiShouTopManVO.setIsCollection(a.getIsCollect());
                kuaiShouTopManVO.setIsAdded(a.getIsAdded());
            }
        });
        return resultEntityList;
    }

    private QueryWrapper<KuaiShouTopManEntity> getQueryWrapper(SimplePostRequestParam<KuaiShouTopManDTO> topManDto) {
        String[] columns;
        String column;
        KuaiShouTopManDTO filterInfo = (KuaiShouTopManDTO)topManDto.getFilterInfo();
        QueryWrapper query = new QueryWrapper();
        KuaiShouTopManDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        this.handleInTitle(screenItem.getContentType(), (QueryWrapper<KuaiShouTopManEntity>)query, KuaiShouTopManEntity::getContentTypeName);
        this.handleInTitle(screenItem.getIndustry(), (QueryWrapper<KuaiShouTopManEntity>)query, KuaiShouTopManEntity::getIndustryName);
        this.handleInTitle(screenItem.getContentForm(), (QueryWrapper<KuaiShouTopManEntity>)query, KuaiShouTopManEntity::getContentFormName);
        List<KuaiShouTopManDTO.ScreenItemField> starRecommendation = screenItem.getStarRecommendation();
        if (starRecommendation != null && starRecommendation.size() > 0) {
            query.and(wrapper -> {
                for (KuaiShouTopManDTO.ScreenItemField screenItemField : starRecommendation) {
                    ((LambdaQueryWrapper)wrapper.lambda().like(KuaiShouTopManEntity::getStarTagIds, (Object)screenItemField)).or();
                }
            });
        }
        List<KuaiShouTopManDTO.ScreenItemField> talentInfos = screenItem.getTalentInfo();
        block10: for (int i = 0; talentInfos != null && i < talentInfos.size(); ++i) {
            KuaiShouTopManDTO.ScreenItemField screenItemField = talentInfos.get(i);
            String value = screenItemField.getValue();
            switch (screenItemField.getTitle()) {
                case "\u7c89\u4e1d\u6570\u91cf": {
                    this.handleMinMax(value, (QueryWrapper<KuaiShouTopManEntity>)query, KuaiShouTopManEntity::getFansNum);
                    continue block10;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    query.lambda().eq(KuaiShouTopManEntity::getTopmanSex, (Object)value);
                    continue block10;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)value, String.class);
                    ((LambdaQueryWrapper)query.lambda().eq(KuaiShouTopManEntity::getProvinceCode, (Object)Integer.parseInt((String)strings.get(0)))).eq(KuaiShouTopManEntity::getCityCode, (Object)Integer.parseInt((String)strings.get(1)));
                    continue block10;
                }
                default: {
                    throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
                }
            }
        }
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && keyWord.trim().length() > 0) {
            query.and(q -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)q.lambda().like(KuaiShouTopManEntity::getTopmanName, (Object)keyWord)).or(a -> {
                    LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)a.eq(KuaiShouTopManEntity::getTopmanId, (Object)keyWord);
                });
            });
        }
        if ((column = topManDto.getColumn()) != null && !"default".equals(column) && (columns = column.split(",")).length > 0) {
            final String order = topManDto.getOrder();
            QueryGenerator.doMultiFieldsOrder((QueryWrapper)query, (Map)new HashMap<String, String[]>(2){
                {
                    super(x0);
                    this.put("order", order == null ? new String[columns.length] : order.split(","));
                    this.put("column", columns);
                }
            }, (Object)((Object)new KuaiShouTopManEntity()));
        }
        return query;
    }

    private void handleInTitle(List<KuaiShouTopManDTO.ScreenItemField> list, QueryWrapper<KuaiShouTopManEntity> query, SFunction<KuaiShouTopManEntity, ?> field) {
        if (list == null || list.size() == 0) {
            return;
        }
        List collect = list.stream().map(KuaiShouTopManDTO.ScreenItemField::getTitle).collect(Collectors.toList());
        query.lambda().in(field, collect);
    }

    private void handleMinMax(String value, QueryWrapper<KuaiShouTopManEntity> query, SFunction<KuaiShouTopManEntity, ?> field) {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                query.lambda().between(field, (Object)new BigDecimal(split[0]), (Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    query.lambda().le(field, (Object)new BigDecimal(split[0]));
                    break;
                }
                query.lambda().ge(field, (Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new TopManException.TransferParamException.ParamFormatError(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
        }
    }

    @Override
    @Transactional
    public void collect(KuaiShouTopManCollectDTO kuaiShouTopManCollectDTO) {
        if (MarkYn.check(kuaiShouTopManCollectDTO.getCollect())) {
            this.addMarkToSpider(kuaiShouTopManCollectDTO);
        }
        this.collectHandle(kuaiShouTopManCollectDTO);
    }

    private void collectHandle(KuaiShouTopManCollectDTO kuaiShouTopManCollectDTO) {
        LoginUser loginUser = SysUtil.getLoginUser();
        String elsAccount = loginUser.getElsAccount();
        String subAccount = loginUser.getSubAccount();
        String collect = kuaiShouTopManCollectDTO.getCollect();
        KuaiShouTopManVO entity = kuaiShouTopManCollectDTO.getEntity();
        if (MarkYn.check(collect)) {
            TopManCollectEntity topManCollectEntity = new TopManCollectEntity();
            topManCollectEntity.setTopmanId(String.valueOf(entity.getUserId()));
            topManCollectEntity.setPlatform(kuaiShouTopManCollectDTO.getPlatform());
            topManCollectEntity.setElsAccount(elsAccount);
            topManCollectEntity.setSubAccount(subAccount);
            this.topManCollectService.save((Object)topManCollectEntity);
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.lambda().eq(BaseEntity::getElsAccount, (Object)elsAccount);
            queryWrapper.lambda().eq(TopManCollectEntity::getSubAccount, (Object)subAccount);
            queryWrapper.lambda().eq(TopManCollectEntity::getPlatform, (Object)kuaiShouTopManCollectDTO.getPlatform());
            queryWrapper.lambda().eq(TopManCollectEntity::getTopmanId, (Object)entity.getUserId());
            this.topManCollectService.remove((Wrapper)queryWrapper);
        }
    }

    @Override
    public void addMarkToSpider(KuaiShouTopManCollectDTO kuaiShouTopManCollectDTO) {
        this.addMarkToMongo(kuaiShouTopManCollectDTO);
        KuaiShouTopManEntity spiderMarkEntity = this.getSpiderMarkEntity(kuaiShouTopManCollectDTO);
        this.kuaiShouSpiderTopManService.saveKsSpiderTopMan(spiderMarkEntity);
    }

    private void addMarkToMongo(KuaiShouTopManCollectDTO kuaiShouTopManCollectDTO) {
        KuaiShouTopManVO entity = kuaiShouTopManCollectDTO.getEntity();
        String userId = String.valueOf(entity.getUserId());
        MongoCollectionType collectMark = MongoCollectionType.TB_KS_ELS_TOP_MAN;
        HashMap<String, String> param = new HashMap<String, String>(1);
        param.put("topManId", String.valueOf(userId));
        Map<String, TopManSpiderMark> data = this.mongoHandleService.handleMongo(collectMark, param, TopManSpiderMark.class);
        TopManSpiderMark topManSpiderMark = data.get(userId);
        if (topManSpiderMark == null) {
            topManSpiderMark = new TopManSpiderMark();
            topManSpiderMark.setTopManId(userId);
            topManSpiderMark.setTaskType(kuaiShouTopManCollectDTO.getTaskType());
            topManSpiderMark.setCount(1);
            this.mongoTemplate.insert((Object)topManSpiderMark, collectMark.getCollectName());
        } else {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"topManId").is((Object)String.valueOf(userId)));
            Update update = new Update().set("count", (Object)(topManSpiderMark.getCount() + 1));
            this.mongoTemplate.upsert(query, (UpdateDefinition)update, TopManSpiderMark.class, collectMark.getCollectName());
        }
    }

    private KuaiShouTopManEntity getSpiderMarkEntity(KuaiShouTopManCollectDTO kuaiShouTopManCollectDTO) {
        KuaiShouTopManVO entity = kuaiShouTopManCollectDTO.getEntity();
        KuaiShouTopManEntity kuaiShouTopManEntity = new KuaiShouTopManEntity();
        kuaiShouTopManEntity.setStarType(entity.getStarType());
        kuaiShouTopManEntity.setProfileId(entity.getProfileId());
        kuaiShouTopManEntity.setTopmanId(String.valueOf(entity.getUserId()));
        kuaiShouTopManEntity.setTopmanName(entity.getName());
        kuaiShouTopManEntity.setKwaiid(entity.getKwaiId());
        kuaiShouTopManEntity.setStarId(String.valueOf(entity.getStarId()));
        kuaiShouTopManEntity.setPlatform(kuaiShouTopManCollectDTO.getPlatform());
        kuaiShouTopManEntity.setTopmanAvatar(entity.getHeadUrl());
        kuaiShouTopManEntity.setTopmanSource("1");
        kuaiShouTopManEntity.setLiveStatus(String.valueOf(entity.getLiveStatus()));
        kuaiShouTopManEntity.setRegion(entity.getRegion());
        kuaiShouTopManEntity.setProvinceCode(entity.getProvinceCode());
        kuaiShouTopManEntity.setCityCode(entity.getCityCode());
        kuaiShouTopManEntity.setContentTypeName(entity.getStarTagStr());
        kuaiShouTopManEntity.setContentFormName(entity.getMmuStarTagStr());
        kuaiShouTopManEntity.setIndustryName(entity.getIndustryTagStr());
        if (entity.getStarTagIds() != null && entity.getStarTagIds().length > 0) {
            String starTagIds = Arrays.stream(entity.getStarTagIds()).map(String::valueOf).collect(Collectors.joining(","));
            kuaiShouTopManEntity.setStarTagIds(starTagIds);
        }
        kuaiShouTopManEntity.setFansNum(entity.getFansNum());
        kuaiShouTopManEntity.setFansIncreaseNum(entity.getFansIncreaseNum());
        kuaiShouTopManEntity.setFansIncreaseRate(entity.getFansIncreaseRate());
        kuaiShouTopManEntity.setLiveExpectCpm(entity.getLiveExpectCpm());
        kuaiShouTopManEntity.setLiveExpectViewer(entity.getLiveExpectViewer());
        kuaiShouTopManEntity.setLiveMaxViewer(entity.getLiveMaxViewer());
        kuaiShouTopManEntity.setPhotoExpectClick(entity.getPhotoExpectClick());
        kuaiShouTopManEntity.setPhotoCompletePlayRate(entity.getPhotoCompletePlayRate());
        kuaiShouTopManEntity.setPhotoExpectCpm(entity.getPhotoExpectCpm());
        kuaiShouTopManEntity.setPhotoInteractionRate(entity.getPhotoInteractionRate());
        kuaiShouTopManEntity.setQuoteOfLive(entity.getLiveQuotedPricePerHour());
        kuaiShouTopManEntity.setQuoteOfVideo(entity.getThreeDaysOrderBid());
        kuaiShouTopManEntity.setTopmanSex(entity.getGender());
        kuaiShouTopManEntity.setCreateTime(new Date());
        LoginUser loginUser = SysUtil.getLoginUser();
        kuaiShouTopManEntity.setCreateBy(loginUser.getElsAccount() + "-" + loginUser.getSubAccount());
        kuaiShouTopManEntity.setDeleted(0);
        return kuaiShouTopManEntity;
    }

    @Override
    public KuaiShouTopManVO getByUserId(String userId) {
        HashMap map = Maps.newHashMap();
        map.put("userName", userId);
        map.put("pageSize", 1);
        map.put("currentPage", 1);
        map.put("starOrderTag", 3);
        map.put("taskType", 1);
        KuaiShouIndexListPage data = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_INDEX_LIST, map, KuaiShouIndexListPage.class);
        KuaiShouTopManInfo info = data.getStarList().get(0);
        KuaiShouTopManVO kuaiShouTopManVO = new KuaiShouTopManVO();
        BeanUtil.copyProperties((Object)info, (Object)kuaiShouTopManVO, (String[])new String[0]);
        kuaiShouTopManVO.setRegion(this.formatRegion(kuaiShouTopManVO.getProvinceCode(), kuaiShouTopManVO.getCityCode()));
        return kuaiShouTopManVO;
    }

    @Override
    @Deprecated
    public KuaiShouTopManDetailHeadVO getDetailHead(KuaiShouTopManDetailDTO param) {
        KuaiShouTopManDetailHeadVO result = null;
        String redisKey = "KsTopManDetailHead_" + param.getUserId() + "_" + param.getStarId() + "_" + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(3);
        apiParam.put("starType", param.getStarType());
        apiParam.put("starId", param.getStarId());
        apiParam.put("userID", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_STAR_PROFILE, apiParam, KuaiShouTopManDetailHeadVO.class);
            KuaiShouTopManDetailHeadVO.CoreData coreData = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CORE_DATA, apiParam, KuaiShouTopManDetailHeadVO.CoreData.class);
            result.setCoreData(coreData);
            KuaiShouTopManDetailVideoAnalysisEntity videoAnalysis = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO_ANALYSIS, apiParam, KuaiShouTopManDetailVideoAnalysisEntity.class);
            this.videoAnalysisConverter(videoAnalysis, result);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_STAR_PROFILE, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailHead(param);
                });
            }
        }
        AddedAndCollect addedAndCollect = new AddedAndCollect();
        addedAndCollect.setPlatform(param.getPlatform());
        addedAndCollect.setLoginUser(SysUtil.getLoginUser());
        addedAndCollect.setTopManIds(Collections.singletonList(param.getUserId()));
        List<AddedAndCollect> addedAndCollects = this.kuaiShouTopManInformationMapper.checkAddedAndCollect(addedAndCollect);
        if (addedAndCollects != null && addedAndCollects.size() > 0) {
            AddedAndCollect a = addedAndCollects.get(0);
            result.setIsAdded(a.getIsAdded());
            result.setIsCollection(a.getIsCollect());
        }
        return result;
    }

    @Deprecated
    private void videoAnalysisConverter(KuaiShouTopManDetailVideoAnalysisEntity videoAnalysis, KuaiShouTopManDetailHeadVO result) {
        if (videoAnalysis == null || videoAnalysis.getStarWorkReport() == null) {
            return;
        }
        KuaiShouTopManDetailVideoAnalysisEntity.StarWorkReport starWorkReport = videoAnalysis.getStarWorkReport();
        KuaiShouTopManDetailHeadVO.VideoResponse videoResponse = result.getVideoResponse();
        videoResponse.setVideoCount(CollectionUtil.isNotEmpty(starWorkReport.getPphotoCntData()) ? BigDecimal.valueOf(starWorkReport.getPphotoCntData().get("30").intValue()) : BigDecimal.ZERO);
        videoResponse.setVideoPlayCntMedian(CollectionUtil.isNotEmpty(starWorkReport.getPplayMedianData()) ? BigDecimal.valueOf(starWorkReport.getPplayMedianData().get("30").intValue()) : BigDecimal.ZERO);
    }

    @Override
    public KuaiShouTopManDetailHeadVO getDetailHeadNew(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_STAR_PROFILE;
        KuaiShouTopManDetailHeadVO result = null;
        String redisKey = "KsTopManDetailHeadNew_" + param.getStarId() + "_" + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("starId", param.getStarId());
        apiParam.put("starType", param.getStarType());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailHeadVO.class);
            this.detailHeadNewConverter(result);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(spiderMethodType, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailHeadNew(param);
                });
            }
        }
        AddedAndCollect addedAndCollect = new AddedAndCollect();
        addedAndCollect.setPlatform(param.getPlatform());
        addedAndCollect.setLoginUser(SysUtil.getLoginUser());
        addedAndCollect.setTopManIds(Collections.singletonList(param.getUserId()));
        List<AddedAndCollect> addedAndCollects = this.kuaiShouTopManInformationMapper.checkAddedAndCollect(addedAndCollect);
        if (addedAndCollects != null && addedAndCollects.size() > 0) {
            AddedAndCollect a = addedAndCollects.get(0);
            result.setIsAdded(a.getIsAdded());
            result.setIsCollection(a.getIsCollect());
        }
        return result;
    }

    private void detailHeadNewConverter(KuaiShouTopManDetailHeadVO result) {
        List<KuaiShouTopManDetailHeadVO.ContentFormTag> contentFormTag;
        if (result == null || result.getStarProfileDict() == null) {
            return;
        }
        KuaiShouTopManDetailHeadVO.StarProfileDict profile = result.getStarProfileDict();
        profile.setHomeUrl(StrUtil.format((CharSequence)"https://www.kuaishou.com/profile/{}", (Object[])new Object[]{profile.getProfileId()}));
        ArrayList<String> starTagStrs = new ArrayList<String>(2);
        KuaiShouTopManDetailHeadVO.PolarisTag polarisTag = profile.getPolarisTag();
        if (polarisTag != null) {
            starTagStrs.add(polarisTag.getFirstTagName());
        }
        if (CollectionUtil.isNotEmpty(contentFormTag = profile.getContentFormTag())) {
            starTagStrs.add(contentFormTag.get(0).getFirstTagName());
        }
        profile.setStarTagStr(StringUtils.join(starTagStrs, (String)"\u3001"));
    }

    @Override
    public KuaiShouTopManDetailHeadVO getDetailHeadPower(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_POWER_INFO;
        KuaiShouTopManDetailHeadVO result = null;
        String redisKey = "KsTopManDetailHeadPower_" + param.getUserId() + "_" + param.getStarId() + "_" + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("userId", param.getUserId());
        apiParam.put("starType", param.getStarType());
        if (result == null) {
            result = new KuaiShouTopManDetailHeadVO();
            KuaiShouTopManDetailHeadPowerEntity powerEntity = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailHeadPowerEntity.class);
            this.headPowerConverter(powerEntity, result);
            HashMap<String, Object> apiParam2 = new HashMap<String, Object>(2);
            apiParam2.put("starId", param.getStarId());
            apiParam2.put("starType", param.getStarType());
            KuaiShouTopManDetailVideoAnalysisEntity videoAnalysis = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO_ANALYSIS, apiParam2, KuaiShouTopManDetailVideoAnalysisEntity.class);
            this.videoAnalysisConverterNew(videoAnalysis, result);
        } else {
            boolean check = this.spiderApiUtil.checkCache(spiderMethodType, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailHeadPower(param);
                });
            }
        }
        return result;
    }

    private void headPowerConverter(KuaiShouTopManDetailHeadPowerEntity powerEntity, KuaiShouTopManDetailHeadVO result) {
        KuaiShouTopManDetailHeadPowerEntity.VideoStarIndex videoStarIndex;
        KuaiShouTopManDetailHeadPowerEntity.StarIndexPowerModel starIndexPowerModel;
        if (powerEntity == null || (starIndexPowerModel = powerEntity.getStarIndexPowerModel()) == null || (videoStarIndex = starIndexPowerModel.getVideoStarIndex()) == null) {
            return;
        }
        KuaiShouTopManDetailHeadVO.BaseData baseData = new KuaiShouTopManDetailHeadVO.BaseData();
        baseData.setPowerValue(videoStarIndex.getPowerValue() != null ? videoStarIndex.getPowerValue().setScale(0, 4) : BigDecimal.ZERO);
        result.setBaseData(baseData);
    }

    private void videoAnalysisConverterNew(KuaiShouTopManDetailVideoAnalysisEntity videoAnalysis, KuaiShouTopManDetailHeadVO result) {
        KuaiShouTopManDetailVideoAnalysisEntity.StarWorkReport starWorkReport;
        if (videoAnalysis == null || (starWorkReport = videoAnalysis.getStarWorkReport()) == null) {
            return;
        }
        KuaiShouTopManDetailHeadVO.VideoResponse videoResponse = new KuaiShouTopManDetailHeadVO.VideoResponse();
        videoResponse.setVideoCount(CollectionUtil.isNotEmpty(starWorkReport.getPphotoCntData()) ? BigDecimal.valueOf(starWorkReport.getPphotoCntData().get("30").intValue()) : BigDecimal.ZERO);
        videoResponse.setVideoPlayCntMedian(CollectionUtil.isNotEmpty(starWorkReport.getPplayMedianData()) ? BigDecimal.valueOf(starWorkReport.getPplayMedianData().get("30").intValue()) : BigDecimal.ZERO);
        result.setVideoResponse(videoResponse);
    }

    @Override
    public KuaiShouTopManDetailHeadVO getDetailBase(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_USER_TEXT;
        KuaiShouTopManDetailHeadVO result = null;
        String redisKey = "KsTopManDetailBase_" + param.getProfileId();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("profileId", param.getProfileId());
        if (result == null) {
            result = new KuaiShouTopManDetailHeadVO();
            KuaiShouTopManDetailHeadVO.BaseData baseData = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailHeadVO.BaseData.class);
            result.setBaseData(baseData);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(spiderMethodType, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailBase(param);
                });
            }
        }
        return result;
    }

    @Override
    public KuaiShouTopManDetailHeadVO getDetailCore(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_PROMOTE_INFO;
        KuaiShouTopManDetailHeadVO result = null;
        String redisKey = "KsTopManDetailCore_" + param.getUserId() + "_" + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailHeadVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("userID", param.getUserId());
        apiParam.put("type", param.getStarType() == 1 ? 2 : 1);
        if (result == null) {
            result = new KuaiShouTopManDetailHeadVO();
            KuaiShouTopManDetailHeadVO.CoreData coreData = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailHeadVO.CoreData.class);
            result.setCoreData(coreData);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(spiderMethodType, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailCore(param);
                });
            }
        }
        return result;
    }

    @Override
    public KuaiShouTopManDetailHeadContacrVO getDetailHeadContacr(KuaiShouTopManDetailDTO param) {
        KuaiShouTopManDetailHeadContacrVO result = null;
        String redisKey = "KsTopManDetailHeadContacr_" + param.getUserId();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailHeadContacrVO)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("advertiserPhone", "(+86)" + param.getContacrPhone());
        apiParam.put("starId", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CONTACR, apiParam, KuaiShouTopManDetailHeadContacrVO.class);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CONTACR, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailHeadContacr(param);
                });
            }
        }
        return result;
    }

    @Override
    public KuaiShouTopManDetailBaseEntity getDetailBodyBase(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_BASE;
        KuaiShouTopManDetailBaseEntity result = null;
        String redisKey = "KsTopManDetailBodyBase_" + param.getUserId();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailBaseEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("userID", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailBaseEntity.class);
            KuaiShouTopManDetailHeadVO.CoreData coreData = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_CORE_DATA, apiParam, KuaiShouTopManDetailHeadVO.CoreData.class);
            this.getDetailBodyBaseTranslation(coreData, result);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyBase(param);
            });
        }
        return result;
    }

    private void getDetailBodyBaseTranslation(KuaiShouTopManDetailHeadVO.CoreData coreData, KuaiShouTopManDetailBaseEntity result) {
        KuaiShouTopManDetailBaseEntity.CommerceRequirement commerceRequirement = result.getCommerceRequirement();
        if (commerceRequirement != null && commerceRequirement.getInviteCommissionRate() != null) {
            commerceRequirement.setInviteCommissionRate(commerceRequirement.getInviteCommissionRate().divide(new BigDecimal(10), 2, RoundingMode.HALF_UP));
        }
        if (coreData == null) {
            return;
        }
        KuaiShouTopManDetailBaseEntity.CommerceCapacity commerceCapacity = result.getCommerceCapacity();
        List<KuaiShouTopManDetailHeadVO.HotSaleChannelInfo> hotSaleChannelList = coreData.getHotSaleChannelInfo();
        List<KuaiShouTopManDetailHeadVO.HotSaleBrandInfo> hotSaleBrandList = coreData.getHotSaleBrandInfo();
        if (CollectionUtil.isNotEmpty(hotSaleChannelList)) {
            ArrayList<KuaiShouTopManDetailBaseEntity.HotSaleChannelInfo> hotSaleChannelInfos = new ArrayList<KuaiShouTopManDetailBaseEntity.HotSaleChannelInfo>(hotSaleChannelList.size());
            hotSaleChannelList.forEach(h -> {
                KuaiShouTopManDetailBaseEntity.HotSaleChannelInfo hotSaleChannelInfo = new KuaiShouTopManDetailBaseEntity.HotSaleChannelInfo();
                BeanUtils.copyProperties((Object)h, (Object)hotSaleChannelInfo);
                hotSaleChannelInfos.add(hotSaleChannelInfo);
            });
            commerceCapacity.setHotSaleChannelInfo(hotSaleChannelInfos);
        }
        if (CollectionUtil.isNotEmpty(hotSaleBrandList)) {
            ArrayList<KuaiShouTopManDetailBaseEntity.HotSaleBrandInfo> hotSaleBrandInfos = new ArrayList<KuaiShouTopManDetailBaseEntity.HotSaleBrandInfo>(hotSaleBrandList.size());
            hotSaleBrandList.forEach(h -> {
                KuaiShouTopManDetailBaseEntity.HotSaleBrandInfo hotSaleBrandInfo = new KuaiShouTopManDetailBaseEntity.HotSaleBrandInfo();
                BeanUtils.copyProperties((Object)h, (Object)hotSaleBrandInfo);
                hotSaleBrandInfos.add(hotSaleBrandInfo);
            });
            commerceCapacity.setHotSaleBrandInfo(hotSaleBrandInfos);
        }
    }

    @Override
    public KuaiShouTopManDetailLiveAnalysisEntity getDetailBodyLiveNew(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_ANALYSIS;
        KuaiShouTopManDetailLiveAnalysisEntity result = null;
        String redisKey = "KsTopManDetailBodyLiveAnalysis_" + param.getUserId() + "_" + param.getTimeRangeType();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailLiveAnalysisEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(3);
        apiParam.put("userID", param.getUserId());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        apiParam.put("type", 1);
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailLiveAnalysisEntity.class);
            KuaiShouTopManDetailLiveEntity tCount = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_SALE_COUNT, apiParam, KuaiShouTopManDetailLiveEntity.class);
            if (tCount != null) {
                KuaiShouTopManDetailLiveAnalysisEntity.StaticDataInfoView staticDataInfoView = result.getStaticDataInfoView();
                staticDataInfoView.setPromoteItemCount(tCount.getPromoteItemCount());
                result.setStaticDataInfoView(staticDataInfoView);
            }
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyLiveNew(param);
            });
        }
        return result;
    }

    @Override
    public KuaiShouTopManDetailLiveEntity getDetailBodyLive(KuaiShouTopManDetailDTO param) {
        HashMap<String, Object> apiParam = new HashMap<String, Object>(9);
        apiParam.put("promoterId", param.getUserId());
        apiParam.put("offset", (param.getPage() - 1) * param.getPageSize());
        apiParam.put("limit", param.getPageSize());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        apiParam.put("type", 1);
        apiParam.put("orderType", param.getOrderType() == null ? 0 : param.getOrderType());
        apiParam.put("minPrice", param.getMinPrice() == null ? Integer.valueOf(0) : param.getMinPrice().multiply(this.d100));
        apiParam.put("maxPrice", param.getMaxPrice() == null ? Integer.valueOf(10000000) : param.getMaxPrice().multiply(this.d100));
        apiParam.put("channelIdList", param.getChannelIdList() == null ? Collections.EMPTY_LIST : param.getChannelIdList());
        KuaiShouTopManDetailLiveEntity result = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_LIST, apiParam, KuaiShouTopManDetailLiveEntity.class);
        result.getResultList().forEach(a -> a.setPromoteAvgPrice(a.getPromoteAvgPrice().divide(this.d100, 0, RoundingMode.HALF_UP)));
        return result;
    }

    @Override
    public KuaiShouTopManDetailLiveDataEntity getDetailBodyLiveData(KuaiShouTopManDetailDTO param) {
        HashMap<String, Object> apiParam = new HashMap<String, Object>(8);
        apiParam.put("orderType", param.getOrderType() == null ? 0 : param.getOrderType());
        apiParam.put("type", 1);
        apiParam.put("promoterId", param.getUserId());
        apiParam.put("liveStreamId", param.getLiveStreamId());
        apiParam.put("offset", (param.getPage() - 1) * param.getPageSize());
        apiParam.put("limit", param.getPageSize());
        apiParam.put("channelIdList", param.getChannelIdList() == null ? Collections.EMPTY_LIST : param.getChannelIdList());
        apiParam.put("brandIdList", param.getBrandIdList() == null ? Collections.EMPTY_LIST : param.getBrandIdList());
        KuaiShouTopManDetailLiveDataEntity result = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_BODY_LIVE_DATA, apiParam, KuaiShouTopManDetailLiveDataEntity.class);
        this.detailBodyLiveDataConverter(result);
        return result;
    }

    private void detailBodyLiveDataConverter(KuaiShouTopManDetailLiveDataEntity result) {
        if (result == null || CollectionUtil.isEmpty(result.getResultList())) {
            return;
        }
        result.getResultList().forEach(h -> {
            String itemSale = h.getItemSale();
            if (StringUtils.isNotBlank((CharSequence)itemSale) && itemSale.contains("\u4e07")) {
                String[] splits = itemSale.substring(0, itemSale.length() - 1).split("-");
                ArrayList<String> list = new ArrayList<String>(2);
                for (String str : splits) {
                    if ("0".equals(str) || h.getItemPrice().compareTo(BigDecimal.ZERO) == 0) {
                        list.add(str);
                        continue;
                    }
                    BigDecimal divide = new BigDecimal(Integer.valueOf(str) * 10000).divide(h.getItemPrice(), 0, 4);
                    list.add(divide.toPlainString());
                }
                h.setItemNum(StrUtil.join((CharSequence)"-", list));
            }
        });
    }

    @Override
    public KuaiShouTopManDetailVideoAnalysisEntity getDetailBodyVideoNew(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO_ANALYSIS;
        KuaiShouTopManDetailVideoAnalysisEntity result = null;
        String redisKey = "KsTopManDetailBodyVideoAnalysis_" + param.getStarId() + "_" + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailVideoAnalysisEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("starId", param.getStarId());
        apiParam.put("starType", param.getStarType());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailVideoAnalysisEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyVideoNew(param);
            });
        }
        return result;
    }

    @Override
    public KuaiShouTopManDetailVideoInfoEntity getDetailBodyVideoInfo(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO_INFO;
        KuaiShouTopManDetailVideoInfoEntity result = null;
        String redisKey = "KsTopManDetailBodyVideoInfo_" + param.getStarId();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailVideoInfoEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("starId", param.getStarId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailVideoInfoEntity.class);
            if (result != null) {
                this.detailBodyVideoInfoConverter(result);
                this.redisUtil.set(redisKey, (Object)result, 14400L);
            }
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyVideoInfo(param);
            });
        }
        return result;
    }

    private void detailBodyVideoInfoConverter(KuaiShouTopManDetailVideoInfoEntity result) {
        KuaiShouTopManDetailVideoInfoEntity.StarCommerceInfo info = result.getStarCommerceInfo30();
        if (info == null) {
            result.setStarCommerceInfo30(new KuaiShouTopManDetailVideoInfoEntity.StarCommerceInfo());
            return;
        }
        info.setVideoGmv(info.getVideoGmv() != null ? info.getVideoGmv().divide(this.d1000, 2, 4) : BigDecimal.ZERO);
        info.setVideoAvgUnitPrice(info.getVideoAvgUnitPrice() != null ? info.getVideoAvgUnitPrice().divide(this.d1000, 2, 4) : BigDecimal.ZERO);
        info.setVideoGpm(info.getVideoGpm() != null ? info.getVideoGpm().divide(this.d1000, 2, 4) : BigDecimal.ZERO);
        result.setStarCommerceInfo30(info);
    }

    @Override
    public KuaiShouTopManDetailVideoEntity getDetailBodyVideo(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO;
        KuaiShouTopManDetailVideoEntity result = null;
        String redisKey = "KsTopManDetailBodyVideo_" + param.getStarId();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailVideoEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(1);
        apiParam.put("starId", param.getStarId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailVideoEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyVideo(param);
            });
        }
        return result;
    }

    @Override
    public KuaiShouTopManDetailVideoListEntity getDetailBodyVideoList(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_VIDEO_LIST;
        KuaiShouTopManDetailVideoListEntity result = null;
        String redisKey = "KsTopManDetailBodyVideoList_" + param.getUserId() + "_" + param.getOrderType() + "_" + param.getPage() + "_" + param.getTimeRangeType();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailVideoListEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(4);
        apiParam.put("userID", param.getUserId());
        apiParam.put("orderType", param.getOrderType());
        apiParam.put("page", param.getPage());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailVideoListEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyVideoList(param);
            });
        }
        return result;
    }

    @Override
    public KuaiShouTopManDetailFansEntity getDetailBodyFans(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_FANS;
        KuaiShouTopManDetailFansEntity result = null;
        String redisKey = "KsTopManDetailBodyFans_" + param.getUserId() + "_" + param.getStarId() + "_" + param.getStarType();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailFansEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(3);
        apiParam.put("starType", param.getStarType() != null ? param.getStarType() : 1);
        apiParam.put("starId", param.getStarId());
        apiParam.put("userID", param.getUserId());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailFansEntity.class);
            this.formatFansAnalysisData(result);
            KuaiShouTopManDetailHeadVO fansDataOther = this.spiderApiUtil.postForEntity(SpiderMethodType.KUAI_SHOU_DETAIL_HEAD_STAR_PROFILE, apiParam, KuaiShouTopManDetailHeadVO.class);
            this.fansTrendTranslation(fansDataOther, result);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyFans(param);
            });
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void formatFansAnalysisData(KuaiShouTopManDetailFansEntity result) {
        if (result == null) {
            return;
        }
        HashMap<String, String> cityLine = new HashMap<String, String>(6);
        cityLine.put("firstline", "\u4e00\u7ebf");
        cityLine.put("newfirstline", "\u65b0\u4e00\u7ebf");
        cityLine.put("secondline", "\u4e8c\u7ebf");
        cityLine.put("thirdline", "\u4e09\u7ebf");
        cityLine.put("fourthline", "\u56db\u7ebf");
        cityLine.put("fifthline", "\u4e94\u7ebf");
        BigDecimal check = new BigDecimal(0);
        for (KuaiShouTopManDetailFansEntity.ViewData viewData : result.getCityPercentage()) {
            viewData.setLabel((String)cityLine.get(viewData.getLabel()));
            BigDecimal bigDecimal = viewData.getValue();
            viewData.setValue(bigDecimal.multiply(this.d100).setScale(2, RoundingMode.HALF_UP));
            if (check.compareTo(bigDecimal) >= 0) continue;
            check = bigDecimal;
            result.setCityPercentageOptimum(viewData);
        }
        BigDecimal check1 = new BigDecimal(0);
        for (KuaiShouTopManDetailFansEntity.ViewData viewData : result.getSexPercentage()) {
            BigDecimal bigDecimal = viewData.getValue();
            viewData.setValue(bigDecimal.multiply(this.d100).setScale(2, RoundingMode.HALF_UP));
            if (check1.compareTo(bigDecimal) >= 0) continue;
            check1 = bigDecimal;
            result.setSexPercentageOptimum(viewData);
        }
        BigDecimal bigDecimal = new BigDecimal(0);
        for (KuaiShouTopManDetailFansEntity.ViewData viewData : result.getAgePercentage()) {
            void var5_8;
            BigDecimal bigDecimal2 = viewData.getValue();
            viewData.setValue(bigDecimal2.multiply(this.d100).setScale(2, RoundingMode.HALF_UP));
            if (var5_8.compareTo(bigDecimal2) >= 0) continue;
            BigDecimal bigDecimal3 = bigDecimal2;
            result.setAgePercentageOptimum(viewData);
        }
        BigDecimal bigDecimal4 = new BigDecimal(0);
        for (KuaiShouTopManDetailFansEntity.ViewData viewData : result.getMobileBrandPercentage()) {
            void var6_15;
            BigDecimal bigDecimal5 = viewData.getValue();
            viewData.setValue(bigDecimal5.multiply(this.d100).setScale(2, RoundingMode.HALF_UP));
            if (var6_15.compareTo(bigDecimal5) >= 0) continue;
            BigDecimal bigDecimal6 = bigDecimal5;
            result.setMobileBrandPercentageOptimum(viewData);
        }
        BigDecimal bigDecimal7 = new BigDecimal(0);
        for (KuaiShouTopManDetailFansEntity.ViewData viewData : result.getMobilePricePercentage()) {
            void var7_22;
            BigDecimal value = viewData.getValue();
            viewData.setValue(value.multiply(this.d100).setScale(2, RoundingMode.HALF_UP));
            if (var7_22.compareTo(value) >= 0) continue;
            BigDecimal bigDecimal8 = value;
            result.setMobilePricePercentageOptimum(viewData);
        }
        BigDecimal bigDecimal9 = new BigDecimal(0);
        for (KuaiShouTopManDetailFansEntity.ViewData viewData : result.getAreaTopWithRadio()) {
            void var8_29;
            BigDecimal value = viewData.getValue();
            viewData.setValue(value.multiply(this.d100).setScale(2, RoundingMode.HALF_UP));
            if (var8_29.compareTo(value) >= 0) continue;
            BigDecimal bigDecimal10 = value;
            result.setAreaTopWithRadioOptimum(viewData);
        }
        BigDecimal bigDecimal11 = new BigDecimal(0);
        for (KuaiShouTopManDetailFansEntity.ViewData viewData : result.getAreaTopWithPermeation()) {
            void var9_36;
            BigDecimal value = viewData.getValue();
            viewData.setValue(value.multiply(this.d100).setScale(2, RoundingMode.HALF_UP));
            if (var9_36.compareTo(value) >= 0) continue;
            BigDecimal bigDecimal12 = value;
            result.setAreaTopWithPermeationOptimum(viewData);
        }
    }

    private void fansTrendTranslation(KuaiShouTopManDetailHeadVO fansDataOther, KuaiShouTopManDetailFansEntity result) {
        if (fansDataOther == null) {
            return;
        }
        if (fansDataOther.getFansData() != null) {
            KuaiShouTopManDetailHeadVO.FansData fansData = fansDataOther.getFansData();
            result.setFansIncreaseRateIn30(fansData.getFansIncreaseRateIn30());
            result.setFansIncreaseRateIn90(fansData.getFansIncreaseRateIn90());
            result.setFansInterestPercentage(fansData.getFansInterestPercentage());
            result.setCityDetailPercentage(fansData.getCityDetailPercentage());
            result.setStarActiveFansRateDtoList(fansData.getStarActiveFansRateDtoList());
        }
        Map<String, List<KuaiShouTopManDetailHeadVO.ViewData>> trendDataMap = fansDataOther.getStarProfileDict().getTrendData();
        Map<String, List<KuaiShouTopManDetailHeadVO.ViewData>> trendDiffDataMap = fansDataOther.getStarProfileDict().getTrendDiffData();
        String day = "90";
        if (trendDataMap != null) {
            for (String key : trendDataMap.keySet()) {
                List<KuaiShouTopManDetailHeadVO.ViewData> trendDatas;
                if (!day.equals(key) || !CollectionUtil.isNotEmpty(trendDatas = trendDataMap.get(key))) continue;
                ArrayList<KuaiShouTopManDetailFansEntity.ViewData> trend = new ArrayList<KuaiShouTopManDetailFansEntity.ViewData>(trendDatas.size());
                trendDatas.forEach(h -> {
                    KuaiShouTopManDetailFansEntity.ViewData data = new KuaiShouTopManDetailFansEntity.ViewData();
                    BeanUtils.copyProperties((Object)h, (Object)data);
                    trend.add(data);
                });
                result.setTrend(trend);
            }
        }
        if (trendDiffDataMap != null) {
            for (String key : trendDiffDataMap.keySet()) {
                List<KuaiShouTopManDetailHeadVO.ViewData> trendDiffDatas;
                if (!day.equals(key) || !CollectionUtil.isNotEmpty(trendDiffDatas = trendDiffDataMap.get(key))) continue;
                ArrayList<KuaiShouTopManDetailFansEntity.ViewData> trendDiff = new ArrayList<KuaiShouTopManDetailFansEntity.ViewData>(trendDiffDatas.size());
                trendDiffDatas.forEach(h -> {
                    KuaiShouTopManDetailFansEntity.ViewData data = new KuaiShouTopManDetailFansEntity.ViewData();
                    BeanUtils.copyProperties((Object)h, (Object)data);
                    trendDiff.add(data);
                });
                result.setTrendDiff(trendDiff);
            }
        }
    }

    @Override
    public KuaiShouTopManDetailGoodsEntity getDetailBodyGoodsCategory(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_CHANNEL_LIST;
        KuaiShouTopManDetailGoodsEntity result = null;
        String redisKey = "KsTopManDetailBodyGoodsCategory_";
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailGoodsEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(0);
        if (result == null) {
            result = this.spiderApiUtil.getForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailGoodsEntity.class);
            this.channelListConverter(result);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyGoodsCategory(param);
            });
        }
        return result;
    }

    private void channelListConverter(KuaiShouTopManDetailGoodsEntity result) {
        if (result == null || CollectionUtil.isEmpty(result.getChannelList())) {
            return;
        }
        result.setChannelList(result.getChannelList().stream().filter(h -> !"\u9996\u9875".equals(h.getChannelName())).collect(Collectors.toList()));
    }

    @Override
    public KuaiShouTopManDetailGoodsEntity getDetailBodyGoods(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_GOODS;
        KuaiShouTopManDetailGoodsEntity result = null;
        String redisKey = "KsTopManDetailBodyGoods_" + param.getUserId() + "_" + param.getTimeRangeType();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailGoodsEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(2);
        apiParam.put("userID", param.getUserId());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailGoodsEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else {
            boolean check = this.spiderApiUtil.checkCache(spiderMethodType, apiParam);
            if (!check) {
                SpiderApiUtil.taskExecutor.execute(() -> {
                    param.setClearCache("1");
                    this.getDetailBodyGoods(param);
                });
            }
        }
        return result;
    }

    @Override
    public KuaiShouTopManDetailGoodsItemEntity getDetailBodyGoodsItem(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_GOODS_ITEM;
        KuaiShouTopManDetailGoodsItemEntity result = null;
        String redisKey = "KsTopManDetailBodyGoodsItem_" + param.getUserId() + "_" + param.getTimeRangeType() + "_" + param.getPage() + "_" + param.getPageSize() + "_" + param.getChannelIdList() + "_" + param.getBrandIdList();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailGoodsItemEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(8);
        apiParam.put("promoterId", param.getUserId());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        apiParam.put("pageNum", param.getPage());
        apiParam.put("pageSize", param.getPageSize());
        apiParam.put("channelIdList", param.getChannelIdList());
        apiParam.put("channelNameList", param.getChannelNameList());
        apiParam.put("brandIdList", param.getBrandIdList());
        apiParam.put("brandNameList", param.getBrandNameList());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailGoodsItemEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyGoodsItem(param);
            });
        }
        return result;
    }

    @Override
    public KuaiShouTopManDetailGoodsStoreEntity getDetailBodyGoodsStore(KuaiShouTopManDetailDTO param) {
        SpiderMethodType spiderMethodType = SpiderMethodType.KUAI_SHOU_DETAIL_BODY_GOODS_STORE;
        KuaiShouTopManDetailGoodsStoreEntity result = null;
        String redisKey = "KsTopManDetailBodyGoodsStore_" + param.getUserId() + "_" + param.getTimeRangeType() + "_" + param.getPage() + "_" + param.getPageSize() + "_" + param.getChannelIdList();
        if (!"1".equals(param.getClearCache())) {
            result = (KuaiShouTopManDetailGoodsStoreEntity)this.redisUtil.get(redisKey);
        }
        HashMap<String, Object> apiParam = new HashMap<String, Object>(6);
        apiParam.put("promoterId", param.getUserId());
        apiParam.put("timeRangeType", param.getTimeRangeType());
        apiParam.put("pageNum", param.getPage());
        apiParam.put("pageSize", param.getPageSize());
        apiParam.put("channelIdList", param.getChannelIdList());
        apiParam.put("channelNameList", param.getChannelNameList());
        if (result == null) {
            result = this.spiderApiUtil.postForEntity(spiderMethodType, apiParam, KuaiShouTopManDetailGoodsStoreEntity.class);
            this.redisUtil.set(redisKey, (Object)result, 14400L);
        } else if (!this.spiderApiUtil.checkCache(spiderMethodType, apiParam)) {
            SpiderApiUtil.taskExecutor.execute(() -> {
                param.setClearCache("1");
                this.getDetailBodyGoodsStore(param);
            });
        }
        return result;
    }

    @Override
    public Map<?, ?> apiGetList(SimplePostRequestParam<KuaiShouTopManDTO> topManDto) throws Exception {
        String column = topManDto.getColumn();
        String order = topManDto.getOrder();
        KuaiShouTopManDTO filterInfo = (KuaiShouTopManDTO)topManDto.getFilterInfo();
        Integer orderTabId = orderTag.get(order == null ? "default" : column);
        if (orderTabId == null) {
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u8be5\u5b57\u6bb5\u65e0\u6cd5\u6392\u5e8f"));
        }
        KuaiShouSpiderApiIndexListVO kuaiShouSpiderApiIndexListVo = new KuaiShouSpiderApiIndexListVO(topManDto.getPageNo(), topManDto.getPageSize());
        String keyWord = topManDto.getKeyWord();
        if (keyWord != null && !"".equals(keyWord)) {
            kuaiShouSpiderApiIndexListVo.setUserName(keyWord);
        }
        kuaiShouSpiderApiIndexListVo.setStarOrderTag(orderTabId);
        if (!orderTabId.equals(3)) {
            kuaiShouSpiderApiIndexListVo.setStarOrderType("desc".equals(order) ? 2 : 1);
        }
        kuaiShouSpiderApiIndexListVo.setTaskType(Integer.parseInt(filterInfo.getTaskType()));
        KuaiShouTopManDTO.ScreenItem screenItem = filterInfo.getScreenItem();
        if (screenItem != null) {
            List<KuaiShouTopManDTO.ScreenItemField> contentType = screenItem.getContentType();
            kuaiShouSpiderApiIndexListVo.setContentTagIdList(this.handleTagList(contentType, "\u5185\u5bb9\u5206\u7c7b"));
            List<KuaiShouTopManDTO.ScreenItemField> industry = screenItem.getIndustry();
            kuaiShouSpiderApiIndexListVo.setIndustryTagIdList(this.handleTagList(industry, "\u6240\u5c5e\u884c\u4e1a"));
            List<KuaiShouTopManDTO.ScreenItemField> contentForm = screenItem.getContentForm();
            kuaiShouSpiderApiIndexListVo.setContentFormTagId(this.handleStringList(contentForm));
            List<KuaiShouTopManDTO.ScreenItemField> starRecommendation = screenItem.getStarRecommendation();
            kuaiShouSpiderApiIndexListVo.setStarTagIds(this.handleStringList(starRecommendation));
            List<KuaiShouTopManDTO.ScreenItemField> talentInfos = screenItem.getTalentInfo();
            this.initScreenItemField(talentInfos, kuaiShouSpiderApiIndexListVo);
            List<KuaiShouTopManDTO.ScreenItemField> talentIndex = screenItem.getTalentIndex();
            this.initScreenItemField(talentIndex, kuaiShouSpiderApiIndexListVo);
            List<KuaiShouTopManDTO.ScreenItemField> fanInfo = screenItem.getFanInfo();
            this.initScreenItemField(fanInfo, kuaiShouSpiderApiIndexListVo);
            List<KuaiShouTopManDTO.ScreenItemField> contentPerformance = screenItem.getContentPerformance();
            this.initScreenItemField(contentPerformance, kuaiShouSpiderApiIndexListVo);
            List<KuaiShouTopManDTO.ScreenItemField> goodsPerformance = screenItem.getGoodsPerformance();
            this.initScreenItemField(goodsPerformance, kuaiShouSpiderApiIndexListVo);
        }
        String json = JSON.toJSONString((Object)kuaiShouSpiderApiIndexListVo);
        return (Map)JSON.parseObject((String)json, Map.class);
    }

    private List<KuaiShouSpiderApiIndexListVO.Tag> handleTagList(List<KuaiShouTopManDTO.ScreenItemField> screenItemFields, String name) {
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return null;
        }
        return screenItemFields.stream().filter(a -> a.getStarTagId() != null).map(a -> {
            KuaiShouCategoryEntity suCategory;
            KuaiShouSpiderApiIndexListVO.Tag tag = new KuaiShouSpiderApiIndexListVO.Tag();
            tag.setId(a.getStarTagId());
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("name", name);
            Map<String, KuaiShouCategoryEntity> category = this.cacheMongo(MongoCollectionType.TB_KS_CATEGORY, KuaiShouCategoryEntity.class, param);
            if (category != null && (suCategory = category.get(a.getStarTagId())) != null) {
                tag.setSubIds(suCategory.getSubTagsString());
            }
            return tag;
        }).collect(Collectors.toList());
    }

    private List<String> handleStringList(List<KuaiShouTopManDTO.ScreenItemField> screenItemFields) {
        if (screenItemFields != null && screenItemFields.size() > 0) {
            return screenItemFields.stream().map(KuaiShouTopManDTO.ScreenItemField::getStarTagId).collect(Collectors.toList());
        }
        return null;
    }

    private void initScreenItemField(List<KuaiShouTopManDTO.ScreenItemField> screenItemFields, KuaiShouSpiderApiIndexListVO kuaiShouSpiderApiIndexListVo) throws Exception {
        if (screenItemFields == null || screenItemFields.size() == 0) {
            return;
        }
        block62: for (KuaiShouTopManDTO.ScreenItemField screenItemField : screenItemFields) {
            String value = screenItemField.getValue();
            switch (screenItemField.getTitle()) {
                case "\u7c89\u4e1d\u6570\u91cf": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setFansMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setFansMaxNum));
                    continue block62;
                }
                case "\u8fbe\u4eba\u62a5\u4ef7": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setStarMinPrice), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setStarMaxPrice));
                    continue block62;
                }
                case "\u8fbe\u4eba\u6027\u522b": {
                    kuaiShouSpiderApiIndexListVo.setGender(value);
                    continue block62;
                }
                case "\u8fbe\u4eba\u5730\u57df": {
                    List strings = JSON.parseArray((String)value, String.class);
                    kuaiShouSpiderApiIndexListVo.setProvinceCode(Integer.parseInt((String)strings.get(0)));
                    kuaiShouSpiderApiIndexListVo.setCityCode(Integer.parseInt((String)strings.get(1)));
                    continue block62;
                }
                case "\u7efc\u5408\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setStarIndex));
                    continue block62;
                }
                case "\u6da8\u7c89\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setAddFansIndex));
                    continue block62;
                }
                case "\u521b\u4f5c\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setCreateIndex));
                    continue block62;
                }
                case "\u6027\u4ef7\u6bd4": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setPerformancePriceIndex));
                    continue block62;
                }
                case "\u5546\u4e1a\u6d3b\u8dc3\u5ea6": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setBizActIndex));
                    continue block62;
                }
                case "\u5408\u4f5c\u6307\u6570": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setCoopIndex));
                    continue block62;
                }
                case "\u7c89\u4e1d\u5e74\u9f84": {
                    this.handleRatioList(value, (VoidFunc1<List<KuaiShouSpiderApiIndexListVO.Ratio>>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setFansAgeList));
                    continue block62;
                }
                case "\u7c89\u4e1d\u6027\u522b": {
                    this.handleRatio(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Ratio>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setFansGender));
                    continue block62;
                }
                case "\u7c89\u4e1d\u57ce\u5e02\u7ebf": {
                    this.handleRatioList(value, (VoidFunc1<List<KuaiShouSpiderApiIndexListVO.Ratio>>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setFansCityList));
                    continue block62;
                }
                case "\u7c89\u4e1d\u8bbe\u5907": {
                    this.handleRatio(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Ratio>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setFansMobile));
                    continue block62;
                }
                case "\u9884\u671fCPM": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setExpectCpmMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setExpectCpmMaxNum));
                    continue block62;
                }
                case "CPE": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setExpectedCpe));
                    continue block62;
                }
                case "\u9884\u671f\u64ad\u653e\u91cf": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setPhotoExpectPlayMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setPhotoExpectPlayMaxNum));
                    continue block62;
                }
                case "\u9884\u671f\u89c2\u770b\u4eba\u6570": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setLiveAvgPeopleMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setLiveAvgPeopleMaxNum));
                    continue block62;
                }
                case "\u6700\u9ad8\u5728\u7ebf\u4eba\u6570": {
                    this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setLiveMaxViewerMinNum), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setLiveMaxViewerMaxNum));
                    continue block62;
                }
                case "\u4e92\u52a8\u7387": {
                    this.handleScopePercentage(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setPhotoInteractionRate));
                    continue block62;
                }
                case "\u5b8c\u64ad\u7387": {
                    this.handleScopePercentage(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setPhotoCompletePlayRate));
                    continue block62;
                }
                case "\u5e26\u8d27\u89c6\u9891\u65b0\u53d1\u5e03\u6570": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setVideoCnt));
                    continue block62;
                }
                case "\u5e26\u8d27\u89c6\u9891\u9500\u552e\u8ba2\u5355\u91cf": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setVideoOrderCnt));
                    continue block62;
                }
                case "\u5e26\u8d27\u89c6\u9891\u9500\u552e\u91d1\u989d": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setVideoGmv));
                    continue block62;
                }
                case "\u5e26\u8d27\u89c6\u9891\u5747\u5355\u4ef7": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setVideoAvgUnitPrice));
                    continue block62;
                }
                case "\u5e26\u8d27\u89c6\u9891\u5546\u54c1\u66dd\u5149\u91cf": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setVideoItemImpressionCnt));
                    continue block62;
                }
                case "\u5e26\u8d27\u89c6\u9891\u5546\u54c1\u8bbf\u95ee\u91cf": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setVideoItemVisitCnt));
                    continue block62;
                }
                case "\u5e26\u8d27\u89c6\u9891\u5546\u54c1\u8bbf\u95ee-\u652f\u4ed8\u8f6c\u5316\u7387": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setVideoCvr));
                    continue block62;
                }
                case "GPM": {
                    this.handleScope(value, (VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope>)((VoidFunc1 & Serializable)kuaiShouSpiderApiIndexListVo::setVideoGpm));
                    continue block62;
                }
            }
            throw new RuntimeException(I18nUtil.translate((String)"", (String)"\u627e\u4e0d\u5230\u5bf9\u5e94\u7684\u53c2\u6570\u7c7b\u578b"));
        }
    }

    private void handleScope(String value, VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope> field) throws Exception {
        KuaiShouSpiderApiIndexListVO.Scope scope = new KuaiShouSpiderApiIndexListVO.Scope();
        this.handleMinMax(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)scope::setMin), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)scope::setMax));
        field.call((Object)scope);
    }

    private void handleMinMax(String value, VoidFunc1<BigDecimal> minField, VoidFunc1<BigDecimal> maxField) throws Exception {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                String max;
                String min = split[0];
                if (min != null && !"".equals(min)) {
                    minField.call((Object)new BigDecimal(split[0]));
                }
                if ((max = split[1]) == null || "".equals(max)) break;
                maxField.call((Object)new BigDecimal(split[1]));
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    maxField.call((Object)new BigDecimal(split[0]));
                    break;
                }
                minField.call((Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new TopManException.TransferParamException.ParamFormatError(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
        }
    }

    private void handleScopePercentage(String value, VoidFunc1<KuaiShouSpiderApiIndexListVO.Scope> field) throws Exception {
        KuaiShouSpiderApiIndexListVO.Scope scope = new KuaiShouSpiderApiIndexListVO.Scope();
        this.handleMinMaxPercentage(value, (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)scope::setMin), (VoidFunc1<BigDecimal>)((VoidFunc1 & Serializable)scope::setMax));
        field.call((Object)scope);
    }

    private void handleMinMaxPercentage(String value, VoidFunc1<BigDecimal> minField, VoidFunc1<BigDecimal> maxField) throws Exception {
        if (value == null) {
            return;
        }
        String[] split = value.split("-");
        switch (split.length) {
            case 0: {
                return;
            }
            case 2: {
                String max;
                String min = split[0];
                if (min != null && !"".equals(min)) {
                    BigDecimal minPercentage = new BigDecimal(split[0]).divide(this.d100, 2, 4);
                    minField.call((Object)minPercentage);
                }
                if ((max = split[1]) == null || "".equals(max)) break;
                BigDecimal maxPercentage = new BigDecimal(split[1]).divide(this.d100, 2, 4);
                maxField.call((Object)maxPercentage);
                break;
            }
            case 1: {
                if (value.startsWith("-")) {
                    maxField.call((Object)new BigDecimal(split[0]));
                    break;
                }
                minField.call((Object)new BigDecimal(split[0]));
                break;
            }
            default: {
                throw new TopManException.TransferParamException.ParamFormatError(I18nUtil.translate((String)"", (String)"{}\u914d\u7f6e\u7684\u6570\u636e\u503c\u4e0d\u6b63\u786e\uff0c\u8bf7\u4f7f\u7528\u59820-9\u7c7b\u4f3c\u7684\u683c\u5f0f\uff0c\u5de6\u8fb9\u662f\u5f00\u59cb\u53f3\u8fb9\u662f\u7ed3\u675f\uff0c\u5de6\u53f3\u54ea\u8fb9\u4e0d\u9650\u5236\u5219\u7559\u7a7a\uff0c\u90fd\u4e0d\u9650\u5236\u5219\u4e3a-"));
            }
        }
    }

    private void handleRatio(String value, VoidFunc1<KuaiShouSpiderApiIndexListVO.Ratio> field) throws Exception {
        if (value == null || "".equals(value)) {
            return;
        }
        field.call((Object)new KuaiShouSpiderApiIndexListVO.Ratio(value));
    }

    private void handleRatioList(String value, VoidFunc1<List<KuaiShouSpiderApiIndexListVO.Ratio>> field) throws Exception {
        if (value == null || "".equals(value)) {
            return;
        }
        field.call(Collections.singletonList(new KuaiShouSpiderApiIndexListVO.Ratio(value)));
    }

    @Override
    public String formatRegion(Integer provinceCode, Integer cityCode) {
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("name", "\u8fbe\u4eba\u4fe1\u606f");
        param.put("sec_name", "\u8fbe\u4eba\u5730\u57df");
        Map<String, KuaiShouRegionEntity> region = this.cacheMongo(MongoCollectionType.TB_KS_CATEGORY, KuaiShouRegionEntity.class, param);
        if (CollectionUtil.isEmpty(region) || region.get(String.valueOf(provinceCode)) == null) {
            return null;
        }
        KuaiShouRegionEntity province = region.get(String.valueOf(provinceCode));
        List<KuaiShouRegionEntity.KsCityEntity> cityList = province.getCitys();
        String regionString = province.getProvinceName();
        for (KuaiShouRegionEntity.KsCityEntity city : cityList) {
            if (!city.getCityCode().equals(String.valueOf(cityCode))) continue;
            regionString = regionString + "-" + city.getCityName();
            break;
        }
        return regionString;
    }

    private <T extends MongoEntityService> Map<String, T> cacheMongo(MongoCollectionType collectionType, Class<T> beanClass, Map<String, String> param) {
        if (beanClass == null || collectionType.getRedisKeyPre() == null) {
            return null;
        }
        StringBuilder redisKey = new StringBuilder(collectionType.getRedisKeyPre());
        for (String value : param.values()) {
            redisKey.append("_").append(value);
        }
        Map<String, T> result = (Map<String, T>)this.redisUtil.get(redisKey.toString());
        if (result == null) {
            result = this.mongoHandleService.handleMongo(collectionType, param, beanClass);
            this.redisUtil.set(redisKey.toString(), result, (long)collectionType.getCacheTime().intValue());
        }
        return result;
    }

    static {
        Field[] declaredFields;
        log = LoggerFactory.getLogger(KuaiShouTopManServiceImpl.class);
        orderTag = new HashMap<String, Integer>(10);
        orderTag.put("default", 3);
        orderTag.put(null, 3);
        Class<KuaiShouTopManVO> ksTopManResultEntityClass = KuaiShouTopManVO.class;
        for (Field declaredField : declaredFields = ksTopManResultEntityClass.getDeclaredFields()) {
            OrderTagId annotation = declaredField.getAnnotation(OrderTagId.class);
            if (annotation == null) continue;
            orderTag.put(declaredField.getName(), annotation.value());
        }
    }

    public static class AddedAndCollect {
        private LoginUser loginUser;
        private String platform;
        private Collection<String> topManIds;
        private String topManId;
        private String isAdded;
        private String isCollect;

        public LoginUser getLoginUser() {
            return this.loginUser;
        }

        public String getPlatform() {
            return this.platform;
        }

        public Collection<String> getTopManIds() {
            return this.topManIds;
        }

        public String getTopManId() {
            return this.topManId;
        }

        public String getIsAdded() {
            return this.isAdded;
        }

        public String getIsCollect() {
            return this.isCollect;
        }

        public void setLoginUser(LoginUser loginUser) {
            this.loginUser = loginUser;
        }

        public void setPlatform(String platform) {
            this.platform = platform;
        }

        public void setTopManIds(Collection<String> topManIds) {
            this.topManIds = topManIds;
        }

        public void setTopManId(String topManId) {
            this.topManId = topManId;
        }

        public void setIsAdded(String isAdded) {
            this.isAdded = isAdded;
        }

        public void setIsCollect(String isCollect) {
            this.isCollect = isCollect;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AddedAndCollect)) {
                return false;
            }
            AddedAndCollect other = (AddedAndCollect)o;
            if (!other.canEqual(this)) {
                return false;
            }
            LoginUser this$loginUser = this.getLoginUser();
            LoginUser other$loginUser = other.getLoginUser();
            if (this$loginUser == null ? other$loginUser != null : !this$loginUser.equals(other$loginUser)) {
                return false;
            }
            String this$platform = this.getPlatform();
            String other$platform = other.getPlatform();
            if (this$platform == null ? other$platform != null : !this$platform.equals(other$platform)) {
                return false;
            }
            Collection<String> this$topManIds = this.getTopManIds();
            Collection<String> other$topManIds = other.getTopManIds();
            if (this$topManIds == null ? other$topManIds != null : !((Object)this$topManIds).equals(other$topManIds)) {
                return false;
            }
            String this$topManId = this.getTopManId();
            String other$topManId = other.getTopManId();
            if (this$topManId == null ? other$topManId != null : !this$topManId.equals(other$topManId)) {
                return false;
            }
            String this$isAdded = this.getIsAdded();
            String other$isAdded = other.getIsAdded();
            if (this$isAdded == null ? other$isAdded != null : !this$isAdded.equals(other$isAdded)) {
                return false;
            }
            String this$isCollect = this.getIsCollect();
            String other$isCollect = other.getIsCollect();
            return !(this$isCollect == null ? other$isCollect != null : !this$isCollect.equals(other$isCollect));
        }

        protected boolean canEqual(Object other) {
            return other instanceof AddedAndCollect;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            LoginUser $loginUser = this.getLoginUser();
            result = result * 59 + ($loginUser == null ? 43 : $loginUser.hashCode());
            String $platform = this.getPlatform();
            result = result * 59 + ($platform == null ? 43 : $platform.hashCode());
            Collection<String> $topManIds = this.getTopManIds();
            result = result * 59 + ($topManIds == null ? 43 : ((Object)$topManIds).hashCode());
            String $topManId = this.getTopManId();
            result = result * 59 + ($topManId == null ? 43 : $topManId.hashCode());
            String $isAdded = this.getIsAdded();
            result = result * 59 + ($isAdded == null ? 43 : $isAdded.hashCode());
            String $isCollect = this.getIsCollect();
            result = result * 59 + ($isCollect == null ? 43 : $isCollect.hashCode());
            return result;
        }

        public String toString() {
            return "KuaiShouTopManServiceImpl.AddedAndCollect(loginUser=" + this.getLoginUser() + ", platform=" + this.getPlatform() + ", topManIds=" + this.getTopManIds() + ", topManId=" + this.getTopManId() + ", isAdded=" + this.getIsAdded() + ", isCollect=" + this.getIsCollect() + ")";
        }
    }
}

