/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.topman.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.text.CharSequenceUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.RedisUtil;
import com.els.modules.attachment.storage.StorageFileInfo;
import com.els.modules.attachment.storage.service.FileStoreSignService;
import com.els.modules.common.utils.HttpRequestUtils;
import com.els.modules.topman.entity.McnAttachmentEntity;
import com.els.modules.topman.mapper.McnAttachmentMapper;
import com.els.modules.topman.service.McnAttachmentService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class McnAttachmentServiceImpl
extends BaseServiceImpl<McnAttachmentMapper, McnAttachmentEntity>
implements McnAttachmentService {
    private static final Logger log = LoggerFactory.getLogger(McnAttachmentServiceImpl.class);
    @Resource(name="fileStoreSignServiceImpl")
    private FileStoreSignService fileStoreSignServiceImpl;
    @Autowired
    private RedisUtil redisUtil;
    private static final String COLON = ":";
    @Resource
    private MongoTemplate mongoTemplate;
    private final String TB_DY_LOGIN_USER = "tb_dy_login_user";

    @Override
    public void upload(JSONObject jsonParam) {
        JSONArray upload = jsonParam.getJSONArray("upload");
        List jsonObjects = upload.toJavaList(JSONObject.class);
        log.info("\u4e0a\u4f20\u56fe\u7247list:" + jsonObjects.toString());
        if (CollectionUtils.isNotEmpty((Collection)jsonObjects)) {
            for (JSONObject jsonObject : jsonObjects) {
                this.uploadFile(jsonObject);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Async
    public void uploadFile(JSONObject jsonParam) {
        String topmanId = jsonParam.getString("topmanId");
        String path = jsonParam.getString("path");
        Assert.hasText((String)topmanId, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u8fbe\u4ebaid\u4e0d\u80fd\u4e3a\u7a7a"));
        String platform = jsonParam.getString("platform");
        StringBuilder sb = new StringBuilder(path).append(COLON).append("upload").append(COLON).append(topmanId);
        String id = (String)this.redisUtil.get(sb.toString());
        if (id == null) {
            String cookie = "";
            if (!"5".equals(platform)) {
                ArrayList<Criteria> criteriaList = new ArrayList<Criteria>();
                criteriaList.add(Criteria.where((String)"status").is((Object)"1"));
                criteriaList.add(Criteria.where((String)"web_server").is((Object)"1"));
                criteriaList.add(Criteria.where((String)"type").is((Object)"B\u7ad9\u82b1\u706b"));
                Query query = new Query((CriteriaDefinition)new Criteria().andOperator(criteriaList.toArray(new Criteria[0])));
                Map cookieMap = (Map)this.mongoTemplate.findOne(query, Map.class, "tb_dy_login_user");
                cookie = cookieMap.get("cookies").toString();
            }
            Assert.hasText((String)platform, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u5e73\u53f0\u4e0d\u80fd\u4e3a\u7a7a"));
            String url = jsonParam.getString("url");
            Assert.hasText((String)url, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"url\u4e0d\u80fd\u4e3a\u7a7a"));
            Assert.hasText((String)path, (String)I18nUtil.translate((String)"i18n_alert_ESWWxOLV_a67a232", (String)"\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a"));
            CloseableHttpClient client = null;
            HttpGet request = new HttpGet(url);
            try {
                client = HttpClients.createDefault();
                InputStream inputStream = HttpRequestUtils.httpGetImg(request, client, cookie, platform);
                byte[] bytes = McnAttachmentServiceImpl.inputStreamToByteArray(inputStream);
                StorageFileInfo fileInfo = new StorageFileInfo();
                LocalDateTime time = LocalDateTime.now();
                DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyyMMdd");
                String nowday = dtf.format(time);
                String documentName = topmanId + ".jpg";
                documentName = documentName.replaceAll("-", "_");
                String documentType = "";
                String documentLocation = File.separator + "mcn" + File.separator + platform + File.separator + path + File.separator + "pic" + File.separator + documentName;
                if (documentLocation.contains("\\")) {
                    documentLocation = documentLocation.replace("\\", "/");
                }
                String savePath = CharSequenceUtil.emptyToDefault(null, (String)documentLocation);
                savePath = savePath.replaceAll(" ", "_");
                fileInfo.setPath(savePath);
                fileInfo.setFilename(documentName);
                fileInfo.setOriginalFilename(documentName);
                fileInfo = this.fileStoreSignServiceImpl.storeFile((InputStream)new ByteArrayInputStream(bytes), fileInfo, (String)null);
                McnAttachmentEntity attachment = new McnAttachmentEntity();
                attachment.setTopmanId(topmanId);
                attachment.setId(topmanId);
                attachment.setPlatform(platform);
                attachment.setFileName(fileInfo.getOriginalFilename());
                attachment.setFileSize(bytes.length);
                attachment.setFilePath(fileInfo.getPath());
                attachment.setTopmanAvatar(this.fileStoreSignServiceImpl.getDownloadPath(attachment.getFilePath(), fileInfo.getSaveType()));
                boolean b = this.saveOrUpdate((Object)attachment);
                log.info("\u56fe\u7247\u4e0a\u4f20\u6210\u529fbbbbbbbbbbbbbbbbbbbb:" + b + "attachment");
                if (b) {
                    this.redisUtil.set(sb.toString(), (Object)topmanId, 72000000L);
                    log.info("\u8fbe\u4ebaid:" + topmanId + ":\u4e0a\u4f20\u6210\u529f:" + (Object)((Object)attachment));
                }
                inputStream.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (client != null) {
                    try {
                        client.close();
                        request.releaseConnection();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    @Override
    public boolean deleteBatch(String ids) {
        List mcnAttachmentEntities;
        List list = this.list();
        List bStationId = list.stream().map(McnAttachmentEntity::getTopmanId).distinct().collect(Collectors.toList());
        List<String> idList = Arrays.asList(ids.split(","));
        ArrayList<String> filePaths = new ArrayList<String>();
        if (CollectionUtil.isNotEmpty(idList) && CollectionUtil.isNotEmpty((Collection)(mcnAttachmentEntities = this.listByIds(bStationId)))) {
            for (McnAttachmentEntity purchaseAttachment : mcnAttachmentEntities) {
                filePaths.add(purchaseAttachment.getFilePath());
            }
        }
        boolean b = this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
        this.removeByIds(idList);
        return b;
    }

    @Override
    public boolean delete(String path) {
        ArrayList<String> filePaths = new ArrayList<String>();
        filePaths.add(path);
        boolean b = this.fileStoreSignServiceImpl.deleteFileBatch(filePaths, (String)null);
        log.info("aaaaaaaaaaaaaaaaaaaaaaaaaaaa:" + b);
        return b;
    }

    @Override
    public void cleanCache() {
        StringBuilder sb = new StringBuilder("bilibili").append(COLON).append("upload");
        this.redisUtil.dels(sb.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] inputStreamToByteArray(InputStream inputStream) {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            int num;
            byte[] buffer = new byte[1024];
            while ((num = inputStream.read(buffer)) != -1) {
                byteArrayOutputStream.write(buffer, 0, num);
            }
            byteArrayOutputStream.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new byte[0];
        }
    }

    public static void main(String[] args) {
    }
}

