/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.touch.controller;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.annotation.McnLog;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.config.mybatis.TenantContext;
import com.els.modules.touch.dto.PdAppRq;
import com.els.modules.touch.entity.PdCustomerHead;
import com.els.modules.touch.entity.PdCustomerItem;
import com.els.modules.touch.enumerate.ClueStageEnum;
import com.els.modules.touch.service.PdCustomerHeadService;
import com.els.modules.touch.service.PdCustomerItemService;
import com.els.modules.touch.util.EncryptAesUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u79c1\u57df\u83b7\u5ba2\u5934\u8868"})
@RestController
@RequestMapping(value={"/pdCustomerHead"})
public class PdCustomerHeadController
extends BaseController<PdCustomerHead, PdCustomerHeadService> {
    @Autowired
    private PdCustomerHeadService pdCustomerHeadService;
    @Autowired
    private PdCustomerItemService pdCustomerItemService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list/{platform}/{type}"})
    public Result<?> queryPageList(PdCustomerHead pdCustomerHead, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, @PathVariable(value="platform") String platform, @PathVariable(value="type") String type, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)pdCustomerHead), (Map)req.getParameterMap());
        if (ObjectUtil.notEqual((Object)type, (Object)ClueStageEnum.ALL.getCode())) {
            queryWrapper.eq((Object)"clue_stage", (Object)type);
        }
        queryWrapper.eq((Object)"platform", (Object)platform);
        queryWrapper.eq((Object)"els_account", (Object)TenantContext.getTenant());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.pdCustomerHeadService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @AutoLog(value="\u79c1\u57df\u83b7\u5ba2\u5934\u8868-\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody PdCustomerHead pdCustomerHead) {
        this.pdCustomerHeadService.add(pdCustomerHead);
        return Result.ok((Object)((Object)pdCustomerHead));
    }

    @AutoLog(value="\u79c1\u57df\u83b7\u5ba2\u5934\u8868-\u7f16\u8f91")
    @ApiOperation(value="\u7f16\u8f91", notes="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody PdCustomerHead pdCustomerHead) {
        this.pdCustomerHeadService.edit(pdCustomerHead);
        return this.commonSuccessResult(3);
    }

    @GetMapping(value={"/updateClueStage"})
    public Result<?> updateClueStage(@RequestParam(name="id") String id) {
        PdCustomerHead head = (PdCustomerHead)((Object)this.pdCustomerHeadService.getById((Serializable)((Object)id)));
        head.setClueStage(ClueStageEnum.WE_CHAT_ADDED.getCode());
        this.pdCustomerHeadService.updateById((Object)head);
        return this.commonSuccessResult(3);
    }

    @AutoLog(value="\u79c1\u57df\u83b7\u5ba2\u5934\u8868-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664", notes="\u901a\u8fc7id\u5220\u9664")
    @GetMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id") String id) {
        this.pdCustomerHeadService.delete(id);
        return this.commonSuccessResult(4);
    }

    @AutoLog(value="\u79c1\u57df\u83b7\u5ba2\u5934\u8868-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u6279\u91cf\u5220\u9664", notes="\u6279\u91cf\u5220\u9664")
    @GetMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids") String ids) {
        List<String> idList = Arrays.asList(ids.split(","));
        this.pdCustomerHeadService.deleteBatch(idList);
        return this.commonSuccessResult(4);
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2", notes="\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        PdCustomerHead pdCustomerHead = (PdCustomerHead)((Object)this.pdCustomerHeadService.getById((Serializable)((Object)id)));
        PdAppRq.Customer rp = new PdAppRq.Customer();
        BeanUtil.copyProperties((Object)((Object)pdCustomerHead), (Object)((Object)rp), (String[])new String[0]);
        List<PdCustomerItem> items = this.pdCustomerItemService.getByHeadId(rp.getId());
        rp.setBehaviors(items);
        return Result.ok((Object)((Object)rp));
    }

    @PostMapping(value={"/app/receive"})
    @McnLog(apiName="\u79c1\u57df\u83b7\u5ba2-\u63a5\u6536\u5ba2\u6237\u5b9e\u4f8b")
    public Result<?> receive(@RequestBody PdAppRq.Receive rq, @RequestHeader(value="authCode") String authCode) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthCode()), (String)"\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthType()), (String)"\u6388\u6743\u9879\u4e0d\u80fd\u4e3a\u7a7a");
        EncryptAesUtil.checkAuthCode(authCode, rq.getAuthCode());
        return Result.ok(this.pdCustomerHeadService.receive(rq));
    }

    @PostMapping(value={"/app/msgStatus"})
    @McnLog(apiName="\u79c1\u57df\u83b7\u5ba2-\u63a5\u6536\u6d88\u606f\u72b6\u6001\u56de\u4f20")
    public Result<?> msgStatus(@RequestBody PdAppRq.MsgStatus rq, @RequestHeader(value="authCode") String authCode) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthCode()), (String)"\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getId()), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getMsgId()), (String)"msgId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getOptTime()), (String)"optTime\u4e0d\u80fd\u4e3a\u7a7a");
        EncryptAesUtil.checkAuthCode(authCode, rq.getAuthCode());
        this.pdCustomerHeadService.msgStatus(rq);
        return Result.ok();
    }

    @PostMapping(value={"/app/reply"})
    @McnLog(apiName="\u79c1\u57df\u83b7\u5ba2-\u63a5\u6536\u6d88\u606f\u72b6\u6001\u56de\u4f20")
    public Result<?> reply(@RequestBody PdAppRq.MsgReply rq, @RequestHeader(value="authCode") String authCode) {
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq), (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getAuthCode()), (String)"\u6388\u6743\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getCustomerId()), (String)"customerId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getOptTime()), (String)"optTime\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getMsgContent()), (String)"msgContent\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)ObjectUtil.isNotEmpty((Object)rq.getPlatform()), (String)"platform\u4e0d\u80fd\u4e3a\u7a7a");
        EncryptAesUtil.checkAuthCode(authCode, rq.getAuthCode());
        this.pdCustomerHeadService.reply(rq);
        return Result.ok();
    }
}

