/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.zyoa.single.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.util.InterfaceUtil;
import com.els.modules.third.zyoa.api.dto.TaskDto;
import com.els.modules.third.zyoa.api.service.TodoPushService;
import com.els.modules.third.zyoa.single.utils.OaUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class TodoPushServiceimpl
implements TodoPushService {
    @Resource
    private OaUtils oaUtils;
    @Resource
    private Environment env;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Value(value="${sapinterface.elsaccout}")
    private String elsaccount;
    @Value(value="${oa.registerCode}")
    private String registerCode;

    public void pushMessage(List<TaskDto> taskDtoList) {
        JSONObject result;
        String interfaceCode = this.env.getProperty("oa.onepushinterfacecode");
        JSONObject params = new JSONObject();
        JSONArray objects = new JSONArray();
        JSONObject url = this.oaUtils.getToken();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String stringDate = dateFormat.format(new Date());
        for (TaskDto taskDto : taskDtoList) {
            JSONObject param = new JSONObject();
            param.put("registerCode", (Object)this.registerCode);
            param.put("taskId", (Object)taskDto.getTaskId());
            param.put("title", (Object)taskDto.getTitle());
            param.put("senderName", (Object)taskDto.getSenderName());
            param.put("classify", (Object)taskDto.getClassify());
            param.put("contentType", (Object)taskDto.getContentType());
            param.put("state", (Object)taskDto.getState());
            param.put("thirdSenderId", (Object)taskDto.getThirdSenderId());
            param.put("thirdReceiverId", (Object)taskDto.getThirdReceiverId());
            param.put("creationDate", (Object)stringDate);
            param.put("content", (Object)taskDto.getContent());
            param.put("h5url", (Object)taskDto.getH5url());
            param.put("url", (Object)taskDto.getUrl());
            param.put("noneBindingSender", (Object)taskDto.getNoneBindingSender());
            param.put("noneBindingReceiver", (Object)taskDto.getNoneBindingReceiver());
            objects.add((Object)param);
        }
        if (taskDtoList.size() > 1) {
            interfaceCode = this.env.getProperty("oa.morepushinterfacecode");
            params.put("pendingList", (Object)objects);
        } else {
            params = objects.getJSONObject(0);
        }
        JSONObject jsonObject = this.interfaceUtil.callInterface(this.elsaccount, null, interfaceCode, null, url, params, null);
        if (jsonObject == null || !"200".equals(jsonObject.get((Object)"code")) || (result = jsonObject.getJSONObject("result")) != null) {
            // empty if block
        }
    }

    public void updateStatus(List<TaskDto> taskDtoList) {
        String interfaceCode = this.env.getProperty("oa.updatestatusinterfacecode");
        for (TaskDto taskDto : taskDtoList) {
            JSONObject param = new JSONObject();
            param.put("registerCode", (Object)this.registerCode);
            param.put("taskId", (Object)taskDto.getTaskId());
            param.put("state", (Object)taskDto.getState());
            param.put("subState", (Object)taskDto.getTaskId());
        }
    }
}

