/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.third.zyoa.single.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.els.common.exception.ELSBootException;
import com.els.common.util.InterfaceUtil;
import com.els.common.util.SpringContextUtils;
import com.els.modules.third.zyoa.api.dto.TaskDto;
import com.els.modules.third.zyoa.api.service.TodoPushService;
import com.els.modules.third.zyoa.single.dto.ElsInterfaceLog;
import com.els.modules.third.zyoa.single.service.ElsInterfaceLogService;
import com.els.modules.third.zyoa.single.utils.OaUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class TodoPushServiceimpl
implements TodoPushService {
    @Resource
    private OaUtils oaUtils;
    @Resource
    private Environment env;
    @Resource
    private InterfaceUtil interfaceUtil;
    @Value(value="${sapinterface.elsaccout}")
    private String elsaccount;
    @Value(value="${oa.registerCode}")
    private String registerCode;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushMessage(List<TaskDto> taskDtoList) {
        String interfaceCode = this.env.getProperty("oa.onepushinterfacecode");
        JSONObject params = new JSONObject();
        JSONArray objects = new JSONArray();
        JSONObject url = this.oaUtils.getToken();
        if (url == null) {
            throw new ELSBootException("token\u83b7\u53d6\u5931\u8d25");
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String stringDate = dateFormat.format(new Date());
        for (TaskDto taskDto : taskDtoList) {
            JSONObject param = new JSONObject();
            param.put("registerCode", (Object)this.registerCode);
            param.put("taskId", (Object)taskDto.getTaskId());
            param.put("title", (Object)taskDto.getTitle());
            param.put("senderName", (Object)taskDto.getSenderName());
            param.put("classify", (Object)taskDto.getClassify());
            param.put("contentType", (Object)taskDto.getContentType());
            param.put("state", (Object)taskDto.getState());
            param.put("thirdSenderId", (Object)taskDto.getThirdSenderId());
            param.put("thirdReceiverId", (Object)taskDto.getThirdReceiverId());
            param.put("creationDate", (Object)stringDate);
            param.put("content", (Object)taskDto.getContent());
            param.put("h5url", (Object)taskDto.getH5url());
            param.put("url", (Object)taskDto.getUrl());
            param.put("noneBindingSender", (Object)taskDto.getNoneBindingSender());
            param.put("noneBindingReceiver", (Object)taskDto.getNoneBindingReceiver());
            objects.add((Object)param);
        }
        if (taskDtoList.size() > 1) {
            interfaceCode = this.env.getProperty("oa.morepushinterfacecode");
            params.put("pendingList", (Object)objects);
        } else {
            params = objects.getJSONObject(0);
        }
        JSONObject jsonObject = this.interfaceUtil.callInterface(this.elsaccount, null, interfaceCode, null, url, params, null);
        if (jsonObject == null) return;
        if (!"200".equals(jsonObject.getString("code"))) throw new ELSBootException("\u63a8\u9001\u5f85\u529e\u5f02\u5e38");
        JSONObject result = jsonObject.getJSONObject("result");
        if (result == null) return;
    }

    public void saveInterfaceLog(JSONArray params, JSONObject returnObject, String busModule) {
        ArrayList<ElsInterfaceLog> elsInterfaceLogs = new ArrayList<ElsInterfaceLog>();
        for (int i = 0; i < params.size(); ++i) {
            JSONObject jsonObject = (JSONObject)params.get(i);
            ElsInterfaceLog elsInterfaceLog = new ElsInterfaceLog();
            elsInterfaceLog.setRequestParam(params == null ? "" : params.toJSONString());
            elsInterfaceLog.setRequestParam(returnObject == null ? "" : returnObject.toJSONString());
            elsInterfaceLog.setCreateTime(new Date());
            elsInterfaceLog.setCreateBy("1001");
            elsInterfaceLog.setLogContent(jsonObject.getString("logContent"));
            elsInterfaceLog.setBusinessId(jsonObject.getString("bussinessid"));
            elsInterfaceLog.setBusModule(busModule);
            elsInterfaceLogs.add(elsInterfaceLog);
        }
        ElsInterfaceLogService elsInterfaceLogService = (ElsInterfaceLogService)SpringContextUtils.getBean(ElsInterfaceLogService.class);
        elsInterfaceLogService.saveBatch(elsInterfaceLogs, 200);
    }

    public void updateStatus(List<TaskDto> taskDtoList) {
        String interfaceCode = this.env.getProperty("oa.updatestatusinterfacecode");
        JSONObject url = this.oaUtils.getToken();
        if (url == null) {
            throw new ELSBootException("token\u83b7\u53d6\u5931\u8d25");
        }
        for (TaskDto taskDto : taskDtoList) {
            JSONObject param = new JSONObject();
            param.put("registerCode", (Object)this.registerCode);
            param.put("taskId", (Object)taskDto.getTaskId());
            param.put("state", (Object)taskDto.getState());
            param.put("subState", (Object)taskDto.getSubState());
            JSONObject jsonObject = this.interfaceUtil.callInterface(this.elsaccount, null, interfaceCode, null, url, param, null);
            if (jsonObject == null) continue;
            if ("200".equals(jsonObject.getString("code"))) {
                JSONObject result = jsonObject.getJSONObject("result");
                if (result == null) continue;
            }
            throw new ELSBootException("\u63a8\u9001\u5f85\u529e\u5f02\u5e38");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void pushUser(List<TaskDto> taskDtoList) {
        JSONObject url = this.oaUtils.getToken();
        String interfaceCode = this.env.getProperty("oa.pushuser");
        JSONArray objects = new JSONArray();
        ElsInterfaceLogService elsInterfaceLogService = (ElsInterfaceLogService)SpringContextUtils.getBean(ElsInterfaceLogService.class);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHH:mm:ss");
        String bussinessid = dateFormat.format(new Date()) + "pushUser" + System.currentTimeMillis();
        QueryWrapper elsInterfaceLogQueryWrapper = new QueryWrapper();
        HashMap objectObjectHashMap = new HashMap();
        for (TaskDto taskDto : taskDtoList) {
            if (objectObjectHashMap.containsKey(taskDto.getThirdUserId() + "_" + taskDto.getThirdLoginName())) continue;
            objectObjectHashMap.put(taskDto.getThirdUserId() + "_" + taskDto.getThirdLoginName(), null);
            elsInterfaceLogQueryWrapper.clear();
            elsInterfaceLogQueryWrapper.lambda().eq(ElsInterfaceLog::getLogContent, (Object)(taskDto.getThirdUserId() + "_" + taskDto.getThirdLoginName()));
            ElsInterfaceLog one = (ElsInterfaceLog)elsInterfaceLogService.getOne((Wrapper)elsInterfaceLogQueryWrapper);
            if (one != null) continue;
            JSONObject param = new JSONObject();
            param.put("registerCode", (Object)this.registerCode);
            param.put("thirdUserId", (Object)taskDto.getThirdUserId());
            param.put("thirdLoginName", (Object)taskDto.getThirdLoginName());
            param.put("thirdName", (Object)taskDto.getThirdName());
            param.put("thirdCode", (Object)taskDto.getThirdCode());
            param.put("thirdMobile", (Object)taskDto.getThirdMobile());
            param.put("thirdEmail", (Object)taskDto.getThirdEmail());
            param.put("param0", (Object)taskDto.getParam0());
            param.put("param1", (Object)taskDto.getParam1());
            param.put("logContent", (Object)(taskDto.getThirdUserId() + "_" + taskDto.getThirdLoginName()));
            param.put("bussinessid", (Object)bussinessid);
            param.put("noneBindingSender", (Object)taskDto.getNoneBindingSender());
            param.put("noneBindingReceiver", (Object)taskDto.getNoneBindingReceiver());
            objects.add((Object)param);
        }
        JSONObject params = new JSONObject();
        params.put("userlist", (Object)objects);
        JSONObject jsonObject = this.interfaceUtil.callInterface(this.elsaccount, null, interfaceCode, null, url, params, null);
        this.saveInterfaceLog(objects, jsonObject, "pushUser");
        if (jsonObject == null) return;
        if (!"200".equals(jsonObject.getString("code"))) throw new ELSBootException("\u63a8\u9001\u7528\u6237\u5f02\u5e38");
        JSONObject result = jsonObject.getJSONObject("result");
        if (result == null) return;
    }
}

