/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.enumerate.ApiLimitErrorEnum;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.AssertI18nUtil;
import com.els.common.util.RedisUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.amateur.api.service.ApiCallCountRpcService;
import com.els.modules.apirecord.entity.ApiCallRecord;
import com.els.modules.apirecord.enumerate.ApiTypeEnum;
import com.els.modules.apirecord.service.ApiCallRecordService;
import com.els.modules.system.entity.TenantParamConfig;
import com.els.modules.system.service.TenantParamConfigService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiCallRecordRpcServiceImpl
implements ApiCallCountRpcService {
    @Autowired
    private ApiCallRecordService apiCallRecordService;
    @Autowired
    private TenantParamConfigService tenantParamConfigService;
    @Autowired
    private RedisUtil redisUtil;

    public void saveApiCallRecord(String apiCode, String id) {
        ApiCallRecord record = new ApiCallRecord();
        String elsAccount = TenantContext.getTenant();
        record.setElsAccount(elsAccount);
        record.setApiCode(apiCode);
        record.setRelatedId(id);
        record.setCreateTime(new Date());
        LoginUser loginUser = SysUtil.getLoginUser();
        record.setCreateBy(loginUser.getSubAccount());
        ApiTypeEnum apiTypeEnum = ApiTypeEnum.getApiTypeEnumByCode((String)apiCode);
        if (apiTypeEnum == null) {
            return;
        }
        record.setApiName(apiTypeEnum.getDesc());
        record.setApiCode(apiTypeEnum.getCode());
        record.setApiType(apiTypeEnum.getType());
        this.apiCallRecordService.save((Object)record);
        String configCode = apiTypeEnum.getConfigCode();
        if (StrUtil.isBlank((CharSequence)apiTypeEnum.getConfigCode())) {
            return;
        }
        String num = this.tenantParamConfigService.getOneConfig(elsAccount, configCode);
        if (!"Y".equals(num)) {
            this.saveCount(record, elsAccount, configCode);
        }
    }

    public void checkApiLimit(String apiCode) {
        ApiTypeEnum apiTypeEnum;
        String configCode;
        String elsAccount = TenantContext.getTenant();
        String num = this.tenantParamConfigService.getOneConfig(elsAccount, configCode = (apiTypeEnum = ApiTypeEnum.getApiTypeEnumByCode((String)apiCode)).getConfigCode());
        if (!"Y".equals(num)) {
            Long limitNum = Long.valueOf(num);
            Long countNum = null;
            String redisKey = "api:count:str:" + elsAccount + ":" + apiCode;
            if (!this.redisUtil.hasKey(redisKey)) {
                TenantParamConfig config = this.tenantParamConfigService.getOneConfigDb(elsAccount, configCode);
                countNum = (long)config.getSequenceNumber();
                this.redisUtil.set(redisKey, (Object)countNum.toString(), 86400L);
            } else {
                String numStr = (String)this.redisUtil.get(redisKey);
                countNum = Long.valueOf(numStr);
            }
            AssertI18nUtil.isTrue((countNum > limitNum ? 1 : 0) != 0, (Enum)ApiLimitErrorEnum.NUM_LIMIT_MESSAGE);
        }
    }

    private void saveCount(ApiCallRecord record, String elsAccount, String configCode) {
        String key = "api:count:" + elsAccount + ":" + record.getApiCode();
        String keyStr = "api:count:str:" + elsAccount + ":" + record.getApiCode();
        Long count = this.redisUtil.incr(key, 1L);
        this.redisUtil.set(keyStr, (Object)count.toString(), 86400L);
        this.tenantParamConfigService.incr(count, elsAccount, configCode);
    }
}

