/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.api.service.impl;

import cn.hutool.core.util.StrUtil;
import com.els.common.enumerate.ApiLimitErrorEnum;
import com.els.common.util.RedisUtil;
import com.els.common.utils.ApiAssertI18nUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.amateur.api.service.ApiCallCountRpcService;
import com.els.modules.apirecord.entity.ApiCallRecord;
import com.els.modules.apirecord.enumerate.ApiTypeEnum;
import com.els.modules.apirecord.service.ApiCallRecordService;
import com.els.modules.system.entity.TenantParamConfig;
import com.els.modules.system.service.McnTenantParamConfigService;
import java.util.Date;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiCallRecordRpcServiceImpl
implements ApiCallCountRpcService {
    @Autowired
    private ApiCallRecordService apiCallRecordService;
    @Autowired
    private McnTenantParamConfigService tenantParamConfigService;
    @Autowired
    private RedisUtil redisUtil;

    public void removeRedisCache(String apiCode, String elsAccount) {
        String key = "api:count:" + elsAccount + ":" + apiCode;
        String keyStr = "api:count:str:" + elsAccount + ":" + apiCode;
        this.redisUtil.del(new String[]{key, keyStr});
    }

    public void saveApiCallRecord(String apiCode, String id, String elsAccount, String subAccount) {
        ApiCallRecord record = new ApiCallRecord();
        ApiTypeEnum apiTypeEnum = ApiTypeEnum.getApiTypeEnumByCode((String)apiCode);
        if (apiTypeEnum == null) {
            return;
        }
        String configCode = apiTypeEnum.getConfigCode();
        if (StrUtil.isBlank((CharSequence)configCode)) {
            return;
        }
        String num = this.tenantParamConfigService.getOneConfig(elsAccount, configCode);
        if ("Y".equals(num)) {
            return;
        }
        record.setElsAccount(elsAccount);
        record.setApiCode(apiCode);
        record.setRelatedId(id);
        record.setCreateTime(new Date());
        record.setCreateBy(subAccount);
        record.setApiName(apiTypeEnum.getDesc());
        record.setApiCode(apiTypeEnum.getCode());
        record.setApiType(apiTypeEnum.getType());
        this.apiCallRecordService.save((Object)record);
        if (StrUtil.isBlank((CharSequence)apiTypeEnum.getConfigCode())) {
            return;
        }
        this.saveCount(record, elsAccount, configCode);
    }

    public void checkApiLimit(String apiCode) {
        String elsAccount = TenantContext.getTenant();
        ApiTypeEnum apiTypeEnum = ApiTypeEnum.getApiTypeEnumByCode((String)apiCode);
        if (apiTypeEnum == null) {
            return;
        }
        String configCode = apiTypeEnum.getConfigCode();
        String num = this.tenantParamConfigService.getOneConfig(elsAccount, configCode);
        if (!"Y".equals(num)) {
            Long limitNum = Long.valueOf(num);
            Long countNum = null;
            String redisKey = "api:count:str:" + elsAccount + ":" + apiCode;
            if (!this.redisUtil.hasKey(redisKey)) {
                TenantParamConfig config = this.tenantParamConfigService.getOneConfigDb(elsAccount, configCode);
                if (config == null || config.getCountNum() == null || config.getCountNum().equals(0)) {
                    return;
                }
                countNum = (long)config.getCountNum();
                this.redisUtil.set(redisKey, (Object)countNum.toString(), 86400L);
            } else {
                String numStr = (String)this.redisUtil.get(redisKey);
                countNum = Long.valueOf(numStr);
            }
            ApiAssertI18nUtil.isTrue((countNum >= limitNum ? 1 : 0) != 0, (Enum)ApiLimitErrorEnum.NUM_LIMIT_MESSAGE, (String)(ApiTypeEnum.isListLimit((ApiTypeEnum)apiTypeEnum) ? "100002" : "100001"));
        }
    }

    private void saveCount(ApiCallRecord record, String elsAccount, String configCode) {
        String key = "api:count:" + elsAccount + ":" + record.getApiCode();
        String keyStr = "api:count:str:" + elsAccount + ":" + record.getApiCode();
        Long count = this.redisUtil.incr(key, 1L);
        this.redisUtil.set(keyStr, (Object)count.toString(), 86400L);
        this.tenantParamConfigService.incr(count, elsAccount, configCode);
    }
}

