/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.companystore.controller;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.els.common.api.vo.Result;
import com.els.common.aspect.annotation.AutoLog;
import com.els.common.aspect.annotation.PermissionDataView;
import com.els.common.system.base.controller.BaseController;
import com.els.common.system.query.QueryGenerator;
import com.els.common.vo.CountVO;
import com.els.config.mybatis.TenantContext;
import com.els.modules.account.api.service.PermissionDataRpcService;
import com.els.modules.companystore.dto.CompanyGoodsHeadQueryDTO;
import com.els.modules.companystore.dto.CompanyGoodsItemQueryDTO;
import com.els.modules.companystore.dto.CompanyGoodsLiveRecordVO;
import com.els.modules.companystore.dto.CompanyGoodsTopmanItemQueryDTO;
import com.els.modules.companystore.dto.CompanyStoreHeadQueryDTO;
import com.els.modules.companystore.dto.CompanyTopmanItemQueryDTO;
import com.els.modules.companystore.entity.CompanyGoodsHead;
import com.els.modules.companystore.entity.CompanyGoodsItem;
import com.els.modules.companystore.entity.CompanyGoodsLiveItem;
import com.els.modules.companystore.entity.CompanyGoodsLiveRecord;
import com.els.modules.companystore.entity.CompanyGoodsVideoItem;
import com.els.modules.companystore.entity.CompanyGoodsVideoRecord;
import com.els.modules.companystore.entity.CompanyStoreOrderItem;
import com.els.modules.companystore.excel.CompanyGoodsHeadExportServiceImpl;
import com.els.modules.companystore.excel.CompanyGoodsHeadStatisticsExportServiceImpl;
import com.els.modules.companystore.excel.CompanyGoodsTopmanItemExportServiceImpl;
import com.els.modules.companystore.excel.KsCompanyGoodsHeadExportServiceImpl;
import com.els.modules.companystore.excel.MonitorCompanyGoodsHeadExportServiceImpl;
import com.els.modules.companystore.job.ProductManageJob;
import com.els.modules.companystore.query.CompanyGoodsHeadQueryParam;
import com.els.modules.companystore.query.CompanyTopmanRecordQueryParam;
import com.els.modules.companystore.service.CompanyGoodsHeadService;
import com.els.modules.companystore.service.CompanyGoodsLiveItemService;
import com.els.modules.companystore.service.CompanyGoodsLiveRecordService;
import com.els.modules.companystore.service.CompanyGoodsTopmanRecordService;
import com.els.modules.companystore.service.CompanyGoodsVideoItemService;
import com.els.modules.companystore.service.CompanyGoodsVideoRecordService;
import com.els.modules.companystore.service.DyProductCategoryService;
import com.els.modules.companystore.service.DyShopProductService;
import com.els.modules.companystore.service.KsItemsCategoryService;
import com.els.modules.companystore.service.KsItemsService;
import com.els.modules.companystore.vo.ChartsVO;
import com.els.modules.companystore.vo.CompanyGoodsHeadStatisticsVO;
import com.els.modules.companystore.vo.CompanyGoodsHeadVO;
import com.els.modules.companystore.vo.CompanyGoodsVideoRecordVO;
import com.els.modules.companystore.vo.CompanyTopmanItemVO;
import com.els.modules.companystore.vo.KsShopItemsVO;
import com.els.modules.companystore.vo.TopMansVO;
import com.google.common.collect.Maps;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/companystore/companyGoodsHead"})
@Api(tags={"\u4f01\u4e1a\u5546\u54c1\u4fe1\u606f\u5934"})
public class CompanyGoodsHeadController
extends BaseController<CompanyGoodsHead, CompanyGoodsHeadService> {
    private static final Logger log = LoggerFactory.getLogger(CompanyGoodsHeadController.class);
    @Autowired
    private CompanyGoodsHeadService companyGoodsHeadService;
    @Autowired
    private CompanyGoodsTopmanRecordService companyGoodsTopmanRecordService;
    @Autowired
    private CompanyGoodsVideoItemService companyGoodsVideoItemService;
    @Autowired
    private CompanyGoodsVideoRecordService companyGoodsVideoRecordService;
    @Autowired
    private CompanyGoodsLiveItemService companyGoodsLiveItemService;
    @Autowired
    private CompanyGoodsLiveRecordService companyGoodsLiveRecordService;
    @Autowired
    private ProductManageJob productManageJob;
    @Autowired
    private KsItemsService ksItemsService;
    @Autowired
    private KsItemsCategoryService itemsCategoryService;
    @Autowired
    private DyProductCategoryService dyProductCategoryService;
    @Autowired
    private PermissionDataRpcService permissionDataRpcService;
    @Autowired
    private DyShopProductService dyShopProductService;

    @ApiOperation(value="\u5546\u54c1\u5217\u8868", notes="\u5546\u54c1\u5217\u8868")
    @GetMapping(value={"/list"})
    @PermissionDataView(businessType="companyStore")
    public Result<?> queryPageList(CompanyGoodsHead companyGoodsHead, CompanyGoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CompanyGoodsHead> queryWrapper = CompanyGoodsHeadQueryParam.getQueryParam(companyGoodsHead, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        this.companyGoodsHeadService.categoryListConvert(queryDTO);
        queryDTO.setElsAccount(TenantContext.getTenant());
        queryDTO.setCompany(this.permissionDataRpcService.getCompany("companyStore"));
        IPage<CompanyGoodsHead> pageList = this.companyGoodsHeadService.queryPage((Page<CompanyGoodsHead>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5546\u54c1\u5217\u8868", notes="\u5546\u54c1\u5217\u8868")
    @GetMapping(value={"/ksList"})
    @PermissionDataView(businessType="companyStore")
    public Result<?> ksList(CompanyGoodsHead companyGoodsHead, CompanyGoodsHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        companyGoodsHead.setElsAccount(TenantContext.getTenant());
        QueryWrapper queryWrapper = new QueryWrapper();
        Map parameterMap = req.getParameterMap();
        if (ObjectUtil.isNotEmpty(parameterMap.get("keyWord"))) {
            String keyWord = ((String[])parameterMap.get("keyWord"))[0];
            queryWrapper.and(qr -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)qr.eq((Object)"kwai_item_id", (Object)keyWord)).or(qr2 -> {
                    QueryWrapper cfr_ignored_0 = (QueryWrapper)qr2.like((Object)"title", (Object)keyWord);
                });
            });
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsItemsCategory())) {
            queryWrapper.in((Object)"category_id", (Object[])queryDTO.getKsItemsCategory().split(","));
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsItemsShop())) {
            queryWrapper.eq((Object)"shop_id", (Object)queryDTO.getKsItemsShop());
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsItemsStatus())) {
            queryWrapper.eq((Object)"shelf_status", (Object)queryDTO.getKsItemsStatus());
        }
        if (StrUtil.isNotBlank((CharSequence)queryDTO.getKsTopManNum())) {
            String[] var = queryDTO.getKsTopManNum().split("-");
            queryWrapper.ge((Object)"relationTopManNum", (Object)var[0]);
            queryWrapper.le((Object)"relationTopManNum", (Object)var[1]);
        }
        IPage<KsShopItemsVO> pageList = this.ksItemsService.ksList((Page<KsShopItemsVO>)page, companyGoodsHead, queryWrapper);
        return Result.ok(pageList);
    }

    @AutoLog(busModule="\u4f01\u4e1a\u5546\u54c1\u4fe1\u606f\u5934", value="\u6dfb\u52a0")
    @ApiOperation(value="\u6dfb\u52a0", notes="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody CompanyGoodsHeadVO headVO) {
        CompanyGoodsHead companyGoodsHead = new CompanyGoodsHead();
        BeanUtils.copyProperties((Object)((Object)headVO), (Object)((Object)companyGoodsHead));
        companyGoodsHead.setBusAccount(this.getTenantId());
        this.companyGoodsHeadService.saveMain(companyGoodsHead, headVO);
        return Result.ok((Object)((Object)companyGoodsHead));
    }

    @GetMapping(value={"/getKsSalesCharts"})
    public Result<?> getKsSalesCharts(@RequestParam(value="id") String id) {
        List<ChartsVO> ksChartsVOS = this.companyGoodsHeadService.getKsSalesCharts(id);
        return Result.ok(ksChartsVOS);
    }

    @GetMapping(value={"/getDySalesCharts"})
    public Result<?> getDySalesCharts(@RequestParam(value="productId") String productId) {
        List<ChartsVO> chartsVO = this.companyGoodsHeadService.getDySalesCharts(productId);
        return Result.ok(chartsVO);
    }

    @ApiOperation(value="\u5546\u54c1\u8be6\u60c5", notes="\u5546\u54c1\u8be6\u60c5")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id") String id) {
        CompanyGoodsHeadVO headVO = this.companyGoodsHeadService.queryById(id);
        return Result.ok((Object)((Object)headVO));
    }

    @ApiOperation(value="\u57fa\u7840\u5206\u6790\u7edf\u8ba1", notes="\u57fa\u7840\u5206\u6790\u7edf\u8ba1")
    @GetMapping(value={"/goodsStat"})
    public Result<?> goodsStat(CompanyGoodsTopmanItemQueryDTO queryDTO) {
        CompanyGoodsHeadStatisticsVO vo = this.companyGoodsHeadService.goodsStatNew(queryDTO);
        return Result.ok((Object)vo);
    }

    @ApiOperation(value="\u57fa\u7840\u5206\u6790\u5217\u8868", notes="\u57fa\u7840\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/goodsList"})
    public Result<?> goodsList(CompanyGoodsItem item, CompanyGoodsTopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)item), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<CompanyGoodsHeadStatisticsVO> pageList = this.companyGoodsHeadService.queryCompanyGoodsItemPage((Page<CompanyGoodsItem>)page, (QueryWrapper<CompanyGoodsItem>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/topmanList"})
    public Result<?> topmanList(CompanyStoreOrderItem item, CompanyTopmanItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper<CompanyStoreOrderItem> queryWrapper = CompanyTopmanRecordQueryParam.getQueryParam(item, req.getParameterMap(), queryDTO);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<CompanyTopmanItemVO> pageList = this.companyGoodsTopmanRecordService.queryTopmanPage((Page<CompanyStoreOrderItem>)page, queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u7c7b\u9875\u7b7e\u6570\u91cf", notes="\u8fbe\u4eba\u5206\u7c7b\u9875\u7b7e\u6570\u91cf")
    @GetMapping(value={"/contentTypeCounts"})
    public Result<?> contentTypeCounts(CompanyTopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.companyGoodsTopmanRecordService.contentTypeCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u8fbe\u4eba\u53e3\u7891\u9875\u7b7e\u6570\u91cf", notes="\u8fbe\u4eba\u53e3\u7891\u9875\u7b7e\u6570\u91cf")
    @GetMapping(value={"/goodsWomCounts"})
    public Result<?> goodsWomCounts(CompanyTopmanItemQueryDTO queryDTO, HttpServletRequest req) {
        List<CountVO> result = this.companyGoodsTopmanRecordService.goodsWomCounts(queryDTO, req);
        return Result.ok(result);
    }

    @ApiOperation(value="\u89c6\u9891\u5206\u6790\u7edf\u8ba1", notes="\u89c6\u9891\u5206\u6790\u7edf\u8ba1")
    @GetMapping(value={"/videoStat"})
    public Result<?> videoStat(CompanyGoodsItemQueryDTO queryDTO) {
        List<CompanyGoodsVideoItem> itemList = this.companyGoodsVideoItemService.videoList(queryDTO);
        return Result.ok(itemList);
    }

    @ApiOperation(value="\u89c6\u9891\u5206\u6790\u5217\u8868", notes="\u89c6\u9891\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/videoList"})
    public Result<?> videoList(CompanyGoodsVideoRecord videoList, CompanyGoodsItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)videoList), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<CompanyGoodsVideoRecordVO> pageList = this.companyGoodsVideoRecordService.queryVideoPage((Page<CompanyGoodsVideoRecord>)page, (QueryWrapper<CompanyGoodsVideoRecord>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u76f4\u64ad\u5206\u6790\u7edf\u8ba1", notes="\u76f4\u64ad\u5206\u6790\u7edf\u8ba1")
    @GetMapping(value={"/liveStat"})
    public Result<?> liveStat(CompanyGoodsItemQueryDTO queryDTO) {
        List<CompanyGoodsLiveItem> itemList = this.companyGoodsLiveItemService.videoList(queryDTO);
        return Result.ok(itemList);
    }

    @ApiOperation(value="\u76f4\u64ad\u5206\u6790\u5217\u8868", notes="\u76f4\u64ad\u5206\u6790\u5217\u8868")
    @GetMapping(value={"/liveList"})
    public Result<?> liveList(CompanyGoodsLiveRecord liveList, CompanyGoodsItemQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)liveList), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        List<CompanyGoodsLiveRecordVO> pageList = this.companyGoodsLiveRecordService.queryLivePage((Page<CompanyGoodsLiveRecord>)page, (QueryWrapper<CompanyGoodsLiveRecord>)queryWrapper, queryDTO);
        return Result.ok(pageList);
    }

    @ApiOperation(value="\u5546\u54c1\u5217\u8868-\u5bfc\u51fa", notes="\u5546\u54c1\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, @RequestParam Map<String, Object> object, @RequestParam(value="platform") String platform, @RequestParam(value="dataType") String dataType) {
        if ("1".equals(platform)) {
            if ("1".equals(dataType)) {
                return super.exportXls(request, object, CompanyGoodsHeadExportServiceImpl.class);
            }
            if ("2".equals(dataType)) {
                return super.exportXls(request, object, MonitorCompanyGoodsHeadExportServiceImpl.class);
            }
        }
        if ("2".equals(platform)) {
            return super.exportXls(request, object, KsCompanyGoodsHeadExportServiceImpl.class);
        }
        return null;
    }

    @ApiOperation(value="\u57fa\u7840\u5206\u6790\u5217\u8868-\u5bfc\u51fa", notes="\u57fa\u7840\u5206\u6790\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/statisticsExportXls"})
    public ModelAndView statisticsExportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, CompanyGoodsHeadStatisticsExportServiceImpl.class);
    }

    @ApiOperation(value="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5bfc\u51fa", notes="\u8fbe\u4eba\u5206\u6790\u5217\u8868-\u5bfc\u51fa")
    @GetMapping(value={"/topmanExportXls"})
    public ModelAndView topmanExportXls(HttpServletRequest request, @RequestParam Map<String, Object> object) {
        return super.exportXls(request, object, CompanyGoodsTopmanItemExportServiceImpl.class);
    }

    @GetMapping(value={"/ksCategory"})
    public Result<?> ksCategory() {
        ArrayList list = Lists.newArrayList();
        HashMap data = Maps.newHashMap();
        data.put("id", 0);
        data.put("categoryId", 0);
        data.put("title", "\u5546\u54c1\u5206\u7c7b:");
        data.put("children", this.itemsCategoryService.ksCategory());
        list.add(data);
        return Result.ok((Object)list);
    }

    @GetMapping(value={"/dyCategory"})
    public Result<?> dyCategory() {
        ArrayList list = Lists.newArrayList();
        HashMap data = Maps.newHashMap();
        data.put("id", 0);
        data.put("categoryId", 0);
        data.put("title", "\u5546\u54c1\u5206\u7c7b:");
        data.put("children", this.dyProductCategoryService.dyCategory());
        list.add(data);
        return Result.ok((Object)list);
    }

    @GetMapping(value={"/getKsTopMans"})
    public Result<?> getKsTopMans(CompanyStoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryDTO.setElsAccount(TenantContext.getTenant());
        IPage<TopMansVO> pageList = this.ksItemsService.getKsTopMans((Page<TopMansVO>)page, queryDTO);
        return Result.ok(pageList);
    }

    @GetMapping(value={"/getDyTopMans"})
    public Result<?> getDyTopMans(CompanyStoreHeadQueryDTO queryDTO, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        queryDTO.setElsAccount(TenantContext.getTenant());
        IPage<TopMansVO> pageList = this.dyShopProductService.getDyTopMans((Page<TopMansVO>)page, queryDTO);
        return Result.ok(pageList);
    }
}

