/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.message.adapter;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.doudian.open.core.AccessToken;
import com.els.common.adapter.Adapter;
import com.els.modules.companystore.entity.CompanyStoreHead;
import com.els.modules.companystore.enumerate.CompanyStoreAuthStatusEnum;
import com.els.modules.companystore.service.CompanyStoreHeadService;
import com.els.modules.companystore.service.DyShopProductService;
import com.els.modules.companystore.utils.DouDianApiUtil;
import com.els.modules.message.adapter.DouDianAdapter;
import com.els.modules.message.adapter.DouDianMessageContext;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Adapter(value={"product"})
public class DouDianProductMessageAdapter
extends DouDianAdapter {
    private static final Logger log = LoggerFactory.getLogger(DouDianProductMessageAdapter.class);
    @Autowired
    private CompanyStoreHeadService companyStoreHeadService;
    @Autowired
    private DouDianApiUtil douDianApiUtil;
    @Autowired
    private DyShopProductService dyShopProductService;

    @Override
    public void handleBefore(DouDianMessageContext douDianMessageContext) {
        JSONObject json = JSONObject.parseObject((String)douDianMessageContext.getDouDianMessageVO().getData().toString());
        String productId = json.getString("product_id");
        String shopId = json.getString("shop_id");
        List companyStoreHeads = this.companyStoreHeadService.list((Wrapper)Wrappers.lambdaQuery().eq(CompanyStoreHead::getShopId, (Object)shopId));
        if (CollUtil.isEmpty((Collection)companyStoreHeads)) {
            return;
        }
        this.saveDbData(companyStoreHeads, productId, shopId);
    }

    private void saveDbData(List<CompanyStoreHead> companyStoreHeads, String productId, String shopId) {
        AccessToken accessToken = this.douDianApiUtil.getToken(shopId);
        if (ObjectUtil.isEmpty((Object)accessToken)) {
            companyStoreHeads.forEach(companyStoreHead -> companyStoreHead.setAuthState(CompanyStoreAuthStatusEnum.EXPIRED.getValue()));
            this.companyStoreHeadService.updateBatchById(companyStoreHeads);
        }
        companyStoreHeads.forEach(companyStoreHead -> this.dyShopProductService.pullById(productId, (CompanyStoreHead)((Object)companyStoreHead), accessToken));
    }
}

