/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.monitor.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.system.vo.LoginUser;
import com.els.common.util.SysUtil;
import com.els.modules.account.api.service.ApiCallCountRpcService;
import com.els.modules.common.spider.properties.MonitorMethodProperties;
import com.els.modules.common.spider.properties.SpiderBaseProperties;
import com.els.modules.common.utils.HttpRequestUtils;
import com.els.modules.monitor.entity.LiveDashboardEntity;
import com.els.modules.monitor.entity.LiveMonitorEntity;
import com.els.modules.monitor.entity.LiveMonitorMessage;
import com.els.modules.monitor.entity.LiveSummaryEntity;
import com.els.modules.monitor.entity.LiveUsersEntity;
import com.els.modules.monitor.entity.MonitorStatusEntiy;
import com.els.modules.monitor.entity.TopmanEntity;
import com.els.modules.monitor.mapper.LivesMonitorMapper;
import com.els.modules.monitor.service.LivesMonitorService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.stereotype.Service;

@Service
public class LivesMonitorServiceImpl
extends BaseServiceImpl<LivesMonitorMapper, LiveMonitorEntity>
implements LivesMonitorService {
    @Autowired
    private SpiderBaseProperties spiderBaseProperties;
    @Resource
    private MongoTemplate mongoTemplate;
    @Autowired
    private MonitorMethodProperties monitorMethodProperties;
    @Autowired
    private ApiCallCountRpcService apiCallcountRpcService;
    private static final String SUCCESS_CODE = "1000";
    private static final String LIVE_MONITOR_COUNT_LIMIT = "live_monitor_count_limit";
    @Value(value="${els.env}")
    private String env;

    @Override
    public LiveMonitorMessage<List<TopmanEntity>> searchTopmanMonitor(String keyWord) throws Exception {
        String url = this.spiderBaseProperties.getMonitor();
        String liveSearchMethod = this.monitorMethodProperties.getLiveSearch();
        LiveMonitorMessage<List<TopmanEntity>> live = new LiveMonitorMessage<List<TopmanEntity>>();
        String param = LivesMonitorServiceImpl.apiGetList(keyWord);
        JSONObject jsonObject = HttpRequestUtils.httpJson(url + liveSearchMethod, param);
        String code = jsonObject.getString("code");
        live.setCode(code);
        live.setMessage(jsonObject.getString("message"));
        if (SUCCESS_CODE.equals(code)) {
            JSONArray dataArray = jsonObject.getJSONArray("data");
            ArrayList<TopmanEntity> list = new ArrayList<TopmanEntity>();
            for (Object obj : dataArray) {
                JSONObject dataJson = (JSONObject)obj;
                TopmanEntity data = (TopmanEntity)dataJson.toJavaObject(TopmanEntity.class);
                data.setLogo(dataJson.getString("user_head_logo"));
                data.setNikeName(dataJson.getString("user_name"));
                data.setAccount(dataJson.getString("aweme_id"));
                data.setUid(dataJson.getString("sec_uid"));
                list.add(data);
            }
            live.setReleaseTime(this.apiCallcountRpcService.getCount(LIVE_MONITOR_COUNT_LIMIT));
            live.setData(list);
        }
        return live;
    }

    private String apiPostParam(Map<String, String> apiParam) {
        String json = JSON.toJSONString(apiParam);
        System.out.println("bbbbbbbbbbbbbbb=" + json);
        return json;
    }

    private static String apiGetList(String keyWord) throws Exception {
        HashMap<String, String> apiParam = new HashMap<String, String>();
        apiParam.put("keyWord", keyWord);
        String json = JSON.toJSONString(apiParam);
        System.out.println("bbbbbbbbbbbbbbb=" + json);
        return json;
    }

    @Override
    public int startMonitor(LiveMonitorEntity entity) {
        int allcount = this.apiCallcountRpcService.getCount(LIVE_MONITOR_COUNT_LIMIT);
        double times = Math.ceil((entity.getMonitorEndDate().getTime() - entity.getMonitorStartDate().getTime()) / 21600000L);
        if (times > (double)allcount) {
            return 0;
        }
        String sec_uid = entity.getUid();
        try {
            entity.setUid(this.getUid(sec_uid));
            entity.setSecUid(sec_uid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        entity.setStatus("0");
        entity.setEnv(this.env);
        entity.setTimes((int)times);
        ((LivesMonitorMapper)this.baseMapper).insert((Object)entity);
        this.mongoTemplate.insert((Object)entity);
        this.apiCallcountRpcService.deductionCount(LIVE_MONITOR_COUNT_LIMIT, (int)times, null);
        return 1;
    }

    private String getUid(String sec_uid) throws Exception {
        String url = this.spiderBaseProperties.getMonitor();
        String liveSearchMethod = this.monitorMethodProperties.getLiveDetail();
        String result = "";
        HashMap<String, String> apiKey = new HashMap<String, String>();
        apiKey.put("sec_uid", sec_uid);
        String param = this.apiPostParam(apiKey);
        JSONObject jsonObject = HttpRequestUtils.httpJson(url + liveSearchMethod, param);
        String code = jsonObject.getString("code");
        if (SUCCESS_CODE.equals(code)) {
            JSONObject obj = jsonObject.getJSONObject("data");
            result = obj.getString("uid");
        }
        return result;
    }

    @Override
    public LiveSummaryEntity getLiveSummary(LiveMonitorEntity entity) throws Exception {
        JSONObject obj;
        String url = this.spiderBaseProperties.getMonitor();
        String LiveMonitorMethod = this.monitorMethodProperties.getLiveSummary();
        LiveSummaryEntity result = new LiveSummaryEntity();
        HashMap<String, String> apiKey = new HashMap<String, String>();
        apiKey.put("uid", entity.getUid());
        String param = this.apiPostParam(apiKey);
        JSONObject jsonObject = HttpRequestUtils.httpJson(url + LiveMonitorMethod, param);
        String code = jsonObject.getString("code");
        if (SUCCESS_CODE.equals(code) && (obj = jsonObject.getJSONObject("data")) != null) {
            result = (LiveSummaryEntity)obj.toJavaObject(LiveSummaryEntity.class);
        }
        return result;
    }

    @Override
    public List<LiveDashboardEntity> getLiveDashboard(LiveMonitorEntity entity) throws Exception {
        JSONArray obj;
        String url = this.spiderBaseProperties.getMonitor();
        String liveDashboardMethod = this.monitorMethodProperties.getLiveDashboard();
        List<LiveDashboardEntity> result = new ArrayList<LiveDashboardEntity>();
        HashMap<String, String> apiKey = new HashMap<String, String>();
        apiKey.put("uid", entity.getUid());
        String param = this.apiPostParam(apiKey);
        JSONObject jsonObject = HttpRequestUtils.httpJson(url + liveDashboardMethod, param);
        String code = jsonObject.getString("code");
        if (SUCCESS_CODE.equals(code) && (obj = jsonObject.getJSONArray("data")) != null) {
            result = obj.toJavaList(LiveDashboardEntity.class);
        }
        return result;
    }

    @Override
    public List<LiveUsersEntity> getLiveUsers(LiveMonitorEntity entity) throws Exception {
        JSONArray obj;
        String url = this.spiderBaseProperties.getMonitor();
        String LiveUsersMethod = this.monitorMethodProperties.getLiveUsers();
        List<LiveUsersEntity> result = new ArrayList<LiveUsersEntity>();
        HashMap<String, String> apiKey = new HashMap<String, String>();
        apiKey.put("uid", entity.getUid());
        String param = this.apiPostParam(apiKey);
        JSONObject jsonObject = HttpRequestUtils.httpJson(url + LiveUsersMethod, param);
        String code = jsonObject.getString("code");
        if (SUCCESS_CODE.equals(code) && (obj = jsonObject.getJSONArray("data")) != null) {
            result = obj.toJavaList(LiveUsersEntity.class);
        }
        return result;
    }

    @Override
    public MonitorStatusEntiy querySumStatusData() {
        LoginUser loginUser = SysUtil.getLoginUser();
        return ((LivesMonitorMapper)this.baseMapper).querySumStatusData(loginUser.getElsAccount());
    }
}

