/*
 * Decompiled with CFR 0.152.
 */
package com.els.modules.purchasercooperation.service.impl;

import com.els.common.exception.ELSBootException;
import com.els.common.system.base.service.impl.BaseServiceImpl;
import com.els.common.util.I18nUtil;
import com.els.common.util.SysUtil;
import com.els.config.mybatis.TenantContext;
import com.els.modules.purchasercooperation.entity.PurchaserTalentScheduleItem;
import com.els.modules.purchasercooperation.mapper.PurchaserTalentScheduleItemMapper;
import com.els.modules.purchasercooperation.service.PurchaserTalentScheduleItemService;
import com.els.modules.suppliercooperation.entity.SupplierTalentScheduleItem;
import com.els.modules.suppliercooperation.service.SupplierTalentScheduleItemService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class PurchaserTalentScheduleItemServiceImpl
extends BaseServiceImpl<PurchaserTalentScheduleItemMapper, PurchaserTalentScheduleItem>
implements PurchaserTalentScheduleItemService {
    @Autowired
    private SupplierTalentScheduleItemService scheduleItemService;

    @Override
    public int insertBatch(List<PurchaserTalentScheduleItem> purchaserTalentScheduleItemList) {
        purchaserTalentScheduleItemList.forEach(a -> {
            if (a.getHeadId() == null) {
                throw new ELSBootException("\u5934\u4fe1\u606fid\u4e0d\u80fd\u4e3a\u7a7a");
            }
        });
        int i = ((PurchaserTalentScheduleItemMapper)this.baseMapper).insertBatchSomeColumn(purchaserTalentScheduleItemList);
        return i;
    }

    @Override
    public void deleteById(List<PurchaserTalentScheduleItem> purchaserTalentScheduleItemList) {
        List<PurchaserTalentScheduleItem> purchaserTalentScheduleItems = ((PurchaserTalentScheduleItemMapper)this.baseMapper).selectByIds(purchaserTalentScheduleItemList, TenantContext.getTenant());
        purchaserTalentScheduleItems.forEach(a -> Assert.isTrue((boolean)"0".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u5220\u9664\u65b0\u5efa\u72b6\u6001\u884c\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u884c\u72b6\u6001\u662f\u5426\u4e3a\u65b0\u5efa")));
        ((PurchaserTalentScheduleItemMapper)this.baseMapper).deleteBatchIds(purchaserTalentScheduleItems);
    }

    @Override
    public void affirmTakeAndRefuseById(String status, List<PurchaserTalentScheduleItem> purchaserTalentScheduleItemList) {
        List<SupplierTalentScheduleItem> scheduleItems = this.checkSchedule(purchaserTalentScheduleItemList);
        PurchaserTalentScheduleItem purchaserTalentScheduleItem = new PurchaserTalentScheduleItem();
        purchaserTalentScheduleItem.setItemStatus(status);
        purchaserTalentScheduleItem.setUpdateBy(SysUtil.getLoginUser().getSubAccount());
        purchaserTalentScheduleItem.setUpdateTime(new Date());
        ((PurchaserTalentScheduleItemMapper)this.baseMapper).updateStatus(purchaserTalentScheduleItem, purchaserTalentScheduleItemList);
        this.scheduleItemService.affirmTakeAndRefuseById(false, status, scheduleItems);
    }

    private List<SupplierTalentScheduleItem> checkSchedule(List<PurchaserTalentScheduleItem> purchaserTalentScheduleItemList) {
        ArrayList<SupplierTalentScheduleItem> scheduleItems = new ArrayList<SupplierTalentScheduleItem>();
        if (CollectionUtils.isNotEmpty(purchaserTalentScheduleItemList)) {
            purchaserTalentScheduleItemList.forEach(a -> {
                Assert.isTrue((boolean)"1".equals(a.getItemStatus()), (String)I18nUtil.translate((String)"", (String)"\u53ea\u80fd\u64cd\u4f5c\u5f85\u786e\u8ba4\u72b6\u6001\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u6240\u9009\u6570\u636e!"));
                SupplierTalentScheduleItem sampleItem = new SupplierTalentScheduleItem();
                BeanUtils.copyProperties((Object)a, (Object)((Object)sampleItem));
                scheduleItems.add(sampleItem);
            });
        }
        return scheduleItems;
    }
}

