/*
 * Decompiled with CFR 0.152.
 */
package com.fadada.sdk.verify.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.fadada.sdk.api.API;
import com.fadada.sdk.exception.SDKException;
import com.fadada.sdk.http.handler.DefaultFddClient;
import com.fadada.sdk.utils.crypt.AESCrypt;
import com.fadada.sdk.verify.model.api.ApplyCert;
import com.fadada.sdk.verify.model.api.CancelExtsignAutoPage;
import com.fadada.sdk.verify.model.api.CancelLegalAuthorize;
import com.fadada.sdk.verify.model.api.CompanyRemittanceSubmit;
import com.fadada.sdk.verify.model.api.CompanyVerifyUrl;
import com.fadada.sdk.verify.model.api.CreateWitnessTask;
import com.fadada.sdk.verify.model.api.CustomQuestions;
import com.fadada.sdk.verify.model.api.FileForUUID;
import com.fadada.sdk.verify.model.api.FindCompanyCert;
import com.fadada.sdk.verify.model.api.FindPersonCert;
import com.fadada.sdk.verify.model.api.FindSerialNo;
import com.fadada.sdk.verify.model.api.FourEleAuth;
import com.fadada.sdk.verify.model.api.GetFaceAuthUrl;
import com.fadada.sdk.verify.model.api.GetFile;
import com.fadada.sdk.verify.model.api.GetGesturePhotoNum;
import com.fadada.sdk.verify.model.api.GetVerificationCode;
import com.fadada.sdk.verify.model.api.PersonThreeEleAuth;
import com.fadada.sdk.verify.model.api.PersonVerifyUrl;
import com.fadada.sdk.verify.model.api.QueryWitnessTask;
import com.fadada.sdk.verify.model.api.UploadGesturePhoto;
import com.fadada.sdk.verify.model.api.UploadRegForm;
import com.fadada.sdk.verify.model.api.VerifyAmount;
import com.fadada.sdk.verify.model.req.ApplyCertParams;
import com.fadada.sdk.verify.model.req.CancelExtsignAutoPageParams;
import com.fadada.sdk.verify.model.req.CancelLegalAuthorizeParams;
import com.fadada.sdk.verify.model.req.CompanyRemittanceSubmitParams;
import com.fadada.sdk.verify.model.req.CompanyVerifyUrlParams;
import com.fadada.sdk.verify.model.req.CreateWitnessTaskParams;
import com.fadada.sdk.verify.model.req.CustomQuestionsParams;
import com.fadada.sdk.verify.model.req.FileForUUIDParams;
import com.fadada.sdk.verify.model.req.FindCompanyCertParams;
import com.fadada.sdk.verify.model.req.FindPersonCertParams;
import com.fadada.sdk.verify.model.req.FindSerialNoParams;
import com.fadada.sdk.verify.model.req.FourEleAuthParams;
import com.fadada.sdk.verify.model.req.GetFaceAuthUrlParams;
import com.fadada.sdk.verify.model.req.GetFileParams;
import com.fadada.sdk.verify.model.req.GetGesturePhotoNumParams;
import com.fadada.sdk.verify.model.req.GetVerificationCodeParams;
import com.fadada.sdk.verify.model.req.PersonThreeEleAuthParams;
import com.fadada.sdk.verify.model.req.PersonVerifyUrlParams;
import com.fadada.sdk.verify.model.req.QueryWitnessTaskParams;
import com.fadada.sdk.verify.model.req.UploadGesturePhotoParams;
import com.fadada.sdk.verify.model.req.UploadRegFormParams;
import com.fadada.sdk.verify.model.req.VerifyAmountParams;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FddVerifyClient
extends DefaultFddClient {
    public FddVerifyClient(String appId, String secret, String version, String url) {
        super(appId, secret, version, url);
    }

    public FddVerifyClient(String appId, String secret, String version, String url, String proxyHost, String proxyFlag, String proxyPort) {
        super(appId, secret, version, url, proxyHost, proxyFlag, proxyPort);
    }

    public FddVerifyClient(String appId, String secret, String version, String url, Integer readTimeout, Integer writeTimeout, Integer fileReadTimeout, Integer fileWriteTimeout) {
        super(appId, secret, version, url, readTimeout, writeTimeout, fileReadTimeout, fileWriteTimeout);
    }

    public FddVerifyClient(String appId, String secret, String version, String url, Integer readTimeout, Integer writeTimeout, Integer fileReadTimeout, Integer fileWriteTimeout, String proxyHost, String proxyFlag, String proxyPort) {
        super(appId, secret, version, url, readTimeout, writeTimeout, fileReadTimeout, fileWriteTimeout, proxyHost, proxyFlag, proxyPort);
    }

    public String invokePersonVerifyUrl(PersonVerifyUrlParams params) {
        try {
            PersonVerifyUrl personVerifyUrl = new PersonVerifyUrl();
            personVerifyUrl.setHasFile(params.getIdentBackImg() != null || params.getIdentFrontImg() != null);
            if ("1".equals(params.getEncryption())) {
                if (StringUtils.isNotBlank(params.getBankCardNo())) {
                    params.setBankCardNo(AESCrypt.encrypt(params.getBankCardNo(), this.getSecret()));
                }
                if (StringUtils.isNotBlank(params.getCustomerIdentNo())) {
                    params.setCustomerIdentNo(AESCrypt.encrypt(params.getCustomerIdentNo(), this.getSecret()));
                }
                if (StringUtils.isNotBlank(params.getMobile())) {
                    params.setMobile(AESCrypt.encrypt(params.getMobile(), this.getSecret()));
                }
            }
            return super.invoke((API)personVerifyUrl, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeCompanyVerifyUrl(CompanyVerifyUrlParams params) {
        try {
            CompanyVerifyUrl companyVerifyUrl = new CompanyVerifyUrl();
            companyVerifyUrl.setHasFile(params.getAuthorizationFile() != null || params.getAgentIdFrontImg() != null || params.getCreditImage() != null || params.getLegalIdFrontImg() != null || params.getAgentIdBackImg() != null || params.getLegalIdBackImg() != null);
            if ("1".equals(params.getEncryption())) {
                CompanyVerifyUrlParams.AgentInfo agentInfo;
                CompanyVerifyUrlParams.LegalInfo legalInfo = params.getLegalInfo();
                if (legalInfo != null) {
                    if (StringUtils.isNotBlank(legalInfo.getLegalId())) {
                        legalInfo.setLegalId(AESCrypt.encrypt(legalInfo.getLegalId(), this.getSecret()));
                    }
                    if (StringUtils.isNotBlank(legalInfo.getLegalMobile())) {
                        legalInfo.setLegalMobile(AESCrypt.encrypt(legalInfo.getLegalMobile(), this.getSecret()));
                    }
                    if (StringUtils.isNotBlank(legalInfo.getBankCardNo())) {
                        legalInfo.setBankCardNo(AESCrypt.encrypt(legalInfo.getBankCardNo(), this.getSecret()));
                    }
                }
                if ((agentInfo = params.getAgentInfo()) != null) {
                    if (StringUtils.isNotBlank(agentInfo.getAgentId())) {
                        agentInfo.setAgentId(AESCrypt.encrypt(agentInfo.getAgentId(), this.getSecret()));
                    }
                    if (StringUtils.isNotBlank(agentInfo.getAgentMobile())) {
                        agentInfo.setAgentMobile(AESCrypt.encrypt(agentInfo.getAgentMobile(), this.getSecret()));
                    }
                    if (StringUtils.isNotBlank(agentInfo.getBankCardNo())) {
                        agentInfo.setBankCardNo(AESCrypt.encrypt(agentInfo.getBankCardNo(), this.getSecret()));
                    }
                }
            }
            return super.invoke((API)companyVerifyUrl, params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeFindPersonCert(FindPersonCertParams params) {
        try {
            JSONObject jsonObject;
            String data;
            String result = super.invoke((API)new FindPersonCert(), params);
            if ("1".equals(params.getEncryption()) && StringUtils.isNotBlank(result) && StringUtils.isNotBlank(data = (jsonObject = JSONObject.parseObject(result)).getString("data"))) {
                String decryptData = AESCrypt.decrypt(data, this.getSecret());
                jsonObject.put("data", (Object)decryptData);
                result = JSON.toJSONString(jsonObject);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeFindPersonCert(FindPersonCertParams params, Map<String, String> headers) {
        try {
            JSONObject jsonObject;
            String data;
            FindPersonCert findPersonCert = new FindPersonCert();
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    findPersonCert.addHeader(entry.getKey(), entry.getValue());
                }
            }
            String result = super.invoke((API)findPersonCert, params);
            if ("1".equals(params.getEncryption()) && StringUtils.isNotBlank(result) && StringUtils.isNotBlank(data = (jsonObject = JSONObject.parseObject(result)).getString("data"))) {
                String decryptData = AESCrypt.decrypt(data, this.getSecret());
                jsonObject.put("data", (Object)decryptData);
                result = JSON.toJSONString(jsonObject);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeFindCompanyCert(FindCompanyCertParams params) {
        try {
            JSONObject jsonObject;
            String data;
            String result = super.invoke((API)new FindCompanyCert(), params);
            if ("1".equals(params.getEncryption()) && StringUtils.isNotBlank(result) && StringUtils.isNotBlank(data = (jsonObject = JSONObject.parseObject(result)).getString("data"))) {
                String decryptData = AESCrypt.decrypt(data, this.getSecret());
                jsonObject.put("data", (Object)decryptData);
                result = JSON.toJSONString(jsonObject);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeFindCompanyCert(FindCompanyCertParams params, Map<String, String> headers) {
        try {
            JSONObject jsonObject;
            String data;
            FindCompanyCert findCompanyCert = new FindCompanyCert();
            if (headers != null && headers.size() > 0) {
                for (Map.Entry<String, String> entry : headers.entrySet()) {
                    findCompanyCert.addHeader(entry.getKey(), entry.getValue());
                }
            }
            String result = super.invoke((API)findCompanyCert, params);
            if ("1".equals(params.getEncryption()) && StringUtils.isNotBlank(result) && StringUtils.isNotBlank(data = (jsonObject = JSONObject.parseObject(result)).getString("data"))) {
                String decryptData = AESCrypt.decrypt(data, this.getSecret());
                jsonObject.put("data", (Object)decryptData);
                result = JSON.toJSONString(jsonObject);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeApplyCert(ApplyCertParams params) {
        try {
            return super.invoke((API)new ApplyCert(), params);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeFileForUUID(FileForUUIDParams params) {
        FileForUUID fileForUUID = new FileForUUID();
        fileForUUID.setUrl(super.getUrl());
        params.setCommonParams(super.getAppId(), super.getSecret(), super.getVersion());
        StringBuilder sBuilder = new StringBuilder(fileForUUID.getUrl()).append("?app_id=").append(super.getAppId()).append("&v=").append(super.getVersion()).append("&timestamp=").append(params.getTimestamp()).append("&uuid=").append(params.getUuid()).append("&doc_type=").append(params.getDocType()).append("&msg_digest=").append(params.getMsgDigest());
        return sBuilder.toString();
    }

    public String invokeCancelExtsignAutoPage(CancelExtsignAutoPageParams params) {
        CancelExtsignAutoPage cancelExtsignAutoPage = new CancelExtsignAutoPage();
        cancelExtsignAutoPage.setUrl(super.getUrl());
        params.setCommonParams(super.getAppId(), super.getSecret(), super.getVersion());
        StringBuilder sBuilder = new StringBuilder(cancelExtsignAutoPage.getUrl());
        try {
            sBuilder.append("?app_id=").append(super.getAppId()).append("&v=").append(super.getVersion()).append("&timestamp=").append(params.getTimestamp()).append("&customer_id=").append(params.getCustomerId());
            if (StringUtils.isNotBlank(params.getReturnUrl())) {
                sBuilder.append("&return_url=").append(URLEncoder.encode(params.getReturnUrl(), "UTF-8"));
            }
            if (StringUtils.isNotBlank(params.getNotifyUrl())) {
                sBuilder.append("&notify_url=").append(URLEncoder.encode(params.getNotifyUrl(), "UTF-8"));
            }
            sBuilder.append("&msg_digest=").append(params.getMsgDigest());
            return sBuilder.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeFindSerialNo(FindSerialNoParams params) {
        try {
            String result = super.invoke((API)new FindSerialNo(), params);
            return result;
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeGetFaceAuthUrl(GetFaceAuthUrlParams params) {
        try {
            String result = super.invoke((API)new GetFaceAuthUrl(), params);
            return result;
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokePersonThreeEleAuth(PersonThreeEleAuthParams params) {
        try {
            String result = super.invoke((API)new PersonThreeEleAuth(), params);
            return result;
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeFourEleAuth(FourEleAuthParams params) {
        try {
            String result = super.invoke((API)new FourEleAuth(), params);
            return result;
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeGetVerificationCode(GetVerificationCodeParams params) {
        try {
            String result = super.invoke((API)new GetVerificationCode(), params);
            return result;
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeGetGesturePhotoNum(GetGesturePhotoNumParams params) {
        try {
            String result = super.invoke((API)new GetGesturePhotoNum(), params);
            return result;
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeUploadGesturePhoto(UploadGesturePhotoParams params) {
        try {
            UploadGesturePhoto uploadGesturePhoto = new UploadGesturePhoto();
            if (params.getGesturePhotoFile() != null || params.getIdCardHeadFile() != null) {
                uploadGesturePhoto.setHasFile(true);
            } else {
                uploadGesturePhoto.setHasFile(false);
            }
            return super.invoke((API)uploadGesturePhoto, params);
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeCompanyRemittanceSubmit(CompanyRemittanceSubmitParams params) {
        try {
            CompanyRemittanceSubmit companyRemittanceSubmit = new CompanyRemittanceSubmit();
            companyRemittanceSubmit.setHasFile(params.getLicenseImageFile() != null);
            String result = super.invoke((API)companyRemittanceSubmit, params);
            return result;
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeGetFile(GetFileParams params) {
        try {
            return super.invoke((API)new GetFile(), params);
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeUploadRegForm(UploadRegFormParams params) {
        try {
            UploadRegForm uploadRegForm = new UploadRegForm();
            uploadRegForm.setHasFile(params.getAuthorizationImageFile() != null);
            return super.invoke((API)uploadRegForm, params);
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeVerifyAmount(VerifyAmountParams params) {
        try {
            return super.invoke((API)new VerifyAmount(), params);
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeCancelLegalAuthorize(CancelLegalAuthorizeParams params) {
        try {
            return super.invoke((API)new CancelLegalAuthorize(), params);
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeCustomQuestions(CustomQuestionsParams params) {
        try {
            return super.invoke((API)new CustomQuestions(), params);
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeCreateWitnessTask(CreateWitnessTaskParams params) {
        try {
            return super.invoke((API)new CreateWitnessTask(), params);
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }

    public String invokeQueryWitnessTask(QueryWitnessTaskParams params) {
        try {
            return super.invoke((API)new QueryWitnessTask(), params);
        }
        catch (SDKException e) {
            throw new RuntimeException(e);
        }
    }
}

