/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.xml.jaxb;

import com.fasterxml.jackson.xml.XmlAnnotationIntrospector;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public class XmlJaxbAnnotationIntrospector
extends JaxbAnnotationIntrospector
implements XmlAnnotationIntrospector {
    @Override
    public String findNamespace(Annotated ann) {
        String ns = null;
        if (ann instanceof AnnotatedClass) {
            XmlRootElement elem = this.findRootElementAnnotation((AnnotatedClass)ann);
            if (elem != null) {
                ns = elem.namespace();
            }
        } else {
            XmlAttribute attr;
            XmlElement elem = this.findAnnotation(XmlElement.class, ann, false, false, false);
            if (elem != null) {
                ns = elem.namespace();
            }
            if ((ns == null || "##default".equals(ns)) && (attr = this.findAnnotation(XmlAttribute.class, ann, false, false, false)) != null) {
                ns = attr.namespace();
            }
        }
        if ("##default".equals(ns)) {
            ns = null;
        }
        return ns;
    }

    @Override
    public Boolean isOutputAsAttribute(Annotated ann) {
        XmlAttribute attr = this.findAnnotation(XmlAttribute.class, ann, false, false, false);
        if (attr != null) {
            return Boolean.TRUE;
        }
        XmlElement elem = this.findAnnotation(XmlElement.class, ann, false, false, false);
        if (elem != null) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public QName findWrapperElement(Annotated ann) {
        XmlElementWrapper w = this.findAnnotation(XmlElementWrapper.class, ann, false, false, false);
        if (w != null) {
            return new QName(this.handleJaxbDefault(w.namespace()), this.handleJaxbDefault(w.name()));
        }
        return null;
    }

    @Override
    public QName findRootElement(Annotated ann) {
        XmlRootElement root = this.findAnnotation(XmlRootElement.class, ann, false, false, false);
        if (root != null) {
            return new QName(this.handleJaxbDefault(root.namespace()), this.handleJaxbDefault(root.name()));
        }
        return null;
    }

    private XmlRootElement findRootElementAnnotation(AnnotatedClass ac) {
        return this.findAnnotation(XmlRootElement.class, (Annotated)ac, true, false, true);
    }

    private String handleJaxbDefault(String value) {
        return "##default".equals(value) ? "" : value;
    }

    protected <A extends Annotation> A findAnnotation(Class<A> annotationClass, Annotated annotated, boolean includePackage, boolean includeClass, boolean includeSuperclasses) {
        Annotation annotation = annotated.getAnnotation(annotationClass);
        if (annotation != null) {
            return (A)annotation;
        }
        Class memberClass = null;
        if (annotated instanceof AnnotatedParameter) {
            memberClass = ((AnnotatedParameter)annotated).getDeclaringClass();
        } else {
            AnnotatedElement annType = annotated.getAnnotated();
            if (annType instanceof Member) {
                memberClass = ((Member)((Object)annType)).getDeclaringClass();
                if (includeClass && (annotation = memberClass.getAnnotation(annotationClass)) != null) {
                    return (A)annotation;
                }
            } else if (annType instanceof Class) {
                memberClass = (Class)annType;
            } else {
                throw new IllegalStateException("Unsupported annotated member: " + annotated.getClass().getName());
            }
        }
        if (memberClass != null) {
            Package pkg;
            if (includeSuperclasses) {
                for (Class<?> superclass = memberClass.getSuperclass(); superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
                    annotation = superclass.getAnnotation(annotationClass);
                    if (annotation == null) continue;
                    return (A)annotation;
                }
            }
            if (includePackage && (pkg = memberClass.getPackage()) != null) {
                return memberClass.getPackage().getAnnotation(annotationClass);
            }
        }
        return null;
    }
}

