/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.oidc;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.ObjectUtil;
import com.fujieid.jap.core.JapUserService;
import com.fujieid.jap.core.cache.JapCache;
import com.fujieid.jap.core.config.AuthenticateConfig;
import com.fujieid.jap.core.config.JapConfig;
import com.fujieid.jap.core.exception.JapException;
import com.fujieid.jap.core.exception.OidcException;
import com.fujieid.jap.core.result.JapErrorCode;
import com.fujieid.jap.core.result.JapResponse;
import com.fujieid.jap.core.store.JapUserStore;
import com.fujieid.jap.http.JapHttpRequest;
import com.fujieid.jap.http.JapHttpResponse;
import com.fujieid.jap.oauth2.OAuthConfig;
import com.fujieid.jap.oauth2.Oauth2Strategy;
import com.fujieid.jap.oidc.OidcConfig;
import com.fujieid.jap.oidc.OidcDiscoveryDto;
import com.fujieid.jap.oidc.OidcUtil;
import java.io.Serializable;

public class OidcStrategy
extends Oauth2Strategy {
    public OidcStrategy(JapUserService japUserService, JapConfig japConfig) {
        super(japUserService, japConfig);
    }

    public OidcStrategy(JapUserService japUserService, JapConfig japConfig, JapCache japCache) {
        super(japUserService, japConfig, japCache);
    }

    public OidcStrategy(JapUserService japUserService, JapConfig japConfig, JapUserStore japUserStore, JapCache japCache) {
        super(japUserService, japConfig, japUserStore, japCache);
    }

    public JapResponse authenticate(AuthenticateConfig config, JapHttpRequest request, JapHttpResponse response) {
        String discoveryCacheKey;
        try {
            this.checkAuthenticateConfig(config, OidcConfig.class);
        }
        catch (JapException e) {
            return JapResponse.error((int)e.getErrorCode(), (String)e.getErrorMessage());
        }
        OidcConfig oidcConfig = (OidcConfig)config;
        if (ObjectUtil.isNull((Object)oidcConfig.getIssuer())) {
            return JapResponse.error((JapErrorCode)JapErrorCode.MISS_ISSUER);
        }
        String issuer = oidcConfig.getIssuer();
        OidcDiscoveryDto discoveryDto = null;
        JapCache japCache = this.japContext.getCache();
        if (japCache.containsKey(discoveryCacheKey = "_jap:oidc:discovery:".concat(issuer))) {
            discoveryDto = (OidcDiscoveryDto)japCache.get(discoveryCacheKey);
        } else {
            try {
                discoveryDto = OidcUtil.getOidcDiscovery(issuer);
                japCache.set(discoveryCacheKey, (Serializable)discoveryDto);
            }
            catch (OidcException e) {
                return JapResponse.error((int)e.getErrorCode(), (String)e.getErrorMessage());
            }
        }
        oidcConfig.setAuthorizationUrl(discoveryDto.getAuthorizationEndpoint()).setTokenUrl(discoveryDto.getTokenEndpoint()).setUserinfoUrl(discoveryDto.getUserinfoEndpoint());
        OAuthConfig oAuthConfig = (OAuthConfig)BeanUtil.copyProperties((Object)((Object)oidcConfig), OAuthConfig.class, (String[])new String[0]);
        return super.authenticate((AuthenticateConfig)oAuthConfig, request, response);
    }
}

