/*
 * Decompiled with CFR 0.152.
 */
package com.fujieid.jap.oidc;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.fujieid.jap.core.exception.OidcException;
import com.fujieid.jap.oidc.OidcDiscoveryDto;
import com.xkcoding.http.HttpUtil;
import com.xkcoding.http.support.SimpleHttpResponse;
import com.xkcoding.json.JsonUtil;
import com.xkcoding.json.util.Kv;
import java.util.Map;

public class OidcUtil {
    private static final String DISCOVERY_URL = "/.well-known/openid-configuration";

    public static OidcDiscoveryDto getOidcDiscovery(String issuer) {
        if (StrUtil.isBlank((CharSequence)issuer)) {
            throw new OidcException("Missing IDP Discovery Url.");
        }
        String discoveryUrl = issuer.concat(DISCOVERY_URL);
        SimpleHttpResponse response = HttpUtil.get((String)discoveryUrl);
        if (!response.isSuccess()) {
            throw new OidcException("Cannot access discovery url: " + discoveryUrl + ", " + response.getError());
        }
        Kv oidcDiscoveryInfo = JsonUtil.parseKv((String)response.getBody());
        if (CollectionUtil.isEmpty((Map)oidcDiscoveryInfo)) {
            throw new OidcException("Unable to parse IDP service discovery configuration information.");
        }
        return new OidcDiscoveryDto().setIssuer(oidcDiscoveryInfo.getString((Object)"issuer")).setAuthorizationEndpoint(oidcDiscoveryInfo.getString((Object)"authorization_endpoint")).setTokenEndpoint(oidcDiscoveryInfo.getString((Object)"token_endpoint")).setUserinfoEndpoint(oidcDiscoveryInfo.getString((Object)"userinfo_endpoint")).setEndSessionEndpoint(oidcDiscoveryInfo.getString((Object)"end_session_endpoint")).setJwksUri(oidcDiscoveryInfo.getString((Object)"jwks_uri"));
    }
}

