/*
 * Decompiled with CFR 0.152.
 */
package com.gccloud.common.service;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.IService;
import com.gccloud.common.dto.SearchDTO;
import com.gccloud.common.exception.GlobalException;
import com.gccloud.common.utils.QueryWrapperUtils;
import com.gccloud.common.vo.PageVO;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.util.Strings;

public interface ISuperService<T>
extends IService<T> {
    public static final Map<String, String> PROPERTY_COLUMN_MAP = Maps.newHashMap();

    default public int deleteById(Serializable id) {
        return this.getBaseMapper().deleteById(id);
    }

    default public int delete(Wrapper<T> wrapper) {
        return this.getBaseMapper().delete(wrapper);
    }

    default public PageVO<T> page(SearchDTO searchDTO, LambdaQueryWrapper<T> queryWrapper) {
        Page<T> searchPage = this.packSearchPage(searchDTO);
        Page page = (Page)this.page((IPage)searchPage, (Wrapper)queryWrapper);
        return new PageVO(page);
    }

    default public PageVO<T> page(SearchDTO searchDTO, SFunction<T, ?> ... fieldNames) {
        LambdaQueryWrapper<T> queryWrapper = this.packQueryWrapper(searchDTO, fieldNames);
        return this.page(searchDTO, queryWrapper);
    }

    default public LambdaQueryWrapper<T> packQueryWrapper(SearchDTO searchDTO, SFunction<T, ?> ... fieldNames) {
        LambdaQueryWrapper<T> queryWrapper = QueryWrapperUtils.wrapperLike(new LambdaQueryWrapper(), searchDTO.getSearchKey(), fieldNames);
        return queryWrapper;
    }

    default public Page<T> packSearchPage(SearchDTO searchDTO) {
        Integer size;
        Page searchPage = new Page();
        if (searchDTO.getCurrent() == null || searchDTO.getCurrent() <= 0) {
            searchPage.setCurrent(1L);
        } else {
            searchPage.setCurrent((long)searchDTO.getCurrent().intValue());
        }
        Integer current = searchDTO.getCurrent();
        if (current == null) {
            current = 1;
        }
        if ((size = searchDTO.getSize()) == null || size <= 0) {
            size = 10;
        }
        if (size > 500) {
            size = 500;
        }
        searchPage.setSize((long)size.intValue());
        searchPage.setCurrent((long)current.intValue());
        return searchPage;
    }

    default public List<String> convert(String idStr) {
        if (Strings.isBlank((String)idStr)) {
            throw new GlobalException("id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        String[] idStrArr = StringUtils.split((String)idStr, (String)"-");
        return Arrays.stream(idStrArr).map(id -> id).collect(Collectors.toList());
    }

    default public T getEntityByField(SFunction<T, ?> field, Object val) {
        LambdaUpdateWrapper query = new LambdaUpdateWrapper();
        query.eq(field, val);
        List list = this.list((Wrapper)query);
        if (list == null || list.size() == 0) {
            return null;
        }
        return (T)list.get(0);
    }

    default public List<T> getEntitiesByField(SFunction<T, ?> field, Object val) {
        LambdaUpdateWrapper query = new LambdaUpdateWrapper();
        query.eq(field, val);
        List list = this.list((Wrapper)query);
        return list;
    }
}

