/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.common;

import com.gitee.starblues.common.DependencyPlugin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;

public abstract class AbstractDependencyPlugin
implements DependencyPlugin {
    public static final String SPLIT_ALL = ",";
    public static final String SPLIT_ONE = "@";

    public abstract void setId(String var1);

    public abstract void setVersion(String var1);

    public abstract void setOptional(Boolean var1);

    public static String toStr(List<? extends AbstractDependencyPlugin> dependencyPlugins) {
        if (dependencyPlugins == null || dependencyPlugins.isEmpty()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        int size = dependencyPlugins.size();
        for (int i = 0; i < size; ++i) {
            AbstractDependencyPlugin dependencyPlugin = dependencyPlugins.get(i);
            Boolean optional = dependencyPlugin.getOptional();
            if (optional == null) {
                optional = false;
            }
            stringBuilder.append(dependencyPlugin.getId()).append(SPLIT_ONE).append(dependencyPlugin.getVersion()).append(SPLIT_ONE).append(optional);
            if (i > size - 2) continue;
            stringBuilder.append(SPLIT_ALL);
        }
        return stringBuilder.toString();
    }

    public static List<DependencyPlugin> toList(String str, Supplier<? extends AbstractDependencyPlugin> supplier) {
        if (str == null || "".equals(str)) {
            return Collections.emptyList();
        }
        String[] all = str.split(SPLIT_ALL);
        if (all.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<DependencyPlugin> list = new ArrayList<DependencyPlugin>(all.length);
        for (String s : all) {
            String[] one = s.split(SPLIT_ONE);
            if (one.length == 0 || one.length != 3) continue;
            AbstractDependencyPlugin dependencyPlugin = supplier.get();
            dependencyPlugin.setId(one[0]);
            dependencyPlugin.setVersion(one[1]);
            dependencyPlugin.setOptional("true".equalsIgnoreCase(one[2]));
            list.add(dependencyPlugin);
        }
        return list;
    }
}

