/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.common;

import java.io.File;
import java.util.regex.Matcher;

public abstract class PackageStructure {
    public static final String[] ILLEGAL_FORMAT = new String[]{",", "@"};
    public static final String CHARSET_NAME = "utf-8";
    public static final String SEPARATOR = "/";
    public static final String CLASSES_NAME = "classes";
    public static final String LIB_NAME = "lib";
    public static final String META_INF_NAME = "META-INF";
    public static final String MANIFEST = "MANIFEST.MF";
    public static final String PLUGIN_META_NAME = "PLUGIN.META";
    public static final String RESOURCES_DEFINE_NAME = "RESOURCES.CONF";
    public static final String RESOURCES_DEFINE_DEPENDENCIES = "dependencies.index";
    public static final String RESOURCES_DEFINE_LOAD_MAIN_INCLUDES = "load.main.resources.includes";
    public static final String RESOURCES_DEFINE_LOAD_MAIN_EXCLUDES = "load.main.resources.excludes";
    public static final String PROD_MANIFEST_PATH = "META-INF/MANIFEST.MF";
    public static final String PROD_RESOURCES_DEFINE_PATH = "META-INF/RESOURCES.CONF";
    public static final String PROD_PLUGIN_META_PATH = "META-INF/PLUGIN.META";
    public static final String PROD_CLASSES_PATH = "classes/";
    public static final String PROD_LIB_PATH = "lib/";

    private PackageStructure() {
    }

    public static String resolvePath(String path) {
        if (path == null || "".equals(path)) {
            return path;
        }
        if (path.contains(SEPARATOR)) {
            return path.replaceAll(SEPARATOR, Matcher.quoteReplacement(File.separator));
        }
        return path;
    }

    public static String getIllegal(String str) {
        for (String s : ILLEGAL_FORMAT) {
            if (!str.contains(s)) continue;
            return s;
        }
        return null;
    }
}

