/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.common.cipher;

import com.gitee.starblues.common.cipher.AbstractPluginCipher;
import com.gitee.starblues.utils.Assert;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public class RsaPluginCipher
extends AbstractPluginCipher {
    public static final String PUBLIC_KEY = "publicKey";
    public static final String PRIVATE_KEY = "privateKey";

    @Override
    protected String encryptImpl(String sourceStr) throws Exception {
        String publicKey = this.parameters.getString(PUBLIC_KEY);
        Assert.isNotEmpty(publicKey, "publicKey \u4e0d\u80fd\u4e3a\u7a7a");
        byte[] decoded = Base64.getDecoder().decode(publicKey);
        RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(1, pubKey);
        return Base64.getEncoder().encodeToString(cipher.doFinal(sourceStr.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    protected String decryptImpl(String cryptoStr) throws Exception {
        String privateKey = this.parameters.getString(PRIVATE_KEY);
        Assert.isNotEmpty(privateKey, "privateKey \u4e0d\u80fd\u4e3a\u7a7a");
        byte[] inputByte = Base64.getDecoder().decode(cryptoStr.getBytes(StandardCharsets.UTF_8));
        byte[] decoded = Base64.getDecoder().decode(privateKey);
        RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, priKey);
        return new String(cipher.doFinal(inputByte));
    }

    public static RsaKey generateKey() throws NoSuchAlgorithmException {
        return RsaPluginCipher.generateKey(512);
    }

    public static RsaKey generateKey(Integer keySize) throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(keySize);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        RSAPublicKey rsaPublicKey = (RSAPublicKey)keyPair.getPublic();
        RSAPrivateKey rsaPrivateKey = (RSAPrivateKey)keyPair.getPrivate();
        return new RsaKey(Base64.getEncoder().encodeToString(rsaPublicKey.getEncoded()), Base64.getEncoder().encodeToString(rsaPrivateKey.getEncoded()));
    }

    public static class RsaKey {
        private final String publicKey;
        private final String privateKey;

        public RsaKey(String publicKey, String privateKey) {
            this.publicKey = publicKey;
            this.privateKey = privateKey;
        }

        public String getPublicKey() {
            return this.publicKey;
        }

        public String getPrivateKey() {
            return this.privateKey;
        }
    }
}

