/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import com.gitee.starblues.utils.ObjectValueUtils;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;

public class MapValueGetter {
    private final Map<String, Object> source;

    public MapValueGetter(Map<String, Object> source) {
        this.source = source == null ? Collections.emptyMap() : source;
    }

    public Map<String, Object> getSource() {
        return this.source;
    }

    public Object getObject(String key) {
        return this.source.get(key);
    }

    public String getString(String key) {
        return this.getValue(key, ObjectValueUtils::getString);
    }

    public Integer getInteger(String key) {
        return this.getValue(key, ObjectValueUtils::getInteger);
    }

    public Long getLong(String key) {
        return this.getValue(key, ObjectValueUtils::getLong);
    }

    public Double getDouble(String key) {
        return this.getValue(key, ObjectValueUtils::getDouble);
    }

    public Float getFloat(String key) {
        return this.getValue(key, ObjectValueUtils::getFloat);
    }

    public Boolean getBoolean(String key) {
        return this.getValue(key, ObjectValueUtils::getBoolean);
    }

    private <T> T getValue(String key, Function<Object, T> function) {
        Object value = this.getObject(key);
        if (value == null) {
            return null;
        }
        return function.apply(value);
    }
}

