/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import com.gitee.starblues.utils.Assert;
import com.gitee.starblues.utils.CompareClassTypeUtils;
import com.gitee.starblues.utils.FieldFilter;
import com.gitee.starblues.utils.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;

public abstract class ReflectionUtils {
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];

    private ReflectionUtils() {
    }

    public static Field findField(Class<?> clazz, String name) {
        return ReflectionUtils.findField(clazz, name, null);
    }

    public static Field findField(Class<?> clazz, Class<?> fieldType) {
        return ReflectionUtils.findField(clazz, null, fieldType);
    }

    public static Field findField(Class<?> clazz, String fieldName, Class<?> fieldType) {
        if (fieldName == null && fieldType == null) {
            throw new IllegalArgumentException("fieldName or fieldType of the field must be specified");
        }
        return ReflectionUtils.findField(clazz, (Field field) -> !(fieldName != null && !fieldName.equals(field.getName()) || fieldType != null && !fieldType.equals(field.getType())));
    }

    public static Field findField(Class<?> clazz, FieldFilter filter) {
        Objects.requireNonNull(clazz, "clazz must not be null");
        Field[] declaredFields = clazz.getDeclaredFields();
        while (true) {
            for (Field field : declaredFields) {
                if (!filter.filter(field)) continue;
                return field;
            }
            if ((clazz = clazz.getSuperclass()) == null || clazz == Object.class) break;
            declaredFields = clazz.getDeclaredFields();
        }
        return null;
    }

    public static Object getField(Object object, Class<?> objectClass, String fieldName) {
        return ReflectionUtils.getField(object, objectClass, fieldName, null);
    }

    public static Object getField(Object object, Class<?> objectClass, String fieldName, Class<?> fieldType) {
        Field field = ReflectionUtils.findField(objectClass, fieldName, fieldType);
        if (field == null) {
            return null;
        }
        field.setAccessible(true);
        try {
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setField(Object o, String fieldName, Object value) {
        ReflectionUtils.setField(o, fieldName, null, value);
    }

    public static void setField(Object o, String fieldName, Class<?> fieldType, Object value) {
        Field field = ReflectionUtils.findField(o.getClass(), fieldName, fieldType);
        if (field != null) {
            field.setAccessible(true);
            try {
                field.set(o, value);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static Method findMethod(Class<?> clazz, String name) {
        return ReflectionUtils.findMethod(clazz, name, EMPTY_CLASS_ARRAY);
    }

    public static Method findMethod(Class<?> clazz, String name, Class<?> ... paramTypes) {
        List<Method> methods = ReflectionUtils.findMethods(clazz, name, paramTypes);
        if (ObjectUtils.isEmpty(methods)) {
            return null;
        }
        return methods.get(0);
    }

    public static List<Method> findMethods(Class<?> clazz, String name, Class<?> ... paramTypes) {
        Assert.isNotNull(clazz, "Class must not be null");
        Assert.isNotEmpty(name, "Method name must not be null");
        ArrayList<Method> methodList = new ArrayList<Method>();
        for (Class<?> searchType = clazz; searchType != null; searchType = searchType.getSuperclass()) {
            Method[] methods;
            for (Method method : methods = searchType.isInterface() ? searchType.getMethods() : ReflectionUtils.getDeclaredMethods(searchType, false)) {
                if (!name.equals(method.getName()) || paramTypes != null && !ReflectionUtils.hasSameParams(method, paramTypes)) continue;
                methodList.add(method);
            }
        }
        return methodList;
    }

    public static <T> T invoke(Object object, String methodName, Object ... params) throws RuntimeException {
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params[i].getClass();
        }
        Class<?> aClass = object.getClass();
        Method method = ReflectionUtils.findMethod(aClass, methodName, paramTypes);
        if (method == null) {
            throw new RuntimeException("Not found method : " + ReflectionUtils.methodToString(aClass, methodName, paramTypes));
        }
        try {
            Object invoke = method.invoke(object, params);
            if (invoke != null) {
                return (T)invoke;
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot call method : " + ReflectionUtils.methodToString(aClass, methodName, paramTypes), e);
        }
    }

    public static void setAttribute(Object bean, String setMethodName, Object setObject) throws Exception {
        Class<?> aClass = bean.getClass();
        Method setMethod = ReflectionUtils.findMethod(aClass, setMethodName, setObject.getClass());
        if (setMethod == null) {
            throw new Exception("Not found method[" + setMethodName + "] of :" + aClass.getName());
        }
        setMethod.invoke(bean, setObject);
    }

    private static Method[] getDeclaredMethods(Class<?> clazz, boolean defensive) {
        Assert.isNotNull(clazz, "Class must not be null");
        Method[] result = new Method[]{};
        try {
            Method[] declaredMethods = clazz.getDeclaredMethods();
            List<Method> defaultMethods = ReflectionUtils.findConcreteMethodsOnInterfaces(clazz);
            if (defaultMethods != null) {
                result = new Method[declaredMethods.length + defaultMethods.size()];
                System.arraycopy(declaredMethods, 0, result, 0, declaredMethods.length);
                int index = declaredMethods.length;
                Iterator<Method> iterator = defaultMethods.iterator();
                while (iterator.hasNext()) {
                    Method defaultMethod;
                    result[index] = defaultMethod = iterator.next();
                    ++index;
                }
            } else {
                result = declaredMethods;
            }
        }
        catch (Throwable ex) {
            throw new IllegalStateException("Failed to introspect Class [" + clazz.getName() + "] from ClassLoader [" + clazz.getClassLoader() + "]", ex);
        }
        return result;
    }

    private static List<Method> findConcreteMethodsOnInterfaces(Class<?> clazz) {
        ArrayList<Method> result = null;
        for (Class<?> ifc : clazz.getInterfaces()) {
            for (Method ifcMethod : ifc.getMethods()) {
                if (Modifier.isAbstract(ifcMethod.getModifiers())) continue;
                if (result == null) {
                    result = new ArrayList<Method>();
                }
                result.add(ifcMethod);
            }
        }
        return result;
    }

    private static boolean hasSameParams(Method method, Class<?>[] paramTypes) {
        if (paramTypes.length != method.getParameterCount()) {
            return false;
        }
        Class<?>[] parameterTypes = method.getParameterTypes();
        for (int i = 0; i < paramTypes.length; ++i) {
            Class<?> methodParamType = parameterTypes[i];
            Class<?> paramType = paramTypes[i];
            if (CompareClassTypeUtils.compare(methodParamType, paramType)) continue;
            return false;
        }
        return true;
    }

    public static NoSuchMethodException getNoSuchMethodException(Class<?> aClass, String name, Class<?>[] argTypes) {
        return new NoSuchMethodException("Not found method:" + ReflectionUtils.methodToString(aClass, name, argTypes));
    }

    public static String methodToString(Class<?> aClass, String name, Class<?>[] argTypes) {
        StringJoiner sj = new StringJoiner(", ", aClass.getName() + "." + name + "(", ")");
        if (argTypes != null) {
            for (Class<?> c : argTypes) {
                sj.add(c == null ? "null" : c.getName());
            }
        }
        return sj.toString();
    }
}

