/*
 * Decompiled with CFR 0.152.
 */
package com.gitee.starblues.utils;

import com.gitee.starblues.utils.ObjectUtils;

public class UrlUtils {
    public static final String PATH_SEPARATOR = "/";
    public static final String SEPARATOR_DOT = ".";
    public static final String SEPARATOR_BACKSLASH = "\\";

    private UrlUtils() {
    }

    public static String restJoiningPath(String path1, String path2) {
        if (path1 != null && path2 != null) {
            if (path1.endsWith(PATH_SEPARATOR) && path2.startsWith(PATH_SEPARATOR)) {
                return path1 + path2.substring(1);
            }
            if (!path1.endsWith(PATH_SEPARATOR) && !path2.startsWith(PATH_SEPARATOR)) {
                return path1 + PATH_SEPARATOR + path2;
            }
            return path1 + path2;
        }
        if (path1 != null) {
            return path1;
        }
        if (path2 != null) {
            return path2;
        }
        return "";
    }

    public static String joiningUrlPath(String ... paths) {
        if (paths == null || paths.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int length = paths.length;
        for (int i = 0; i < length; ++i) {
            String path = paths[i];
            if (ObjectUtils.isEmpty(path)) continue;
            if (i < length - 1 && path.endsWith(PATH_SEPARATOR)) {
                path = path.substring(path.lastIndexOf(PATH_SEPARATOR));
            }
            if (path.startsWith(PATH_SEPARATOR)) {
                stringBuilder.append(path);
                continue;
            }
            stringBuilder.append(PATH_SEPARATOR).append(path);
        }
        return stringBuilder.toString();
    }

    public static String format(String url) {
        if (ObjectUtils.isEmpty(url)) {
            return url;
        }
        String[] split = url.split(PATH_SEPARATOR);
        StringBuilder stringBuilder = new StringBuilder();
        int length = split.length;
        for (int i = 0; i < length; ++i) {
            String str = split[i];
            if (ObjectUtils.isEmpty(str)) continue;
            if (i < length - 1) {
                stringBuilder.append(str).append(PATH_SEPARATOR);
                continue;
            }
            stringBuilder.append(str);
        }
        return stringBuilder.toString();
    }

    public static String formatMatchUrl(String url) {
        if (url.contains(SEPARATOR_DOT)) {
            url = url.replace(SEPARATOR_DOT, PATH_SEPARATOR);
        }
        if (url.contains(SEPARATOR_BACKSLASH)) {
            url = url.replace(SEPARATOR_BACKSLASH, PATH_SEPARATOR);
        }
        if (url.startsWith(PATH_SEPARATOR)) {
            url = url.substring(url.indexOf(PATH_SEPARATOR) + 1);
        }
        return url;
    }
}

