/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata;

import cn.org.atool.fluent.mybatis.metadata.DbFeatures;
import cn.org.atool.fluent.mybatis.metadata.feature.DbFeature;
import cn.org.atool.fluent.mybatis.metadata.feature.EscapeExpress;
import cn.org.atool.fluent.mybatis.metadata.feature.PagedFormat;

public enum DbType {
    MYSQL(DbFeatures.DF_MYSQL),
    MARIADB(DbFeatures.DF_MARIADB),
    H2(DbFeatures.DF_H2),
    SQLITE(DbFeatures.DF_SQLITE),
    ORACLE(DbFeatures.DF_ORACLE),
    ORACLE12(DbFeatures.DF_ORACLE12),
    DB2(DbFeatures.DF_DB2),
    HSQL(DbFeatures.DF_HSQLDB),
    POSTGRE_SQL(DbFeatures.DF_POSTGRE_SQL),
    DERBY(DbFeatures.DF_DERBY),
    CLICK_HOUSE(DbFeatures.DF_CLICK_HOUSE),
    INFORMIX(DbFeatures.DF_INFORMIX),
    SQL_SERVER2005(DbFeatures.DF_SQL_SERVER2005),
    SQL_SERVER2012(DbFeatures.DF_SQL_SERVER2012),
    FIREBIRD(DbFeatures.DF_FIREBIRD),
    OTHER("other", PagedFormat.MYSQL_LIMIT),
    OTHER_2("other2", PagedFormat.MYSQL_LIMIT);

    public final DbFeature feature;

    private DbType(String alias, PagedFormat paged) {
        this.feature = new DbFeature(alias, paged);
    }

    private DbType(DbFeature feature) {
        this.feature = feature;
    }

    public String wrap(String column) {
        return this.feature.getEscape().wrap(column);
    }

    public String unwrap(String column) {
        return this.feature.getEscape().unwrap(column);
    }

    public String paged(String query, String pagedOffset, String pagedSize, String pagedEndOffset) {
        return this.feature.getPaged().build(query.trim(), pagedOffset, pagedSize, pagedEndOffset);
    }

    public void setEscapeExpress(String expression) {
        this.feature.setEscape(new EscapeExpress(expression));
    }

    public void setPagedFormat(String pagedFormat) {
        this.feature.setPaged(new PagedFormat(pagedFormat));
    }

    public static DbType dbType(String type) {
        for (DbType dbType : DbType.values()) {
            if (!dbType.name().equalsIgnoreCase(type)) continue;
            return dbType;
        }
        return null;
    }

    public static DbType getDbType(String driverName, String url) {
        DbType dbType = DbType.isDbType(driverName);
        if (dbType == null) {
            dbType = DbType.isDbType(url);
        }
        return dbType == null ? MYSQL : dbType;
    }

    private static DbType isDbType(String url) {
        DbType[] dbTypes;
        if (url == null || url.trim().isEmpty()) {
            return null;
        }
        String temp = url.toLowerCase();
        for (DbType type : dbTypes = DbType.values()) {
            if (!temp.contains(type.feature.getName().toLowerCase())) continue;
            return type;
        }
        return null;
    }

    public DbFeature getFeature() {
        return this.feature;
    }
}

