/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.metadata.feature;

import java.util.Objects;

public class PagedFormat {
    private static final int SELECT_LENS = "SELECT".length();
    protected final String format;
    public static final PagedFormat UN_SUPPORT_LIMIT = new PagedFormat(null);
    public static final PagedFormat MYSQL_LIMIT = new PagedFormat("{query} LIMIT {offset}, {size}");
    public static final PagedFormat PG_LIMIT = new PagedFormat("{query} LIMIT {size} OFFSET {offset}");
    public static final PagedFormat HSQLDB_LIMIT = new PagedFormat("{query} OFFSET {offset} ROWS LIMIT {size}");
    public static final PagedFormat DB2_LIMIT = new PagedFormat("SELECT * FROM (SELECT TMP_PAGE.*, ROW_NUMBER() OVER() AS RN FROM ({query}) AS TMP_PAGE) WHERE RN > {offset} AND RN <= {end}");
    public static final PagedFormat INFORMIX_LIMIT = new PagedFormat("SELECT SKIP %s FIRST %s %s"){

        @Override
        public String build(String query, String offset, String size, String endOffset) {
            String rest = PagedFormat.startWithSelect(query);
            if (rest != null) {
                return String.format(this.format, offset, size, rest.trim());
            }
            throw new RuntimeException("paged not support for sql:" + query);
        }
    };
    public static final PagedFormat SQLSERVER2005_LIMIT = DB2_LIMIT;
    public static final PagedFormat DERBY_LIMIT;
    public static final PagedFormat SQLSERVER2012_LIMIT;
    public static final PagedFormat ORACLE_LIMIT;
    public static final PagedFormat ORACLE12_LIMIT;
    public static final PagedFormat FIREBIRD_LIMIT;

    public PagedFormat(String format) {
        this.format = format;
    }

    public String build(String query, String offset, String size, String endOffset) {
        if (this.format == null || this.format.trim().isEmpty()) {
            throw new RuntimeException("paged not support by dbType");
        }
        return this.format.replace("{end}", endOffset).replace("{size}", size).replace("{offset}", offset).replace("{query}", query);
    }

    private static String startWithSelect(String query) {
        if (query.length() <= SELECT_LENS) {
            return null;
        }
        String select = query.substring(0, SELECT_LENS);
        if (Objects.equals(select.toUpperCase(), "SELECT")) {
            return query.substring(SELECT_LENS);
        }
        return null;
    }

    public String getFormat() {
        return this.format;
    }

    static {
        SQLSERVER2012_LIMIT = DERBY_LIMIT = new PagedFormat("{query} OFFSET {offset} ROWS FETCH NEXT {size} ROWS ONLY");
        ORACLE_LIMIT = new PagedFormat("SELECT * FROM (SELECT TMP_PAGE.*, ROWNUM RN FROM ({query}) TMP_PAGE) WHERE RN > {offset} AND RN <= {end}");
        ORACLE12_LIMIT = DERBY_LIMIT;
        FIREBIRD_LIMIT = new PagedFormat("{query} ROWS {offset} TO {end}");
    }
}

