/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.filer;

import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;

public abstract class AbstractFiler {
    protected FluentEntity fluent;
    protected String packageName;
    protected String klassName;
    protected String comment;

    public AbstractFiler(FluentEntity fluent) {
        this.fluent = fluent;
    }

    public final JavaFile javaFile() {
        TypeSpec.Builder builder = this.isInterface() ? TypeSpec.interfaceBuilder((String)this.klassName).addModifiers(new Modifier[]{Modifier.PUBLIC}) : TypeSpec.classBuilder((String)this.klassName).addModifiers(new Modifier[]{Modifier.PUBLIC});
        this.build(builder);
        CodeBlock comment = this.codeBlock("", this.klassName + (this.comment == null ? "" : ": " + this.comment), "", "@author powered by FluentMybatis");
        builder.addJavadoc(comment);
        JavaFile.Builder javaBuilder = JavaFile.builder((String)this.packageName, (TypeSpec)builder.build());
        this.staticImport(javaBuilder);
        return javaBuilder.build();
    }

    protected void staticImport(JavaFile.Builder spec) {
    }

    protected CodeBlock codeBlock(String ... lines) {
        return CodeBlock.join((Iterable)Stream.of(lines).map(x$0 -> CodeBlock.of((String)x$0, (Object[])new Object[0])).collect(Collectors.toList()), (String)"\n");
    }

    protected CodeBlock codeBlock(CodeBlock ... blocks) {
        return CodeBlock.join((Iterable)Stream.of(blocks).collect(Collectors.toList()), (String)"\n");
    }

    protected abstract void build(TypeSpec.Builder var1);

    protected TypeName parameterizedType(ClassName raw, TypeName ... paras) {
        return ParameterizedTypeName.get((ClassName)raw, (TypeName[])paras);
    }

    protected TypeName parameterizedType(Class raw, Class ... paras) {
        return ParameterizedTypeName.get((Class)raw, (Type[])paras);
    }

    protected abstract boolean isInterface();

    protected MethodSpec m_mapping() {
        return this.protectedMethod("mapping", true, (TypeName)ClassName.get(IMapping.class)).addStatement("return $T.MAPPING", new Object[]{this.fluent.mapping()}).build();
    }

    protected MethodSpec.Builder publicMethod(String methodName, boolean isOverride, Class returnKlass) {
        return this.publicMethod(methodName, isOverride, (TypeName)(returnKlass == null ? null : ClassName.get((Class)returnKlass)));
    }

    protected MethodSpec.Builder publicMethod(String methodName, boolean isOverride, TypeName returnKlass) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName);
        if (isOverride) {
            builder.addAnnotation(Override.class);
        }
        if (returnKlass != null) {
            builder.returns(returnKlass);
        }
        builder.addModifiers(new Modifier[]{Modifier.PUBLIC});
        return builder;
    }

    protected MethodSpec.Builder protectedMethod(String methodName, boolean isOverride, TypeName returnKlass) {
        MethodSpec.Builder builder = MethodSpec.methodBuilder((String)methodName);
        if (isOverride) {
            builder.addAnnotation(Override.class);
        }
        if (returnKlass != null) {
            builder.returns(returnKlass);
        }
        builder.addModifiers(new Modifier[]{Modifier.PROTECTED});
        return builder;
    }

    public static MethodSpec.Builder throwPrimaryNoFound(MethodSpec.Builder builder) {
        return builder.addStatement("throw new $T($S)", new Object[]{RuntimeException.class, "primary key not found."});
    }

    protected FieldSpec f_defaults() {
        return FieldSpec.builder((TypeName)this.fluent.defaults(), (String)"defaults", (Modifier[])new Modifier[]{Modifier.PRIVATE, Modifier.FINAL, Modifier.STATIC}).addJavadoc("\u9ed8\u8ba4\u8bbe\u7f6e\u5668", new Object[0]).initializer("$T.INSTANCE", new Object[]{this.fluent.defaults()}).build();
    }
}

