/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.filer;

import cn.org.atool.fluent.mybatis.base.IRefs;
import cn.org.atool.fluent.mybatis.processor.entity.EntityRefMethod;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.entity.FluentList;
import cn.org.atool.fluent.mybatis.processor.filer.refs.AllRefFiler;
import cn.org.atool.fluent.mybatis.processor.filer.refs.EntityRelationFiler;
import cn.org.atool.fluent.mybatis.utility.MybatisUtil;
import cn.org.atool.generator.javafile.AbstractFile;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class RefsFile
extends AbstractFile {
    private static final String Refs = "Refs";

    public static ClassName getClassName() {
        return ClassName.get((String)FluentList.refsPackage(), (String)Refs, (String[])new String[0]);
    }

    public RefsFile() {
        this.packageName = FluentList.refsPackage();
        this.klassName = Refs;
        this.comment = "\n o - \u67e5\u8be2\u5668\uff0c\u66f4\u65b0\u5668\u5de5\u5382\u7c7b\u5355\u4f8b\u5f15\u7528\n o - \u5e94\u7528\u6240\u6709Mapper Bean\u5f15\u7528\n o - Entity\u5173\u8054\u5bf9\u8c61\u5ef6\u8fdf\u52a0\u8f7d\u67e5\u8be2\u5b9e\u73b0";
    }

    protected void build(TypeSpec.Builder spec) {
        spec.superclass((TypeName)AllRefFiler.getClassName()).addModifiers(new Modifier[]{Modifier.FINAL}).addMethod(this.m_instance());
        for (FluentEntity fluent : FluentList.getFluents()) {
            for (EntityRefMethod refMethod : fluent.getRefMethods()) {
                if (refMethod.isAbstractMethod()) {
                    spec.addMethod(this.m_refMethod(fluent, refMethod));
                    continue;
                }
                spec.addMethod(this.m_refRealMethod(fluent, refMethod));
            }
        }
    }

    private MethodSpec m_refMethod(FluentEntity fluent, EntityRefMethod refMethod) {
        String methodName = refMethod.getRefMethod(fluent);
        return MethodSpec.methodBuilder((String)methodName).addParameter((TypeName)fluent.entity(), "entity", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(refMethod.getJavaType()).addJavadoc("{@link $L#$L}", new Object[]{fluent.getClassName(), refMethod.getName()}).addCode("if (relation instanceof $T) {\n", new Object[]{EntityRelationFiler.getClassName()}).addStatement("\treturn (($T)relation).$L(entity)", new Object[]{EntityRelationFiler.getClassName(), methodName}).addCode("} else {\n", new Object[0]).addStatement("\tthrow new $T($S)", new Object[]{RuntimeException.class, "It must implement IEntityRelation and add the implementation to spring management."}).addCode("}", new Object[0]).build();
    }

    private MethodSpec m_refRealMethod(FluentEntity fluent, EntityRefMethod refMethod) {
        FluentEntity ref = FluentList.getFluentEntity(refMethod.getReturnEntity());
        MethodSpec.Builder spec = MethodSpec.methodBuilder((String)refMethod.getRefMethod(fluent)).addParameter((TypeName)fluent.entity(), "entity", new Modifier[0]).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(refMethod.getJavaType()).addJavadoc("{@link $L#$L}", new Object[]{fluent.getClassName(), refMethod.getName()});
        String method = refMethod.returnList() ? "listEntity" : "findOne";
        spec.addCode("return mapper().$LMapper.$L(new $T()\n", new Object[]{ref.lowerNoSuffix(), method, ref.query()});
        int index = 0;
        for (Map.Entry<String, String> pair : refMethod.getMapping().entrySet()) {
            spec.addCode(index == 0 ? "\t.where" : "\t.and", new Object[0]).addCode(".$L().eq(entity.get$L())\n", new Object[]{pair.getKey(), MybatisUtil.capitalFirst((String)pair.getValue(), (String)"")});
            ++index;
        }
        spec.addStatement("\t.end())", new Object[0]);
        return spec.build();
    }

    private MethodSpec m_instance() {
        return MethodSpec.methodBuilder((String)"instance").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL}).addJavadoc("Refs \u5355\u4f8b", new Object[0]).returns((TypeName)RefsFile.getClassName()).addStatement("return ($L) $T.instance()", new Object[]{Refs, IRefs.class}).build();
    }

    protected boolean isInterface() {
        return false;
    }

    protected String generatorName() {
        return "FluentMybatis";
    }
}

