/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.filer.segment;

import cn.org.atool.fluent.mybatis.base.IEntity;
import cn.org.atool.fluent.mybatis.base.entity.IEntityHelper;
import cn.org.atool.fluent.mybatis.base.model.EntityToMap;
import cn.org.atool.fluent.mybatis.processor.base.FluentClassName;
import cn.org.atool.fluent.mybatis.processor.entity.CommonField;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.filer.AbstractFiler;
import cn.org.atool.fluent.mybatis.processor.filer.ClassNames2;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.squareup.javapoet.TypeVariableName;
import java.lang.reflect.Type;
import java.util.Map;
import javax.lang.model.element.Modifier;

public class EntityHelperFiler
extends AbstractFiler {
    public static String getClassName(FluentClassName fluent) {
        return fluent.getClassName() + "Helper";
    }

    public static String getPackageName(FluentClassName fluent) {
        return fluent.getEntityPack();
    }

    public EntityHelperFiler(FluentEntity fluentEntity) {
        super(fluentEntity);
        this.packageName = EntityHelperFiler.getPackageName(fluentEntity);
        this.klassName = EntityHelperFiler.getClassName(fluentEntity);
        this.comment = "Entity\u5e2e\u52a9\u7c7b";
    }

    @Override
    protected void staticImport(JavaFile.Builder spec) {
        spec.addStaticImport(this.fluent.mapping(), new String[]{"*"});
        super.staticImport(spec);
    }

    @Override
    protected void build(TypeSpec.Builder builder) {
        builder.addSuperinterface(IEntityHelper.class).addMethod(this.m_toColumnMap()).addMethod(this.m_toEntityMap()).addMethod(this.m_toMap()).addMethod(this.m_toEntity()).addMethod(this.m_copy());
    }

    private MethodSpec m_toColumnMap() {
        return super.publicMethod("toColumnMap", true, (TypeName)ClassNames2.CN_Map_StrObj).addParameter(IEntity.class, "entity", new Modifier[0]).addParameter(ClassName.BOOLEAN, "isNoN", new Modifier[0]).addStatement("return this.toMap(($T)entity, false, isNoN)", new Object[]{this.fluent.entity()}).build();
    }

    private MethodSpec m_toEntityMap() {
        return super.publicMethod("toEntityMap", true, (TypeName)ClassNames2.CN_Map_StrObj).addParameter(IEntity.class, "entity", new Modifier[0]).addParameter(ClassName.BOOLEAN, "isNoN", new Modifier[0]).addStatement("return this.toMap(($T)entity, true, isNoN)", new Object[]{this.fluent.entity()}).build();
    }

    private MethodSpec m_toMap() {
        MethodSpec.Builder builder = super.publicMethod("toMap", false, (TypeName)ClassNames2.CN_Map_StrObj).addParameter((TypeName)this.fluent.entity(), "entity", new Modifier[0]).addParameter(TypeName.BOOLEAN, "isProperty", new Modifier[0]).addParameter(ClassName.BOOLEAN, "isNoN", new Modifier[0]).addCode("return new $T(isProperty)\n", new Object[]{EntityToMap.class});
        for (CommonField fc : this.fluent.getFields()) {
            String getMethod = fc.getMethodName();
            builder.addCode("\t.put($L, entity.$L(), isNoN)\n", new Object[]{fc.getName(), getMethod});
        }
        return builder.addCode("\t.getMap();", new Object[0]).build();
    }

    private MethodSpec m_toEntity() {
        MethodSpec.Builder builder = super.publicMethod("toEntity", true, (TypeName)TypeVariableName.get((String)"E")).addParameter(this.parameterizedType(Map.class, String.class, Object.class), "map", new Modifier[0]).addTypeVariable(TypeVariableName.get((String)"E", (Type[])new Type[]{IEntity.class})).addStatement("$T entity = new $T()", new Object[]{this.fluent.entity(), this.fluent.entity()});
        for (CommonField fc : this.fluent.getFields()) {
            String setMethod = fc.setMethodName();
            builder.addCode("if (map.containsKey($L.name)) {\n", new Object[]{fc.getName()});
            builder.addCode("\tentity.$L(($T) map.get($L.name));\n", new Object[]{setMethod, fc.getJavaType(), fc.getName()});
            builder.addCode("}\n", new Object[0]);
        }
        return builder.addStatement("return (E)entity", new Object[0]).build();
    }

    private MethodSpec m_copy() {
        MethodSpec.Builder builder = super.publicMethod("copy", true, (TypeName)this.fluent.entity()).addParameter(IEntity.class, "iEntity", new Modifier[0]).addStatement("$T entity = ($T) iEntity", new Object[]{this.fluent.entity(), this.fluent.entity()}).addStatement("$T copy = new $T()", new Object[]{this.fluent.entity(), this.fluent.entity()});
        builder.addCode("{\n", new Object[0]);
        for (CommonField fc : this.fluent.getFields()) {
            builder.addStatement("\tcopy.$L(entity.$L())", new Object[]{fc.setMethodName(), fc.getMethodName()});
        }
        builder.addCode("}\n", new Object[0]);
        return builder.addStatement("return copy", new Object[0]).build();
    }

    @Override
    protected boolean isInterface() {
        return false;
    }
}

