/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.filer.segment;

import cn.org.atool.fluent.mybatis.If;
import cn.org.atool.fluent.mybatis.base.entity.IMapping;
import cn.org.atool.fluent.mybatis.base.model.FieldMapping;
import cn.org.atool.fluent.mybatis.base.model.FieldType;
import cn.org.atool.fluent.mybatis.processor.base.FluentClassName;
import cn.org.atool.fluent.mybatis.processor.entity.CommonField;
import cn.org.atool.fluent.mybatis.processor.entity.FieldOrMethod;
import cn.org.atool.fluent.mybatis.processor.entity.FluentEntity;
import cn.org.atool.fluent.mybatis.processor.filer.AbstractFiler;
import cn.org.atool.fluent.mybatis.processor.filer.ClassNames2;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.lang.model.element.Modifier;

public class MappingFiler
extends AbstractFiler {
    public static String getClassName(FluentClassName fluentEntity) {
        return fluentEntity.getNoSuffix() + "Mapping";
    }

    public static String getPackageName(FluentClassName fluentEntity) {
        return fluentEntity.getPackageName("helper");
    }

    public MappingFiler(FluentEntity fluentEntity) {
        super(fluentEntity);
        this.packageName = MappingFiler.getPackageName(fluentEntity);
        this.klassName = MappingFiler.getClassName(fluentEntity);
        this.comment = "Entity\u7c7b\u5b57\u6bb5\u548c\u8868\u7ed3\u6784\u6620\u5c04";
    }

    @Override
    protected void staticImport(JavaFile.Builder spec) {
        spec.addStaticImport(Optional.class, new String[]{"ofNullable"});
    }

    @Override
    public void build(TypeSpec.Builder spec) {
        spec.addSuperinterface(IMapping.class).addField(this.f_instance()).addField(this.f_Table_Name()).addField(this.f_Entity_Name());
        this.fluent.getFields().forEach(field -> spec.addField(this.f_Field((CommonField)field)));
        spec.addField(this.f_Property2Column()).addField(this.f_Column2Mapping()).addField(this.f_ALL_COLUMNS()).addField(this.f_ALL_JOIN_COLUMNS()).addMethod(this.m_findColumnByField()).addMethod(this.m_findField());
    }

    private MethodSpec m_findField() {
        MethodSpec.Builder spec = super.publicMethod("findField", true, (TypeName)ClassNames2.CN_Optional_Mapping).addParameter(FieldType.class, "type", new Modifier[0]).addModifiers(new Modifier[]{Modifier.DEFAULT}).addCode("switch (type) {\n", new Object[0]);
        if (this.fluent.getPrimary() != null) {
            spec.addCode("\tcase PRIMARY_ID:\n", new Object[0]).addStatement("\t\treturn ofNullable($L)", new Object[]{this.fluent.getPrimary().getName()});
        }
        if (If.notBlank((CharSequence)this.fluent.getLogicDelete())) {
            spec.addCode("\tcase LOGIC_DELETED:\n", new Object[0]).addStatement("\t\treturn ofNullable($L)", new Object[]{this.fluent.getLogicDelete()});
        }
        if (If.notBlank((CharSequence)this.fluent.getVersionField())) {
            spec.addCode("\tcase LOCK_VERSION:\n", new Object[0]).addStatement("\t\treturn ofNullable($L)", new Object[]{this.fluent.getVersionField()});
        }
        return spec.addCode("\tdefault:\n", new Object[0]).addStatement("\t\treturn ofNullable(null)", new Object[0]).addCode("}", new Object[0]).build();
    }

    private MethodSpec m_findColumnByField() {
        return super.publicMethod("findColumnByField", true, String.class).addParameter(String.class, "field", new Modifier[0]).addModifiers(new Modifier[]{Modifier.DEFAULT}).addStatement("return Property2Column.get(field)", new Object[0]).build();
    }

    private FieldSpec f_Field(CommonField fc) {
        FieldSpec.Builder spec = FieldSpec.builder(FieldMapping.class, (String)fc.getName(), (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.PUBLIC, Modifier.FINAL}).addJavadoc("\u5b9e\u4f53\u5c5e\u6027 : \u6570\u636e\u5e93\u5b57\u6bb5 \u6620\u5c04\n $L : $L", new Object[]{fc.getName(), fc.getColumn()});
        if (fc.getTypeHandler() == null) {
            return spec.initializer("new FieldMapping($S, $S)", new Object[]{fc.getName(), fc.getColumn()}).build();
        }
        return spec.initializer("new FieldMapping($S, $S, $T.class, $T.class)", new Object[]{fc.getName(), fc.getColumn(), fc.getJavaType(), fc.getTypeHandler()}).build();
    }

    @Override
    protected boolean isInterface() {
        return true;
    }

    private FieldSpec f_Table_Name() {
        return FieldSpec.builder(String.class, (String)"Table_Name", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PUBLIC}).initializer("$S", new Object[]{this.fluent.getTableName()}).addJavadoc(super.codeBlock("\u8868\u540d\u79f0")).build();
    }

    private FieldSpec f_Entity_Name() {
        return FieldSpec.builder(String.class, (String)"Entity_Name", (Modifier[])new Modifier[]{Modifier.STATIC, Modifier.FINAL, Modifier.PUBLIC}).initializer("$S", new Object[]{this.fluent.getClassName()}).addJavadoc(super.codeBlock("Entity\u540d\u79f0")).build();
    }

    private FieldSpec f_Column2Mapping() {
        String statement = this.fluent.getFields().stream().map(FieldOrMethod::getName).map(field -> String.format("\t\tthis.put(%s.column, %s);", field, field)).collect(Collectors.joining("\n"));
        return FieldSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, FieldMapping.class}), (String)"Column2Mapping", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).addJavadoc("\u6570\u636e\u5e93\u5b57\u6bb5\u5bf9\u5e94\u7684FieldMapping", new Object[0]).initializer(this.codeBlock(CodeBlock.of((String)"new $T<String, $T>() {", (Object[])new Object[]{HashMap.class, FieldMapping.class}), CodeBlock.of((String)"  {", (Object[])new Object[0]), CodeBlock.of((String)statement, (Object[])new Object[0]), CodeBlock.of((String)"  }", (Object[])new Object[0]), CodeBlock.of((String)"}", (Object[])new Object[0]))).build();
    }

    private FieldSpec f_instance() {
        return FieldSpec.builder((TypeName)this.fluent.mapping(), (String)"MAPPING", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).initializer("new $T(){}", new Object[]{this.fluent.mapping()}).build();
    }

    private FieldSpec f_Property2Column() {
        String statement = this.fluent.getFields().stream().map(FieldOrMethod::getName).map(field -> String.format("\t\tthis.put(%s.name, %s.column);", field, field)).collect(Collectors.joining("\n"));
        return FieldSpec.builder((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, String.class}), (String)"Property2Column", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).addJavadoc("\u5b9e\u4f8b\u5c5e\u6027\u548c\u6570\u636e\u5e93\u5b57\u6bb5\u5bf9\u5e94\u8868", new Object[0]).initializer(this.codeBlock(CodeBlock.of((String)"new $T<String, String>() {", (Object[])new Object[]{HashMap.class}), CodeBlock.of((String)"  {", (Object[])new Object[0]), CodeBlock.of((String)statement, (Object[])new Object[0]), CodeBlock.of((String)"  }", (Object[])new Object[0]), CodeBlock.of((String)"}", (Object[])new Object[0]))).build();
    }

    private FieldSpec f_ALL_COLUMNS() {
        String statement = this.fluent.getFields().stream().map(FieldOrMethod::getName).map(field -> String.format("\t\t%s.column", field)).collect(Collectors.joining(",\n"));
        return FieldSpec.builder((TypeName)ParameterizedTypeName.get(List.class, (Type[])new Type[]{String.class}), (String)"ALL_COLUMNS", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).addJavadoc("\u6570\u636e\u5e93\u6240\u6709\u5b57\u6bb5\u5217\u8868", new Object[0]).initializer(this.codeBlock(CodeBlock.of((String)"$T.asList(", (Object[])new Object[]{Arrays.class}), CodeBlock.of((String)statement, (Object[])new Object[0]), CodeBlock.of((String)")", (Object[])new Object[0]))).build();
    }

    private FieldSpec f_ALL_JOIN_COLUMNS() {
        return FieldSpec.builder(String.class, (String)"ALL_JOIN_COLUMNS", (Modifier[])new Modifier[]{Modifier.PUBLIC, Modifier.FINAL, Modifier.STATIC}).addJavadoc("\u6570\u636e\u5e93\u6240\u6709\u5b57\u6bb5\u5217\u8868\u7528\u9017\u53f7\u5206\u9694", new Object[0]).initializer("String.join($S, ALL_COLUMNS)", new Object[]{", "}).build();
    }
}

