/*
 * Decompiled with CFR 0.152.
 */
package cn.org.atool.fluent.mybatis.processor.scanner;

import cn.org.atool.fluent.mybatis.annotation.FluentMybatis;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;

public class ClassAttrParser {
    public static final String ATTR_DEFAULTS = "defaults()";
    public static final String ATTR_SUPER_MAPPER = "superMapper()";

    public static String getClassAttr(TypeElement entity, String methodName, Class defaultValue) {
        AnnotationMirror mirror = ClassAttrParser.getFluentMyBatisMirror(entity);
        if (mirror == null) {
            return defaultValue.getName();
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement method = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!method.toString().contains(methodName)) continue;
            DeclaredType aClass = (DeclaredType)value.getValue();
            return aClass.toString();
        }
        return defaultValue.getName();
    }

    private static AnnotationMirror getFluentMyBatisMirror(TypeElement entity) {
        List<? extends AnnotationMirror> annotations = entity.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotations) {
            if (!annotationMirror.getAnnotationType().toString().contains(FluentMybatis.class.getSimpleName())) continue;
            return annotationMirror;
        }
        return null;
    }
}

