/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.cp.bean.message;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import me.chanjar.weixin.cp.bean.article.NewArticle;

public class WxCpGroupRobotMessage {
    private String msgType;
    private String content;
    private List<String> mentionedList;
    private List<String> mentionedMobileList;
    private String base64;
    private String md5;
    private List<NewArticle> articles;

    public String toJson() {
        JsonObject messageJson = new JsonObject();
        messageJson.addProperty("msgtype", this.getMsgType());
        switch (this.getMsgType()) {
            case "text": {
                JsonObject text = new JsonObject();
                JsonArray uidJsonArray = new JsonArray();
                JsonArray mobileJsonArray = new JsonArray();
                text.addProperty("content", this.getContent());
                if (this.getMentionedList() != null) {
                    for (String item : this.getMentionedList()) {
                        uidJsonArray.add(item);
                    }
                }
                if (this.getMentionedMobileList() != null) {
                    for (String item : this.getMentionedMobileList()) {
                        mobileJsonArray.add(item);
                    }
                }
                text.add("mentioned_list", (JsonElement)uidJsonArray);
                text.add("mentioned_mobile_list", (JsonElement)mobileJsonArray);
                messageJson.add("text", (JsonElement)text);
                break;
            }
            case "markdown": {
                JsonObject text = new JsonObject();
                text.addProperty("content", this.getContent());
                messageJson.add("markdown", (JsonElement)text);
                break;
            }
            case "image": {
                JsonObject text = new JsonObject();
                text.addProperty("base64", this.getBase64());
                text.addProperty("md5", this.getMd5());
                messageJson.add("image", (JsonElement)text);
                break;
            }
            case "news": {
                JsonObject text = new JsonObject();
                JsonArray array = new JsonArray();
                for (NewArticle article : this.getArticles()) {
                    JsonObject articleJson = new JsonObject();
                    articleJson.addProperty("title", article.getTitle());
                    articleJson.addProperty("description", article.getDescription());
                    articleJson.addProperty("url", article.getUrl());
                    articleJson.addProperty("picurl", article.getPicUrl());
                    array.add((JsonElement)articleJson);
                }
                text.add("articles", (JsonElement)array);
                messageJson.add("news", (JsonElement)text);
                break;
            }
        }
        return messageJson.toString();
    }

    public WxCpGroupRobotMessage(String msgType, String content, List<String> mentionedList, List<String> mentionedMobileList, String base64, String md5, List<NewArticle> articles) {
        this.msgType = msgType;
        this.content = content;
        this.mentionedList = mentionedList;
        this.mentionedMobileList = mentionedMobileList;
        this.base64 = base64;
        this.md5 = md5;
        this.articles = articles;
    }

    public WxCpGroupRobotMessage() {
    }

    public String getMsgType() {
        return this.msgType;
    }

    public String getContent() {
        return this.content;
    }

    public List<String> getMentionedList() {
        return this.mentionedList;
    }

    public List<String> getMentionedMobileList() {
        return this.mentionedMobileList;
    }

    public String getBase64() {
        return this.base64;
    }

    public String getMd5() {
        return this.md5;
    }

    public List<NewArticle> getArticles() {
        return this.articles;
    }

    public WxCpGroupRobotMessage setMsgType(String msgType) {
        this.msgType = msgType;
        return this;
    }

    public WxCpGroupRobotMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public WxCpGroupRobotMessage setMentionedList(List<String> mentionedList) {
        this.mentionedList = mentionedList;
        return this;
    }

    public WxCpGroupRobotMessage setMentionedMobileList(List<String> mentionedMobileList) {
        this.mentionedMobileList = mentionedMobileList;
        return this;
    }

    public WxCpGroupRobotMessage setBase64(String base64) {
        this.base64 = base64;
        return this;
    }

    public WxCpGroupRobotMessage setMd5(String md5) {
        this.md5 = md5;
        return this;
    }

    public WxCpGroupRobotMessage setArticles(List<NewArticle> articles) {
        this.articles = articles;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WxCpGroupRobotMessage)) {
            return false;
        }
        WxCpGroupRobotMessage other = (WxCpGroupRobotMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$msgType = this.getMsgType();
        String other$msgType = other.getMsgType();
        if (this$msgType == null ? other$msgType != null : !this$msgType.equals(other$msgType)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        List<String> this$mentionedList = this.getMentionedList();
        List<String> other$mentionedList = other.getMentionedList();
        if (this$mentionedList == null ? other$mentionedList != null : !((Object)this$mentionedList).equals(other$mentionedList)) {
            return false;
        }
        List<String> this$mentionedMobileList = this.getMentionedMobileList();
        List<String> other$mentionedMobileList = other.getMentionedMobileList();
        if (this$mentionedMobileList == null ? other$mentionedMobileList != null : !((Object)this$mentionedMobileList).equals(other$mentionedMobileList)) {
            return false;
        }
        String this$base64 = this.getBase64();
        String other$base64 = other.getBase64();
        if (this$base64 == null ? other$base64 != null : !this$base64.equals(other$base64)) {
            return false;
        }
        String this$md5 = this.getMd5();
        String other$md5 = other.getMd5();
        if (this$md5 == null ? other$md5 != null : !this$md5.equals(other$md5)) {
            return false;
        }
        List<NewArticle> this$articles = this.getArticles();
        List<NewArticle> other$articles = other.getArticles();
        return !(this$articles == null ? other$articles != null : !((Object)this$articles).equals(other$articles));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WxCpGroupRobotMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $msgType = this.getMsgType();
        result = result * 59 + ($msgType == null ? 43 : $msgType.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        List<String> $mentionedList = this.getMentionedList();
        result = result * 59 + ($mentionedList == null ? 43 : ((Object)$mentionedList).hashCode());
        List<String> $mentionedMobileList = this.getMentionedMobileList();
        result = result * 59 + ($mentionedMobileList == null ? 43 : ((Object)$mentionedMobileList).hashCode());
        String $base64 = this.getBase64();
        result = result * 59 + ($base64 == null ? 43 : $base64.hashCode());
        String $md5 = this.getMd5();
        result = result * 59 + ($md5 == null ? 43 : $md5.hashCode());
        List<NewArticle> $articles = this.getArticles();
        result = result * 59 + ($articles == null ? 43 : ((Object)$articles).hashCode());
        return result;
    }

    public String toString() {
        return "WxCpGroupRobotMessage(msgType=" + this.getMsgType() + ", content=" + this.getContent() + ", mentionedList=" + this.getMentionedList() + ", mentionedMobileList=" + this.getMentionedMobileList() + ", base64=" + this.getBase64() + ", md5=" + this.getMd5() + ", articles=" + this.getArticles() + ")";
    }
}

