/*
 * Decompiled with CFR 0.152.
 */
package cn.binarywang.wx.miniapp.api.impl;

import cn.binarywang.wx.miniapp.api.WxMaAnalysisService;
import cn.binarywang.wx.miniapp.api.WxMaCloudService;
import cn.binarywang.wx.miniapp.api.WxMaCodeService;
import cn.binarywang.wx.miniapp.api.WxMaExpressService;
import cn.binarywang.wx.miniapp.api.WxMaJsapiService;
import cn.binarywang.wx.miniapp.api.WxMaLiveGoodsService;
import cn.binarywang.wx.miniapp.api.WxMaLiveService;
import cn.binarywang.wx.miniapp.api.WxMaMediaService;
import cn.binarywang.wx.miniapp.api.WxMaMsgService;
import cn.binarywang.wx.miniapp.api.WxMaPluginService;
import cn.binarywang.wx.miniapp.api.WxMaQrcodeService;
import cn.binarywang.wx.miniapp.api.WxMaRunService;
import cn.binarywang.wx.miniapp.api.WxMaSecCheckService;
import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.api.WxMaSettingService;
import cn.binarywang.wx.miniapp.api.WxMaShareService;
import cn.binarywang.wx.miniapp.api.WxMaSubscribeService;
import cn.binarywang.wx.miniapp.api.WxMaTemplateService;
import cn.binarywang.wx.miniapp.api.WxMaUserService;
import cn.binarywang.wx.miniapp.api.impl.WxMaAnalysisServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaCloudServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaCodeServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaExpressServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaJsapiServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaLiveGoodsServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaLiveServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaMediaServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaMsgServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaOcrServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaPluginServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaQrcodeServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaRunServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaSecCheckServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaSettingServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaShareServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaSubscribeServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaTemplateServiceImpl;
import cn.binarywang.wx.miniapp.api.impl.WxMaUserServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import me.chanjar.weixin.common.WxType;
import me.chanjar.weixin.common.api.WxOcrService;
import me.chanjar.weixin.common.bean.WxAccessToken;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.DataUtils;
import me.chanjar.weixin.common.util.crypto.SHA1;
import me.chanjar.weixin.common.util.http.RequestExecutor;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.SimpleGetRequestExecutor;
import me.chanjar.weixin.common.util.http.SimplePostRequestExecutor;
import me.chanjar.weixin.common.util.json.GsonParser;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseWxMaServiceImpl<H, P>
implements WxMaService,
RequestHttp<H, P> {
    private static final Logger log = LoggerFactory.getLogger(BaseWxMaServiceImpl.class);
    private WxMaConfig wxMaConfig;
    private final WxMaMsgService kefuService = new WxMaMsgServiceImpl(this);
    private final WxMaMediaService materialService = new WxMaMediaServiceImpl(this);
    private final WxMaUserService userService = new WxMaUserServiceImpl(this);
    private final WxMaQrcodeService qrCodeService = new WxMaQrcodeServiceImpl(this);
    private final WxMaTemplateService templateService = new WxMaTemplateServiceImpl(this);
    private final WxMaAnalysisService analysisService = new WxMaAnalysisServiceImpl(this);
    private final WxMaCodeService codeService = new WxMaCodeServiceImpl(this);
    private final WxMaSettingService settingService = new WxMaSettingServiceImpl(this);
    private final WxMaJsapiService jsapiService = new WxMaJsapiServiceImpl(this);
    private final WxMaShareService shareService = new WxMaShareServiceImpl(this);
    private final WxMaRunService runService = new WxMaRunServiceImpl(this);
    private final WxMaSecCheckService secCheckService = new WxMaSecCheckServiceImpl(this);
    private final WxMaPluginService pluginService = new WxMaPluginServiceImpl(this);
    private final WxMaExpressService expressService = new WxMaExpressServiceImpl(this);
    private final WxMaSubscribeService subscribeService = new WxMaSubscribeServiceImpl(this);
    private final WxMaCloudService cloudService = new WxMaCloudServiceImpl(this);
    private final WxMaLiveService liveService = new WxMaLiveServiceImpl(this);
    private final WxMaLiveGoodsService liveGoodsService = new WxMaLiveGoodsServiceImpl(this);
    private final WxOcrService ocrService = new WxMaOcrServiceImpl(this);
    private int retrySleepMillis = 1000;
    private int maxRetryTimes = 5;
    protected static final Gson GSON = new Gson();

    @Override
    public RequestHttp getRequestHttp() {
        return this;
    }

    @Override
    public String getPaidUnionId(String openid, String transactionId, String mchId, String outTradeNo) throws WxErrorException {
        String responseContent;
        WxError error;
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("openid", openid);
        if (StringUtils.isNotEmpty((CharSequence)transactionId)) {
            params.put("transaction_id", transactionId);
        }
        if (StringUtils.isNotEmpty((CharSequence)mchId)) {
            params.put("mch_id", mchId);
        }
        if (StringUtils.isNotEmpty((CharSequence)outTradeNo)) {
            params.put("out_trade_no", outTradeNo);
        }
        if ((error = WxError.fromJson((String)(responseContent = this.get("https://api.weixin.qq.com/wxa/getpaidunionid", Joiner.on((String)"&").withKeyValueSeparator("=").join(params))), (WxType)WxType.MiniApp)).getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        return GsonParser.parse((String)responseContent).get("unionid").getAsString();
    }

    @Override
    public WxMaJscode2SessionResult jsCode2SessionInfo(String jsCode) throws WxErrorException {
        WxMaConfig config = this.getWxMaConfig();
        HashMap<String, String> params = new HashMap<String, String>(8);
        params.put("appid", config.getAppid());
        params.put("secret", config.getSecret());
        params.put("js_code", jsCode);
        params.put("grant_type", "authorization_code");
        String result = this.get("https://api.weixin.qq.com/sns/jscode2session", Joiner.on((String)"&").withKeyValueSeparator("=").join(params));
        return WxMaJscode2SessionResult.fromJson(result);
    }

    @Override
    public void setDynamicData(int lifespan, String type, int scene, String data) throws WxErrorException {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("lifespan", (Number)lifespan);
        jsonObject.addProperty("query", WxGsonBuilder.create().toJson((Object)ImmutableMap.of((Object)"type", (Object)type)));
        jsonObject.addProperty("data", data);
        jsonObject.addProperty("scene", (Number)scene);
        this.post("https://api.weixin.qq.com/wxa/setdynamicdata", jsonObject.toString());
    }

    @Override
    public boolean checkSignature(String timestamp, String nonce, String signature) {
        try {
            return SHA1.gen((String[])new String[]{this.getWxMaConfig().getToken(), timestamp, nonce}).equals(signature);
        }
        catch (Exception e) {
            log.error("Checking signature failed, and the reason is :" + e.getMessage());
            return false;
        }
    }

    @Override
    public String getAccessToken() throws WxErrorException {
        return this.getAccessToken(false);
    }

    @Override
    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        if (!forceRefresh && !this.getWxMaConfig().isAccessTokenExpired()) {
            return this.getWxMaConfig().getAccessToken();
        }
        Lock lock = this.getWxMaConfig().getAccessTokenLock();
        boolean locked = false;
        try {
            do {
                locked = lock.tryLock(100L, TimeUnit.MILLISECONDS);
                if (forceRefresh || this.getWxMaConfig().isAccessTokenExpired()) continue;
                String string = this.getWxMaConfig().getAccessToken();
                return string;
            } while (!locked);
            String response = this.doGetAccessTokenRequest();
            String string = this.extractAccessToken(response);
            return string;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (locked) {
                lock.unlock();
            }
        }
    }

    protected abstract String doGetAccessTokenRequest() throws IOException;

    public String get(String url, String queryParam) throws WxErrorException {
        return (String)this.execute(SimpleGetRequestExecutor.create((RequestHttp)this), url, queryParam);
    }

    public String post(String url, String postData) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, postData);
    }

    public String post(String url, Object obj) throws WxErrorException {
        return (String)this.execute(SimplePostRequestExecutor.create((RequestHttp)this), url, WxGsonBuilder.create().toJson(obj));
    }

    @Override
    public <T, E> T execute(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        int retryTimes = 0;
        while (true) {
            try {
                return this.executeInternal(executor, uri, data);
            }
            catch (WxErrorException e) {
                if (retryTimes + 1 > this.maxRetryTimes) {
                    log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                    throw new WxErrorException(WxError.builder().errorCode(e.getError().getErrorCode()).errorMsg("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570\uff01").build());
                }
                WxError error = e.getError();
                if (error.getErrorCode() == -1) {
                    int sleepMillis = this.retrySleepMillis * (1 << retryTimes);
                    try {
                        log.warn("\u5fae\u4fe1\u7cfb\u7edf\u7e41\u5fd9\uff0c{} ms \u540e\u91cd\u8bd5(\u7b2c{}\u6b21)", (Object)sleepMillis, (Object)(retryTimes + 1));
                        Thread.sleep(sleepMillis);
                    }
                    catch (InterruptedException e1) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                throw e;
                if (retryTimes++ < this.maxRetryTimes) continue;
                log.warn("\u91cd\u8bd5\u8fbe\u5230\u6700\u5927\u6b21\u6570\u3010{}\u3011", (Object)this.maxRetryTimes);
                throw new RuntimeException("\u5fae\u4fe1\u670d\u52a1\u7aef\u5f02\u5e38\uff0c\u8d85\u51fa\u91cd\u8bd5\u6b21\u6570");
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T, E> T executeInternal(RequestExecutor<T, E> executor, String uri, E data) throws WxErrorException {
        Object dataForLog = DataUtils.handleDataWithSecret(data);
        if (uri.contains("access_token=")) {
            throw new IllegalArgumentException("uri\u53c2\u6570\u4e2d\u4e0d\u5141\u8bb8\u6709access_token: " + uri);
        }
        String accessToken = this.getAccessToken(false);
        String uriWithAccessToken = uri + (uri.contains("?") ? "&" : "?") + "access_token=" + accessToken;
        try {
            Object result = executor.execute(uriWithAccessToken, data, WxType.MiniApp);
            log.debug("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u54cd\u5e94\u6570\u636e\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, result});
            return (T)result;
        }
        catch (WxErrorException e) {
            WxError error = e.getError();
            if (error.getErrorCode() == 40001 || error.getErrorCode() == 42001 || error.getErrorCode() == 40014) {
                Lock lock = this.getWxMaConfig().getAccessTokenLock();
                lock.lock();
                try {
                    if (StringUtils.equals((CharSequence)this.getWxMaConfig().getAccessToken(), (CharSequence)accessToken)) {
                        this.getWxMaConfig().expireAccessToken();
                    }
                }
                catch (Exception ex) {
                    this.getWxMaConfig().expireAccessToken();
                }
                finally {
                    lock.unlock();
                }
                if (this.getWxMaConfig().autoRefreshToken()) {
                    return this.execute(executor, uri, data);
                }
            }
            if (error.getErrorCode() != 0) {
                log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u9519\u8bef\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, error});
                throw new WxErrorException(error, (Throwable)e);
            }
            return null;
        }
        catch (IOException e) {
            log.error("\n\u3010\u8bf7\u6c42\u5730\u5740\u3011: {}\n\u3010\u8bf7\u6c42\u53c2\u6570\u3011\uff1a{}\n\u3010\u5f02\u5e38\u4fe1\u606f\u3011\uff1a{}", new Object[]{uriWithAccessToken, dataForLog, e.getMessage()});
            throw new RuntimeException(e);
        }
    }

    protected String extractAccessToken(String resultContent) throws WxErrorException {
        WxMaConfig config = this.getWxMaConfig();
        WxError error = WxError.fromJson((String)resultContent, (WxType)WxType.MiniApp);
        if (error.getErrorCode() != 0) {
            throw new WxErrorException(error);
        }
        WxAccessToken accessToken = WxAccessToken.fromJson((String)resultContent);
        config.updateAccessToken(accessToken.getAccessToken(), accessToken.getExpiresIn());
        return accessToken.getAccessToken();
    }

    @Override
    public WxMaConfig getWxMaConfig() {
        return this.wxMaConfig;
    }

    @Override
    public void setWxMaConfig(WxMaConfig wxConfigProvider) {
        this.wxMaConfig = wxConfigProvider;
        this.initHttp();
    }

    @Override
    public void setRetrySleepMillis(int retrySleepMillis) {
        this.retrySleepMillis = retrySleepMillis;
    }

    @Override
    public void setMaxRetryTimes(int maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    @Override
    public WxMaMsgService getMsgService() {
        return this.kefuService;
    }

    @Override
    public WxMaMediaService getMediaService() {
        return this.materialService;
    }

    @Override
    public WxMaUserService getUserService() {
        return this.userService;
    }

    @Override
    public WxMaQrcodeService getQrcodeService() {
        return this.qrCodeService;
    }

    @Override
    public WxMaTemplateService getTemplateService() {
        return this.templateService;
    }

    @Override
    public WxMaSubscribeService getSubscribeService() {
        return this.subscribeService;
    }

    @Override
    public WxMaAnalysisService getAnalysisService() {
        return this.analysisService;
    }

    @Override
    public WxMaCodeService getCodeService() {
        return this.codeService;
    }

    @Override
    public WxMaJsapiService getJsapiService() {
        return this.jsapiService;
    }

    @Override
    public WxMaSettingService getSettingService() {
        return this.settingService;
    }

    @Override
    public WxMaShareService getShareService() {
        return this.shareService;
    }

    @Override
    public WxMaRunService getRunService() {
        return this.runService;
    }

    @Override
    public WxMaSecCheckService getSecCheckService() {
        return this.secCheckService;
    }

    @Override
    public WxMaPluginService getPluginService() {
        return this.pluginService;
    }

    @Override
    public WxMaExpressService getExpressService() {
        return this.expressService;
    }

    @Override
    public WxMaCloudService getCloudService() {
        return this.cloudService;
    }

    @Override
    public WxMaLiveService getLiveService() {
        return this.liveService;
    }

    @Override
    public WxMaLiveGoodsService getLiveGoodsService() {
        return this.liveGoodsService;
    }

    @Override
    public WxOcrService getOcrService() {
        return this.ocrService;
    }
}

