/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.api.impl;

import cn.binarywang.wx.miniapp.api.impl.WxMaServiceImpl;
import cn.binarywang.wx.miniapp.bean.WxMaAuditMediaUploadResult;
import cn.binarywang.wx.miniapp.bean.WxMaJscode2SessionResult;
import cn.binarywang.wx.miniapp.bean.WxMaUploadAuthMaterialResult;
import cn.binarywang.wx.miniapp.config.WxMaConfig;
import cn.binarywang.wx.miniapp.executor.UploadAuthMaterialRequestExecutor;
import cn.binarywang.wx.miniapp.json.WxMaGsonBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.List;
import java.util.Map;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.open.api.WxOpenComponentService;
import me.chanjar.weixin.open.api.WxOpenMaAuthService;
import me.chanjar.weixin.open.api.WxOpenMaBasicService;
import me.chanjar.weixin.open.api.WxOpenMaEmbeddedService;
import me.chanjar.weixin.open.api.WxOpenMaIcpService;
import me.chanjar.weixin.open.api.WxOpenMaPrivacyService;
import me.chanjar.weixin.open.api.WxOpenMaService;
import me.chanjar.weixin.open.api.WxOpenMaShoppingOrdersService;
import me.chanjar.weixin.open.api.impl.WxOpenMaAuthServiceImpl;
import me.chanjar.weixin.open.api.impl.WxOpenMaBasicServiceImpl;
import me.chanjar.weixin.open.api.impl.WxOpenMaEmbeddedServiceImpl;
import me.chanjar.weixin.open.api.impl.WxOpenMaIcpServiceImpl;
import me.chanjar.weixin.open.api.impl.WxOpenMaPrivacyServiceImpl;
import me.chanjar.weixin.open.api.impl.WxOpenMaShoppingOrdersServiceImpl;
import me.chanjar.weixin.open.bean.ma.WxMaPrefetchDomain;
import me.chanjar.weixin.open.bean.ma.WxMaQrcodeParam;
import me.chanjar.weixin.open.bean.ma.WxMaScheme;
import me.chanjar.weixin.open.bean.message.WxOpenMaSubmitAuditMessage;
import me.chanjar.weixin.open.bean.message.WxOpenMaVerifyBetaWeappMessage;
import me.chanjar.weixin.open.bean.result.WxDownlooadQrcodeJumpResult;
import me.chanjar.weixin.open.bean.result.WxGetQrcodeJumpResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaApplyLiveInfoResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaBindTesterResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaCategoryListResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaDomainConfirmFileResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaDomainResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaGetCodePrivacyInfoResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaGrayReleasePlanResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaHistoryVersionResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaPageListResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaPrefetchDomainResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaQueryAuditResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaQueryQuotaResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaSearchStatusResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaShowItemResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaSubmitAuditResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaTesterListResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaVisitStatusResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaWeappSupportVersionResult;
import me.chanjar.weixin.open.bean.result.WxOpenMaWebDomainResult;
import me.chanjar.weixin.open.bean.result.WxOpenResult;
import me.chanjar.weixin.open.bean.result.WxOpenVersioninfoResult;
import me.chanjar.weixin.open.bean.result.WxQrcodeJumpRule;
import me.chanjar.weixin.open.executor.MaQrCodeRequestExecutor;

public class WxOpenMaServiceImpl
extends WxMaServiceImpl
implements WxOpenMaService {
    private static final String ACTION = "action";
    private static final String ACTION_GET = "get";
    private final WxOpenComponentService wxOpenComponentService;
    private final WxMaConfig wxMaConfig;
    private final String appId;
    private final WxOpenMaBasicService basicService;
    private final WxOpenMaAuthService authService;
    private final WxOpenMaIcpService icpService;
    private final WxOpenMaPrivacyService privacyService;
    private final WxOpenMaShoppingOrdersService shoppingOrdersService;
    private final WxOpenMaEmbeddedService embeddedService;

    public WxOpenMaServiceImpl(WxOpenComponentService wxOpenComponentService, String appId, WxMaConfig wxMaConfig) {
        this.wxOpenComponentService = wxOpenComponentService;
        this.appId = appId;
        this.wxMaConfig = wxMaConfig;
        this.basicService = new WxOpenMaBasicServiceImpl(this);
        this.authService = new WxOpenMaAuthServiceImpl(this);
        this.icpService = new WxOpenMaIcpServiceImpl(this);
        this.privacyService = new WxOpenMaPrivacyServiceImpl(this);
        this.shoppingOrdersService = new WxOpenMaShoppingOrdersServiceImpl(this);
        this.embeddedService = new WxOpenMaEmbeddedServiceImpl(this);
        this.initHttp();
    }

    public WxMaJscode2SessionResult jsCode2SessionInfo(String jsCode) throws WxErrorException {
        return this.wxOpenComponentService.miniappJscode2Session(this.appId, jsCode);
    }

    public WxMaConfig getWxMaConfig() {
        return this.wxMaConfig;
    }

    public String getAccessToken(boolean forceRefresh) throws WxErrorException {
        return this.wxOpenComponentService.getAuthorizerAccessToken(this.appId, forceRefresh);
    }

    @Override
    public WxOpenMaDomainResult getDomain() throws WxErrorException {
        return this.modifyDomain(ACTION_GET, null, null, null, null, null, null);
    }

    @Override
    public WxOpenMaDomainResult modifyDomain(String action, List<String> requestDomains, List<String> wsRequestDomains, List<String> uploadDomains, List<String> downloadDomains, List<String> udpDomains, List<String> tcpDomains) throws WxErrorException {
        JsonObject requestJson = new JsonObject();
        requestJson.addProperty(ACTION, action);
        if (!ACTION_GET.equals(action)) {
            requestJson.add("requestdomain", (JsonElement)this.toJsonArray(requestDomains));
            requestJson.add("wsrequestdomain", (JsonElement)this.toJsonArray(wsRequestDomains));
            requestJson.add("uploaddomain", (JsonElement)this.toJsonArray(uploadDomains));
            requestJson.add("downloaddomain", (JsonElement)this.toJsonArray(downloadDomains));
            requestJson.add("udpdomain", (JsonElement)this.toJsonArray(udpDomains));
            requestJson.add("tcpdomain", (JsonElement)this.toJsonArray(tcpDomains));
        }
        String response = this.post("https://api.weixin.qq.com/wxa/modify_domain", GSON.toJson((JsonElement)requestJson));
        return (WxOpenMaDomainResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaDomainResult.class);
    }

    @Override
    public String getWebViewDomain() throws WxErrorException {
        return this.setWebViewDomain(ACTION_GET, null);
    }

    @Override
    public WxOpenMaWebDomainResult getWebViewDomainInfo() throws WxErrorException {
        return this.setWebViewDomainInfo(ACTION_GET, null);
    }

    @Override
    public String setWebViewDomain(String action, List<String> domainList) throws WxErrorException {
        JsonObject requestJson = new JsonObject();
        requestJson.addProperty(ACTION, action);
        if (!ACTION_GET.equals(action)) {
            requestJson.add("webviewdomain", (JsonElement)this.toJsonArray(domainList));
        }
        return this.post("https://api.weixin.qq.com/wxa/setwebviewdomain", GSON.toJson((JsonElement)requestJson));
    }

    @Override
    public WxOpenMaWebDomainResult setWebViewDomainInfo(String action, List<String> domainList) throws WxErrorException {
        String response = this.setWebViewDomain(action, domainList);
        return (WxOpenMaWebDomainResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaWebDomainResult.class);
    }

    @Override
    public WxOpenMaDomainConfirmFileResult getWebviewDomainConfirmFile() throws WxErrorException {
        String responseContent = this.post("https://api.weixin.qq.com/wxa/get_webviewdomain_confirmfile", "{}");
        return WxOpenMaDomainConfirmFileResult.fromJson(responseContent);
    }

    @Override
    public String getAccountBasicInfo() throws WxErrorException {
        return this.get("https://api.weixin.qq.com/cgi-bin/account/getaccountbasicinfo", "");
    }

    @Override
    public WxOpenMaBindTesterResult bindTester(String wechatId) throws WxErrorException {
        JsonObject paramJson = new JsonObject();
        paramJson.addProperty("wechatid", wechatId);
        String response = this.post("https://api.weixin.qq.com/wxa/bind_tester", GSON.toJson((JsonElement)paramJson));
        return (WxOpenMaBindTesterResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaBindTesterResult.class);
    }

    @Override
    public WxOpenResult unbindTester(String wechatId) throws WxErrorException {
        JsonObject paramJson = new JsonObject();
        paramJson.addProperty("wechatid", wechatId);
        String response = this.post("https://api.weixin.qq.com/wxa/unbind_tester", GSON.toJson((JsonElement)paramJson));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult unbindTesterByUserStr(String userStr) throws WxErrorException {
        JsonObject paramJson = new JsonObject();
        paramJson.addProperty("userstr", userStr);
        String response = this.post("https://api.weixin.qq.com/wxa/unbind_tester", GSON.toJson((JsonElement)paramJson));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenMaTesterListResult getTesterList() throws WxErrorException {
        JsonObject paramJson = new JsonObject();
        paramJson.addProperty(ACTION, "get_experiencer");
        String response = this.post("https://api.weixin.qq.com/wxa/memberauth", GSON.toJson((JsonElement)paramJson));
        return (WxOpenMaTesterListResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaTesterListResult.class);
    }

    @Override
    public WxOpenResult changeWxaSearchStatus(Integer status) throws WxErrorException {
        JsonObject paramJson = new JsonObject();
        paramJson.addProperty("status", (Number)status);
        String response = this.post("https://api.weixin.qq.com/wxa/changewxasearchstatus", GSON.toJson((JsonElement)paramJson));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenMaSearchStatusResult getWxaSearchStatus() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/getwxasearchstatus", null);
        return (WxOpenMaSearchStatusResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaSearchStatusResult.class);
    }

    @Override
    public WxOpenMaShowItemResult getShowWxaItem() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/getshowwxaitem", null);
        return (WxOpenMaShowItemResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaShowItemResult.class);
    }

    @Override
    public WxOpenResult updateShowWxaItem(Integer flag, String mpAppId) throws WxErrorException {
        JsonObject paramJson = new JsonObject();
        paramJson.addProperty("wxa_subscribe_biz_flag", (Number)flag);
        paramJson.addProperty("appid", mpAppId);
        String response = this.post("https://api.weixin.qq.com/wxa/updateshowwxaitem", GSON.toJson((JsonElement)paramJson));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult codeCommit(Long templateId, String userVersion, String userDesc, Object extJsonObject) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("template_id", (Number)templateId);
        params.addProperty("user_version", userVersion);
        params.addProperty("user_desc", userDesc);
        params.addProperty("ext_json", GSON.toJson(extJsonObject));
        String response = this.post("https://api.weixin.qq.com/wxa/commit", GSON.toJson((JsonElement)params));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public File getTestQrcode(String pagePath, Map<String, String> params) throws WxErrorException {
        WxMaQrcodeParam qrcodeParam = WxMaQrcodeParam.create(pagePath);
        qrcodeParam.addPageParam(params);
        WxOpenMaServiceImpl wxMaService = this;
        return (File)wxMaService.execute(MaQrCodeRequestExecutor.create(this.getRequestHttp()), "https://api.weixin.qq.com/wxa/get_qrcode", qrcodeParam);
    }

    @Override
    public WxOpenResult verifyBetaWeapp(WxOpenMaVerifyBetaWeappMessage verifyBetaWeappMessage) throws WxErrorException {
        String response = this.post("https://api.weixin.qq.com/wxa/verifybetaweapp", GSON.toJson((Object)verifyBetaWeappMessage));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenMaCategoryListResult getCategoryList() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/get_category", null);
        return (WxOpenMaCategoryListResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaCategoryListResult.class);
    }

    @Override
    public WxOpenMaPageListResult getPageList() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/get_page", null);
        return (WxOpenMaPageListResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaPageListResult.class);
    }

    @Override
    public WxOpenMaSubmitAuditResult submitAudit(WxOpenMaSubmitAuditMessage submitAuditMessage) throws WxErrorException {
        String response = this.post("https://api.weixin.qq.com/wxa/submit_audit", GSON.toJson((Object)submitAuditMessage));
        return (WxOpenMaSubmitAuditResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaSubmitAuditResult.class);
    }

    @Override
    public WxOpenMaQueryAuditResult getAuditStatus(Long auditId) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("auditid", (Number)auditId);
        String response = this.post("https://api.weixin.qq.com/wxa/get_auditstatus", GSON.toJson((JsonElement)params));
        return (WxOpenMaQueryAuditResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaQueryAuditResult.class);
    }

    @Override
    public WxOpenMaQueryAuditResult getLatestAuditStatus() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/get_latest_auditstatus", null);
        return (WxOpenMaQueryAuditResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaQueryAuditResult.class);
    }

    @Override
    public WxOpenResult releaseAudited() throws WxErrorException {
        JsonObject params = new JsonObject();
        String response = this.post("https://api.weixin.qq.com/wxa/release", GSON.toJson((JsonElement)params));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult changeVisitStatus(String action) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty(ACTION, action);
        String response = this.post("https://api.weixin.qq.com/wxa/change_visitstatus", GSON.toJson((JsonElement)params));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenMaVisitStatusResult getVisitStatus() throws WxErrorException {
        String responseContent = this.post("https://api.weixin.qq.com/wxa/getvisitstatus", "{}");
        return WxOpenMaVisitStatusResult.fromJson(responseContent);
    }

    @Override
    public WxOpenResult revertCodeRelease() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/revertcoderelease", null);
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenMaHistoryVersionResult getHistoryVersion() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/revertcoderelease", "action=get_history_version");
        return (WxOpenMaHistoryVersionResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaHistoryVersionResult.class);
    }

    @Override
    public WxOpenResult undoCodeAudit() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/undocodeaudit", null);
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public String getSupportVersion() throws WxErrorException {
        JsonObject params = new JsonObject();
        return this.post("https://api.weixin.qq.com/cgi-bin/wxopen/getweappsupportversion", GSON.toJson((JsonElement)params));
    }

    @Override
    public WxOpenMaWeappSupportVersionResult getSupportVersionInfo() throws WxErrorException {
        String response = this.getSupportVersion();
        return (WxOpenMaWeappSupportVersionResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaWeappSupportVersionResult.class);
    }

    @Override
    public String setSupportVersion(String version) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("version", version);
        return this.post("https://api.weixin.qq.com/cgi-bin/wxopen/setweappsupportversion", GSON.toJson((JsonElement)params));
    }

    @Override
    public WxOpenResult setSupportVersionInfo(String version) throws WxErrorException {
        String response = this.setSupportVersion(version);
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult grayRelease(Integer grayPercentage) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("gray_percentage", (Number)grayPercentage);
        String response = this.post("https://api.weixin.qq.com/wxa/grayrelease", GSON.toJson((JsonElement)params));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult revertGrayRelease() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/revertgrayrelease", null);
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenMaGrayReleasePlanResult getGrayReleasePlan() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/getgrayreleaseplan", null);
        return (WxOpenMaGrayReleasePlanResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaGrayReleasePlanResult.class);
    }

    @Override
    public WxOpenMaGetCodePrivacyInfoResult getCodePrivacyInfo() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/security/get_code_privacy_info", null);
        return (WxOpenMaGetCodePrivacyInfoResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaGetCodePrivacyInfoResult.class);
    }

    @Override
    public WxOpenMaQueryQuotaResult queryQuota() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/queryquota", null);
        return (WxOpenMaQueryQuotaResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaQueryQuotaResult.class);
    }

    @Override
    public Boolean speedAudit(Long auditId) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("auditid", (Number)auditId);
        String response = this.post("https://api.weixin.qq.com/wxa/speedupaudit", GSON.toJson((JsonElement)params));
        WxOpenResult result = (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
        return result.isSuccess();
    }

    @Override
    public WxOpenResult addQrcodeJump(WxQrcodeJumpRule wxQrcodeJumpRule) throws WxErrorException {
        String response = this.post("https://api.weixin.qq.com/cgi-bin/wxopen/qrcodejumpadd", GSON.toJson((Object)wxQrcodeJumpRule));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxGetQrcodeJumpResult getQrcodeJump() throws WxErrorException {
        String response = this.post("https://api.weixin.qq.com/cgi-bin/wxopen/qrcodejumpget", "{}");
        return (WxGetQrcodeJumpResult)WxMaGsonBuilder.create().fromJson(response, WxGetQrcodeJumpResult.class);
    }

    @Override
    public WxDownlooadQrcodeJumpResult downloadQrcodeJump() throws WxErrorException {
        String response = this.post("https://api.weixin.qq.com/cgi-bin/wxopen/qrcodejumpdownload", "{}");
        return (WxDownlooadQrcodeJumpResult)WxMaGsonBuilder.create().fromJson(response, WxDownlooadQrcodeJumpResult.class);
    }

    @Override
    public WxOpenResult deleteQrcodeJump(String prefix) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("prefix", prefix);
        String response = this.post("https://api.weixin.qq.com/cgi-bin/wxopen/qrcodejumpdelete", GSON.toJson((JsonElement)params));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenResult publishQrcodeJump(String prefix) throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty("prefix", prefix);
        String response = this.post("https://api.weixin.qq.com/cgi-bin/wxopen/qrcodejumppublish", GSON.toJson((JsonElement)params));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxMaScheme generateMaScheme(String jumpWxaPath, String jumpWxaQuery, Boolean isExpire, Long expireTime) throws WxErrorException {
        JsonObject jumpWxa = null;
        if (jumpWxaPath != null && jumpWxaQuery != null) {
            jumpWxa = new JsonObject();
            jumpWxa.addProperty("path", jumpWxaPath);
            jumpWxa.addProperty("query", jumpWxaQuery);
        }
        JsonObject params = new JsonObject();
        if (jumpWxa != null) {
            params.add("jump_wxa", (JsonElement)jumpWxa);
        }
        if (isExpire != null) {
            params.addProperty("is_expire", isExpire);
        }
        if (expireTime != null) {
            params.addProperty("expire_time", (Number)expireTime);
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String response = this.post("https://api.weixin.qq.com/wxa/generatescheme", gson.toJson((JsonElement)params));
        return (WxMaScheme)WxMaGsonBuilder.create().fromJson(response, WxMaScheme.class);
    }

    @Override
    public WxOpenResult registerShopComponent() throws WxErrorException {
        JsonObject params = new JsonObject();
        String response = this.post("https://api.weixin.qq.com/shop/register/apply", GSON.toJson((JsonElement)params));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxMaAuditMediaUploadResult uploadMedia(File file) throws WxErrorException {
        CommonUploadParam param = CommonUploadParam.fromFile((String)"media", (File)file);
        String result = this.upload("https://api.weixin.qq.com/wxa/uploadmedia", param);
        return WxMaAuditMediaUploadResult.fromJson((String)result);
    }

    private JsonArray toJsonArray(List<String> strList) {
        JsonArray jsonArray = new JsonArray();
        if (strList != null && !strList.isEmpty()) {
            for (String str : strList) {
                jsonArray.add(str);
            }
        }
        return jsonArray;
    }

    @Override
    public WxOpenVersioninfoResult getVersionInfo() throws WxErrorException {
        JsonObject params = new JsonObject();
        String response = this.post("https://api.weixin.qq.com/wxa/getversioninfo", GSON.toJson((JsonElement)params));
        return (WxOpenVersioninfoResult)WxMaGsonBuilder.create().fromJson(response, WxOpenVersioninfoResult.class);
    }

    @Override
    public WxOpenResult setPrefetchDomain(WxMaPrefetchDomain domain) throws WxErrorException {
        String response = this.post("https://api.weixin.qq.com/wxa/set_prefetchdnsdomain", GSON.toJson((Object)domain));
        return (WxOpenResult)WxMaGsonBuilder.create().fromJson(response, WxOpenResult.class);
    }

    @Override
    public WxOpenMaPrefetchDomainResult getPrefetchDomain() throws WxErrorException {
        String response = this.get("https://api.weixin.qq.com/wxa/get_prefetchdnsdomain", null);
        return (WxOpenMaPrefetchDomainResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaPrefetchDomainResult.class);
    }

    @Override
    public WxOpenMaApplyLiveInfoResult applyLiveInfo() throws WxErrorException {
        JsonObject params = new JsonObject();
        params.addProperty(ACTION, "apply");
        String response = this.post("https://api.weixin.qq.com/wxa/business/applyliveinfo", GSON.toJson((JsonElement)params));
        return (WxOpenMaApplyLiveInfoResult)WxMaGsonBuilder.create().fromJson(response, WxOpenMaApplyLiveInfoResult.class);
    }

    @Override
    public WxMaUploadAuthMaterialResult uploadAuthMaterial(File file) throws WxErrorException {
        return (WxMaUploadAuthMaterialResult)this.execute(UploadAuthMaterialRequestExecutor.create((RequestHttp)this.getRequestHttp()), "https://api.weixin.qq.com/wxa/sec/uploadauthmaterial", file);
    }

    @Override
    public WxOpenMaBasicService getBasicService() {
        return this.basicService;
    }

    @Override
    public WxOpenMaAuthService getAuthService() {
        return this.authService;
    }

    @Override
    public WxOpenMaIcpService getIcpService() {
        return this.icpService;
    }

    @Override
    public WxOpenMaPrivacyService getPrivacyService() {
        return this.privacyService;
    }

    @Override
    public WxOpenMaShoppingOrdersService getShoppingOrdersService() {
        return this.shoppingOrdersService;
    }

    @Override
    public WxOpenMaEmbeddedService getEmbeddedService() {
        return this.embeddedService;
    }
}

