/*
 * Decompiled with CFR 0.152.
 */
package me.chanjar.weixin.open.executor;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.List;
import me.chanjar.weixin.common.bean.CommonUploadData;
import me.chanjar.weixin.common.bean.CommonUploadParam;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxError;
import me.chanjar.weixin.common.error.WxErrorException;
import me.chanjar.weixin.common.util.http.RequestHttp;
import me.chanjar.weixin.common.util.http.apache.Utf8ResponseHandler;
import me.chanjar.weixin.open.bean.CommonUploadMultiParam;
import me.chanjar.weixin.open.executor.CommonUploadMultiRequestExecutor;
import org.apache.http.Consts;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.CloseableHttpClient;
import org.springframework.util.CollectionUtils;

public class CommonUploadMultiRequestExecutorApacheImpl
extends CommonUploadMultiRequestExecutor<CloseableHttpClient, HttpHost> {
    public CommonUploadMultiRequestExecutorApacheImpl(RequestHttp<CloseableHttpClient, HttpHost> requestHttp) {
        super(requestHttp);
    }

    /*
     * Loose catch block
     */
    public String execute(String uri, CommonUploadMultiParam param, WxType wxType) throws WxErrorException, IOException {
        HttpPost httpPost = new HttpPost(uri);
        if (this.requestHttp.getRequestHttpProxy() != null) {
            RequestConfig config = RequestConfig.custom().setProxy((HttpHost)this.requestHttp.getRequestHttpProxy()).build();
            httpPost.setConfig(config);
        }
        if (param != null) {
            CommonUploadParam uploadParam;
            MultipartEntityBuilder entity = MultipartEntityBuilder.create();
            List<CommonUploadMultiParam.NormalParam> normalParams = param.getNormalParams();
            if (!CollectionUtils.isEmpty(normalParams)) {
                for (CommonUploadMultiParam.NormalParam normalParam : normalParams) {
                    entity.addPart(normalParam.getName(), (ContentBody)new StringBody(normalParam.getValue(), ContentType.create((String)"multipart/form-data", (Charset)Consts.UTF_8)));
                }
            }
            if ((uploadParam = param.getUploadParam()) != null) {
                CommonUploadData data = uploadParam.getData();
                InnerStreamBody part = new InnerStreamBody(data.getInputStream(), ContentType.DEFAULT_BINARY, data.getFileName(), data.getLength());
                entity.addPart(uploadParam.getName(), (ContentBody)part).setMode(HttpMultipartMode.RFC6532);
            }
            httpPost.setEntity(entity.build());
        }
        try {
            try (CloseableHttpResponse response = ((CloseableHttpClient)this.requestHttp.getRequestHttpClient()).execute((HttpUriRequest)httpPost);){
                String responseContent = (String)Utf8ResponseHandler.INSTANCE.handleResponse((HttpResponse)response);
                if (responseContent == null || responseContent.isEmpty()) {
                    throw new WxErrorException(String.format("\u4e0a\u4f20\u5931\u8d25\uff0c\u670d\u52a1\u5668\u54cd\u5e94\u7a7a url:%s param:%s", uri, param));
                }
                WxError error = WxError.fromJson((String)responseContent, (WxType)wxType);
                if (error.getErrorCode() != 0) {
                    throw new WxErrorException(error);
                }
                String string = responseContent;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            httpPost.releaseConnection();
        }
    }

    public static class InnerStreamBody
    extends InputStreamBody {
        private final long contentLength;

        public InnerStreamBody(InputStream in, ContentType contentType, String filename, long contentLength) {
            super(in, contentType, filename);
            this.contentLength = contentLength;
        }

        public long getContentLength() {
            return this.contentLength;
        }
    }
}

