/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.service.impl;

import com.github.binarywang.wxpay.bean.request.WxH5EntrustRequest;
import com.github.binarywang.wxpay.bean.request.WxMaEntrustRequest;
import com.github.binarywang.wxpay.bean.request.WxMpEntrustRequest;
import com.github.binarywang.wxpay.bean.request.WxPayEntrustRequest;
import com.github.binarywang.wxpay.bean.request.WxPreWithholdRequest;
import com.github.binarywang.wxpay.bean.request.WxSignQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxTerminatedContractRequest;
import com.github.binarywang.wxpay.bean.request.WxWithholdOrderQueryRequest;
import com.github.binarywang.wxpay.bean.request.WxWithholdRequest;
import com.github.binarywang.wxpay.bean.result.BaseWxPayResult;
import com.github.binarywang.wxpay.bean.result.WxH5EntrustResult;
import com.github.binarywang.wxpay.bean.result.WxPayEntrustResult;
import com.github.binarywang.wxpay.bean.result.WxSignQueryResult;
import com.github.binarywang.wxpay.bean.result.WxTerminationContractResult;
import com.github.binarywang.wxpay.bean.result.WxWithholdOrderQueryResult;
import com.github.binarywang.wxpay.bean.result.WxWithholdResult;
import com.github.binarywang.wxpay.exception.WxPayException;
import com.github.binarywang.wxpay.service.WxEntrustPapService;
import com.github.binarywang.wxpay.service.WxPayService;
import com.github.binarywang.wxpay.util.SignUtils;
import java.net.URLEncoder;
import me.chanjar.weixin.common.util.json.WxGsonBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WxEntrustPapServiceImpl
implements WxEntrustPapService {
    private static final Logger log = LoggerFactory.getLogger(WxEntrustPapServiceImpl.class);
    private final WxPayService payService;

    @Override
    public String mpSign(WxMpEntrustRequest wxMpEntrustRequest) throws WxPayException {
        StringBuilder signStrTemp = new StringBuilder(this.payService.getPayBaseUrl() + "/papay/entrustweb");
        signStrTemp.append("?appid=").append(wxMpEntrustRequest.getAppid());
        signStrTemp.append("&contract_code=").append(wxMpEntrustRequest.getContractCode());
        signStrTemp.append("&contract_display_account=").append(URLEncoder.encode(wxMpEntrustRequest.getContractDisplayAccount()));
        signStrTemp.append("&mch_id=").append(wxMpEntrustRequest.getMchId()).append("&notify_url=").append(URLEncoder.encode(wxMpEntrustRequest.getNotifyUrl()));
        signStrTemp.append("&plan_id=").append(wxMpEntrustRequest.getPlanId()).append("&outerid=").append(URLEncoder.encode(wxMpEntrustRequest.getOuterId()));
        signStrTemp.append("&request_serial=").append(wxMpEntrustRequest.getRequestSerial()).append("&timestamp=").append(wxMpEntrustRequest.getTimestamp());
        signStrTemp.append("&version=").append(wxMpEntrustRequest.getVersion()).append("&return_web=").append(wxMpEntrustRequest.getReturnWeb()).append("&sign=").append(wxMpEntrustRequest.getSign());
        return signStrTemp.toString();
    }

    @Override
    public String maSign(WxMaEntrustRequest wxMaEntrustRequest) throws WxPayException {
        wxMaEntrustRequest.checkAndSign(this.payService.getConfig());
        wxMaEntrustRequest.setNotifyUrl(URLEncoder.encode(wxMaEntrustRequest.getNotifyUrl()));
        return wxMaEntrustRequest.toString();
    }

    @Override
    public WxH5EntrustResult h5Sign(WxH5EntrustRequest wxH5EntrustRequest) throws WxPayException {
        wxH5EntrustRequest.checkAndSign(this.payService.getConfig());
        String sign = SignUtils.createSign(wxH5EntrustRequest, "HMAC-SHA256", this.payService.getConfig().getMchKey(), null);
        String url = this.payService.getPayBaseUrl() + "/papay/h5entrustweb";
        StringBuilder strBuilder = new StringBuilder(url);
        strBuilder.append("?appid=").append(wxH5EntrustRequest.getAppid());
        strBuilder.append("&contract_code=").append(wxH5EntrustRequest.getContractCode());
        strBuilder.append("&contract_display_account=").append(URLEncoder.encode(wxH5EntrustRequest.getContractDisplayAccount()));
        strBuilder.append("&mch_id=").append(wxH5EntrustRequest.getMchId()).append("&notify_url=").append(URLEncoder.encode(wxH5EntrustRequest.getNotifyUrl()));
        strBuilder.append("&plan_id=").append(wxH5EntrustRequest.getPlanId()).append("&outerid=").append(URLEncoder.encode(wxH5EntrustRequest.getOuterId()));
        strBuilder.append("&return_appid=").append(wxH5EntrustRequest.getReturnAppid());
        strBuilder.append("&clientip=").append(wxH5EntrustRequest.getClientIp());
        strBuilder.append("&request_serial=").append(wxH5EntrustRequest.getRequestSerial()).append("&timestamp=").append(wxH5EntrustRequest.getTimestamp());
        strBuilder.append("&version=").append(wxH5EntrustRequest.getVersion()).append("&sign=").append(sign);
        log.debug("h5\u7eaf\u7b7e\u7ea6\u8bf7\u6c42URL\uff1a{}", (Object)strBuilder.toString());
        String responseContent = this.payService.getV3(strBuilder.toString());
        WxH5EntrustResult result = BaseWxPayResult.fromXML(responseContent, WxH5EntrustResult.class);
        result.checkResult(this.payService, wxH5EntrustRequest.getSignType(), true);
        return result;
    }

    @Override
    public WxPayEntrustResult paySign(WxPayEntrustRequest wxPayEntrustRequest) throws WxPayException {
        wxPayEntrustRequest.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/contractorder";
        String responseContent = this.payService.post(url, wxPayEntrustRequest.toXML(), false);
        WxPayEntrustResult result = BaseWxPayResult.fromXML(responseContent, WxPayEntrustResult.class);
        result.checkResult(this.payService, wxPayEntrustRequest.getSignType(), true);
        return result;
    }

    @Override
    public WxWithholdResult withhold(WxWithholdRequest wxWithholdRequest) throws WxPayException {
        wxWithholdRequest.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/pappayapply";
        String responseContent = this.payService.post(url, wxWithholdRequest.toXML(), false);
        WxWithholdResult result = BaseWxPayResult.fromXML(responseContent, WxWithholdResult.class);
        result.checkResult(this.payService, wxWithholdRequest.getSignType(), true);
        return result;
    }

    @Override
    public String preWithhold(WxPreWithholdRequest wxPreWithholdRequest) throws WxPayException {
        String requestParam = WxGsonBuilder.create().toJson((Object)wxPreWithholdRequest);
        String url = this.payService.getPayBaseUrl() + "/v3/papay/contracts/%s/notify";
        String httpResponse = this.payService.postV3(String.format(url, wxPreWithholdRequest.getContractId()), requestParam);
        return httpResponse;
    }

    @Override
    public WxSignQueryResult querySign(WxSignQueryRequest wxSignQueryRequest) throws WxPayException {
        wxSignQueryRequest.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/papay/querycontract";
        String responseContent = this.payService.post(url, wxSignQueryRequest.toXML(), false);
        WxSignQueryResult result = BaseWxPayResult.fromXML(responseContent, WxSignQueryResult.class);
        result.checkResult(this.payService, wxSignQueryRequest.getSignType(), true);
        return result;
    }

    @Override
    public WxTerminationContractResult terminationContract(WxTerminatedContractRequest wxTerminatedContractRequest) throws WxPayException {
        wxTerminatedContractRequest.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/papay/deletecontract";
        String responseContent = this.payService.post(url, wxTerminatedContractRequest.toXML(), false);
        WxTerminationContractResult terminationContractResult = BaseWxPayResult.fromXML(responseContent, WxTerminationContractResult.class);
        terminationContractResult.checkResult(this.payService, wxTerminatedContractRequest.getSignType(), true);
        return terminationContractResult;
    }

    @Override
    public WxWithholdOrderQueryResult papOrderQuery(WxWithholdOrderQueryRequest wxWithholdOrderQueryRequest) throws WxPayException {
        wxWithholdOrderQueryRequest.checkAndSign(this.payService.getConfig());
        String url = this.payService.getPayBaseUrl() + "/pay/paporderquery";
        String responseContent = this.payService.post(url, wxWithholdOrderQueryRequest.toXML(), false);
        WxWithholdOrderQueryResult wxWithholdOrderQueryResult = BaseWxPayResult.fromXML(responseContent, WxWithholdOrderQueryResult.class);
        wxWithholdOrderQueryResult.checkResult(this.payService, wxWithholdOrderQueryRequest.getSignType(), true);
        return wxWithholdOrderQueryResult;
    }

    public WxEntrustPapServiceImpl(WxPayService payService) {
        this.payService = payService;
    }
}

