/*
 * Decompiled with CFR 0.152.
 */
package com.github.binarywang.wxpay.v3.auth;

import com.github.binarywang.wxpay.v3.auth.Verifier;
import com.github.binarywang.wxpay.v3.auth.X509PublicCertificate;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import java.util.Base64;
import me.chanjar.weixin.common.error.WxRuntimeException;

public class PublicCertificateVerifier
implements Verifier {
    private final PublicKey publicKey;
    private final X509PublicCertificate publicCertificate;

    public PublicCertificateVerifier(PublicKey publicKey, String publicId) {
        this.publicKey = publicKey;
        this.publicCertificate = new X509PublicCertificate(publicKey, publicId);
    }

    @Override
    public boolean verify(String serialNumber, byte[] message, String signature) {
        try {
            Signature sign = Signature.getInstance("SHA256withRSA");
            sign.initVerify(this.publicKey);
            sign.update(message);
            return sign.verify(Base64.getDecoder().decode(signature));
        }
        catch (NoSuchAlgorithmException e) {
            throw new WxRuntimeException("\u5f53\u524dJava\u73af\u5883\u4e0d\u652f\u6301SHA256withRSA", (Throwable)e);
        }
        catch (SignatureException e) {
            throw new WxRuntimeException("\u7b7e\u540d\u9a8c\u8bc1\u8fc7\u7a0b\u53d1\u751f\u4e86\u9519\u8bef", (Throwable)e);
        }
        catch (InvalidKeyException e) {
            throw new WxRuntimeException("\u65e0\u6548\u7684\u8bc1\u4e66", (Throwable)e);
        }
    }

    @Override
    public X509Certificate getValidCertificate() {
        return this.publicCertificate;
    }
}

