/*
 * Decompiled with CFR 0.152.
 */
package com.github.houbb.opencc4j.support.datamap.impl;

import com.github.houbb.heaven.support.instance.impl.Instances;
import com.github.houbb.heaven.util.util.ArrayUtil;
import com.github.houbb.opencc4j.support.datamap.IDataMap;
import com.github.houbb.opencc4j.support.datamap.impl.DataMapChains;
import com.github.houbb.opencc4j.support.datamap.impl.DataMapChainsAndMerge;
import com.github.houbb.opencc4j.support.datamap.impl.DataMapDefault;
import com.github.houbb.opencc4j.support.datamap.impl.DataMapHkSelf;
import com.github.houbb.opencc4j.support.datamap.impl.DataMapJpSelf;
import com.github.houbb.opencc4j.support.datamap.impl.DataMapMerge;
import com.github.houbb.opencc4j.support.datamap.impl.DataMapTaiwan;
import com.github.houbb.opencc4j.support.datamap.impl.DataMapTaiwanSelf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class DataMaps {
    private DataMaps() {
    }

    public static IDataMap defaults() {
        return (IDataMap)Instances.singleton(DataMapDefault.class);
    }

    public static IDataMap taiwan() {
        return (IDataMap)Instances.singleton(DataMapTaiwan.class);
    }

    public static IDataMap taiwanSelf() {
        return new DataMapTaiwanSelf();
    }

    public static IDataMap hongKongSelf() {
        return new DataMapHkSelf();
    }

    public static IDataMap hongKong() {
        return DataMaps.chains(DataMaps.defaults(), DataMaps.hongKongSelf());
    }

    public static IDataMap japan() {
        return DataMaps.chains(DataMaps.defaults(), DataMaps.japanSelf());
    }

    public static IDataMap japanSelf() {
        return new DataMapJpSelf();
    }

    public static IDataMap chains(IDataMap dataMap, IDataMap ... others) {
        List<IDataMap> dataMapList = DataMaps.buildDataMapList(dataMap, others);
        return new DataMapChains(dataMapList);
    }

    public static IDataMap merge(IDataMap dataMap, IDataMap ... others) {
        List<IDataMap> dataMapList = DataMaps.buildDataMapList(dataMap, others);
        return new DataMapMerge(dataMapList);
    }

    public static IDataMap chainsAndMerge(IDataMap dataMap, IDataMap ... others) {
        List<IDataMap> dataMapList = DataMaps.buildDataMapList(dataMap, others);
        return new DataMapChainsAndMerge(dataMapList);
    }

    private static List<IDataMap> buildDataMapList(IDataMap dataMap, IDataMap ... others) {
        ArrayList<IDataMap> resultList = new ArrayList<IDataMap>();
        resultList.add(dataMap);
        if (ArrayUtil.isNotEmpty((Object[])others)) {
            resultList.addAll(Arrays.asList(others));
        }
        return resultList;
    }
}

